/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.testrunner;

import androidx.annotation.Nullable;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.testing.testrunner.LithoLocalTestRunConfiguration;
import com.facebook.litho.testing.testrunner.LithoTestRunConfiguration;
import com.facebook.litho.testing.testrunner.NoOpComponentsSystrace;
import com.facebook.litho.testing.testrunner.SplitBuildAndLayoutTestRunConfiguration;
import com.facebook.rendercore.Systracer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.robolectric.DefaultTestLifecycle;
import org.robolectric.RobolectricTestRunner;
import org.robolectric.TestLifecycle;
import org.robolectric.internal.bytecode.Sandbox;
import org.robolectric.util.ReflectionHelpers;

public class LithoTestRunner
extends RobolectricTestRunner {
    private final List<Class<? extends LithoLocalTestRunConfiguration>> mLocalTestRunConfigs;

    public LithoTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        LocalConfigurations annotation = (LocalConfigurations)this.getTestClass().getAnnotation(LocalConfigurations.class);
        this.mLocalTestRunConfigs = annotation != null ? Arrays.asList(annotation.value()) : Collections.emptyList();
    }

    private List<? extends Class<? extends LithoTestRunConfiguration>> getGlobalConfigs() {
        return Arrays.asList(SplitBuildAndLayoutTestRunConfiguration.class);
    }

    protected List<FrameworkMethod> getChildren() {
        List children = super.getChildren();
        ArrayList<? extends Class<? extends LithoTestRunConfiguration>> configs = new ArrayList<Class<? extends LithoTestRunConfiguration>>();
        configs.addAll(this.getGlobalConfigs());
        if (configs.isEmpty()) {
            return children;
        }
        ArrayList<FrameworkMethod> res = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : children) {
            res.add(method);
            for (Class<? extends LithoLocalTestRunConfiguration> clazz : this.mLocalTestRunConfigs) {
                res.add((FrameworkMethod)new LithoRobolectricFrameworkMethod((RobolectricTestRunner.RobolectricFrameworkMethod)method, null, clazz));
            }
            for (Class<LithoLocalTestRunConfiguration> clazz : configs) {
                res.add((FrameworkMethod)new LithoRobolectricFrameworkMethod((RobolectricTestRunner.RobolectricFrameworkMethod)method, clazz, null));
                for (Class<? extends LithoLocalTestRunConfiguration> localConfig : this.mLocalTestRunConfigs) {
                    res.add((FrameworkMethod)new LithoRobolectricFrameworkMethod((RobolectricTestRunner.RobolectricFrameworkMethod)method, clazz, localConfig));
                }
            }
        }
        return res;
    }

    protected void beforeTest(Sandbox sandbox, FrameworkMethod method, Method bootstrappedMethod) throws Throwable {
        super.beforeTest(sandbox, method, bootstrappedMethod);
        if (method instanceof LithoRobolectricFrameworkMethod) {
            LithoRobolectricFrameworkMethod lithoMethod = (LithoRobolectricFrameworkMethod)method;
            lithoMethod.sandbox = sandbox;
            if (lithoMethod.configurationClass != null) {
                lithoMethod.configurationInstance = ReflectionHelpers.newInstance((Class)sandbox.bootstrappedClass(lithoMethod.configurationClass));
                Class testConfig = lithoMethod.sandbox.bootstrappedClass(LithoTestRunConfiguration.class);
                try {
                    testConfig.getMethod("beforeTest", FrameworkMethod.class).invoke(lithoMethod.configurationInstance, method);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (lithoMethod.localConfigurationClass != null) {
                lithoMethod.localConfigurationInstance = ReflectionHelpers.newInstance((Class)sandbox.bootstrappedClass(lithoMethod.localConfigurationClass));
                Class localTestConfig = lithoMethod.sandbox.bootstrappedClass(LithoLocalTestRunConfiguration.class);
                try {
                    localTestConfig.getMethod("beforeTest", FrameworkMethod.class).invoke(lithoMethod.localConfigurationInstance, method);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void afterTest(FrameworkMethod method, Method bootstrappedMethod) {
        if (method instanceof LithoRobolectricFrameworkMethod) {
            LithoRobolectricFrameworkMethod lithoMethod = (LithoRobolectricFrameworkMethod)method;
            if (lithoMethod.configurationInstance != null) {
                Class testConfig = lithoMethod.sandbox.bootstrappedClass(LithoTestRunConfiguration.class);
                try {
                    testConfig.getMethod("afterTest", FrameworkMethod.class).invoke(lithoMethod.configurationInstance, method);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            lithoMethod.configurationInstance = null;
            if (lithoMethod.localConfigurationInstance != null) {
                Class localTestConfig = lithoMethod.sandbox.bootstrappedClass(LithoLocalTestRunConfiguration.class);
                try {
                    localTestConfig.getMethod("afterTest", FrameworkMethod.class).invoke(lithoMethod.localConfigurationInstance, method);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            lithoMethod.localConfigurationInstance = null;
            lithoMethod.sandbox = null;
        }
        super.afterTest(method, bootstrappedMethod);
    }

    protected Class<? extends TestLifecycle> getTestLifecycleClass() {
        return LithoTestLifecycle.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface LocalConfigurations {
        public Class<? extends LithoLocalTestRunConfiguration>[] value();
    }

    public static class LithoTestLifecycle
    extends DefaultTestLifecycle {
        private final Map<Field, Object> mSavedComponentsConfiguration;

        public LithoTestLifecycle() {
            ComponentsSystrace.provide((Systracer)NoOpComponentsSystrace.sInstance);
            this.mSavedComponentsConfiguration = LithoTestLifecycle.recordComponentsConfiguration();
        }

        public void afterTest(Method method) {
            super.afterTest(method);
            LithoTestLifecycle.restoreComponentsConfiguration(this.mSavedComponentsConfiguration);
        }

        private static Map<Field, Object> recordComponentsConfiguration() {
            HashMap<Field, Object> record = new HashMap<Field, Object>();
            for (Field f : ComponentsConfiguration.class.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers)) continue;
                try {
                    record.put(f, f.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Couldn't record ComponentsConfiguration state", e);
                }
            }
            return record;
        }

        private static void restoreComponentsConfiguration(Map<Field, Object> fieldsToValues) {
            for (Map.Entry<Field, Object> entry : fieldsToValues.entrySet()) {
                try {
                    entry.getKey().set(null, entry.getValue());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Couldn't restore ComponentsConfiguration state", e);
                }
            }
        }
    }

    private static class LithoRobolectricFrameworkMethod
    extends RobolectricTestRunner.RobolectricFrameworkMethod {
        @Nullable
        public final Class<? extends LithoTestRunConfiguration> configurationClass;
        @Nullable
        public final Class<? extends LithoLocalTestRunConfiguration> localConfigurationClass;
        @Nullable
        Object configurationInstance;
        @Nullable
        Object localConfigurationInstance;
        @Nullable
        Sandbox sandbox;

        protected LithoRobolectricFrameworkMethod(RobolectricTestRunner.RobolectricFrameworkMethod other, @Nullable Class<? extends LithoTestRunConfiguration> configurationClass, @Nullable Class<? extends LithoLocalTestRunConfiguration> localConfigClass) {
            super(other);
            this.configurationClass = configurationClass;
            this.localConfigurationClass = localConfigClass;
        }

        public String getName() {
            String variant = (this.configurationClass != null ? this.configurationClass.getSimpleName() + ":" : "") + (this.localConfigurationClass != null ? this.localConfigurationClass.getSimpleName() : "");
            return super.getName() + "[" + variant + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
                return false;
            }
            LithoRobolectricFrameworkMethod that = (LithoRobolectricFrameworkMethod)((Object)o);
            return Objects.equals(this.configurationClass, that.configurationClass) && Objects.equals(this.localConfigurationClass, that.localConfigurationClass);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.configurationClass, this.localConfigurationClass);
        }
    }
}

