/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.viewtree;

import android.graphics.drawable.Drawable;
import android.os.Build;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.MatrixDrawable;
import com.facebook.litho.testing.viewtree.ViewPredicates;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.robolectric.Shadows;

class ComponentQueries {
    ComponentQueries() {
    }

    static boolean hasTextMatchingPredicate(ComponentHost host, Predicate<String> predicate) {
        for (CharSequence foundText : host.getTextContent().getTextItems()) {
            if (!predicate.apply((Object)foundText.toString())) continue;
            return true;
        }
        return false;
    }

    static boolean matchesPattern(ComponentHost host, Pattern pattern) {
        for (CharSequence foundText : host.getTextContent().getTextItems()) {
            if (!pattern.matcher(foundText).find()) continue;
            return true;
        }
        return false;
    }

    static boolean hasDrawable(ComponentHost host, final Drawable drawable) {
        return ComponentQueries.satisfiesPredicate(host, new Predicate<Drawable>(){

            public boolean apply(Drawable input) {
                return ComponentQueries.hasDrawable(input, drawable);
            }
        });
    }

    private static boolean hasDrawable(Drawable containingDrawable, Drawable drawable) {
        while (containingDrawable instanceof MatrixDrawable) {
            containingDrawable = ((MatrixDrawable)containingDrawable).getMountedDrawable();
        }
        String drawnDrawableDescription = ViewPredicates.getDrawnDrawableDescription(drawable);
        if (!drawnDrawableDescription.isEmpty()) {
            return ViewPredicates.getDrawnDrawableDescription(containingDrawable).contains(drawnDrawableDescription);
        }
        int containingDrawableResId = Shadows.shadowOf((Drawable)containingDrawable).getCreatedFromResId();
        int drawableResId = Shadows.shadowOf((Drawable)drawable).getCreatedFromResId();
        if (drawableResId != -1 && containingDrawableResId == drawableResId) {
            return true;
        }
        return containingDrawable == drawable;
    }

    private static boolean satisfiesPredicate(ComponentHost host, Predicate<Drawable> predicate) {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>(host.getDrawables());
        if (host.getBackground() != null) {
            drawables.add(host.getBackground());
        }
        if (Build.VERSION.SDK_INT >= 23 && host.getForeground() != null) {
            drawables.add(host.getForeground());
        }
        for (Drawable drawable : drawables) {
            if (!predicate.apply((Object)drawable)) continue;
            return true;
        }
        for (Drawable drawable : host.getImageContent().getImageItems()) {
            if (!predicate.apply((Object)drawable)) continue;
            return true;
        }
        return false;
    }
}

