/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.viewtree;

public class LevenshteinDistance {
    public static int getLevenshteinDistance(String s, String t, int maxAllowedEditDistance) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            int min = maxAllowedEditDistance + 1;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
                if (min <= d[i]) continue;
                min = d[i];
            }
            if (j == m) {
                int n2 = min = d[n] > maxAllowedEditDistance ? maxAllowedEditDistance + 1 : d[n];
            }
            if (min > maxAllowedEditDistance) {
                return min;
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }
}

