/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.viewtree;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.testing.viewtree.ViewTreeUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class ViewExtractors {
    public static final Function<View, String> GET_TEXT_FUNCTION = new Function<View, String>(){

        public String apply(@Nullable View input) {
            CharSequence text = null;
            if (input instanceof ComponentHost) {
                List strings = ((ComponentHost)input).getTextContent().getTextItems();
                if (!strings.isEmpty()) {
                    text = Joiner.on((String)"\", and \"").join((Iterable)strings);
                }
            } else if (input instanceof TextView) {
                text = ((TextView)input).getText();
            }
            if (text == null) {
                return String.format("No text found, view is %s", ViewExtractors.getVisibilityString(input.getVisibility()));
            }
            return String.format("Found text: \"%s\", view is %s", Strings.nullToEmpty((String)text.toString()), ViewExtractors.getVisibilityString(input.getVisibility()));
        }
    };
    public static final Function<View, String> GET_DRAWABLE_FUNCTION = new Function<View, String>(){

        public String apply(@Nullable View input) {
            if (input instanceof ImageView) {
                return String.format("Found drawable: \"%s\", view is %s", String.valueOf(((ImageView)input).getDrawable()), ViewExtractors.getVisibilityString(input.getVisibility()));
            }
            if (input instanceof ComponentHost) {
                ComponentHost host = (ComponentHost)input;
                ArrayList<String> drawables = new ArrayList<String>();
                for (Drawable d : host.getDrawables()) {
                    drawables.add(String.valueOf(d));
                }
                for (Drawable d : host.getImageContent().getImageItems()) {
                    drawables.add(String.valueOf(d));
                }
                if (host.getBackground() != null) {
                    drawables.add(String.valueOf(host.getBackground()));
                }
                if (Build.VERSION.SDK_INT >= 23 && host.getForeground() != null) {
                    drawables.add(String.valueOf(host.getForeground()));
                }
                return String.format("Found drawables: \"%s\", view is %s", TextUtils.join((CharSequence)"\", \"", drawables), ViewExtractors.getVisibilityString(input.getVisibility()));
            }
            return "No drawable found";
        }
    };
    public static final Function<View, String> GET_CONTENT_DESCRIPTION_FUNCTION = new Function<View, String>(){

        public String apply(@Nullable View input) {
            if (input == null) {
                return "Provided view was null";
            }
            if (input.getContentDescription() == null) {
                return String.format("No content description found, view is %s", ViewExtractors.getVisibilityString(input.getVisibility()));
            }
            return String.format("Found content description: \"%s\", view is %s", input.getContentDescription(), ViewExtractors.getVisibilityString(input.getVisibility()));
        }
    };
    public static final Function<View, String> GET_VIEW_ID_FUNCTION = new Function<View, String>(){

        public String apply(View input) {
            int id = input.getId();
            return String.format("View with id \"%s=%d\" is %s.", ViewTreeUtil.getResourceName(id), id, ViewExtractors.getVisibilityString(input.getVisibility()));
        }
    };

    private ViewExtractors() {
    }

    public static Function<View, String> generateGetViewTagFunction(final int key) {
        return new Function<View, String>(){

            public String apply(View input) {
                if (input.getTag(key) == null) {
                    return String.format("No view tag found, view is %s", ViewExtractors.getVisibilityString(input.getVisibility()));
                }
                return String.format("Found view tag: \"%s\", view is %s", input.getTag(key), ViewExtractors.getVisibilityString(input.getVisibility()));
            }
        };
    }

    private static String getVisibilityString(int visibility) {
        return visibility == 0 ? "visible" : "not visible";
    }
}

