/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.viewtree;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.testing.viewtree.ComponentQueries;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.robolectric.Shadows;
import org.robolectric.shadows.ShadowCanvas;

public final class ViewPredicates {
    private ViewPredicates() {
    }

    public static Predicate<View> hasTextMatchingPredicate(final Predicate<String> predicate) {
        return new Predicate<View>(){

            public boolean apply(View input) {
                if (predicate.apply((Object)ViewPredicates.extractString(input))) {
                    return true;
                }
                if (input instanceof ComponentHost) {
                    return ComponentQueries.hasTextMatchingPredicate((ComponentHost)input, (Predicate<String>)predicate);
                }
                return false;
            }
        };
    }

    public static Predicate<View> hasText(String text) {
        return ViewPredicates.hasTextMatchingPredicate((Predicate<String>)Predicates.equalTo((Object)text));
    }

    public static Predicate<View> hasTag(final int tagId, final Object tagValue) {
        return new Predicate<View>(){

            public boolean apply(View input) {
                Object tag = input.getTag(tagId);
                return tag != null && tag.equals(tagValue);
            }
        };
    }

    public static Predicate<View> hasContentDescription(final String contentDescription) {
        return new Predicate<View>(){

            public boolean apply(View input) {
                if (input instanceof ComponentHost) {
                    List contentDescriptions = ((ComponentHost)input).getContentDescriptions();
                    return contentDescriptions.contains(contentDescription);
                }
                return contentDescription.equals(input.getContentDescription());
            }
        };
    }

    public static Predicate<View> hasVisibleText(String text) {
        return Predicates.and(ViewPredicates.isVisible(), ViewPredicates.hasText(text));
    }

    public static Predicate<View> hasVisibleTextWithTag(String text, int tagId, Object tagValue) {
        return Predicates.and(ViewPredicates.hasVisibleText(text), ViewPredicates.hasTag(tagId, tagValue));
    }

    public static Predicate<View> matchesText(String text) {
        final Pattern pattern = Pattern.compile(text);
        return new Predicate<View>(){

            public boolean apply(View input) {
                if (pattern.matcher(ViewPredicates.extractString(input)).find()) {
                    return true;
                }
                if (input instanceof ComponentHost) {
                    return ComponentQueries.matchesPattern((ComponentHost)input, pattern);
                }
                return false;
            }
        };
    }

    public static Predicate<View> hasVisibleMatchingText(String text) {
        return Predicates.and(ViewPredicates.isVisible(), ViewPredicates.matchesText(text));
    }

    public static Predicate<View> isVisible() {
        return new Predicate<View>(){

            public boolean apply(View input) {
                return input.getVisibility() == 0;
            }
        };
    }

    public static Predicate<View> isClass(Class<? extends View> clazz) {
        return Predicates.instanceOf(clazz);
    }

    static String getDrawnDrawableDescription(Drawable drawable) {
        Canvas canvas = new Canvas();
        drawable.draw(canvas);
        ShadowCanvas shadowCanvas = Shadows.shadowOf((Canvas)canvas);
        return shadowCanvas.getDescription();
    }

    private static String extractString(View view) {
        if (!(view instanceof TextView)) {
            return "";
        }
        CharSequence text = ((TextView)view).getText();
        return text != null ? text.toString() : "";
    }

    public static Predicate<View> hasDrawable(final Drawable drawable) {
        return new Predicate<View>(){

            public boolean apply(@Nullable View input) {
                if (input == null) {
                    return false;
                }
                if (input instanceof ComponentHost) {
                    return ComponentQueries.hasDrawable((ComponentHost)input, drawable);
                }
                String drawnDrawableDescription = ViewPredicates.extractResourceIdFromDrawnDescription(ViewPredicates.getDrawnDrawableDescription(drawable));
                String drawnViewDescription = ViewPredicates.extractResourceIdFromDrawnDescription(ViewPredicates.getDrawnViewDescription(input));
                return !drawnDrawableDescription.isEmpty() && drawnViewDescription.contains(drawnDrawableDescription);
            }
        };
    }

    private static String extractResourceIdFromDrawnDescription(String description) {
        int resourceIdIndex = description.indexOf("resource:");
        if (resourceIdIndex == -1) {
            return description;
        }
        return description.substring(resourceIdIndex);
    }

    public static Predicate<View> hasVisibleDrawable(Drawable drawable) {
        return Predicates.and(ViewPredicates.isVisible(), ViewPredicates.hasDrawable(drawable));
    }

    public static Predicate<View> hasVisibleId(int viewId) {
        return Predicates.and(ViewPredicates.isVisible(), ViewPredicates.hasId(viewId));
    }

    @TargetApi(value=19)
    private static String getDrawnViewDescription(View view) {
        Canvas canvas = new Canvas();
        view.draw(canvas);
        ShadowCanvas shadowCanvas = Shadows.shadowOf((Canvas)canvas);
        if (!shadowCanvas.getDescription().isEmpty()) {
            return shadowCanvas.getDescription();
        }
        try {
            Method onDraw = ViewPredicates.getOnDrawMethod(view.getClass());
            if (onDraw == null) {
                throw new RuntimeException(view.getClass().getCanonicalName() + " has no implementation of View.onDraw(), which should be impossible");
            }
            onDraw.invoke((Object)view, canvas);
            ShadowCanvas shadowCanvas2 = Shadows.shadowOf((Canvas)canvas);
            return shadowCanvas2.getDescription();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static Method getOnDrawMethod(Class<? extends View> viewClass) {
        if (viewClass == null) {
            return null;
        }
        try {
            Method onDraw = viewClass.getDeclaredMethod("onDraw", Canvas.class);
            onDraw.setAccessible(true);
            return onDraw;
        }
        catch (NoSuchMethodException onDraw) {
            Class<? extends View> superclass = viewClass.getSuperclass();
            if (superclass == null || !View.class.isAssignableFrom(superclass)) {
                return null;
            }
            return ViewPredicates.getOnDrawMethod(superclass);
        }
    }

    public static Predicate<View> hasId(final int id) {
        return new Predicate<View>(){

            public boolean apply(View input) {
                return input.getId() == id;
            }
        };
    }
}

