/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.viewtree;

import android.view.View;
import android.view.ViewGroup;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

public final class ViewTree {
    private final View mView;

    public static ViewTree of(View view) {
        return new ViewTree(view);
    }

    private ViewTree(View view) {
        this.mView = view;
    }

    public View getRoot() {
        return this.mView;
    }

    @Nullable
    public ImmutableList<View> findChild(Predicate<View> predicate) {
        return this.findChild(this.mView, predicate, (Predicate<? super ViewGroup>)Predicates.alwaysTrue());
    }

    @Nullable
    public ImmutableList<View> findChild(Predicate<View> predicate, Predicate<? super ViewGroup> shouldCheckChildren) {
        return this.findChild(this.mView, predicate, shouldCheckChildren);
    }

    public String makeString(Function<View, String> extraTextFunction) {
        return this.makeString(extraTextFunction, this.mView, 0);
    }

    public String makeString(int startingDepth, Function<View, String> extraTextFunction) {
        return this.makeString(extraTextFunction, this.mView, startingDepth);
    }

    private String makeString(Function<View, String> extraTextFunction, View view, int depth) {
        String extra;
        StringBuilder builder = new StringBuilder();
        if (depth > 0) {
            builder.append('\n');
        }
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
        builder.append(this.getViewString(view));
        String string = extra = extraTextFunction != null ? (String)extraTextFunction.apply((Object)view) : null;
        if (extra != null) {
            builder.append(" (");
            builder.append(extra);
            builder.append(")");
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                builder.append(this.makeString(extraTextFunction, child, depth + 1));
            }
        }
        return builder.toString();
    }

    private String getViewString(View view) {
        String string = view.toString();
        return ViewTree.removePrefix(ViewTree.removePrefix(string, "android.widget."), "android.view.");
    }

    private static String removePrefix(String string, String prefix) {
        return string.startsWith(prefix) ? string.substring(prefix.length()) : string;
    }

    @Nullable
    private ImmutableList<View> findChild(View root, Predicate<View> predicate, Predicate<? super ViewGroup> shouldCheckChildren) {
        if (predicate.apply((Object)root)) {
            return ImmutableList.of((Object)root);
        }
        if (root instanceof ViewGroup && shouldCheckChildren.apply((Object)((ViewGroup)root))) {
            ViewGroup viewGroup = (ViewGroup)root;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                ImmutableList<View> result = this.findChild(child, predicate, shouldCheckChildren);
                if (result == null) continue;
                return ImmutableList.builder().add((Object)root).addAll(result).build();
            }
        }
        return null;
    }
}

