/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.testing.viewtree;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import androidx.test.core.app.ApplicationProvider;
import com.facebook.litho.testing.viewtree.LevenshteinDistance;
import com.facebook.litho.testing.viewtree.ViewExtractors;
import com.facebook.litho.testing.viewtree.ViewPredicates;
import com.facebook.litho.testing.viewtree.ViewTree;
import com.facebook.litho.testing.viewtree.ViewTreeUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public final class ViewTreeAssert
extends AbstractAssert<ViewTreeAssert, ViewTree> {
    private ViewTreeAssert(ViewTree actual) {
        super((Object)actual, ViewTreeAssert.class);
    }

    public static ViewTreeAssert assertThat(ViewTree actual) {
        return new ViewTreeAssert(actual);
    }

    public ViewTreeAssert hasVisibleText(String text) {
        ImmutableList<View> path = this.getPathToVisibleText(text);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage(path == null ? this.getHasVisibleTextErrorMessage(text) : "", new Object[0])).isNotNull();
        return this;
    }

    private String getHasVisibleTextErrorMessage(String text) {
        String errorMsg = String.format("Cannot find text \"%s\" in view hierarchy:%n%s. ", text, ((ViewTree)this.actual).makeString(ViewExtractors.GET_TEXT_FUNCTION));
        ImmutableList<View> similarPath = this.getPathToVisibleSimilarText(text);
        errorMsg = similarPath != null ? errorMsg + String.format("\nHowever, a near-match was found: \"%s\"", ViewExtractors.GET_TEXT_FUNCTION.apply((Object)((View)similarPath.get(similarPath.size() - 1)))) : errorMsg + "\nNo near-match was found.";
        return errorMsg;
    }

    public ViewTreeAssert hasVisibleTextWithTag(String text, int tagId, Object tagValue) {
        ImmutableList<View> path = this.getPathToVisibleTextWithTag(text, tagId, tagValue);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Cannot find text \"%s\" with tagId \"%d\" and value:%s in view hierarchy:%n%s", new Object[]{text, tagId, tagValue.toString(), ((ViewTree)this.actual).makeString(ViewExtractors.GET_TEXT_FUNCTION)})).isNotNull();
        return this;
    }

    public ViewTreeAssert hasVisibleText(int resourceId) {
        return this.hasVisibleText(ApplicationProvider.getApplicationContext().getResources().getString(resourceId));
    }

    public ViewTreeAssert doesNotHaveVisibleText(String text) {
        ImmutableList<View> path = this.getPathToVisibleText(text);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Found text \"%s\" in view hierarchy for path: %s", new Object[]{text, this.makeString((Iterable<View>)path)})).isNull();
        return this;
    }

    public ViewTreeAssert hasViewTag(int tagId, Object tagValue) {
        ImmutableList<View> path = this.getPathToViewTag(tagId, tagValue);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Cannot find tag id \"%d\" with tag value \"%s\" in view hierarchy:%n%s", new Object[]{tagId, tagValue, ((ViewTree)this.actual).makeString(ViewExtractors.generateGetViewTagFunction(tagId))})).isNotNull();
        return this;
    }

    public ViewTreeAssert hasContentDescription(String contentDescription) {
        ImmutableList<View> path = this.getPathToContentDescription(contentDescription);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Cannot find content description \"%s\" in view hierarchy:%n%s", new Object[]{contentDescription, ((ViewTree)this.actual).makeString(ViewExtractors.GET_CONTENT_DESCRIPTION_FUNCTION)})).isNotNull();
        return this;
    }

    public ViewTreeAssert doesNotHaveVisibleText(int resourceId) {
        return this.doesNotHaveVisibleText(ApplicationProvider.getApplicationContext().getResources().getString(resourceId));
    }

    public ViewTreeAssert hasContentDescription(int resourceId) {
        return this.hasContentDescription(ApplicationProvider.getApplicationContext().getResources().getString(resourceId));
    }

    private ImmutableList<View> getPathToVisibleSimilarText(final String text) {
        return ((ViewTree)this.actual).findChild((Predicate<View>)Predicates.and(ViewPredicates.isVisible(), ViewPredicates.hasTextMatchingPredicate(new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                if (input == null) {
                    return false;
                }
                int maxEditDistance = Math.max(3, text.length() / 4);
                return LevenshteinDistance.getLevenshteinDistance(text, input, maxEditDistance) <= maxEditDistance;
            }
        })), ViewPredicates.isVisible());
    }

    private ImmutableList<View> getPathToVisibleText(String text) {
        return ((ViewTree)this.actual).findChild(ViewPredicates.hasVisibleText(text), ViewPredicates.isVisible());
    }

    private ImmutableList<View> getPathToVisibleTextWithTag(String text, int tagId, Object tagValue) {
        return ((ViewTree)this.actual).findChild(ViewPredicates.hasVisibleTextWithTag(text, tagId, tagValue), ViewPredicates.isVisible());
    }

    private ImmutableList<View> getPathToViewTag(int tagId, Object tagValue) {
        return ((ViewTree)this.actual).findChild(ViewPredicates.hasTag(tagId, tagValue));
    }

    private ImmutableList<View> getPathToContentDescription(String contentDescription) {
        return ((ViewTree)this.actual).findChild(ViewPredicates.hasContentDescription(contentDescription));
    }

    public ViewTreeAssert hasVisibleTextMatching(String pattern) {
        ImmutableList<View> path = this.getPathToVisibleMatchingText(pattern);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Cannot find text matching \"%s\" in view hierarchy:%n%s", new Object[]{pattern, ((ViewTree)this.actual).makeString(ViewExtractors.GET_TEXT_FUNCTION)})).isNotNull();
        return this;
    }

    public ViewTreeAssert doesNotHaveVisibleTextMatching(String pattern) {
        ImmutableList<View> path = this.getPathToVisibleMatchingText(pattern);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Found pattern \"%s\" in view hierarchy for path: %s", new Object[]{pattern, this.makeString((Iterable<View>)path)})).isNull();
        return this;
    }

    public ViewTreeAssert doesNotHaveVisibleText() {
        ImmutableList<View> path = this.getPathToVisibleMatchingText(".+");
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Found text \"%s\" in view hierarchy for path: %s", new Object[]{this.getTextProof(path), this.makeString((Iterable<View>)path)})).isNull();
        return this;
    }

    private String getTextProof(@Nullable ImmutableList<View> path) {
        if (path == null) {
            return "";
        }
        View last = (View)path.get(path.size() - 1);
        return ((TextView)last).getText().toString();
    }

    private ImmutableList<View> getPathToVisibleMatchingText(String pattern) {
        return ((ViewTree)this.actual).findChild(ViewPredicates.hasVisibleMatchingText(pattern), ViewPredicates.isVisible());
    }

    private String makeString(Iterable<View> path) {
        return path != null ? Joiner.on((String)" -> ").join(path) : "";
    }

    public ViewTreeAssert hasVisibleDrawable(int resourceId) {
        this.hasVisibleDrawable(ApplicationProvider.getApplicationContext().getResources().getDrawable(resourceId));
        return this;
    }

    public ViewTreeAssert hasVisibleDrawable(Drawable drawable) {
        ImmutableList<View> path = this.getPathToVisibleWithDrawable(drawable);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Did not find drawable %s in view hierarchy:%n%s", new Object[]{drawable, ((ViewTree)this.actual).makeString(ViewExtractors.GET_DRAWABLE_FUNCTION)})).isNotNull();
        return this;
    }

    public ViewTreeAssert doesNotHaveVisibleDrawable(int resourceId) {
        this.doesNotHaveVisibleDrawable(ApplicationProvider.getApplicationContext().getResources().getDrawable(resourceId));
        return this;
    }

    public ViewTreeAssert doesNotHaveVisibleDrawable(Drawable drawable) {
        ImmutableList<View> path = this.getPathToVisibleWithDrawable(drawable);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Found drawable %s in view hierarchy:%n%s", new Object[]{drawable, ((ViewTree)this.actual).makeString(ViewExtractors.GET_DRAWABLE_FUNCTION)})).isNull();
        return this;
    }

    public ViewTreeAssert hasVisibleViewWithId(int viewId) {
        ImmutableList<View> path = this.getPathToVisibleWithId(viewId);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Did not find visible view with id \"%s=%d\":%n%s", new Object[]{ViewTreeUtil.getResourceName(viewId), viewId, ((ViewTree)this.actual).makeString(ViewExtractors.GET_VIEW_ID_FUNCTION)})).isNotNull();
        return this;
    }

    public ViewTreeAssert doesNotHaveVisibleViewWithId(int viewId) {
        ImmutableList<View> path = this.getPathToVisibleWithId(viewId);
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Found visible view with id \"%s=%d\":%n%s", new Object[]{ViewTreeUtil.getResourceName(viewId), viewId, ((ViewTree)this.actual).makeString(ViewExtractors.GET_VIEW_ID_FUNCTION)})).isNull();
        return this;
    }

    public <V extends View> ViewTreeAssert hasVisible(Class<V> clazz, Predicate<V> predicate) {
        Predicate conjunction = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(clazz), ViewPredicates.isVisible(), predicate});
        ImmutableList<View> path = ((ViewTree)this.actual).findChild((Predicate<View>)conjunction, ViewPredicates.isVisible());
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Did not find view for which given predicate is true in view hierarchy:%n%s", new Object[]{((ViewTree)this.actual).makeString(null)})).isNotNull();
        return this;
    }

    public <V extends View> ViewTreeAssert doesNotHaveVisible(Class<V> clazz, Predicate<Object> predicate) {
        Predicate conjunction = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(clazz), ViewPredicates.isVisible(), predicate});
        ImmutableList<View> path = ((ViewTree)this.actual).findChild((Predicate<View>)conjunction, ViewPredicates.isVisible());
        ((ListAssert)Assertions.assertThat(path).overridingErrorMessage("Found a view for which given predicate is true in view hierarchy:%n%s", new Object[]{((ViewTree)this.actual).makeString(null)})).isNull();
        return this;
    }

    private ImmutableList<View> getPathToVisibleWithDrawable(Drawable drawable) {
        return ((ViewTree)this.actual).findChild(ViewPredicates.hasVisibleDrawable(drawable), ViewPredicates.isVisible());
    }

    private ImmutableList<View> getPathToVisibleWithId(int viewId) {
        return ((ViewTree)this.actual).findChild(ViewPredicates.hasVisibleId(viewId), ViewPredicates.isVisible());
    }
}

