/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.Card;
import com.facebook.litho.widget.TestCardSpec;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestCard
implements TestCardSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mCardBackgroundColorMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<DynamicValue> mCardBackgroundColorDvMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<String> mCardBackgroundTransitionKeyMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mClippingColorMatcher;
        @javax.annotation.Nullable
        Condition<InspectableComponent> mContentComponentMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Component> mContentMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mCornerRadiusMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mDisableClipBottomLeftMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mDisableClipBottomRightMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mDisableClipTopLeftMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mDisableClipTopRightMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mElevationMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mShadowBottomOverrideMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mShadowEndColorMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mShadowLeftOverrideMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mShadowRightOverrideMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mShadowStartColorMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mShadowTopOverrideMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mTransparencyEnabledMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher cardBackgroundColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mCardBackgroundColorMatcher = matcher;
            return this;
        }

        public Matcher cardBackgroundColor(@ColorInt int cardBackgroundColor) {
            this.mCardBackgroundColorMatcher = Is.is((Object)cardBackgroundColor);
            return this;
        }

        public Matcher cardBackgroundColorRes(@ColorRes int resId) {
            this.mCardBackgroundColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher cardBackgroundColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardBackgroundColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher cardBackgroundColorAttr(@AttrRes int attrResId) {
            this.mCardBackgroundColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher cardBackgroundColorDv(org.hamcrest.Matcher<DynamicValue> matcher) {
            this.mCardBackgroundColorDvMatcher = matcher;
            return this;
        }

        public Matcher cardBackgroundColorDv(@Nullable DynamicValue cardBackgroundColorDv) {
            this.mCardBackgroundColorDvMatcher = Is.is((Object)cardBackgroundColorDv);
            return this;
        }

        public Matcher cardBackgroundTransitionKey(org.hamcrest.Matcher<String> matcher) {
            this.mCardBackgroundTransitionKeyMatcher = matcher;
            return this;
        }

        public Matcher cardBackgroundTransitionKey(@Nullable String cardBackgroundTransitionKey) {
            this.mCardBackgroundTransitionKeyMatcher = Is.is((Object)cardBackgroundTransitionKey);
            return this;
        }

        public Matcher clippingColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mClippingColorMatcher = matcher;
            return this;
        }

        public Matcher clippingColor(@ColorInt int clippingColor) {
            this.mClippingColorMatcher = Is.is((Object)clippingColor);
            return this;
        }

        public Matcher clippingColorRes(@ColorRes int resId) {
            this.mClippingColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher clippingColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mClippingColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher clippingColorAttr(@AttrRes int attrResId) {
            this.mClippingColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher content(Condition<InspectableComponent> matcher) {
            this.mContentComponentMatcher = matcher;
            return this;
        }

        public Matcher content(org.hamcrest.Matcher<Component> matcher) {
            this.mContentMatcher = matcher;
            return this;
        }

        public Matcher content(Component content) {
            this.mContentMatcher = Is.is((Object)content);
            return this;
        }

        public Matcher content(Component.Builder<?> contentBuilder) {
            this.mContentMatcher = Is.is((Object)contentBuilder.build());
            return this;
        }

        public Matcher cornerRadius(org.hamcrest.Matcher<Float> matcher) {
            this.mCornerRadiusMatcher = matcher;
            return this;
        }

        public Matcher cornerRadiusPx(@Px float cornerRadius) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(cornerRadius));
            return this;
        }

        public Matcher cornerRadiusRes(@DimenRes int resId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher cornerRadiusDip(@Dimension(unit=0) float dips) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher disableClipBottomLeft(org.hamcrest.Matcher<Boolean> matcher) {
            this.mDisableClipBottomLeftMatcher = matcher;
            return this;
        }

        public Matcher disableClipBottomLeft(boolean disableClipBottomLeft) {
            this.mDisableClipBottomLeftMatcher = Is.is((Object)disableClipBottomLeft);
            return this;
        }

        public Matcher disableClipBottomRight(org.hamcrest.Matcher<Boolean> matcher) {
            this.mDisableClipBottomRightMatcher = matcher;
            return this;
        }

        public Matcher disableClipBottomRight(boolean disableClipBottomRight) {
            this.mDisableClipBottomRightMatcher = Is.is((Object)disableClipBottomRight);
            return this;
        }

        public Matcher disableClipTopLeft(org.hamcrest.Matcher<Boolean> matcher) {
            this.mDisableClipTopLeftMatcher = matcher;
            return this;
        }

        public Matcher disableClipTopLeft(boolean disableClipTopLeft) {
            this.mDisableClipTopLeftMatcher = Is.is((Object)disableClipTopLeft);
            return this;
        }

        public Matcher disableClipTopRight(org.hamcrest.Matcher<Boolean> matcher) {
            this.mDisableClipTopRightMatcher = matcher;
            return this;
        }

        public Matcher disableClipTopRight(boolean disableClipTopRight) {
            this.mDisableClipTopRightMatcher = Is.is((Object)disableClipTopRight);
            return this;
        }

        public Matcher elevation(org.hamcrest.Matcher<Float> matcher) {
            this.mElevationMatcher = matcher;
            return this;
        }

        public Matcher elevationPx(@Px float elevation) {
            this.mElevationMatcher = Is.is((Object)Float.valueOf(elevation));
            return this;
        }

        public Matcher elevationRes(@DimenRes int resId) {
            this.mElevationMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher elevationAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mElevationMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher elevationAttr(@AttrRes int attrResId) {
            this.mElevationMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher elevationDip(@Dimension(unit=0) float dips) {
            this.mElevationMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowBottomOverride(org.hamcrest.Matcher<Integer> matcher) {
            this.mShadowBottomOverrideMatcher = matcher;
            return this;
        }

        public Matcher shadowBottomOverridePx(@Px int shadowBottomOverride) {
            this.mShadowBottomOverrideMatcher = Is.is((Object)shadowBottomOverride);
            return this;
        }

        public Matcher shadowBottomOverrideRes(@DimenRes int resId) {
            this.mShadowBottomOverrideMatcher = Is.is((Object)this.mResourceResolver.resolveDimenOffsetRes(resId));
            return this;
        }

        public Matcher shadowBottomOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowBottomOverrideMatcher = Is.is((Object)this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId));
            return this;
        }

        public Matcher shadowBottomOverrideAttr(@AttrRes int attrResId) {
            this.mShadowBottomOverrideMatcher = Is.is((Object)this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0));
            return this;
        }

        public Matcher shadowBottomOverrideDip(@Dimension(unit=0) float dips) {
            this.mShadowBottomOverrideMatcher = Is.is((Object)this.mResourceResolver.dipsToPixels(dips));
            return this;
        }

        public Matcher shadowEndColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mShadowEndColorMatcher = matcher;
            return this;
        }

        public Matcher shadowEndColor(@ColorInt int shadowEndColor) {
            this.mShadowEndColorMatcher = Is.is((Object)shadowEndColor);
            return this;
        }

        public Matcher shadowEndColorRes(@ColorRes int resId) {
            this.mShadowEndColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher shadowEndColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mShadowEndColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher shadowEndColorAttr(@AttrRes int attrResId) {
            this.mShadowEndColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher shadowLeftOverride(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowLeftOverrideMatcher = matcher;
            return this;
        }

        public Matcher shadowLeftOverridePx(@Px float shadowLeftOverride) {
            this.mShadowLeftOverrideMatcher = Is.is((Object)Float.valueOf(shadowLeftOverride));
            return this;
        }

        public Matcher shadowLeftOverrideRes(@DimenRes int resId) {
            this.mShadowLeftOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowLeftOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowLeftOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowLeftOverrideAttr(@AttrRes int attrResId) {
            this.mShadowLeftOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowLeftOverrideDip(@Dimension(unit=0) float dips) {
            this.mShadowLeftOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowRightOverride(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowRightOverrideMatcher = matcher;
            return this;
        }

        public Matcher shadowRightOverridePx(@Px float shadowRightOverride) {
            this.mShadowRightOverrideMatcher = Is.is((Object)Float.valueOf(shadowRightOverride));
            return this;
        }

        public Matcher shadowRightOverrideRes(@DimenRes int resId) {
            this.mShadowRightOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowRightOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowRightOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowRightOverrideAttr(@AttrRes int attrResId) {
            this.mShadowRightOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowRightOverrideDip(@Dimension(unit=0) float dips) {
            this.mShadowRightOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowStartColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mShadowStartColorMatcher = matcher;
            return this;
        }

        public Matcher shadowStartColor(@ColorInt int shadowStartColor) {
            this.mShadowStartColorMatcher = Is.is((Object)shadowStartColor);
            return this;
        }

        public Matcher shadowStartColorRes(@ColorRes int resId) {
            this.mShadowStartColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher shadowStartColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mShadowStartColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher shadowStartColorAttr(@AttrRes int attrResId) {
            this.mShadowStartColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher shadowTopOverride(org.hamcrest.Matcher<Integer> matcher) {
            this.mShadowTopOverrideMatcher = matcher;
            return this;
        }

        public Matcher shadowTopOverridePx(@Px int shadowTopOverride) {
            this.mShadowTopOverrideMatcher = Is.is((Object)shadowTopOverride);
            return this;
        }

        public Matcher shadowTopOverrideRes(@DimenRes int resId) {
            this.mShadowTopOverrideMatcher = Is.is((Object)this.mResourceResolver.resolveDimenOffsetRes(resId));
            return this;
        }

        public Matcher shadowTopOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowTopOverrideMatcher = Is.is((Object)this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId));
            return this;
        }

        public Matcher shadowTopOverrideAttr(@AttrRes int attrResId) {
            this.mShadowTopOverrideMatcher = Is.is((Object)this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0));
            return this;
        }

        public Matcher shadowTopOverrideDip(@Dimension(unit=0) float dips) {
            this.mShadowTopOverrideMatcher = Is.is((Object)this.mResourceResolver.dipsToPixels(dips));
            return this;
        }

        public Matcher transparencyEnabled(org.hamcrest.Matcher<Boolean> matcher) {
            this.mTransparencyEnabledMatcher = matcher;
            return this;
        }

        public Matcher transparencyEnabled(boolean transparencyEnabled) {
            this.mTransparencyEnabledMatcher = Is.is((Object)transparencyEnabled);
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(Card.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.Card\"", new Object[0]));
                        return false;
                    }
                    Card impl = (Card)value.getComponent();
                    int propValueCardBackgroundColor = impl.cardBackgroundColor;
                    if (mCardBackgroundColorMatcher != null && !mCardBackgroundColorMatcher.matches((Object)propValueCardBackgroundColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <cardBackgroundColor> %s (doesn't match %s)", new Object[]{mCardBackgroundColorMatcher, propValueCardBackgroundColor}));
                        return false;
                    }
                    DynamicValue propValueCardBackgroundColorDv = impl.cardBackgroundColorDv;
                    if (mCardBackgroundColorDvMatcher != null && !mCardBackgroundColorDvMatcher.matches((Object)propValueCardBackgroundColorDv)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <cardBackgroundColorDv> %s (doesn't match %s)", new Object[]{mCardBackgroundColorDvMatcher, propValueCardBackgroundColorDv}));
                        return false;
                    }
                    String propValueCardBackgroundTransitionKey = impl.cardBackgroundTransitionKey;
                    if (mCardBackgroundTransitionKeyMatcher != null && !mCardBackgroundTransitionKeyMatcher.matches((Object)propValueCardBackgroundTransitionKey)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <cardBackgroundTransitionKey> %s (doesn't match %s)", new Object[]{mCardBackgroundTransitionKeyMatcher, propValueCardBackgroundTransitionKey}));
                        return false;
                    }
                    int propValueClippingColor = impl.clippingColor;
                    if (mClippingColorMatcher != null && !mClippingColorMatcher.matches((Object)propValueClippingColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <clippingColor> %s (doesn't match %s)", new Object[]{mClippingColorMatcher, propValueClippingColor}));
                        return false;
                    }
                    Component propValueContentComponent = impl.content;
                    if (mContentComponentMatcher != null && !mContentComponentMatcher.matches((Object)value.getNestedInstance(propValueContentComponent))) {
                        this.as(mContentComponentMatcher.description());
                        return false;
                    }
                    Component propValueContent = impl.content;
                    if (mContentMatcher != null && !mContentMatcher.matches((Object)propValueContent)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <content> %s (doesn't match %s)", new Object[]{mContentMatcher, propValueContent}));
                        return false;
                    }
                    float propValueCornerRadius = impl.cornerRadius;
                    if (mCornerRadiusMatcher != null && !mCornerRadiusMatcher.matches((Object)Float.valueOf(propValueCornerRadius))) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <cornerRadius> %s (doesn't match %s)", new Object[]{mCornerRadiusMatcher, Float.valueOf(propValueCornerRadius)}));
                        return false;
                    }
                    boolean propValueDisableClipBottomLeft = impl.disableClipBottomLeft;
                    if (mDisableClipBottomLeftMatcher != null && !mDisableClipBottomLeftMatcher.matches((Object)propValueDisableClipBottomLeft)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <disableClipBottomLeft> %s (doesn't match %s)", new Object[]{mDisableClipBottomLeftMatcher, propValueDisableClipBottomLeft}));
                        return false;
                    }
                    boolean propValueDisableClipBottomRight = impl.disableClipBottomRight;
                    if (mDisableClipBottomRightMatcher != null && !mDisableClipBottomRightMatcher.matches((Object)propValueDisableClipBottomRight)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <disableClipBottomRight> %s (doesn't match %s)", new Object[]{mDisableClipBottomRightMatcher, propValueDisableClipBottomRight}));
                        return false;
                    }
                    boolean propValueDisableClipTopLeft = impl.disableClipTopLeft;
                    if (mDisableClipTopLeftMatcher != null && !mDisableClipTopLeftMatcher.matches((Object)propValueDisableClipTopLeft)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <disableClipTopLeft> %s (doesn't match %s)", new Object[]{mDisableClipTopLeftMatcher, propValueDisableClipTopLeft}));
                        return false;
                    }
                    boolean propValueDisableClipTopRight = impl.disableClipTopRight;
                    if (mDisableClipTopRightMatcher != null && !mDisableClipTopRightMatcher.matches((Object)propValueDisableClipTopRight)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <disableClipTopRight> %s (doesn't match %s)", new Object[]{mDisableClipTopRightMatcher, propValueDisableClipTopRight}));
                        return false;
                    }
                    float propValueElevation = impl.elevation;
                    if (mElevationMatcher != null && !mElevationMatcher.matches((Object)Float.valueOf(propValueElevation))) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <elevation> %s (doesn't match %s)", new Object[]{mElevationMatcher, Float.valueOf(propValueElevation)}));
                        return false;
                    }
                    int propValueShadowBottomOverride = impl.shadowBottomOverride;
                    if (mShadowBottomOverrideMatcher != null && !mShadowBottomOverrideMatcher.matches((Object)propValueShadowBottomOverride)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <shadowBottomOverride> %s (doesn't match %s)", new Object[]{mShadowBottomOverrideMatcher, propValueShadowBottomOverride}));
                        return false;
                    }
                    int propValueShadowEndColor = impl.shadowEndColor;
                    if (mShadowEndColorMatcher != null && !mShadowEndColorMatcher.matches((Object)propValueShadowEndColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <shadowEndColor> %s (doesn't match %s)", new Object[]{mShadowEndColorMatcher, propValueShadowEndColor}));
                        return false;
                    }
                    float propValueShadowLeftOverride = impl.shadowLeftOverride;
                    if (mShadowLeftOverrideMatcher != null && !mShadowLeftOverrideMatcher.matches((Object)Float.valueOf(propValueShadowLeftOverride))) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <shadowLeftOverride> %s (doesn't match %s)", new Object[]{mShadowLeftOverrideMatcher, Float.valueOf(propValueShadowLeftOverride)}));
                        return false;
                    }
                    float propValueShadowRightOverride = impl.shadowRightOverride;
                    if (mShadowRightOverrideMatcher != null && !mShadowRightOverrideMatcher.matches((Object)Float.valueOf(propValueShadowRightOverride))) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <shadowRightOverride> %s (doesn't match %s)", new Object[]{mShadowRightOverrideMatcher, Float.valueOf(propValueShadowRightOverride)}));
                        return false;
                    }
                    int propValueShadowStartColor = impl.shadowStartColor;
                    if (mShadowStartColorMatcher != null && !mShadowStartColorMatcher.matches((Object)propValueShadowStartColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <shadowStartColor> %s (doesn't match %s)", new Object[]{mShadowStartColorMatcher, propValueShadowStartColor}));
                        return false;
                    }
                    int propValueShadowTopOverride = impl.shadowTopOverride;
                    if (mShadowTopOverrideMatcher != null && !mShadowTopOverrideMatcher.matches((Object)propValueShadowTopOverride)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <shadowTopOverride> %s (doesn't match %s)", new Object[]{mShadowTopOverrideMatcher, propValueShadowTopOverride}));
                        return false;
                    }
                    boolean propValueTransparencyEnabled = impl.transparencyEnabled;
                    if (mTransparencyEnabledMatcher != null && !mTransparencyEnabledMatcher.matches((Object)propValueTransparencyEnabled)) {
                        this.as((Description)new TextDescription("Sub-component of type <Card> with prop <transparencyEnabled> %s (doesn't match %s)", new Object[]{mTransparencyEnabledMatcher, propValueTransparencyEnabled}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

