/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Px;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.CardClip;
import com.facebook.litho.widget.TestCardClipSpec;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestCardClip
implements TestCardClipSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @Nullable
        org.hamcrest.Matcher<Integer> mClippingColorMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mCornerRadiusMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mDisableClipBottomLeftMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mDisableClipBottomRightMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mDisableClipTopLeftMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mDisableClipTopRightMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher clippingColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mClippingColorMatcher = matcher;
            return this;
        }

        public Matcher clippingColor(@ColorInt int clippingColor) {
            this.mClippingColorMatcher = Is.is((Object)clippingColor);
            return this;
        }

        public Matcher clippingColorRes(@ColorRes int resId) {
            this.mClippingColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher clippingColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mClippingColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher clippingColorAttr(@AttrRes int attrResId) {
            this.mClippingColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher cornerRadius(org.hamcrest.Matcher<Float> matcher) {
            this.mCornerRadiusMatcher = matcher;
            return this;
        }

        public Matcher cornerRadiusPx(@Px float cornerRadius) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(cornerRadius));
            return this;
        }

        public Matcher cornerRadiusRes(@DimenRes int resId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher cornerRadiusDip(@Dimension(unit=0) float dips) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher disableClipBottomLeft(org.hamcrest.Matcher<Boolean> matcher) {
            this.mDisableClipBottomLeftMatcher = matcher;
            return this;
        }

        public Matcher disableClipBottomLeft(boolean disableClipBottomLeft) {
            this.mDisableClipBottomLeftMatcher = Is.is((Object)disableClipBottomLeft);
            return this;
        }

        public Matcher disableClipBottomRight(org.hamcrest.Matcher<Boolean> matcher) {
            this.mDisableClipBottomRightMatcher = matcher;
            return this;
        }

        public Matcher disableClipBottomRight(boolean disableClipBottomRight) {
            this.mDisableClipBottomRightMatcher = Is.is((Object)disableClipBottomRight);
            return this;
        }

        public Matcher disableClipTopLeft(org.hamcrest.Matcher<Boolean> matcher) {
            this.mDisableClipTopLeftMatcher = matcher;
            return this;
        }

        public Matcher disableClipTopLeft(boolean disableClipTopLeft) {
            this.mDisableClipTopLeftMatcher = Is.is((Object)disableClipTopLeft);
            return this;
        }

        public Matcher disableClipTopRight(org.hamcrest.Matcher<Boolean> matcher) {
            this.mDisableClipTopRightMatcher = matcher;
            return this;
        }

        public Matcher disableClipTopRight(boolean disableClipTopRight) {
            this.mDisableClipTopRightMatcher = Is.is((Object)disableClipTopRight);
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(CardClip.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.CardClip\"", new Object[0]));
                        return false;
                    }
                    CardClip impl = (CardClip)value.getComponent();
                    int propValueClippingColor = impl.clippingColor;
                    if (mClippingColorMatcher != null && !mClippingColorMatcher.matches((Object)propValueClippingColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardClip> with prop <clippingColor> %s (doesn't match %s)", new Object[]{mClippingColorMatcher, propValueClippingColor}));
                        return false;
                    }
                    float propValueCornerRadius = impl.cornerRadius;
                    if (mCornerRadiusMatcher != null && !mCornerRadiusMatcher.matches((Object)Float.valueOf(propValueCornerRadius))) {
                        this.as((Description)new TextDescription("Sub-component of type <CardClip> with prop <cornerRadius> %s (doesn't match %s)", new Object[]{mCornerRadiusMatcher, Float.valueOf(propValueCornerRadius)}));
                        return false;
                    }
                    boolean propValueDisableClipBottomLeft = impl.disableClipBottomLeft;
                    if (mDisableClipBottomLeftMatcher != null && !mDisableClipBottomLeftMatcher.matches((Object)propValueDisableClipBottomLeft)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardClip> with prop <disableClipBottomLeft> %s (doesn't match %s)", new Object[]{mDisableClipBottomLeftMatcher, propValueDisableClipBottomLeft}));
                        return false;
                    }
                    boolean propValueDisableClipBottomRight = impl.disableClipBottomRight;
                    if (mDisableClipBottomRightMatcher != null && !mDisableClipBottomRightMatcher.matches((Object)propValueDisableClipBottomRight)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardClip> with prop <disableClipBottomRight> %s (doesn't match %s)", new Object[]{mDisableClipBottomRightMatcher, propValueDisableClipBottomRight}));
                        return false;
                    }
                    boolean propValueDisableClipTopLeft = impl.disableClipTopLeft;
                    if (mDisableClipTopLeftMatcher != null && !mDisableClipTopLeftMatcher.matches((Object)propValueDisableClipTopLeft)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardClip> with prop <disableClipTopLeft> %s (doesn't match %s)", new Object[]{mDisableClipTopLeftMatcher, propValueDisableClipTopLeft}));
                        return false;
                    }
                    boolean propValueDisableClipTopRight = impl.disableClipTopRight;
                    if (mDisableClipTopRightMatcher != null && !mDisableClipTopRightMatcher.matches((Object)propValueDisableClipTopRight)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardClip> with prop <disableClipTopRight> %s (doesn't match %s)", new Object[]{mDisableClipTopRightMatcher, propValueDisableClipTopRight}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

