/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Px;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.CardShadow;
import com.facebook.litho.widget.TestCardShadowSpec;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestCardShadow
implements TestCardShadowSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @Nullable
        org.hamcrest.Matcher<Float> mCornerRadiusMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mHideBottomShadowMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mHideTopShadowMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mShadowDxMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mShadowDyMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mShadowEndColorMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mShadowLeftSizeOverrideMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mShadowRightSizeOverrideMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mShadowSizeMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mShadowStartColorMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher cornerRadius(org.hamcrest.Matcher<Float> matcher) {
            this.mCornerRadiusMatcher = matcher;
            return this;
        }

        public Matcher cornerRadiusPx(@Px float cornerRadius) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(cornerRadius));
            return this;
        }

        public Matcher cornerRadiusRes(@DimenRes int resId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher cornerRadiusDip(@Dimension(unit=0) float dips) {
            this.mCornerRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher hideBottomShadow(org.hamcrest.Matcher<Boolean> matcher) {
            this.mHideBottomShadowMatcher = matcher;
            return this;
        }

        public Matcher hideBottomShadow(boolean hideBottomShadow) {
            this.mHideBottomShadowMatcher = Is.is((Object)hideBottomShadow);
            return this;
        }

        public Matcher hideTopShadow(org.hamcrest.Matcher<Boolean> matcher) {
            this.mHideTopShadowMatcher = matcher;
            return this;
        }

        public Matcher hideTopShadow(boolean hideTopShadow) {
            this.mHideTopShadowMatcher = Is.is((Object)hideTopShadow);
            return this;
        }

        public Matcher shadowDx(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowDxMatcher = matcher;
            return this;
        }

        public Matcher shadowDxPx(@Px float shadowDx) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(shadowDx));
            return this;
        }

        public Matcher shadowDxRes(@DimenRes int resId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowDxAttr(@AttrRes int attrResId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowDxDip(@Dimension(unit=0) float dips) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowDy(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowDyMatcher = matcher;
            return this;
        }

        public Matcher shadowDyPx(@Px float shadowDy) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(shadowDy));
            return this;
        }

        public Matcher shadowDyRes(@DimenRes int resId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowDyAttr(@AttrRes int attrResId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowDyDip(@Dimension(unit=0) float dips) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowEndColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mShadowEndColorMatcher = matcher;
            return this;
        }

        public Matcher shadowEndColor(@ColorInt int shadowEndColor) {
            this.mShadowEndColorMatcher = Is.is((Object)shadowEndColor);
            return this;
        }

        public Matcher shadowEndColorRes(@ColorRes int resId) {
            this.mShadowEndColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher shadowEndColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mShadowEndColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher shadowEndColorAttr(@AttrRes int attrResId) {
            this.mShadowEndColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher shadowLeftSizeOverride(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowLeftSizeOverrideMatcher = matcher;
            return this;
        }

        public Matcher shadowLeftSizeOverridePx(@Px float shadowLeftSizeOverride) {
            this.mShadowLeftSizeOverrideMatcher = Is.is((Object)Float.valueOf(shadowLeftSizeOverride));
            return this;
        }

        public Matcher shadowLeftSizeOverrideRes(@DimenRes int resId) {
            this.mShadowLeftSizeOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeRes(resId)));
            return this;
        }

        public Matcher shadowLeftSizeOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowLeftSizeOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowLeftSizeOverrideAttr(@AttrRes int attrResId) {
            this.mShadowLeftSizeOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowLeftSizeOverrideDip(@Dimension(unit=0) float dips) {
            this.mShadowLeftSizeOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowRightSizeOverride(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowRightSizeOverrideMatcher = matcher;
            return this;
        }

        public Matcher shadowRightSizeOverridePx(@Px float shadowRightSizeOverride) {
            this.mShadowRightSizeOverrideMatcher = Is.is((Object)Float.valueOf(shadowRightSizeOverride));
            return this;
        }

        public Matcher shadowRightSizeOverrideRes(@DimenRes int resId) {
            this.mShadowRightSizeOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeRes(resId)));
            return this;
        }

        public Matcher shadowRightSizeOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowRightSizeOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowRightSizeOverrideAttr(@AttrRes int attrResId) {
            this.mShadowRightSizeOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowRightSizeOverrideDip(@Dimension(unit=0) float dips) {
            this.mShadowRightSizeOverrideMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowSize(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowSizeMatcher = matcher;
            return this;
        }

        public Matcher shadowSizePx(@Px float shadowSize) {
            this.mShadowSizeMatcher = Is.is((Object)Float.valueOf(shadowSize));
            return this;
        }

        public Matcher shadowSizeRes(@DimenRes int resId) {
            this.mShadowSizeMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeRes(resId)));
            return this;
        }

        public Matcher shadowSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowSizeMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowSizeAttr(@AttrRes int attrResId) {
            this.mShadowSizeMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowSizeDip(@Dimension(unit=0) float dips) {
            this.mShadowSizeMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowStartColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mShadowStartColorMatcher = matcher;
            return this;
        }

        public Matcher shadowStartColor(@ColorInt int shadowStartColor) {
            this.mShadowStartColorMatcher = Is.is((Object)shadowStartColor);
            return this;
        }

        public Matcher shadowStartColorRes(@ColorRes int resId) {
            this.mShadowStartColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher shadowStartColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mShadowStartColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher shadowStartColorAttr(@AttrRes int attrResId) {
            this.mShadowStartColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(CardShadow.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.CardShadow\"", new Object[0]));
                        return false;
                    }
                    CardShadow impl = (CardShadow)value.getComponent();
                    float propValueCornerRadius = impl.cornerRadius;
                    if (mCornerRadiusMatcher != null && !mCornerRadiusMatcher.matches((Object)Float.valueOf(propValueCornerRadius))) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <cornerRadius> %s (doesn't match %s)", new Object[]{mCornerRadiusMatcher, Float.valueOf(propValueCornerRadius)}));
                        return false;
                    }
                    boolean propValueHideBottomShadow = impl.hideBottomShadow;
                    if (mHideBottomShadowMatcher != null && !mHideBottomShadowMatcher.matches((Object)propValueHideBottomShadow)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <hideBottomShadow> %s (doesn't match %s)", new Object[]{mHideBottomShadowMatcher, propValueHideBottomShadow}));
                        return false;
                    }
                    boolean propValueHideTopShadow = impl.hideTopShadow;
                    if (mHideTopShadowMatcher != null && !mHideTopShadowMatcher.matches((Object)propValueHideTopShadow)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <hideTopShadow> %s (doesn't match %s)", new Object[]{mHideTopShadowMatcher, propValueHideTopShadow}));
                        return false;
                    }
                    float propValueShadowDx = impl.shadowDx;
                    if (mShadowDxMatcher != null && !mShadowDxMatcher.matches((Object)Float.valueOf(propValueShadowDx))) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <shadowDx> %s (doesn't match %s)", new Object[]{mShadowDxMatcher, Float.valueOf(propValueShadowDx)}));
                        return false;
                    }
                    float propValueShadowDy = impl.shadowDy;
                    if (mShadowDyMatcher != null && !mShadowDyMatcher.matches((Object)Float.valueOf(propValueShadowDy))) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <shadowDy> %s (doesn't match %s)", new Object[]{mShadowDyMatcher, Float.valueOf(propValueShadowDy)}));
                        return false;
                    }
                    int propValueShadowEndColor = impl.shadowEndColor;
                    if (mShadowEndColorMatcher != null && !mShadowEndColorMatcher.matches((Object)propValueShadowEndColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <shadowEndColor> %s (doesn't match %s)", new Object[]{mShadowEndColorMatcher, propValueShadowEndColor}));
                        return false;
                    }
                    float propValueShadowLeftSizeOverride = impl.shadowLeftSizeOverride;
                    if (mShadowLeftSizeOverrideMatcher != null && !mShadowLeftSizeOverrideMatcher.matches((Object)Float.valueOf(propValueShadowLeftSizeOverride))) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <shadowLeftSizeOverride> %s (doesn't match %s)", new Object[]{mShadowLeftSizeOverrideMatcher, Float.valueOf(propValueShadowLeftSizeOverride)}));
                        return false;
                    }
                    float propValueShadowRightSizeOverride = impl.shadowRightSizeOverride;
                    if (mShadowRightSizeOverrideMatcher != null && !mShadowRightSizeOverrideMatcher.matches((Object)Float.valueOf(propValueShadowRightSizeOverride))) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <shadowRightSizeOverride> %s (doesn't match %s)", new Object[]{mShadowRightSizeOverrideMatcher, Float.valueOf(propValueShadowRightSizeOverride)}));
                        return false;
                    }
                    float propValueShadowSize = impl.shadowSize;
                    if (mShadowSizeMatcher != null && !mShadowSizeMatcher.matches((Object)Float.valueOf(propValueShadowSize))) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <shadowSize> %s (doesn't match %s)", new Object[]{mShadowSizeMatcher, Float.valueOf(propValueShadowSize)}));
                        return false;
                    }
                    int propValueShadowStartColor = impl.shadowStartColor;
                    if (mShadowStartColorMatcher != null && !mShadowStartColorMatcher.matches((Object)propValueShadowStartColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <CardShadow> with prop <shadowStartColor> %s (doesn't match %s)", new Object[]{mShadowStartColorMatcher, propValueShadowStartColor}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

