/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.text.InputFilter;
import android.text.Layout;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.IntegerRes;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.EditText;
import com.facebook.litho.widget.EditTextStateUpdatePolicy;
import com.facebook.litho.widget.TestEditTextSpec;
import java.util.List;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestEditText
implements TestEditTextSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @Nullable
        org.hamcrest.Matcher<Integer> mCursorDrawableResMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mEditableMatcher;
        @Nullable
        org.hamcrest.Matcher<TextView.OnEditorActionListener> mEditorActionListenerMatcher;
        @Nullable
        org.hamcrest.Matcher<TextUtils.TruncateAt> mEllipsizeMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mExtraSpacingMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mGravityMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mHighlightColorMatcher;
        @Nullable
        org.hamcrest.Matcher<CharSequence> mHintMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mHintColorMatcher;
        @Nullable
        org.hamcrest.Matcher<ColorStateList> mHintColorStateListMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mImeOptionsMatcher;
        @Nullable
        org.hamcrest.Matcher<CharSequence> mInitialTextMatcher;
        @Nullable
        org.hamcrest.Matcher<List> mInputFiltersMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mInputTypeMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mIsSingleLineMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mIsSingleLineWrapMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mLinkColorMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mMaxLengthMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mMaxLinesMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mMinLinesMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mRawInputTypeMatcher;
        @Nullable
        org.hamcrest.Matcher<Boolean> mRequestFocusMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mSelectionMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mShadowColorMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mShadowDxMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mShadowDyMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mShadowRadiusMatcher;
        @Nullable
        org.hamcrest.Matcher<Float> mSpacingMultiplierMatcher;
        @Nullable
        org.hamcrest.Matcher<EditTextStateUpdatePolicy> mStateUpdatePolicyMatcher;
        @Nullable
        org.hamcrest.Matcher<CharSequence> mTextMatcher;
        @Nullable
        org.hamcrest.Matcher<Layout.Alignment> mTextAlignmentMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mTextColorMatcher;
        @Nullable
        org.hamcrest.Matcher<ColorStateList> mTextColorStateListMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mTextSizeMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mTextStyleMatcher;
        @Nullable
        org.hamcrest.Matcher<List> mTextWatchersMatcher;
        @Nullable
        org.hamcrest.Matcher<ColorStateList> mTintColorStateListMatcher;
        @Nullable
        org.hamcrest.Matcher<Typeface> mTypefaceMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher cursorDrawableRes(org.hamcrest.Matcher<Integer> matcher) {
            this.mCursorDrawableResMatcher = matcher;
            return this;
        }

        public Matcher cursorDrawableRes(int cursorDrawableRes) {
            this.mCursorDrawableResMatcher = Is.is((Object)cursorDrawableRes);
            return this;
        }

        public Matcher editable(org.hamcrest.Matcher<Boolean> matcher) {
            this.mEditableMatcher = matcher;
            return this;
        }

        public Matcher editable(boolean editable) {
            this.mEditableMatcher = Is.is((Object)editable);
            return this;
        }

        public Matcher editorActionListener(org.hamcrest.Matcher<TextView.OnEditorActionListener> matcher) {
            this.mEditorActionListenerMatcher = matcher;
            return this;
        }

        public Matcher editorActionListener(TextView.OnEditorActionListener editorActionListener) {
            this.mEditorActionListenerMatcher = Is.is((Object)editorActionListener);
            return this;
        }

        public Matcher ellipsize(org.hamcrest.Matcher<TextUtils.TruncateAt> matcher) {
            this.mEllipsizeMatcher = matcher;
            return this;
        }

        public Matcher ellipsize(TextUtils.TruncateAt ellipsize) {
            this.mEllipsizeMatcher = Is.is((Object)ellipsize);
            return this;
        }

        public Matcher extraSpacing(org.hamcrest.Matcher<Float> matcher) {
            this.mExtraSpacingMatcher = matcher;
            return this;
        }

        public Matcher extraSpacingPx(@Px float extraSpacing) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(extraSpacing));
            return this;
        }

        public Matcher extraSpacingRes(@DimenRes int resId) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher extraSpacingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher extraSpacingAttr(@AttrRes int attrResId) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher extraSpacingDip(@Dimension(unit=0) float dips) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher gravity(org.hamcrest.Matcher<Integer> matcher) {
            this.mGravityMatcher = matcher;
            return this;
        }

        public Matcher gravity(int gravity) {
            this.mGravityMatcher = Is.is((Object)gravity);
            return this;
        }

        public Matcher highlightColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mHighlightColorMatcher = matcher;
            return this;
        }

        public Matcher highlightColor(@ColorInt int highlightColor) {
            this.mHighlightColorMatcher = Is.is((Object)highlightColor);
            return this;
        }

        public Matcher highlightColorRes(@ColorRes int resId) {
            this.mHighlightColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher highlightColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mHighlightColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher highlightColorAttr(@AttrRes int attrResId) {
            this.mHighlightColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher hint(org.hamcrest.Matcher<CharSequence> matcher) {
            this.mHintMatcher = matcher;
            return this;
        }

        public Matcher hint(CharSequence hint) {
            this.mHintMatcher = Is.is((Object)hint);
            return this;
        }

        public Matcher hintRes(@StringRes int resId) {
            this.mHintMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId));
            return this;
        }

        public Matcher hintRes(@StringRes int resId, Object ... formatArgs) {
            this.mHintMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId, formatArgs));
            return this;
        }

        public Matcher hintAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mHintMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, defResId));
            return this;
        }

        public Matcher hintAttr(@AttrRes int attrResId) {
            this.mHintMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, 0));
            return this;
        }

        public Matcher hintColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mHintColorMatcher = matcher;
            return this;
        }

        public Matcher hintColor(@ColorInt int hintColor) {
            this.mHintColorMatcher = Is.is((Object)hintColor);
            return this;
        }

        public Matcher hintColorRes(@ColorRes int resId) {
            this.mHintColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher hintColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mHintColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher hintColorAttr(@AttrRes int attrResId) {
            this.mHintColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher hintColorStateList(org.hamcrest.Matcher<ColorStateList> matcher) {
            this.mHintColorStateListMatcher = matcher;
            return this;
        }

        public Matcher hintColorStateList(ColorStateList hintColorStateList) {
            this.mHintColorStateListMatcher = Is.is((Object)hintColorStateList);
            return this;
        }

        public Matcher imeOptions(org.hamcrest.Matcher<Integer> matcher) {
            this.mImeOptionsMatcher = matcher;
            return this;
        }

        public Matcher imeOptions(int imeOptions) {
            this.mImeOptionsMatcher = Is.is((Object)imeOptions);
            return this;
        }

        public Matcher initialText(org.hamcrest.Matcher<CharSequence> matcher) {
            this.mInitialTextMatcher = matcher;
            return this;
        }

        public Matcher initialText(CharSequence initialText) {
            this.mInitialTextMatcher = Is.is((Object)initialText);
            return this;
        }

        public Matcher initialTextRes(@StringRes int resId) {
            this.mInitialTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId));
            return this;
        }

        public Matcher initialTextRes(@StringRes int resId, Object ... formatArgs) {
            this.mInitialTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId, formatArgs));
            return this;
        }

        public Matcher initialTextAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mInitialTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, defResId));
            return this;
        }

        public Matcher initialTextAttr(@AttrRes int attrResId) {
            this.mInitialTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, 0));
            return this;
        }

        public Matcher inputFilters(org.hamcrest.Matcher<List> matcher) {
            this.mInputFiltersMatcher = matcher;
            return this;
        }

        public Matcher inputFilter(InputFilter inputFilter) {
            if (inputFilter == null) {
                return this;
            }
            return this;
        }

        public Matcher inputFilters(List inputFilters) {
            if (inputFilters == null) {
                return this;
            }
            return this;
        }

        public Matcher inputType(org.hamcrest.Matcher<Integer> matcher) {
            this.mInputTypeMatcher = matcher;
            return this;
        }

        public Matcher inputType(int inputType) {
            this.mInputTypeMatcher = Is.is((Object)inputType);
            return this;
        }

        public Matcher isSingleLine(org.hamcrest.Matcher<Boolean> matcher) {
            this.mIsSingleLineMatcher = matcher;
            return this;
        }

        public Matcher isSingleLine(boolean isSingleLine) {
            this.mIsSingleLineMatcher = Is.is((Object)isSingleLine);
            return this;
        }

        public Matcher isSingleLineRes(@BoolRes int resId) {
            this.mIsSingleLineMatcher = Is.is((Object)this.mResourceResolver.resolveBoolRes(resId));
            return this;
        }

        public Matcher isSingleLineAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mIsSingleLineMatcher = Is.is((Object)this.mResourceResolver.resolveBoolAttr(attrResId, defResId));
            return this;
        }

        public Matcher isSingleLineAttr(@AttrRes int attrResId) {
            this.mIsSingleLineMatcher = Is.is((Object)this.mResourceResolver.resolveBoolAttr(attrResId, 0));
            return this;
        }

        public Matcher isSingleLineWrap(org.hamcrest.Matcher<Boolean> matcher) {
            this.mIsSingleLineWrapMatcher = matcher;
            return this;
        }

        public Matcher isSingleLineWrap(boolean isSingleLineWrap) {
            this.mIsSingleLineWrapMatcher = Is.is((Object)isSingleLineWrap);
            return this;
        }

        public Matcher linkColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mLinkColorMatcher = matcher;
            return this;
        }

        public Matcher linkColor(@ColorInt int linkColor) {
            this.mLinkColorMatcher = Is.is((Object)linkColor);
            return this;
        }

        public Matcher linkColorRes(@ColorRes int resId) {
            this.mLinkColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher linkColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mLinkColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher linkColorAttr(@AttrRes int attrResId) {
            this.mLinkColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher maxLength(org.hamcrest.Matcher<Integer> matcher) {
            this.mMaxLengthMatcher = matcher;
            return this;
        }

        public Matcher maxLength(int maxLength) {
            this.mMaxLengthMatcher = Is.is((Object)maxLength);
            return this;
        }

        public Matcher maxLengthRes(@IntegerRes int resId) {
            this.mMaxLengthMatcher = Is.is((Object)this.mResourceResolver.resolveIntRes(resId));
            return this;
        }

        public Matcher maxLengthAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mMaxLengthMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, defResId));
            return this;
        }

        public Matcher maxLengthAttr(@AttrRes int attrResId) {
            this.mMaxLengthMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, 0));
            return this;
        }

        public Matcher maxLines(org.hamcrest.Matcher<Integer> matcher) {
            this.mMaxLinesMatcher = matcher;
            return this;
        }

        public Matcher maxLines(int maxLines) {
            this.mMaxLinesMatcher = Is.is((Object)maxLines);
            return this;
        }

        public Matcher maxLinesRes(@IntegerRes int resId) {
            this.mMaxLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntRes(resId));
            return this;
        }

        public Matcher maxLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mMaxLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, defResId));
            return this;
        }

        public Matcher maxLinesAttr(@AttrRes int attrResId) {
            this.mMaxLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, 0));
            return this;
        }

        public Matcher minLines(org.hamcrest.Matcher<Integer> matcher) {
            this.mMinLinesMatcher = matcher;
            return this;
        }

        public Matcher minLines(int minLines) {
            this.mMinLinesMatcher = Is.is((Object)minLines);
            return this;
        }

        public Matcher minLinesRes(@IntegerRes int resId) {
            this.mMinLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntRes(resId));
            return this;
        }

        public Matcher minLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mMinLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, defResId));
            return this;
        }

        public Matcher minLinesAttr(@AttrRes int attrResId) {
            this.mMinLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, 0));
            return this;
        }

        public Matcher rawInputType(org.hamcrest.Matcher<Integer> matcher) {
            this.mRawInputTypeMatcher = matcher;
            return this;
        }

        public Matcher rawInputType(int rawInputType) {
            this.mRawInputTypeMatcher = Is.is((Object)rawInputType);
            return this;
        }

        public Matcher requestFocus(org.hamcrest.Matcher<Boolean> matcher) {
            this.mRequestFocusMatcher = matcher;
            return this;
        }

        public Matcher requestFocus(boolean requestFocus) {
            this.mRequestFocusMatcher = Is.is((Object)requestFocus);
            return this;
        }

        public Matcher selection(org.hamcrest.Matcher<Integer> matcher) {
            this.mSelectionMatcher = matcher;
            return this;
        }

        public Matcher selection(int selection) {
            this.mSelectionMatcher = Is.is((Object)selection);
            return this;
        }

        public Matcher shadowColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mShadowColorMatcher = matcher;
            return this;
        }

        public Matcher shadowColor(@ColorInt int shadowColor) {
            this.mShadowColorMatcher = Is.is((Object)shadowColor);
            return this;
        }

        public Matcher shadowColorRes(@ColorRes int resId) {
            this.mShadowColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher shadowColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mShadowColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher shadowColorAttr(@AttrRes int attrResId) {
            this.mShadowColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher shadowDx(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowDxMatcher = matcher;
            return this;
        }

        public Matcher shadowDxPx(@Px float shadowDx) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(shadowDx));
            return this;
        }

        public Matcher shadowDxRes(@DimenRes int resId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowDxAttr(@AttrRes int attrResId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowDxDip(@Dimension(unit=0) float dips) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowDy(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowDyMatcher = matcher;
            return this;
        }

        public Matcher shadowDyPx(@Px float shadowDy) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(shadowDy));
            return this;
        }

        public Matcher shadowDyRes(@DimenRes int resId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowDyAttr(@AttrRes int attrResId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowDyDip(@Dimension(unit=0) float dips) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowRadius(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowRadiusMatcher = matcher;
            return this;
        }

        public Matcher shadowRadiusPx(@Px float shadowRadius) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(shadowRadius));
            return this;
        }

        public Matcher shadowRadiusRes(@DimenRes int resId) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowRadiusAttr(@AttrRes int attrResId) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowRadiusDip(@Dimension(unit=0) float dips) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher spacingMultiplier(org.hamcrest.Matcher<Float> matcher) {
            this.mSpacingMultiplierMatcher = matcher;
            return this;
        }

        public Matcher spacingMultiplier(float spacingMultiplier) {
            this.mSpacingMultiplierMatcher = Is.is((Object)Float.valueOf(spacingMultiplier));
            return this;
        }

        public Matcher spacingMultiplierRes(@DimenRes int resId) {
            this.mSpacingMultiplierMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatRes(resId)));
            return this;
        }

        public Matcher spacingMultiplierAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mSpacingMultiplierMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatAttr(attrResId, defResId)));
            return this;
        }

        public Matcher spacingMultiplierAttr(@AttrRes int attrResId) {
            this.mSpacingMultiplierMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatAttr(attrResId, 0)));
            return this;
        }

        public Matcher stateUpdatePolicy(org.hamcrest.Matcher<EditTextStateUpdatePolicy> matcher) {
            this.mStateUpdatePolicyMatcher = matcher;
            return this;
        }

        public Matcher stateUpdatePolicy(EditTextStateUpdatePolicy stateUpdatePolicy) {
            this.mStateUpdatePolicyMatcher = Is.is((Object)stateUpdatePolicy);
            return this;
        }

        public Matcher text(org.hamcrest.Matcher<CharSequence> matcher) {
            this.mTextMatcher = matcher;
            return this;
        }

        public Matcher text(CharSequence text) {
            this.mTextMatcher = Is.is((Object)text);
            return this;
        }

        public Matcher textRes(@StringRes int resId) {
            this.mTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId));
            return this;
        }

        public Matcher textRes(@StringRes int resId, Object ... formatArgs) {
            this.mTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId, formatArgs));
            return this;
        }

        public Matcher textAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, defResId));
            return this;
        }

        public Matcher textAttr(@AttrRes int attrResId) {
            this.mTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, 0));
            return this;
        }

        public Matcher textAlignment(org.hamcrest.Matcher<Layout.Alignment> matcher) {
            this.mTextAlignmentMatcher = matcher;
            return this;
        }

        public Matcher textAlignment(Layout.Alignment textAlignment) {
            this.mTextAlignmentMatcher = Is.is((Object)textAlignment);
            return this;
        }

        public Matcher textColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mTextColorMatcher = matcher;
            return this;
        }

        public Matcher textColor(@ColorInt int textColor) {
            this.mTextColorMatcher = Is.is((Object)textColor);
            return this;
        }

        public Matcher textColorRes(@ColorRes int resId) {
            this.mTextColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher textColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTextColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher textColorAttr(@AttrRes int attrResId) {
            this.mTextColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher textColorStateList(org.hamcrest.Matcher<ColorStateList> matcher) {
            this.mTextColorStateListMatcher = matcher;
            return this;
        }

        public Matcher textColorStateList(ColorStateList textColorStateList) {
            this.mTextColorStateListMatcher = Is.is((Object)textColorStateList);
            return this;
        }

        public Matcher textSize(org.hamcrest.Matcher<Integer> matcher) {
            this.mTextSizeMatcher = matcher;
            return this;
        }

        public Matcher textSizePx(@Px int textSize) {
            this.mTextSizeMatcher = Is.is((Object)textSize);
            return this;
        }

        public Matcher textSizeRes(@DimenRes int resId) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeRes(resId));
            return this;
        }

        public Matcher textSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId));
            return this;
        }

        public Matcher textSizeAttr(@AttrRes int attrResId) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0));
            return this;
        }

        public Matcher textSizeDip(@Dimension(unit=0) float dips) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.dipsToPixels(dips));
            return this;
        }

        public Matcher textSizeSp(@Dimension(unit=2) float sips) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.sipsToPixels(sips));
            return this;
        }

        public Matcher textStyle(org.hamcrest.Matcher<Integer> matcher) {
            this.mTextStyleMatcher = matcher;
            return this;
        }

        public Matcher textStyle(int textStyle) {
            this.mTextStyleMatcher = Is.is((Object)textStyle);
            return this;
        }

        public Matcher textWatchers(org.hamcrest.Matcher<List> matcher) {
            this.mTextWatchersMatcher = matcher;
            return this;
        }

        public Matcher textWatcher(TextWatcher textWatcher) {
            if (textWatcher == null) {
                return this;
            }
            return this;
        }

        public Matcher textWatchers(List textWatchers) {
            if (textWatchers == null) {
                return this;
            }
            return this;
        }

        public Matcher tintColorStateList(org.hamcrest.Matcher<ColorStateList> matcher) {
            this.mTintColorStateListMatcher = matcher;
            return this;
        }

        public Matcher tintColorStateList(ColorStateList tintColorStateList) {
            this.mTintColorStateListMatcher = Is.is((Object)tintColorStateList);
            return this;
        }

        public Matcher typeface(org.hamcrest.Matcher<Typeface> matcher) {
            this.mTypefaceMatcher = matcher;
            return this;
        }

        public Matcher typeface(Typeface typeface) {
            this.mTypefaceMatcher = Is.is((Object)typeface);
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(EditText.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.EditText\"", new Object[0]));
                        return false;
                    }
                    EditText impl = (EditText)value.getComponent();
                    int propValueCursorDrawableRes = impl.cursorDrawableRes;
                    if (mCursorDrawableResMatcher != null && !mCursorDrawableResMatcher.matches((Object)propValueCursorDrawableRes)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <cursorDrawableRes> %s (doesn't match %s)", new Object[]{mCursorDrawableResMatcher, propValueCursorDrawableRes}));
                        return false;
                    }
                    boolean propValueEditable = impl.editable;
                    if (mEditableMatcher != null && !mEditableMatcher.matches((Object)propValueEditable)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <editable> %s (doesn't match %s)", new Object[]{mEditableMatcher, propValueEditable}));
                        return false;
                    }
                    TextView.OnEditorActionListener propValueEditorActionListener = impl.editorActionListener;
                    if (mEditorActionListenerMatcher != null && !mEditorActionListenerMatcher.matches((Object)propValueEditorActionListener)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <editorActionListener> %s (doesn't match %s)", new Object[]{mEditorActionListenerMatcher, propValueEditorActionListener}));
                        return false;
                    }
                    TextUtils.TruncateAt propValueEllipsize = impl.ellipsize;
                    if (mEllipsizeMatcher != null && !mEllipsizeMatcher.matches((Object)propValueEllipsize)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <ellipsize> %s (doesn't match %s)", new Object[]{mEllipsizeMatcher, propValueEllipsize}));
                        return false;
                    }
                    float propValueExtraSpacing = impl.extraSpacing;
                    if (mExtraSpacingMatcher != null && !mExtraSpacingMatcher.matches((Object)Float.valueOf(propValueExtraSpacing))) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <extraSpacing> %s (doesn't match %s)", new Object[]{mExtraSpacingMatcher, Float.valueOf(propValueExtraSpacing)}));
                        return false;
                    }
                    int propValueGravity = impl.gravity;
                    if (mGravityMatcher != null && !mGravityMatcher.matches((Object)propValueGravity)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <gravity> %s (doesn't match %s)", new Object[]{mGravityMatcher, propValueGravity}));
                        return false;
                    }
                    int propValueHighlightColor = impl.highlightColor;
                    if (mHighlightColorMatcher != null && !mHighlightColorMatcher.matches((Object)propValueHighlightColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <highlightColor> %s (doesn't match %s)", new Object[]{mHighlightColorMatcher, propValueHighlightColor}));
                        return false;
                    }
                    CharSequence propValueHint = impl.hint;
                    if (mHintMatcher != null && !mHintMatcher.matches((Object)propValueHint)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <hint> %s (doesn't match %s)", new Object[]{mHintMatcher, propValueHint}));
                        return false;
                    }
                    int propValueHintColor = impl.hintColor;
                    if (mHintColorMatcher != null && !mHintColorMatcher.matches((Object)propValueHintColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <hintColor> %s (doesn't match %s)", new Object[]{mHintColorMatcher, propValueHintColor}));
                        return false;
                    }
                    ColorStateList propValueHintColorStateList = impl.hintColorStateList;
                    if (mHintColorStateListMatcher != null && !mHintColorStateListMatcher.matches((Object)propValueHintColorStateList)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <hintColorStateList> %s (doesn't match %s)", new Object[]{mHintColorStateListMatcher, propValueHintColorStateList}));
                        return false;
                    }
                    int propValueImeOptions = impl.imeOptions;
                    if (mImeOptionsMatcher != null && !mImeOptionsMatcher.matches((Object)propValueImeOptions)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <imeOptions> %s (doesn't match %s)", new Object[]{mImeOptionsMatcher, propValueImeOptions}));
                        return false;
                    }
                    CharSequence propValueInitialText = impl.initialText;
                    if (mInitialTextMatcher != null && !mInitialTextMatcher.matches((Object)propValueInitialText)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <initialText> %s (doesn't match %s)", new Object[]{mInitialTextMatcher, propValueInitialText}));
                        return false;
                    }
                    List propValueInputFilters = impl.inputFilters;
                    if (mInputFiltersMatcher != null && !mInputFiltersMatcher.matches((Object)propValueInputFilters)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <inputFilters> %s (doesn't match %s)", new Object[]{mInputFiltersMatcher, propValueInputFilters}));
                        return false;
                    }
                    int propValueInputType = impl.inputType;
                    if (mInputTypeMatcher != null && !mInputTypeMatcher.matches((Object)propValueInputType)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <inputType> %s (doesn't match %s)", new Object[]{mInputTypeMatcher, propValueInputType}));
                        return false;
                    }
                    boolean propValueIsSingleLine = impl.isSingleLine;
                    if (mIsSingleLineMatcher != null && !mIsSingleLineMatcher.matches((Object)propValueIsSingleLine)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <isSingleLine> %s (doesn't match %s)", new Object[]{mIsSingleLineMatcher, propValueIsSingleLine}));
                        return false;
                    }
                    boolean propValueIsSingleLineWrap = impl.isSingleLineWrap;
                    if (mIsSingleLineWrapMatcher != null && !mIsSingleLineWrapMatcher.matches((Object)propValueIsSingleLineWrap)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <isSingleLineWrap> %s (doesn't match %s)", new Object[]{mIsSingleLineWrapMatcher, propValueIsSingleLineWrap}));
                        return false;
                    }
                    int propValueLinkColor = impl.linkColor;
                    if (mLinkColorMatcher != null && !mLinkColorMatcher.matches((Object)propValueLinkColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <linkColor> %s (doesn't match %s)", new Object[]{mLinkColorMatcher, propValueLinkColor}));
                        return false;
                    }
                    int propValueMaxLength = impl.maxLength;
                    if (mMaxLengthMatcher != null && !mMaxLengthMatcher.matches((Object)propValueMaxLength)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <maxLength> %s (doesn't match %s)", new Object[]{mMaxLengthMatcher, propValueMaxLength}));
                        return false;
                    }
                    int propValueMaxLines = impl.maxLines;
                    if (mMaxLinesMatcher != null && !mMaxLinesMatcher.matches((Object)propValueMaxLines)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <maxLines> %s (doesn't match %s)", new Object[]{mMaxLinesMatcher, propValueMaxLines}));
                        return false;
                    }
                    int propValueMinLines = impl.minLines;
                    if (mMinLinesMatcher != null && !mMinLinesMatcher.matches((Object)propValueMinLines)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <minLines> %s (doesn't match %s)", new Object[]{mMinLinesMatcher, propValueMinLines}));
                        return false;
                    }
                    int propValueRawInputType = impl.rawInputType;
                    if (mRawInputTypeMatcher != null && !mRawInputTypeMatcher.matches((Object)propValueRawInputType)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <rawInputType> %s (doesn't match %s)", new Object[]{mRawInputTypeMatcher, propValueRawInputType}));
                        return false;
                    }
                    boolean propValueRequestFocus = impl.requestFocus;
                    if (mRequestFocusMatcher != null && !mRequestFocusMatcher.matches((Object)propValueRequestFocus)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <requestFocus> %s (doesn't match %s)", new Object[]{mRequestFocusMatcher, propValueRequestFocus}));
                        return false;
                    }
                    int propValueSelection = impl.selection;
                    if (mSelectionMatcher != null && !mSelectionMatcher.matches((Object)propValueSelection)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <selection> %s (doesn't match %s)", new Object[]{mSelectionMatcher, propValueSelection}));
                        return false;
                    }
                    int propValueShadowColor = impl.shadowColor;
                    if (mShadowColorMatcher != null && !mShadowColorMatcher.matches((Object)propValueShadowColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <shadowColor> %s (doesn't match %s)", new Object[]{mShadowColorMatcher, propValueShadowColor}));
                        return false;
                    }
                    float propValueShadowDx = impl.shadowDx;
                    if (mShadowDxMatcher != null && !mShadowDxMatcher.matches((Object)Float.valueOf(propValueShadowDx))) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <shadowDx> %s (doesn't match %s)", new Object[]{mShadowDxMatcher, Float.valueOf(propValueShadowDx)}));
                        return false;
                    }
                    float propValueShadowDy = impl.shadowDy;
                    if (mShadowDyMatcher != null && !mShadowDyMatcher.matches((Object)Float.valueOf(propValueShadowDy))) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <shadowDy> %s (doesn't match %s)", new Object[]{mShadowDyMatcher, Float.valueOf(propValueShadowDy)}));
                        return false;
                    }
                    float propValueShadowRadius = impl.shadowRadius;
                    if (mShadowRadiusMatcher != null && !mShadowRadiusMatcher.matches((Object)Float.valueOf(propValueShadowRadius))) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <shadowRadius> %s (doesn't match %s)", new Object[]{mShadowRadiusMatcher, Float.valueOf(propValueShadowRadius)}));
                        return false;
                    }
                    float propValueSpacingMultiplier = impl.spacingMultiplier;
                    if (mSpacingMultiplierMatcher != null && !mSpacingMultiplierMatcher.matches((Object)Float.valueOf(propValueSpacingMultiplier))) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <spacingMultiplier> %s (doesn't match %s)", new Object[]{mSpacingMultiplierMatcher, Float.valueOf(propValueSpacingMultiplier)}));
                        return false;
                    }
                    EditTextStateUpdatePolicy propValueStateUpdatePolicy = impl.stateUpdatePolicy;
                    if (mStateUpdatePolicyMatcher != null && !mStateUpdatePolicyMatcher.matches((Object)propValueStateUpdatePolicy)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <stateUpdatePolicy> %s (doesn't match %s)", new Object[]{mStateUpdatePolicyMatcher, propValueStateUpdatePolicy}));
                        return false;
                    }
                    CharSequence propValueText = impl.text;
                    if (mTextMatcher != null && !mTextMatcher.matches((Object)propValueText)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <text> %s (doesn't match %s)", new Object[]{mTextMatcher, propValueText}));
                        return false;
                    }
                    Layout.Alignment propValueTextAlignment = impl.textAlignment;
                    if (mTextAlignmentMatcher != null && !mTextAlignmentMatcher.matches((Object)propValueTextAlignment)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <textAlignment> %s (doesn't match %s)", new Object[]{mTextAlignmentMatcher, propValueTextAlignment}));
                        return false;
                    }
                    int propValueTextColor = impl.textColor;
                    if (mTextColorMatcher != null && !mTextColorMatcher.matches((Object)propValueTextColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <textColor> %s (doesn't match %s)", new Object[]{mTextColorMatcher, propValueTextColor}));
                        return false;
                    }
                    ColorStateList propValueTextColorStateList = impl.textColorStateList;
                    if (mTextColorStateListMatcher != null && !mTextColorStateListMatcher.matches((Object)propValueTextColorStateList)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <textColorStateList> %s (doesn't match %s)", new Object[]{mTextColorStateListMatcher, propValueTextColorStateList}));
                        return false;
                    }
                    int propValueTextSize = impl.textSize;
                    if (mTextSizeMatcher != null && !mTextSizeMatcher.matches((Object)propValueTextSize)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <textSize> %s (doesn't match %s)", new Object[]{mTextSizeMatcher, propValueTextSize}));
                        return false;
                    }
                    int propValueTextStyle = impl.textStyle;
                    if (mTextStyleMatcher != null && !mTextStyleMatcher.matches((Object)propValueTextStyle)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <textStyle> %s (doesn't match %s)", new Object[]{mTextStyleMatcher, propValueTextStyle}));
                        return false;
                    }
                    List propValueTextWatchers = impl.textWatchers;
                    if (mTextWatchersMatcher != null && !mTextWatchersMatcher.matches((Object)propValueTextWatchers)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <textWatchers> %s (doesn't match %s)", new Object[]{mTextWatchersMatcher, propValueTextWatchers}));
                        return false;
                    }
                    ColorStateList propValueTintColorStateList = impl.tintColorStateList;
                    if (mTintColorStateListMatcher != null && !mTintColorStateListMatcher.matches((Object)propValueTintColorStateList)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <tintColorStateList> %s (doesn't match %s)", new Object[]{mTintColorStateListMatcher, propValueTintColorStateList}));
                        return false;
                    }
                    Typeface propValueTypeface = impl.typeface;
                    if (mTypefaceMatcher != null && !mTypefaceMatcher.matches((Object)propValueTypeface)) {
                        this.as((Description)new TextDescription("Sub-component of type <EditText> with prop <typeface> %s (doesn't match %s)", new Object[]{mTypefaceMatcher, propValueTypeface}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

