/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.Nullable;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.HorizontalScroll;
import com.facebook.litho.widget.HorizontalScrollEventsController;
import com.facebook.litho.widget.HorizontalScrollLithoView;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.litho.widget.TestHorizontalScrollSpec;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestHorizontalScroll
implements TestHorizontalScrollSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @javax.annotation.Nullable
        Condition<InspectableComponent> mContentPropsComponentMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Component> mContentPropsMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<HorizontalScrollEventsController> mEventsControllerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mFillViewportMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mIncrementalMountEnabledMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mInitialScrollPositionMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<HorizontalScrollLithoView.OnScrollChangeListener> mOnScrollChangeListenerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mOverScrollModeMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<ScrollStateListener> mScrollStateListenerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mScrollbarEnabledMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher contentProps(Condition<InspectableComponent> matcher) {
            this.mContentPropsComponentMatcher = matcher;
            return this;
        }

        public Matcher contentProps(org.hamcrest.Matcher<Component> matcher) {
            this.mContentPropsMatcher = matcher;
            return this;
        }

        public Matcher contentProps(Component contentProps) {
            this.mContentPropsMatcher = Is.is((Object)contentProps);
            return this;
        }

        public Matcher contentProps(Component.Builder<?> contentPropsBuilder) {
            this.mContentPropsMatcher = Is.is((Object)contentPropsBuilder.build());
            return this;
        }

        public Matcher eventsController(org.hamcrest.Matcher<HorizontalScrollEventsController> matcher) {
            this.mEventsControllerMatcher = matcher;
            return this;
        }

        public Matcher eventsController(@Nullable HorizontalScrollEventsController eventsController) {
            this.mEventsControllerMatcher = Is.is((Object)eventsController);
            return this;
        }

        public Matcher fillViewport(org.hamcrest.Matcher<Boolean> matcher) {
            this.mFillViewportMatcher = matcher;
            return this;
        }

        public Matcher fillViewport(boolean fillViewport) {
            this.mFillViewportMatcher = Is.is((Object)fillViewport);
            return this;
        }

        public Matcher incrementalMountEnabled(org.hamcrest.Matcher<Boolean> matcher) {
            this.mIncrementalMountEnabledMatcher = matcher;
            return this;
        }

        public Matcher incrementalMountEnabled(boolean incrementalMountEnabled) {
            this.mIncrementalMountEnabledMatcher = Is.is((Object)incrementalMountEnabled);
            return this;
        }

        public Matcher initialScrollPosition(org.hamcrest.Matcher<Integer> matcher) {
            this.mInitialScrollPositionMatcher = matcher;
            return this;
        }

        public Matcher initialScrollPosition(int initialScrollPosition) {
            this.mInitialScrollPositionMatcher = Is.is((Object)initialScrollPosition);
            return this;
        }

        public Matcher onScrollChangeListener(org.hamcrest.Matcher<HorizontalScrollLithoView.OnScrollChangeListener> matcher) {
            this.mOnScrollChangeListenerMatcher = matcher;
            return this;
        }

        public Matcher onScrollChangeListener(@Nullable HorizontalScrollLithoView.OnScrollChangeListener onScrollChangeListener) {
            this.mOnScrollChangeListenerMatcher = Is.is((Object)onScrollChangeListener);
            return this;
        }

        public Matcher overScrollMode(org.hamcrest.Matcher<Integer> matcher) {
            this.mOverScrollModeMatcher = matcher;
            return this;
        }

        public Matcher overScrollMode(int overScrollMode) {
            this.mOverScrollModeMatcher = Is.is((Object)overScrollMode);
            return this;
        }

        public Matcher scrollStateListener(org.hamcrest.Matcher<ScrollStateListener> matcher) {
            this.mScrollStateListenerMatcher = matcher;
            return this;
        }

        public Matcher scrollStateListener(@Nullable ScrollStateListener scrollStateListener) {
            this.mScrollStateListenerMatcher = Is.is((Object)scrollStateListener);
            return this;
        }

        public Matcher scrollbarEnabled(org.hamcrest.Matcher<Boolean> matcher) {
            this.mScrollbarEnabledMatcher = matcher;
            return this;
        }

        public Matcher scrollbarEnabled(boolean scrollbarEnabled) {
            this.mScrollbarEnabledMatcher = Is.is((Object)scrollbarEnabled);
            return this;
        }

        public Matcher scrollbarEnabledRes(@BoolRes int resId) {
            this.mScrollbarEnabledMatcher = Is.is((Object)this.mResourceResolver.resolveBoolRes(resId));
            return this;
        }

        public Matcher scrollbarEnabledAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mScrollbarEnabledMatcher = Is.is((Object)this.mResourceResolver.resolveBoolAttr(attrResId, defResId));
            return this;
        }

        public Matcher scrollbarEnabledAttr(@AttrRes int attrResId) {
            this.mScrollbarEnabledMatcher = Is.is((Object)this.mResourceResolver.resolveBoolAttr(attrResId, 0));
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(HorizontalScroll.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.HorizontalScroll\"", new Object[0]));
                        return false;
                    }
                    HorizontalScroll impl = (HorizontalScroll)value.getComponent();
                    Component propValueContentPropsComponent = impl.contentProps;
                    if (mContentPropsComponentMatcher != null && !mContentPropsComponentMatcher.matches((Object)value.getNestedInstance(propValueContentPropsComponent))) {
                        this.as(mContentPropsComponentMatcher.description());
                        return false;
                    }
                    Component propValueContentProps = impl.contentProps;
                    if (mContentPropsMatcher != null && !mContentPropsMatcher.matches((Object)propValueContentProps)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <contentProps> %s (doesn't match %s)", new Object[]{mContentPropsMatcher, propValueContentProps}));
                        return false;
                    }
                    HorizontalScrollEventsController propValueEventsController = impl.eventsController;
                    if (mEventsControllerMatcher != null && !mEventsControllerMatcher.matches((Object)propValueEventsController)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <eventsController> %s (doesn't match %s)", new Object[]{mEventsControllerMatcher, propValueEventsController}));
                        return false;
                    }
                    boolean propValueFillViewport = impl.fillViewport;
                    if (mFillViewportMatcher != null && !mFillViewportMatcher.matches((Object)propValueFillViewport)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <fillViewport> %s (doesn't match %s)", new Object[]{mFillViewportMatcher, propValueFillViewport}));
                        return false;
                    }
                    boolean propValueIncrementalMountEnabled = impl.incrementalMountEnabled;
                    if (mIncrementalMountEnabledMatcher != null && !mIncrementalMountEnabledMatcher.matches((Object)propValueIncrementalMountEnabled)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <incrementalMountEnabled> %s (doesn't match %s)", new Object[]{mIncrementalMountEnabledMatcher, propValueIncrementalMountEnabled}));
                        return false;
                    }
                    int propValueInitialScrollPosition = impl.initialScrollPosition;
                    if (mInitialScrollPositionMatcher != null && !mInitialScrollPositionMatcher.matches((Object)propValueInitialScrollPosition)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <initialScrollPosition> %s (doesn't match %s)", new Object[]{mInitialScrollPositionMatcher, propValueInitialScrollPosition}));
                        return false;
                    }
                    HorizontalScrollLithoView.OnScrollChangeListener propValueOnScrollChangeListener = impl.onScrollChangeListener;
                    if (mOnScrollChangeListenerMatcher != null && !mOnScrollChangeListenerMatcher.matches((Object)propValueOnScrollChangeListener)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <onScrollChangeListener> %s (doesn't match %s)", new Object[]{mOnScrollChangeListenerMatcher, propValueOnScrollChangeListener}));
                        return false;
                    }
                    int propValueOverScrollMode = impl.overScrollMode;
                    if (mOverScrollModeMatcher != null && !mOverScrollModeMatcher.matches((Object)propValueOverScrollMode)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <overScrollMode> %s (doesn't match %s)", new Object[]{mOverScrollModeMatcher, propValueOverScrollMode}));
                        return false;
                    }
                    ScrollStateListener propValueScrollStateListener = impl.scrollStateListener;
                    if (mScrollStateListenerMatcher != null && !mScrollStateListenerMatcher.matches((Object)propValueScrollStateListener)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <scrollStateListener> %s (doesn't match %s)", new Object[]{mScrollStateListenerMatcher, propValueScrollStateListener}));
                        return false;
                    }
                    boolean propValueScrollbarEnabled = impl.scrollbarEnabled;
                    if (mScrollbarEnabledMatcher != null && !mScrollbarEnabledMatcher.matches((Object)propValueScrollbarEnabled)) {
                        this.as((Description)new TextDescription("Sub-component of type <HorizontalScroll> with prop <scrollbarEnabled> %s (doesn't match %s)", new Object[]{mScrollbarEnabledMatcher, propValueScrollbarEnabled}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

