/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.AttrRes;
import androidx.annotation.DrawableRes;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.Image;
import com.facebook.litho.widget.TestImageSpec;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestImage
implements TestImageSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @Nullable
        org.hamcrest.Matcher<Drawable> mDrawableMatcher;
        @Nullable
        org.hamcrest.Matcher<ImageView.ScaleType> mScaleTypeMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher drawable(org.hamcrest.Matcher<Drawable> matcher) {
            this.mDrawableMatcher = matcher;
            return this;
        }

        public Matcher drawable(@Nullable Drawable drawable) {
            this.mDrawableMatcher = Is.is((Object)drawable);
            return this;
        }

        public Matcher drawableRes(@Nullable @DrawableRes int resId) {
            this.mDrawableMatcher = Is.is((Object)this.mResourceResolver.resolveDrawableRes(resId));
            return this;
        }

        public Matcher drawableAttr(@Nullable @AttrRes int attrResId, @Nullable @DrawableRes int defResId) {
            this.mDrawableMatcher = Is.is((Object)this.mResourceResolver.resolveDrawableAttr(attrResId, defResId));
            return this;
        }

        public Matcher drawableAttr(@Nullable @AttrRes int attrResId) {
            this.mDrawableMatcher = Is.is((Object)this.mResourceResolver.resolveDrawableAttr(attrResId, 0));
            return this;
        }

        public Matcher scaleType(org.hamcrest.Matcher<ImageView.ScaleType> matcher) {
            this.mScaleTypeMatcher = matcher;
            return this;
        }

        public Matcher scaleType(@Nullable ImageView.ScaleType scaleType) {
            this.mScaleTypeMatcher = Is.is((Object)scaleType);
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(Image.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.Image\"", new Object[0]));
                        return false;
                    }
                    Image impl = (Image)value.getComponent();
                    Drawable propValueDrawable = impl.drawable;
                    if (mDrawableMatcher != null && !mDrawableMatcher.matches((Object)propValueDrawable)) {
                        this.as((Description)new TextDescription("Sub-component of type <Image> with prop <drawable> %s (doesn't match %s)", new Object[]{mDrawableMatcher, propValueDrawable}));
                        return false;
                    }
                    ImageView.ScaleType propValueScaleType = impl.scaleType;
                    if (mScaleTypeMatcher != null && !mScaleTypeMatcher.matches((Object)propValueScaleType)) {
                        this.as((Description)new TextDescription("Sub-component of type <Image> with prop <scaleType> %s (doesn't match %s)", new Object[]{mScaleTypeMatcher, propValueScaleType}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

