/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.Image;
import org.assertj.core.api.Condition;
import org.robolectric.Shadows;

public class TestImageConditions {
    public static Condition<InspectableComponent> imageWithDrawable(final @DrawableRes int resId) {
        return new Condition<InspectableComponent>(){

            public boolean matches(InspectableComponent value) {
                if (value.getComponentClass() != Image.class) {
                    return false;
                }
                Image impl = (Image)value.getComponent();
                Drawable propValueDrawable = impl.drawable;
                return Shadows.shadowOf((Bitmap)((BitmapDrawable)propValueDrawable).getBitmap()).getCreatedFromResId() == resId;
            }
        };
    }
}

