/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.drawable.Drawable;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.Progress;
import com.facebook.litho.widget.TestProgressSpec;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestProgress
implements TestProgressSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @Nullable
        org.hamcrest.Matcher<Integer> mColorMatcher;
        @Nullable
        org.hamcrest.Matcher<Drawable> mIndeterminateDrawableMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher color(org.hamcrest.Matcher<Integer> matcher) {
            this.mColorMatcher = matcher;
            return this;
        }

        public Matcher color(@ColorInt int color) {
            this.mColorMatcher = Is.is((Object)color);
            return this;
        }

        public Matcher colorRes(@ColorRes int resId) {
            this.mColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher colorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher colorAttr(@AttrRes int attrResId) {
            this.mColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher indeterminateDrawable(org.hamcrest.Matcher<Drawable> matcher) {
            this.mIndeterminateDrawableMatcher = matcher;
            return this;
        }

        public Matcher indeterminateDrawable(Drawable indeterminateDrawable) {
            this.mIndeterminateDrawableMatcher = Is.is((Object)indeterminateDrawable);
            return this;
        }

        public Matcher indeterminateDrawableRes(@DrawableRes int resId) {
            this.mIndeterminateDrawableMatcher = Is.is((Object)this.mResourceResolver.resolveDrawableRes(resId));
            return this;
        }

        public Matcher indeterminateDrawableAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mIndeterminateDrawableMatcher = Is.is((Object)this.mResourceResolver.resolveDrawableAttr(attrResId, defResId));
            return this;
        }

        public Matcher indeterminateDrawableAttr(@AttrRes int attrResId) {
            this.mIndeterminateDrawableMatcher = Is.is((Object)this.mResourceResolver.resolveDrawableAttr(attrResId, 0));
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(Progress.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.Progress\"", new Object[0]));
                        return false;
                    }
                    Progress impl = (Progress)value.getComponent();
                    int propValueColor = impl.color;
                    if (mColorMatcher != null && !mColorMatcher.matches((Object)propValueColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Progress> with prop <color> %s (doesn't match %s)", new Object[]{mColorMatcher, propValueColor}));
                        return false;
                    }
                    Drawable propValueIndeterminateDrawable = impl.indeterminateDrawable;
                    if (mIndeterminateDrawableMatcher != null && !mIndeterminateDrawableMatcher.matches((Object)propValueIndeterminateDrawable)) {
                        this.as((Description)new TextDescription("Sub-component of type <Progress> with prop <indeterminateDrawable> %s (doesn't match %s)", new Object[]{mIndeterminateDrawableMatcher, propValueIndeterminateDrawable}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

