/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.SolidColor;
import com.facebook.litho.widget.TestSolidColorSpec;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestSolidColor
implements TestSolidColorSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @Nullable
        org.hamcrest.Matcher<Float> mAlphaMatcher;
        @Nullable
        org.hamcrest.Matcher<Integer> mColorMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher alpha(org.hamcrest.Matcher<Float> matcher) {
            this.mAlphaMatcher = matcher;
            return this;
        }

        public Matcher alpha(float alpha) {
            this.mAlphaMatcher = Is.is((Object)Float.valueOf(alpha));
            return this;
        }

        public Matcher color(org.hamcrest.Matcher<Integer> matcher) {
            this.mColorMatcher = matcher;
            return this;
        }

        public Matcher color(@ColorInt int color) {
            this.mColorMatcher = Is.is((Object)color);
            return this;
        }

        public Matcher colorRes(@ColorRes int resId) {
            this.mColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher colorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher colorAttr(@AttrRes int attrResId) {
            this.mColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(SolidColor.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.SolidColor\"", new Object[0]));
                        return false;
                    }
                    SolidColor impl = (SolidColor)value.getComponent();
                    float propValueAlpha = impl.alpha;
                    if (mAlphaMatcher != null && !mAlphaMatcher.matches((Object)Float.valueOf(propValueAlpha))) {
                        this.as((Description)new TextDescription("Sub-component of type <SolidColor> with prop <alpha> %s (doesn't match %s)", new Object[]{mAlphaMatcher, Float.valueOf(propValueAlpha)}));
                        return false;
                    }
                    int propValueColor = impl.color;
                    if (mColorMatcher != null && !mColorMatcher.matches((Object)propValueColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <SolidColor> with prop <color> %s (doesn't match %s)", new Object[]{mColorMatcher, propValueColor}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

