/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.TextUtils;
import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.core.text.TextDirectionHeuristicCompat;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.EventHandler;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.ClickableSpanListener;
import com.facebook.litho.widget.TestTextSpec;
import com.facebook.litho.widget.Text;
import com.facebook.litho.widget.TextAlignment;
import com.facebook.litho.widget.TouchableSpanListener;
import com.facebook.litho.widget.VerticalGravity;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestText
implements TestTextSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<TextAlignment> mAlignmentMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mBreakStrategyMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mClickableSpanExpandedOffsetMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mClipToBoundsMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<CharSequence> mCustomEllipsisTextMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<DynamicValue<Integer>> mDynamicTextColorMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<TextUtils.TruncateAt> mEllipsizeMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mExtraSpacingMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mGlyphWarmingMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mHighlightColorMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mHighlightEndOffsetMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mHighlightStartOffsetMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mHyphenationFrequencyMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mIsSingleLineMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mJustificationModeMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mLetterSpacingMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mLineHeightMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mLinkColorMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mMaxEmsMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mMaxLinesMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mMaxTextWidthMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mMinEmsMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mMinLinesMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mMinTextWidthMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mMinimallyWideMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mMinimallyWideThresholdMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mShadowColorMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mShadowDxMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mShadowDyMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mShadowRadiusMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mShouldIncludeFontPaddingMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Float> mSpacingMultiplierMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<ClickableSpanListener> mSpanListenerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<CharSequence> mTextMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Layout.Alignment> mTextAlignmentMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mTextColorMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<ColorStateList> mTextColorStateListMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<TextDirectionHeuristicCompat> mTextDirectionMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<EventHandler> mTextOffsetOnTouchHandlerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mTextSizeMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mTextStyleMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<TouchableSpanListener> mTouchableSpanListenerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Typeface> mTypefaceMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<VerticalGravity> mVerticalGravityMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher alignment(org.hamcrest.Matcher<TextAlignment> matcher) {
            this.mAlignmentMatcher = matcher;
            return this;
        }

        public Matcher alignment(@Nullable TextAlignment alignment) {
            this.mAlignmentMatcher = Is.is((Object)alignment);
            return this;
        }

        public Matcher breakStrategy(org.hamcrest.Matcher<Integer> matcher) {
            this.mBreakStrategyMatcher = matcher;
            return this;
        }

        public Matcher breakStrategy(int breakStrategy) {
            this.mBreakStrategyMatcher = Is.is((Object)breakStrategy);
            return this;
        }

        public Matcher clickableSpanExpandedOffset(org.hamcrest.Matcher<Float> matcher) {
            this.mClickableSpanExpandedOffsetMatcher = matcher;
            return this;
        }

        public Matcher clickableSpanExpandedOffsetPx(@Px float clickableSpanExpandedOffset) {
            this.mClickableSpanExpandedOffsetMatcher = Is.is((Object)Float.valueOf(clickableSpanExpandedOffset));
            return this;
        }

        public Matcher clickableSpanExpandedOffsetRes(@DimenRes int resId) {
            this.mClickableSpanExpandedOffsetMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeRes(resId)));
            return this;
        }

        public Matcher clickableSpanExpandedOffsetAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mClickableSpanExpandedOffsetMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId)));
            return this;
        }

        public Matcher clickableSpanExpandedOffsetAttr(@AttrRes int attrResId) {
            this.mClickableSpanExpandedOffsetMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0)));
            return this;
        }

        public Matcher clickableSpanExpandedOffsetDip(@Dimension(unit=0) float dips) {
            this.mClickableSpanExpandedOffsetMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher clickableSpanExpandedOffsetSp(@Dimension(unit=2) float sips) {
            this.mClickableSpanExpandedOffsetMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.sipsToPixels(sips)));
            return this;
        }

        public Matcher clipToBounds(org.hamcrest.Matcher<Boolean> matcher) {
            this.mClipToBoundsMatcher = matcher;
            return this;
        }

        public Matcher clipToBounds(boolean clipToBounds) {
            this.mClipToBoundsMatcher = Is.is((Object)clipToBounds);
            return this;
        }

        public Matcher customEllipsisText(org.hamcrest.Matcher<CharSequence> matcher) {
            this.mCustomEllipsisTextMatcher = matcher;
            return this;
        }

        public Matcher customEllipsisText(@Nullable CharSequence customEllipsisText) {
            this.mCustomEllipsisTextMatcher = Is.is((Object)customEllipsisText);
            return this;
        }

        public Matcher customEllipsisTextRes(@Nullable @StringRes int resId) {
            this.mCustomEllipsisTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId));
            return this;
        }

        public Matcher customEllipsisTextRes(@Nullable @StringRes int resId, Object ... formatArgs) {
            this.mCustomEllipsisTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId, formatArgs));
            return this;
        }

        public Matcher customEllipsisTextAttr(@Nullable @AttrRes int attrResId, @Nullable @StringRes int defResId) {
            this.mCustomEllipsisTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, defResId));
            return this;
        }

        public Matcher customEllipsisTextAttr(@Nullable @AttrRes int attrResId) {
            this.mCustomEllipsisTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, 0));
            return this;
        }

        public Matcher dynamicTextColor(org.hamcrest.Matcher<DynamicValue<Integer>> matcher) {
            this.mDynamicTextColorMatcher = matcher;
            return this;
        }

        public Matcher dynamicTextColor(DynamicValue<Integer> dynamicTextColor) {
            this.mDynamicTextColorMatcher = Is.is(dynamicTextColor);
            return this;
        }

        public Matcher ellipsize(org.hamcrest.Matcher<TextUtils.TruncateAt> matcher) {
            this.mEllipsizeMatcher = matcher;
            return this;
        }

        public Matcher ellipsize(@Nullable TextUtils.TruncateAt ellipsize) {
            this.mEllipsizeMatcher = Is.is((Object)ellipsize);
            return this;
        }

        public Matcher extraSpacing(org.hamcrest.Matcher<Float> matcher) {
            this.mExtraSpacingMatcher = matcher;
            return this;
        }

        public Matcher extraSpacingPx(@Px float extraSpacing) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(extraSpacing));
            return this;
        }

        public Matcher extraSpacingRes(@DimenRes int resId) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher extraSpacingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher extraSpacingAttr(@AttrRes int attrResId) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher extraSpacingDip(@Dimension(unit=0) float dips) {
            this.mExtraSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher glyphWarming(org.hamcrest.Matcher<Boolean> matcher) {
            this.mGlyphWarmingMatcher = matcher;
            return this;
        }

        public Matcher glyphWarming(boolean glyphWarming) {
            this.mGlyphWarmingMatcher = Is.is((Object)glyphWarming);
            return this;
        }

        public Matcher highlightColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mHighlightColorMatcher = matcher;
            return this;
        }

        public Matcher highlightColor(@ColorInt int highlightColor) {
            this.mHighlightColorMatcher = Is.is((Object)highlightColor);
            return this;
        }

        public Matcher highlightColorRes(@ColorRes int resId) {
            this.mHighlightColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher highlightColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mHighlightColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher highlightColorAttr(@AttrRes int attrResId) {
            this.mHighlightColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher highlightEndOffset(org.hamcrest.Matcher<Integer> matcher) {
            this.mHighlightEndOffsetMatcher = matcher;
            return this;
        }

        public Matcher highlightEndOffset(int highlightEndOffset) {
            this.mHighlightEndOffsetMatcher = Is.is((Object)highlightEndOffset);
            return this;
        }

        public Matcher highlightStartOffset(org.hamcrest.Matcher<Integer> matcher) {
            this.mHighlightStartOffsetMatcher = matcher;
            return this;
        }

        public Matcher highlightStartOffset(int highlightStartOffset) {
            this.mHighlightStartOffsetMatcher = Is.is((Object)highlightStartOffset);
            return this;
        }

        public Matcher hyphenationFrequency(org.hamcrest.Matcher<Integer> matcher) {
            this.mHyphenationFrequencyMatcher = matcher;
            return this;
        }

        public Matcher hyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequencyMatcher = Is.is((Object)hyphenationFrequency);
            return this;
        }

        public Matcher isSingleLine(org.hamcrest.Matcher<Boolean> matcher) {
            this.mIsSingleLineMatcher = matcher;
            return this;
        }

        public Matcher isSingleLine(boolean isSingleLine) {
            this.mIsSingleLineMatcher = Is.is((Object)isSingleLine);
            return this;
        }

        public Matcher isSingleLineRes(@BoolRes int resId) {
            this.mIsSingleLineMatcher = Is.is((Object)this.mResourceResolver.resolveBoolRes(resId));
            return this;
        }

        public Matcher isSingleLineAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mIsSingleLineMatcher = Is.is((Object)this.mResourceResolver.resolveBoolAttr(attrResId, defResId));
            return this;
        }

        public Matcher isSingleLineAttr(@AttrRes int attrResId) {
            this.mIsSingleLineMatcher = Is.is((Object)this.mResourceResolver.resolveBoolAttr(attrResId, 0));
            return this;
        }

        public Matcher justificationMode(org.hamcrest.Matcher<Integer> matcher) {
            this.mJustificationModeMatcher = matcher;
            return this;
        }

        public Matcher justificationMode(int justificationMode) {
            this.mJustificationModeMatcher = Is.is((Object)justificationMode);
            return this;
        }

        public Matcher letterSpacing(org.hamcrest.Matcher<Float> matcher) {
            this.mLetterSpacingMatcher = matcher;
            return this;
        }

        public Matcher letterSpacing(float letterSpacing) {
            this.mLetterSpacingMatcher = Is.is((Object)Float.valueOf(letterSpacing));
            return this;
        }

        public Matcher letterSpacingRes(@DimenRes int resId) {
            this.mLetterSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatRes(resId)));
            return this;
        }

        public Matcher letterSpacingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mLetterSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatAttr(attrResId, defResId)));
            return this;
        }

        public Matcher letterSpacingAttr(@AttrRes int attrResId) {
            this.mLetterSpacingMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatAttr(attrResId, 0)));
            return this;
        }

        public Matcher lineHeight(org.hamcrest.Matcher<Float> matcher) {
            this.mLineHeightMatcher = matcher;
            return this;
        }

        public Matcher lineHeightPx(@Px float lineHeight) {
            this.mLineHeightMatcher = Is.is((Object)Float.valueOf(lineHeight));
            return this;
        }

        public Matcher lineHeightRes(@DimenRes int resId) {
            this.mLineHeightMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeRes(resId)));
            return this;
        }

        public Matcher lineHeightAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mLineHeightMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId)));
            return this;
        }

        public Matcher lineHeightAttr(@AttrRes int attrResId) {
            this.mLineHeightMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0)));
            return this;
        }

        public Matcher lineHeightDip(@Dimension(unit=0) float dips) {
            this.mLineHeightMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher lineHeightSp(@Dimension(unit=2) float sips) {
            this.mLineHeightMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.sipsToPixels(sips)));
            return this;
        }

        public Matcher linkColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mLinkColorMatcher = matcher;
            return this;
        }

        public Matcher linkColor(@ColorInt int linkColor) {
            this.mLinkColorMatcher = Is.is((Object)linkColor);
            return this;
        }

        public Matcher linkColorRes(@ColorRes int resId) {
            this.mLinkColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher linkColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mLinkColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher linkColorAttr(@AttrRes int attrResId) {
            this.mLinkColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher maxEms(org.hamcrest.Matcher<Integer> matcher) {
            this.mMaxEmsMatcher = matcher;
            return this;
        }

        public Matcher maxEms(int maxEms) {
            this.mMaxEmsMatcher = Is.is((Object)maxEms);
            return this;
        }

        public Matcher maxEmsRes(@IntegerRes int resId) {
            this.mMaxEmsMatcher = Is.is((Object)this.mResourceResolver.resolveIntRes(resId));
            return this;
        }

        public Matcher maxEmsAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mMaxEmsMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, defResId));
            return this;
        }

        public Matcher maxEmsAttr(@AttrRes int attrResId) {
            this.mMaxEmsMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, 0));
            return this;
        }

        public Matcher maxLines(org.hamcrest.Matcher<Integer> matcher) {
            this.mMaxLinesMatcher = matcher;
            return this;
        }

        public Matcher maxLines(int maxLines) {
            this.mMaxLinesMatcher = Is.is((Object)maxLines);
            return this;
        }

        public Matcher maxLinesRes(@IntegerRes int resId) {
            this.mMaxLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntRes(resId));
            return this;
        }

        public Matcher maxLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mMaxLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, defResId));
            return this;
        }

        public Matcher maxLinesAttr(@AttrRes int attrResId) {
            this.mMaxLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, 0));
            return this;
        }

        public Matcher maxTextWidth(org.hamcrest.Matcher<Integer> matcher) {
            this.mMaxTextWidthMatcher = matcher;
            return this;
        }

        public Matcher maxTextWidthPx(@Px int maxTextWidth) {
            this.mMaxTextWidthMatcher = Is.is((Object)maxTextWidth);
            return this;
        }

        public Matcher maxTextWidthRes(@DimenRes int resId) {
            this.mMaxTextWidthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeRes(resId));
            return this;
        }

        public Matcher maxTextWidthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mMaxTextWidthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId));
            return this;
        }

        public Matcher maxTextWidthAttr(@AttrRes int attrResId) {
            this.mMaxTextWidthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0));
            return this;
        }

        public Matcher maxTextWidthDip(@Dimension(unit=0) float dips) {
            this.mMaxTextWidthMatcher = Is.is((Object)this.mResourceResolver.dipsToPixels(dips));
            return this;
        }

        public Matcher minEms(org.hamcrest.Matcher<Integer> matcher) {
            this.mMinEmsMatcher = matcher;
            return this;
        }

        public Matcher minEms(int minEms) {
            this.mMinEmsMatcher = Is.is((Object)minEms);
            return this;
        }

        public Matcher minEmsRes(@IntegerRes int resId) {
            this.mMinEmsMatcher = Is.is((Object)this.mResourceResolver.resolveIntRes(resId));
            return this;
        }

        public Matcher minEmsAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mMinEmsMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, defResId));
            return this;
        }

        public Matcher minEmsAttr(@AttrRes int attrResId) {
            this.mMinEmsMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, 0));
            return this;
        }

        public Matcher minLines(org.hamcrest.Matcher<Integer> matcher) {
            this.mMinLinesMatcher = matcher;
            return this;
        }

        public Matcher minLines(int minLines) {
            this.mMinLinesMatcher = Is.is((Object)minLines);
            return this;
        }

        public Matcher minLinesRes(@IntegerRes int resId) {
            this.mMinLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntRes(resId));
            return this;
        }

        public Matcher minLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mMinLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, defResId));
            return this;
        }

        public Matcher minLinesAttr(@AttrRes int attrResId) {
            this.mMinLinesMatcher = Is.is((Object)this.mResourceResolver.resolveIntAttr(attrResId, 0));
            return this;
        }

        public Matcher minTextWidth(org.hamcrest.Matcher<Integer> matcher) {
            this.mMinTextWidthMatcher = matcher;
            return this;
        }

        public Matcher minTextWidthPx(@Px int minTextWidth) {
            this.mMinTextWidthMatcher = Is.is((Object)minTextWidth);
            return this;
        }

        public Matcher minTextWidthRes(@DimenRes int resId) {
            this.mMinTextWidthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeRes(resId));
            return this;
        }

        public Matcher minTextWidthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mMinTextWidthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId));
            return this;
        }

        public Matcher minTextWidthAttr(@AttrRes int attrResId) {
            this.mMinTextWidthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0));
            return this;
        }

        public Matcher minTextWidthDip(@Dimension(unit=0) float dips) {
            this.mMinTextWidthMatcher = Is.is((Object)this.mResourceResolver.dipsToPixels(dips));
            return this;
        }

        public Matcher minimallyWide(org.hamcrest.Matcher<Boolean> matcher) {
            this.mMinimallyWideMatcher = matcher;
            return this;
        }

        public Matcher minimallyWide(boolean minimallyWide) {
            this.mMinimallyWideMatcher = Is.is((Object)minimallyWide);
            return this;
        }

        public Matcher minimallyWideThreshold(org.hamcrest.Matcher<Integer> matcher) {
            this.mMinimallyWideThresholdMatcher = matcher;
            return this;
        }

        public Matcher minimallyWideThresholdPx(@Px int minimallyWideThreshold) {
            this.mMinimallyWideThresholdMatcher = Is.is((Object)minimallyWideThreshold);
            return this;
        }

        public Matcher minimallyWideThresholdRes(@DimenRes int resId) {
            this.mMinimallyWideThresholdMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeRes(resId));
            return this;
        }

        public Matcher minimallyWideThresholdAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mMinimallyWideThresholdMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId));
            return this;
        }

        public Matcher minimallyWideThresholdAttr(@AttrRes int attrResId) {
            this.mMinimallyWideThresholdMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0));
            return this;
        }

        public Matcher minimallyWideThresholdDip(@Dimension(unit=0) float dips) {
            this.mMinimallyWideThresholdMatcher = Is.is((Object)this.mResourceResolver.dipsToPixels(dips));
            return this;
        }

        public Matcher shadowColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mShadowColorMatcher = matcher;
            return this;
        }

        public Matcher shadowColor(@ColorInt int shadowColor) {
            this.mShadowColorMatcher = Is.is((Object)shadowColor);
            return this;
        }

        public Matcher shadowColorRes(@ColorRes int resId) {
            this.mShadowColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher shadowColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mShadowColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher shadowColorAttr(@AttrRes int attrResId) {
            this.mShadowColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher shadowDx(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowDxMatcher = matcher;
            return this;
        }

        public Matcher shadowDxPx(@Px float shadowDx) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(shadowDx));
            return this;
        }

        public Matcher shadowDxRes(@DimenRes int resId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowDxAttr(@AttrRes int attrResId) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowDxDip(@Dimension(unit=0) float dips) {
            this.mShadowDxMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowDy(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowDyMatcher = matcher;
            return this;
        }

        public Matcher shadowDyPx(@Px float shadowDy) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(shadowDy));
            return this;
        }

        public Matcher shadowDyRes(@DimenRes int resId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowDyAttr(@AttrRes int attrResId) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowDyDip(@Dimension(unit=0) float dips) {
            this.mShadowDyMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shadowRadius(org.hamcrest.Matcher<Float> matcher) {
            this.mShadowRadiusMatcher = matcher;
            return this;
        }

        public Matcher shadowRadiusPx(@Px float shadowRadius) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(shadowRadius));
            return this;
        }

        public Matcher shadowRadiusRes(@DimenRes int resId) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetRes(resId)));
            return this;
        }

        public Matcher shadowRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, defResId)));
            return this;
        }

        public Matcher shadowRadiusAttr(@AttrRes int attrResId) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveDimenOffsetAttr(attrResId, 0)));
            return this;
        }

        public Matcher shadowRadiusDip(@Dimension(unit=0) float dips) {
            this.mShadowRadiusMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.dipsToPixels(dips)));
            return this;
        }

        public Matcher shouldIncludeFontPadding(org.hamcrest.Matcher<Boolean> matcher) {
            this.mShouldIncludeFontPaddingMatcher = matcher;
            return this;
        }

        public Matcher shouldIncludeFontPadding(boolean shouldIncludeFontPadding) {
            this.mShouldIncludeFontPaddingMatcher = Is.is((Object)shouldIncludeFontPadding);
            return this;
        }

        public Matcher shouldIncludeFontPaddingRes(@BoolRes int resId) {
            this.mShouldIncludeFontPaddingMatcher = Is.is((Object)this.mResourceResolver.resolveBoolRes(resId));
            return this;
        }

        public Matcher shouldIncludeFontPaddingAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mShouldIncludeFontPaddingMatcher = Is.is((Object)this.mResourceResolver.resolveBoolAttr(attrResId, defResId));
            return this;
        }

        public Matcher shouldIncludeFontPaddingAttr(@AttrRes int attrResId) {
            this.mShouldIncludeFontPaddingMatcher = Is.is((Object)this.mResourceResolver.resolveBoolAttr(attrResId, 0));
            return this;
        }

        public Matcher spacingMultiplier(org.hamcrest.Matcher<Float> matcher) {
            this.mSpacingMultiplierMatcher = matcher;
            return this;
        }

        public Matcher spacingMultiplier(float spacingMultiplier) {
            this.mSpacingMultiplierMatcher = Is.is((Object)Float.valueOf(spacingMultiplier));
            return this;
        }

        public Matcher spacingMultiplierRes(@DimenRes int resId) {
            this.mSpacingMultiplierMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatRes(resId)));
            return this;
        }

        public Matcher spacingMultiplierAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mSpacingMultiplierMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatAttr(attrResId, defResId)));
            return this;
        }

        public Matcher spacingMultiplierAttr(@AttrRes int attrResId) {
            this.mSpacingMultiplierMatcher = Is.is((Object)Float.valueOf(this.mResourceResolver.resolveFloatAttr(attrResId, 0)));
            return this;
        }

        public Matcher spanListener(org.hamcrest.Matcher<ClickableSpanListener> matcher) {
            this.mSpanListenerMatcher = matcher;
            return this;
        }

        public Matcher spanListener(@Nullable ClickableSpanListener spanListener) {
            this.mSpanListenerMatcher = Is.is((Object)spanListener);
            return this;
        }

        public Matcher text(org.hamcrest.Matcher<CharSequence> matcher) {
            this.mTextMatcher = matcher;
            return this;
        }

        public Matcher text(@Nullable CharSequence text) {
            this.mTextMatcher = Is.is((Object)text);
            return this;
        }

        public Matcher textRes(@Nullable @StringRes int resId) {
            this.mTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId));
            return this;
        }

        public Matcher textRes(@Nullable @StringRes int resId, Object ... formatArgs) {
            this.mTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringRes(resId, formatArgs));
            return this;
        }

        public Matcher textAttr(@Nullable @AttrRes int attrResId, @Nullable @StringRes int defResId) {
            this.mTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, defResId));
            return this;
        }

        public Matcher textAttr(@Nullable @AttrRes int attrResId) {
            this.mTextMatcher = Is.is((Object)this.mResourceResolver.resolveStringAttr(attrResId, 0));
            return this;
        }

        public Matcher textAlignment(org.hamcrest.Matcher<Layout.Alignment> matcher) {
            this.mTextAlignmentMatcher = matcher;
            return this;
        }

        public Matcher textAlignment(@Deprecated @Nullable Layout.Alignment textAlignment) {
            this.mTextAlignmentMatcher = Is.is((Object)textAlignment);
            return this;
        }

        public Matcher textColor(org.hamcrest.Matcher<Integer> matcher) {
            this.mTextColorMatcher = matcher;
            return this;
        }

        public Matcher textColor(@ColorInt int textColor) {
            this.mTextColorMatcher = Is.is((Object)textColor);
            return this;
        }

        public Matcher textColorRes(@ColorRes int resId) {
            this.mTextColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorRes(resId));
            return this;
        }

        public Matcher textColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTextColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, defResId));
            return this;
        }

        public Matcher textColorAttr(@AttrRes int attrResId) {
            this.mTextColorMatcher = Is.is((Object)this.mResourceResolver.resolveColorAttr(attrResId, 0));
            return this;
        }

        public Matcher textColorStateList(org.hamcrest.Matcher<ColorStateList> matcher) {
            this.mTextColorStateListMatcher = matcher;
            return this;
        }

        public Matcher textColorStateList(ColorStateList textColorStateList) {
            this.mTextColorStateListMatcher = Is.is((Object)textColorStateList);
            return this;
        }

        public Matcher textDirection(org.hamcrest.Matcher<TextDirectionHeuristicCompat> matcher) {
            this.mTextDirectionMatcher = matcher;
            return this;
        }

        public Matcher textDirection(@Nullable TextDirectionHeuristicCompat textDirection) {
            this.mTextDirectionMatcher = Is.is((Object)textDirection);
            return this;
        }

        public Matcher textOffsetOnTouchHandler(org.hamcrest.Matcher<EventHandler> matcher) {
            this.mTextOffsetOnTouchHandlerMatcher = matcher;
            return this;
        }

        public Matcher textOffsetOnTouchHandler(@Nullable EventHandler textOffsetOnTouchHandler) {
            this.mTextOffsetOnTouchHandlerMatcher = Is.is((Object)textOffsetOnTouchHandler);
            return this;
        }

        public Matcher textSize(org.hamcrest.Matcher<Integer> matcher) {
            this.mTextSizeMatcher = matcher;
            return this;
        }

        public Matcher textSizePx(@Px int textSize) {
            this.mTextSizeMatcher = Is.is((Object)textSize);
            return this;
        }

        public Matcher textSizeRes(@DimenRes int resId) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeRes(resId));
            return this;
        }

        public Matcher textSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId));
            return this;
        }

        public Matcher textSizeAttr(@AttrRes int attrResId) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0));
            return this;
        }

        public Matcher textSizeDip(@Dimension(unit=0) float dips) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.dipsToPixels(dips));
            return this;
        }

        public Matcher textSizeSp(@Dimension(unit=2) float sips) {
            this.mTextSizeMatcher = Is.is((Object)this.mResourceResolver.sipsToPixels(sips));
            return this;
        }

        public Matcher textStyle(org.hamcrest.Matcher<Integer> matcher) {
            this.mTextStyleMatcher = matcher;
            return this;
        }

        public Matcher textStyle(int textStyle) {
            this.mTextStyleMatcher = Is.is((Object)textStyle);
            return this;
        }

        public Matcher touchableSpanListener(org.hamcrest.Matcher<TouchableSpanListener> matcher) {
            this.mTouchableSpanListenerMatcher = matcher;
            return this;
        }

        public Matcher touchableSpanListener(@Nullable TouchableSpanListener touchableSpanListener) {
            this.mTouchableSpanListenerMatcher = Is.is((Object)touchableSpanListener);
            return this;
        }

        public Matcher typeface(org.hamcrest.Matcher<Typeface> matcher) {
            this.mTypefaceMatcher = matcher;
            return this;
        }

        public Matcher typeface(@Nullable Typeface typeface) {
            this.mTypefaceMatcher = Is.is((Object)typeface);
            return this;
        }

        public Matcher verticalGravity(org.hamcrest.Matcher<VerticalGravity> matcher) {
            this.mVerticalGravityMatcher = matcher;
            return this;
        }

        public Matcher verticalGravity(VerticalGravity verticalGravity) {
            this.mVerticalGravityMatcher = Is.is((Object)verticalGravity);
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(Text.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.Text\"", new Object[0]));
                        return false;
                    }
                    Text impl = (Text)value.getComponent();
                    TextAlignment propValueAlignment = impl.alignment;
                    if (mAlignmentMatcher != null && !mAlignmentMatcher.matches((Object)propValueAlignment)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <alignment> %s (doesn't match %s)", new Object[]{mAlignmentMatcher, propValueAlignment}));
                        return false;
                    }
                    int propValueBreakStrategy = impl.breakStrategy;
                    if (mBreakStrategyMatcher != null && !mBreakStrategyMatcher.matches((Object)propValueBreakStrategy)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <breakStrategy> %s (doesn't match %s)", new Object[]{mBreakStrategyMatcher, propValueBreakStrategy}));
                        return false;
                    }
                    float propValueClickableSpanExpandedOffset = impl.clickableSpanExpandedOffset;
                    if (mClickableSpanExpandedOffsetMatcher != null && !mClickableSpanExpandedOffsetMatcher.matches((Object)Float.valueOf(propValueClickableSpanExpandedOffset))) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <clickableSpanExpandedOffset> %s (doesn't match %s)", new Object[]{mClickableSpanExpandedOffsetMatcher, Float.valueOf(propValueClickableSpanExpandedOffset)}));
                        return false;
                    }
                    boolean propValueClipToBounds = impl.clipToBounds;
                    if (mClipToBoundsMatcher != null && !mClipToBoundsMatcher.matches((Object)propValueClipToBounds)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <clipToBounds> %s (doesn't match %s)", new Object[]{mClipToBoundsMatcher, propValueClipToBounds}));
                        return false;
                    }
                    CharSequence propValueCustomEllipsisText = impl.customEllipsisText;
                    if (mCustomEllipsisTextMatcher != null && !mCustomEllipsisTextMatcher.matches((Object)propValueCustomEllipsisText)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <customEllipsisText> %s (doesn't match %s)", new Object[]{mCustomEllipsisTextMatcher, propValueCustomEllipsisText}));
                        return false;
                    }
                    DynamicValue propValueDynamicTextColor = impl.dynamicTextColor;
                    if (mDynamicTextColorMatcher != null && !mDynamicTextColorMatcher.matches((Object)propValueDynamicTextColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <dynamicTextColor> %s (doesn't match %s)", new Object[]{mDynamicTextColorMatcher, propValueDynamicTextColor}));
                        return false;
                    }
                    TextUtils.TruncateAt propValueEllipsize = impl.ellipsize;
                    if (mEllipsizeMatcher != null && !mEllipsizeMatcher.matches((Object)propValueEllipsize)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <ellipsize> %s (doesn't match %s)", new Object[]{mEllipsizeMatcher, propValueEllipsize}));
                        return false;
                    }
                    float propValueExtraSpacing = impl.extraSpacing;
                    if (mExtraSpacingMatcher != null && !mExtraSpacingMatcher.matches((Object)Float.valueOf(propValueExtraSpacing))) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <extraSpacing> %s (doesn't match %s)", new Object[]{mExtraSpacingMatcher, Float.valueOf(propValueExtraSpacing)}));
                        return false;
                    }
                    boolean propValueGlyphWarming = impl.glyphWarming;
                    if (mGlyphWarmingMatcher != null && !mGlyphWarmingMatcher.matches((Object)propValueGlyphWarming)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <glyphWarming> %s (doesn't match %s)", new Object[]{mGlyphWarmingMatcher, propValueGlyphWarming}));
                        return false;
                    }
                    int propValueHighlightColor = impl.highlightColor;
                    if (mHighlightColorMatcher != null && !mHighlightColorMatcher.matches((Object)propValueHighlightColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <highlightColor> %s (doesn't match %s)", new Object[]{mHighlightColorMatcher, propValueHighlightColor}));
                        return false;
                    }
                    int propValueHighlightEndOffset = impl.highlightEndOffset;
                    if (mHighlightEndOffsetMatcher != null && !mHighlightEndOffsetMatcher.matches((Object)propValueHighlightEndOffset)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <highlightEndOffset> %s (doesn't match %s)", new Object[]{mHighlightEndOffsetMatcher, propValueHighlightEndOffset}));
                        return false;
                    }
                    int propValueHighlightStartOffset = impl.highlightStartOffset;
                    if (mHighlightStartOffsetMatcher != null && !mHighlightStartOffsetMatcher.matches((Object)propValueHighlightStartOffset)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <highlightStartOffset> %s (doesn't match %s)", new Object[]{mHighlightStartOffsetMatcher, propValueHighlightStartOffset}));
                        return false;
                    }
                    int propValueHyphenationFrequency = impl.hyphenationFrequency;
                    if (mHyphenationFrequencyMatcher != null && !mHyphenationFrequencyMatcher.matches((Object)propValueHyphenationFrequency)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <hyphenationFrequency> %s (doesn't match %s)", new Object[]{mHyphenationFrequencyMatcher, propValueHyphenationFrequency}));
                        return false;
                    }
                    boolean propValueIsSingleLine = impl.isSingleLine;
                    if (mIsSingleLineMatcher != null && !mIsSingleLineMatcher.matches((Object)propValueIsSingleLine)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <isSingleLine> %s (doesn't match %s)", new Object[]{mIsSingleLineMatcher, propValueIsSingleLine}));
                        return false;
                    }
                    int propValueJustificationMode = impl.justificationMode;
                    if (mJustificationModeMatcher != null && !mJustificationModeMatcher.matches((Object)propValueJustificationMode)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <justificationMode> %s (doesn't match %s)", new Object[]{mJustificationModeMatcher, propValueJustificationMode}));
                        return false;
                    }
                    float propValueLetterSpacing = impl.letterSpacing;
                    if (mLetterSpacingMatcher != null && !mLetterSpacingMatcher.matches((Object)Float.valueOf(propValueLetterSpacing))) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <letterSpacing> %s (doesn't match %s)", new Object[]{mLetterSpacingMatcher, Float.valueOf(propValueLetterSpacing)}));
                        return false;
                    }
                    float propValueLineHeight = impl.lineHeight;
                    if (mLineHeightMatcher != null && !mLineHeightMatcher.matches((Object)Float.valueOf(propValueLineHeight))) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <lineHeight> %s (doesn't match %s)", new Object[]{mLineHeightMatcher, Float.valueOf(propValueLineHeight)}));
                        return false;
                    }
                    int propValueLinkColor = impl.linkColor;
                    if (mLinkColorMatcher != null && !mLinkColorMatcher.matches((Object)propValueLinkColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <linkColor> %s (doesn't match %s)", new Object[]{mLinkColorMatcher, propValueLinkColor}));
                        return false;
                    }
                    int propValueMaxEms = impl.maxEms;
                    if (mMaxEmsMatcher != null && !mMaxEmsMatcher.matches((Object)propValueMaxEms)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <maxEms> %s (doesn't match %s)", new Object[]{mMaxEmsMatcher, propValueMaxEms}));
                        return false;
                    }
                    int propValueMaxLines = impl.maxLines;
                    if (mMaxLinesMatcher != null && !mMaxLinesMatcher.matches((Object)propValueMaxLines)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <maxLines> %s (doesn't match %s)", new Object[]{mMaxLinesMatcher, propValueMaxLines}));
                        return false;
                    }
                    int propValueMaxTextWidth = impl.maxTextWidth;
                    if (mMaxTextWidthMatcher != null && !mMaxTextWidthMatcher.matches((Object)propValueMaxTextWidth)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <maxTextWidth> %s (doesn't match %s)", new Object[]{mMaxTextWidthMatcher, propValueMaxTextWidth}));
                        return false;
                    }
                    int propValueMinEms = impl.minEms;
                    if (mMinEmsMatcher != null && !mMinEmsMatcher.matches((Object)propValueMinEms)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <minEms> %s (doesn't match %s)", new Object[]{mMinEmsMatcher, propValueMinEms}));
                        return false;
                    }
                    int propValueMinLines = impl.minLines;
                    if (mMinLinesMatcher != null && !mMinLinesMatcher.matches((Object)propValueMinLines)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <minLines> %s (doesn't match %s)", new Object[]{mMinLinesMatcher, propValueMinLines}));
                        return false;
                    }
                    int propValueMinTextWidth = impl.minTextWidth;
                    if (mMinTextWidthMatcher != null && !mMinTextWidthMatcher.matches((Object)propValueMinTextWidth)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <minTextWidth> %s (doesn't match %s)", new Object[]{mMinTextWidthMatcher, propValueMinTextWidth}));
                        return false;
                    }
                    boolean propValueMinimallyWide = impl.minimallyWide;
                    if (mMinimallyWideMatcher != null && !mMinimallyWideMatcher.matches((Object)propValueMinimallyWide)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <minimallyWide> %s (doesn't match %s)", new Object[]{mMinimallyWideMatcher, propValueMinimallyWide}));
                        return false;
                    }
                    int propValueMinimallyWideThreshold = impl.minimallyWideThreshold;
                    if (mMinimallyWideThresholdMatcher != null && !mMinimallyWideThresholdMatcher.matches((Object)propValueMinimallyWideThreshold)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <minimallyWideThreshold> %s (doesn't match %s)", new Object[]{mMinimallyWideThresholdMatcher, propValueMinimallyWideThreshold}));
                        return false;
                    }
                    int propValueShadowColor = impl.shadowColor;
                    if (mShadowColorMatcher != null && !mShadowColorMatcher.matches((Object)propValueShadowColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <shadowColor> %s (doesn't match %s)", new Object[]{mShadowColorMatcher, propValueShadowColor}));
                        return false;
                    }
                    float propValueShadowDx = impl.shadowDx;
                    if (mShadowDxMatcher != null && !mShadowDxMatcher.matches((Object)Float.valueOf(propValueShadowDx))) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <shadowDx> %s (doesn't match %s)", new Object[]{mShadowDxMatcher, Float.valueOf(propValueShadowDx)}));
                        return false;
                    }
                    float propValueShadowDy = impl.shadowDy;
                    if (mShadowDyMatcher != null && !mShadowDyMatcher.matches((Object)Float.valueOf(propValueShadowDy))) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <shadowDy> %s (doesn't match %s)", new Object[]{mShadowDyMatcher, Float.valueOf(propValueShadowDy)}));
                        return false;
                    }
                    float propValueShadowRadius = impl.shadowRadius;
                    if (mShadowRadiusMatcher != null && !mShadowRadiusMatcher.matches((Object)Float.valueOf(propValueShadowRadius))) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <shadowRadius> %s (doesn't match %s)", new Object[]{mShadowRadiusMatcher, Float.valueOf(propValueShadowRadius)}));
                        return false;
                    }
                    boolean propValueShouldIncludeFontPadding = impl.shouldIncludeFontPadding;
                    if (mShouldIncludeFontPaddingMatcher != null && !mShouldIncludeFontPaddingMatcher.matches((Object)propValueShouldIncludeFontPadding)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <shouldIncludeFontPadding> %s (doesn't match %s)", new Object[]{mShouldIncludeFontPaddingMatcher, propValueShouldIncludeFontPadding}));
                        return false;
                    }
                    float propValueSpacingMultiplier = impl.spacingMultiplier;
                    if (mSpacingMultiplierMatcher != null && !mSpacingMultiplierMatcher.matches((Object)Float.valueOf(propValueSpacingMultiplier))) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <spacingMultiplier> %s (doesn't match %s)", new Object[]{mSpacingMultiplierMatcher, Float.valueOf(propValueSpacingMultiplier)}));
                        return false;
                    }
                    ClickableSpanListener propValueSpanListener = impl.spanListener;
                    if (mSpanListenerMatcher != null && !mSpanListenerMatcher.matches((Object)propValueSpanListener)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <spanListener> %s (doesn't match %s)", new Object[]{mSpanListenerMatcher, propValueSpanListener}));
                        return false;
                    }
                    CharSequence propValueText = impl.text;
                    if (mTextMatcher != null && !mTextMatcher.matches((Object)propValueText)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <text> %s (doesn't match %s)", new Object[]{mTextMatcher, propValueText}));
                        return false;
                    }
                    Layout.Alignment propValueTextAlignment = impl.textAlignment;
                    if (mTextAlignmentMatcher != null && !mTextAlignmentMatcher.matches((Object)propValueTextAlignment)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <textAlignment> %s (doesn't match %s)", new Object[]{mTextAlignmentMatcher, propValueTextAlignment}));
                        return false;
                    }
                    int propValueTextColor = impl.textColor;
                    if (mTextColorMatcher != null && !mTextColorMatcher.matches((Object)propValueTextColor)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <textColor> %s (doesn't match %s)", new Object[]{mTextColorMatcher, propValueTextColor}));
                        return false;
                    }
                    ColorStateList propValueTextColorStateList = impl.textColorStateList;
                    if (mTextColorStateListMatcher != null && !mTextColorStateListMatcher.matches((Object)propValueTextColorStateList)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <textColorStateList> %s (doesn't match %s)", new Object[]{mTextColorStateListMatcher, propValueTextColorStateList}));
                        return false;
                    }
                    TextDirectionHeuristicCompat propValueTextDirection = impl.textDirection;
                    if (mTextDirectionMatcher != null && !mTextDirectionMatcher.matches((Object)propValueTextDirection)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <textDirection> %s (doesn't match %s)", new Object[]{mTextDirectionMatcher, propValueTextDirection}));
                        return false;
                    }
                    EventHandler propValueTextOffsetOnTouchHandler = impl.textOffsetOnTouchHandler;
                    if (mTextOffsetOnTouchHandlerMatcher != null && !mTextOffsetOnTouchHandlerMatcher.matches((Object)propValueTextOffsetOnTouchHandler)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <textOffsetOnTouchHandler> %s (doesn't match %s)", new Object[]{mTextOffsetOnTouchHandlerMatcher, propValueTextOffsetOnTouchHandler}));
                        return false;
                    }
                    int propValueTextSize = impl.textSize;
                    if (mTextSizeMatcher != null && !mTextSizeMatcher.matches((Object)propValueTextSize)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <textSize> %s (doesn't match %s)", new Object[]{mTextSizeMatcher, propValueTextSize}));
                        return false;
                    }
                    int propValueTextStyle = impl.textStyle;
                    if (mTextStyleMatcher != null && !mTextStyleMatcher.matches((Object)propValueTextStyle)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <textStyle> %s (doesn't match %s)", new Object[]{mTextStyleMatcher, propValueTextStyle}));
                        return false;
                    }
                    TouchableSpanListener propValueTouchableSpanListener = impl.touchableSpanListener;
                    if (mTouchableSpanListenerMatcher != null && !mTouchableSpanListenerMatcher.matches((Object)propValueTouchableSpanListener)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <touchableSpanListener> %s (doesn't match %s)", new Object[]{mTouchableSpanListenerMatcher, propValueTouchableSpanListener}));
                        return false;
                    }
                    Typeface propValueTypeface = impl.typeface;
                    if (mTypefaceMatcher != null && !mTypefaceMatcher.matches((Object)propValueTypeface)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <typeface> %s (doesn't match %s)", new Object[]{mTypefaceMatcher, propValueTypeface}));
                        return false;
                    }
                    VerticalGravity propValueVerticalGravity = impl.verticalGravity;
                    if (mVerticalGravityMatcher != null && !mVerticalGravityMatcher.matches((Object)propValueVerticalGravity)) {
                        this.as((Description)new TextDescription("Sub-component of type <Text> with prop <verticalGravity> %s (doesn't match %s)", new Object[]{mVerticalGravityMatcher, propValueVerticalGravity}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

