/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.AttrRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.core.widget.NestedScrollView;
import com.facebook.litho.BaseMatcher;
import com.facebook.litho.BaseMatcherBuilder;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.testing.subcomponents.InspectableComponent;
import com.facebook.litho.widget.LithoScrollView;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.litho.widget.TestVerticalScrollSpec;
import com.facebook.litho.widget.VerticalScroll;
import com.facebook.litho.widget.VerticalScrollEventsController;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.hamcrest.core.Is;

@Generated
public final class TestVerticalScroll
implements TestVerticalScrollSpec {
    public static Matcher matcher(ComponentContext c) {
        return new Matcher(c);
    }

    @Generated
    public static class Matcher
    extends BaseMatcher<Matcher> {
        protected ResourceResolver mResourceResolver;
        @javax.annotation.Nullable
        Condition<InspectableComponent> mChildComponentComponentMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Component> mChildComponentMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<VerticalScrollEventsController> mEventsControllerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mFadingEdgeLengthMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mFillViewportMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mIncrementalMountEnabledMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mInitialScrollOffsetPixelsMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mNestedScrollingEnabledMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<LithoScrollView.OnInterceptTouchListener> mOnInterceptTouchListenerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<NestedScrollView.OnScrollChangeListener> mOnScrollChangeListenerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Integer> mOverScrollModeMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<ScrollStateListener> mScrollStateListenerMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mScrollbarEnabledMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mScrollbarFadingEnabledMatcher;
        @javax.annotation.Nullable
        org.hamcrest.Matcher<Boolean> mVerticalFadingEdgeEnabledMatcher;

        Matcher(ComponentContext c) {
            this.mResourceResolver = c.getResourceResolver();
        }

        public Matcher childComponent(Condition<InspectableComponent> matcher) {
            this.mChildComponentComponentMatcher = matcher;
            return this;
        }

        public Matcher childComponent(org.hamcrest.Matcher<Component> matcher) {
            this.mChildComponentMatcher = matcher;
            return this;
        }

        public Matcher childComponent(Component childComponent) {
            this.mChildComponentMatcher = Is.is((Object)childComponent);
            return this;
        }

        public Matcher childComponent(Component.Builder<?> childComponentBuilder) {
            this.mChildComponentMatcher = Is.is((Object)childComponentBuilder.build());
            return this;
        }

        public Matcher eventsController(org.hamcrest.Matcher<VerticalScrollEventsController> matcher) {
            this.mEventsControllerMatcher = matcher;
            return this;
        }

        public Matcher eventsController(@Nullable VerticalScrollEventsController eventsController) {
            this.mEventsControllerMatcher = Is.is((Object)eventsController);
            return this;
        }

        public Matcher fadingEdgeLength(org.hamcrest.Matcher<Integer> matcher) {
            this.mFadingEdgeLengthMatcher = matcher;
            return this;
        }

        public Matcher fadingEdgeLengthPx(@Px int fadingEdgeLength) {
            this.mFadingEdgeLengthMatcher = Is.is((Object)fadingEdgeLength);
            return this;
        }

        public Matcher fadingEdgeLengthRes(@DimenRes int resId) {
            this.mFadingEdgeLengthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeRes(resId));
            return this;
        }

        public Matcher fadingEdgeLengthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mFadingEdgeLengthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId));
            return this;
        }

        public Matcher fadingEdgeLengthAttr(@AttrRes int attrResId) {
            this.mFadingEdgeLengthMatcher = Is.is((Object)this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0));
            return this;
        }

        public Matcher fadingEdgeLengthDip(@Dimension(unit=0) float dips) {
            this.mFadingEdgeLengthMatcher = Is.is((Object)this.mResourceResolver.dipsToPixels(dips));
            return this;
        }

        public Matcher fillViewport(org.hamcrest.Matcher<Boolean> matcher) {
            this.mFillViewportMatcher = matcher;
            return this;
        }

        public Matcher fillViewport(boolean fillViewport) {
            this.mFillViewportMatcher = Is.is((Object)fillViewport);
            return this;
        }

        public Matcher incrementalMountEnabled(org.hamcrest.Matcher<Boolean> matcher) {
            this.mIncrementalMountEnabledMatcher = matcher;
            return this;
        }

        public Matcher incrementalMountEnabled(boolean incrementalMountEnabled) {
            this.mIncrementalMountEnabledMatcher = Is.is((Object)incrementalMountEnabled);
            return this;
        }

        public Matcher initialScrollOffsetPixels(org.hamcrest.Matcher<Integer> matcher) {
            this.mInitialScrollOffsetPixelsMatcher = matcher;
            return this;
        }

        public Matcher initialScrollOffsetPixels(int initialScrollOffsetPixels) {
            this.mInitialScrollOffsetPixelsMatcher = Is.is((Object)initialScrollOffsetPixels);
            return this;
        }

        public Matcher nestedScrollingEnabled(org.hamcrest.Matcher<Boolean> matcher) {
            this.mNestedScrollingEnabledMatcher = matcher;
            return this;
        }

        public Matcher nestedScrollingEnabled(boolean nestedScrollingEnabled) {
            this.mNestedScrollingEnabledMatcher = Is.is((Object)nestedScrollingEnabled);
            return this;
        }

        public Matcher onInterceptTouchListener(org.hamcrest.Matcher<LithoScrollView.OnInterceptTouchListener> matcher) {
            this.mOnInterceptTouchListenerMatcher = matcher;
            return this;
        }

        public Matcher onInterceptTouchListener(@Nullable LithoScrollView.OnInterceptTouchListener onInterceptTouchListener) {
            this.mOnInterceptTouchListenerMatcher = Is.is((Object)onInterceptTouchListener);
            return this;
        }

        public Matcher onScrollChangeListener(org.hamcrest.Matcher<NestedScrollView.OnScrollChangeListener> matcher) {
            this.mOnScrollChangeListenerMatcher = matcher;
            return this;
        }

        public Matcher onScrollChangeListener(@Nullable NestedScrollView.OnScrollChangeListener onScrollChangeListener) {
            this.mOnScrollChangeListenerMatcher = Is.is((Object)onScrollChangeListener);
            return this;
        }

        public Matcher overScrollMode(org.hamcrest.Matcher<Integer> matcher) {
            this.mOverScrollModeMatcher = matcher;
            return this;
        }

        public Matcher overScrollMode(int overScrollMode) {
            this.mOverScrollModeMatcher = Is.is((Object)overScrollMode);
            return this;
        }

        public Matcher scrollStateListener(org.hamcrest.Matcher<ScrollStateListener> matcher) {
            this.mScrollStateListenerMatcher = matcher;
            return this;
        }

        public Matcher scrollStateListener(ScrollStateListener scrollStateListener) {
            this.mScrollStateListenerMatcher = Is.is((Object)scrollStateListener);
            return this;
        }

        public Matcher scrollbarEnabled(org.hamcrest.Matcher<Boolean> matcher) {
            this.mScrollbarEnabledMatcher = matcher;
            return this;
        }

        public Matcher scrollbarEnabled(boolean scrollbarEnabled) {
            this.mScrollbarEnabledMatcher = Is.is((Object)scrollbarEnabled);
            return this;
        }

        public Matcher scrollbarFadingEnabled(org.hamcrest.Matcher<Boolean> matcher) {
            this.mScrollbarFadingEnabledMatcher = matcher;
            return this;
        }

        public Matcher scrollbarFadingEnabled(boolean scrollbarFadingEnabled) {
            this.mScrollbarFadingEnabledMatcher = Is.is((Object)scrollbarFadingEnabled);
            return this;
        }

        public Matcher verticalFadingEdgeEnabled(org.hamcrest.Matcher<Boolean> matcher) {
            this.mVerticalFadingEdgeEnabledMatcher = matcher;
            return this;
        }

        public Matcher verticalFadingEdgeEnabled(boolean verticalFadingEdgeEnabled) {
            this.mVerticalFadingEdgeEnabledMatcher = Is.is((Object)verticalFadingEdgeEnabled);
            return this;
        }

        public Condition<InspectableComponent> build() {
            Condition<InspectableComponent> mainBuilder = new Condition<InspectableComponent>(){

                public boolean matches(InspectableComponent value) {
                    if (!value.getComponentClass().isAssignableFrom(VerticalScroll.class)) {
                        this.as((Description)new TextDescription("Sub-component of type \"com.facebook.litho.widget.VerticalScroll\"", new Object[0]));
                        return false;
                    }
                    VerticalScroll impl = (VerticalScroll)value.getComponent();
                    Component propValueChildComponentComponent = impl.childComponent;
                    if (mChildComponentComponentMatcher != null && !mChildComponentComponentMatcher.matches((Object)value.getNestedInstance(propValueChildComponentComponent))) {
                        this.as(mChildComponentComponentMatcher.description());
                        return false;
                    }
                    Component propValueChildComponent = impl.childComponent;
                    if (mChildComponentMatcher != null && !mChildComponentMatcher.matches((Object)propValueChildComponent)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <childComponent> %s (doesn't match %s)", new Object[]{mChildComponentMatcher, propValueChildComponent}));
                        return false;
                    }
                    VerticalScrollEventsController propValueEventsController = impl.eventsController;
                    if (mEventsControllerMatcher != null && !mEventsControllerMatcher.matches((Object)propValueEventsController)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <eventsController> %s (doesn't match %s)", new Object[]{mEventsControllerMatcher, propValueEventsController}));
                        return false;
                    }
                    int propValueFadingEdgeLength = impl.fadingEdgeLength;
                    if (mFadingEdgeLengthMatcher != null && !mFadingEdgeLengthMatcher.matches((Object)propValueFadingEdgeLength)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <fadingEdgeLength> %s (doesn't match %s)", new Object[]{mFadingEdgeLengthMatcher, propValueFadingEdgeLength}));
                        return false;
                    }
                    boolean propValueFillViewport = impl.fillViewport;
                    if (mFillViewportMatcher != null && !mFillViewportMatcher.matches((Object)propValueFillViewport)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <fillViewport> %s (doesn't match %s)", new Object[]{mFillViewportMatcher, propValueFillViewport}));
                        return false;
                    }
                    boolean propValueIncrementalMountEnabled = impl.incrementalMountEnabled;
                    if (mIncrementalMountEnabledMatcher != null && !mIncrementalMountEnabledMatcher.matches((Object)propValueIncrementalMountEnabled)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <incrementalMountEnabled> %s (doesn't match %s)", new Object[]{mIncrementalMountEnabledMatcher, propValueIncrementalMountEnabled}));
                        return false;
                    }
                    int propValueInitialScrollOffsetPixels = impl.initialScrollOffsetPixels;
                    if (mInitialScrollOffsetPixelsMatcher != null && !mInitialScrollOffsetPixelsMatcher.matches((Object)propValueInitialScrollOffsetPixels)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <initialScrollOffsetPixels> %s (doesn't match %s)", new Object[]{mInitialScrollOffsetPixelsMatcher, propValueInitialScrollOffsetPixels}));
                        return false;
                    }
                    boolean propValueNestedScrollingEnabled = impl.nestedScrollingEnabled;
                    if (mNestedScrollingEnabledMatcher != null && !mNestedScrollingEnabledMatcher.matches((Object)propValueNestedScrollingEnabled)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <nestedScrollingEnabled> %s (doesn't match %s)", new Object[]{mNestedScrollingEnabledMatcher, propValueNestedScrollingEnabled}));
                        return false;
                    }
                    LithoScrollView.OnInterceptTouchListener propValueOnInterceptTouchListener = impl.onInterceptTouchListener;
                    if (mOnInterceptTouchListenerMatcher != null && !mOnInterceptTouchListenerMatcher.matches((Object)propValueOnInterceptTouchListener)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <onInterceptTouchListener> %s (doesn't match %s)", new Object[]{mOnInterceptTouchListenerMatcher, propValueOnInterceptTouchListener}));
                        return false;
                    }
                    NestedScrollView.OnScrollChangeListener propValueOnScrollChangeListener = impl.onScrollChangeListener;
                    if (mOnScrollChangeListenerMatcher != null && !mOnScrollChangeListenerMatcher.matches((Object)propValueOnScrollChangeListener)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <onScrollChangeListener> %s (doesn't match %s)", new Object[]{mOnScrollChangeListenerMatcher, propValueOnScrollChangeListener}));
                        return false;
                    }
                    int propValueOverScrollMode = impl.overScrollMode;
                    if (mOverScrollModeMatcher != null && !mOverScrollModeMatcher.matches((Object)propValueOverScrollMode)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <overScrollMode> %s (doesn't match %s)", new Object[]{mOverScrollModeMatcher, propValueOverScrollMode}));
                        return false;
                    }
                    ScrollStateListener propValueScrollStateListener = impl.scrollStateListener;
                    if (mScrollStateListenerMatcher != null && !mScrollStateListenerMatcher.matches((Object)propValueScrollStateListener)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <scrollStateListener> %s (doesn't match %s)", new Object[]{mScrollStateListenerMatcher, propValueScrollStateListener}));
                        return false;
                    }
                    boolean propValueScrollbarEnabled = impl.scrollbarEnabled;
                    if (mScrollbarEnabledMatcher != null && !mScrollbarEnabledMatcher.matches((Object)propValueScrollbarEnabled)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <scrollbarEnabled> %s (doesn't match %s)", new Object[]{mScrollbarEnabledMatcher, propValueScrollbarEnabled}));
                        return false;
                    }
                    boolean propValueScrollbarFadingEnabled = impl.scrollbarFadingEnabled;
                    if (mScrollbarFadingEnabledMatcher != null && !mScrollbarFadingEnabledMatcher.matches((Object)propValueScrollbarFadingEnabled)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <scrollbarFadingEnabled> %s (doesn't match %s)", new Object[]{mScrollbarFadingEnabledMatcher, propValueScrollbarFadingEnabled}));
                        return false;
                    }
                    boolean propValueVerticalFadingEdgeEnabled = impl.verticalFadingEdgeEnabled;
                    if (mVerticalFadingEdgeEnabledMatcher != null && !mVerticalFadingEdgeEnabledMatcher.matches((Object)propValueVerticalFadingEdgeEnabled)) {
                        this.as((Description)new TextDescription("Sub-component of type <VerticalScroll> with prop <verticalFadingEdgeEnabled> %s (doesn't match %s)", new Object[]{mVerticalFadingEdgeEnabledMatcher, propValueVerticalFadingEdgeEnabled}));
                        return false;
                    }
                    return true;
                }
            };
            return Assertions.allOf((Condition[])new Condition[]{mainBuilder, BaseMatcherBuilder.buildCommonMatcher(this)});
        }

        @Override
        public Matcher getThis() {
            return this;
        }
    }
}

