/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.kotlin.widget;

import android.content.Context;
import android.view.ViewTreeObserver;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.LithoLayoutContextExtraData;
import com.facebook.litho.SimpleMountable;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.kotlin.widget.HorizontalScrollLayoutData;
import com.facebook.litho.widget.HorizontalScrollEventsController;
import com.facebook.litho.widget.HorizontalScrollLithoView;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.rendercore.LayoutContextExtraData;
import com.facebook.rendercore.MeasureResult;
import com.facebook.rendercore.RenderState;
import com.facebook.rendercore.RenderUnit;
import com.facebook.yoga.YogaDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&BS\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0004\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J.\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00022\b\u0010$\u001a\u0004\u0018\u00010\u001fH\u0016J\"\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00022\b\u0010$\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/facebook/litho/kotlin/widget/HorizontalScrollMountable;", "Lcom/facebook/litho/SimpleMountable;", "Lcom/facebook/litho/widget/HorizontalScrollLithoView;", "scrollbarEnabled", "", "eventsController", "Lcom/facebook/litho/widget/HorizontalScrollEventsController;", "onScrollChangeListener", "Lcom/facebook/litho/widget/HorizontalScrollLithoView$OnScrollChangeListener;", "scrollStateListener", "Lcom/facebook/litho/widget/ScrollStateListener;", "overScrollMode", "", "lastScrollPosition", "Lcom/facebook/litho/widget/HorizontalScrollLithoView$ScrollPosition;", "fillViewport", "childComponent", "Lcom/facebook/litho/Component;", "childComponentTree", "Lcom/facebook/litho/ComponentTree;", "(ZLcom/facebook/litho/widget/HorizontalScrollEventsController;Lcom/facebook/litho/widget/HorizontalScrollLithoView$OnScrollChangeListener;Lcom/facebook/litho/widget/ScrollStateListener;ILcom/facebook/litho/widget/HorizontalScrollLithoView$ScrollPosition;ZLcom/facebook/litho/Component;Lcom/facebook/litho/ComponentTree;)V", "createContent", "context", "Landroid/content/Context;", "doesMountRenderTreeHosts", "measure", "Lcom/facebook/rendercore/MeasureResult;", "Lcom/facebook/rendercore/RenderState$LayoutContext;", "widthSpec", "heightSpec", "previousLayoutData", "", "mount", "", "c", "content", "layoutData", "unmount", "Companion", "litho-widget-kotlin_release"})
public final class HorizontalScrollMountable
extends SimpleMountable<HorizontalScrollLithoView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean scrollbarEnabled;
    @Nullable
    private final HorizontalScrollEventsController eventsController;
    @Nullable
    private final HorizontalScrollLithoView.OnScrollChangeListener onScrollChangeListener;
    @Nullable
    private final ScrollStateListener scrollStateListener;
    private final int overScrollMode;
    @NotNull
    private final HorizontalScrollLithoView.ScrollPosition lastScrollPosition;
    private final boolean fillViewport;
    @NotNull
    private final Component childComponent;
    @NotNull
    private final ComponentTree childComponentTree;
    @NotNull
    private static final YogaDirection DEFAULT_LAYOUT_DIRECTION = YogaDirection.LTR;

    public HorizontalScrollMountable(boolean scrollbarEnabled, @Nullable HorizontalScrollEventsController eventsController, @Nullable HorizontalScrollLithoView.OnScrollChangeListener onScrollChangeListener, @Nullable ScrollStateListener scrollStateListener, int overScrollMode, @NotNull HorizontalScrollLithoView.ScrollPosition lastScrollPosition2, boolean fillViewport, @NotNull Component childComponent, @NotNull ComponentTree childComponentTree2) {
        Intrinsics.checkNotNullParameter((Object)lastScrollPosition2, (String)"lastScrollPosition");
        Intrinsics.checkNotNullParameter((Object)childComponent, (String)"childComponent");
        Intrinsics.checkNotNullParameter((Object)childComponentTree2, (String)"childComponentTree");
        super(RenderUnit.RenderType.VIEW);
        this.scrollbarEnabled = scrollbarEnabled;
        this.eventsController = eventsController;
        this.onScrollChangeListener = onScrollChangeListener;
        this.scrollStateListener = scrollStateListener;
        this.overScrollMode = overScrollMode;
        this.lastScrollPosition = lastScrollPosition2;
        this.fillViewport = fillViewport;
        this.childComponent = childComponent;
        this.childComponentTree = childComponentTree2;
    }

    public boolean doesMountRenderTreeHosts() {
        return true;
    }

    @NotNull
    public HorizontalScrollLithoView createContent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new HorizontalScrollLithoView(context);
    }

    @NotNull
    protected MeasureResult measure(@NotNull RenderState.LayoutContext<?> context, int widthSpec, int heightSpec, @Nullable Object previousLayoutData) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Size size = new Size();
        int width = Math.max(0, SizeSpec.getSize((int)widthSpec));
        this.childComponentTree.setRootAndSizeSpecSync(this.childComponent, SizeSpec.makeSizeSpec((int)0, (int)0), heightSpec, size);
        size.width = Math.max(0, Math.max(size.width, this.fillViewport ? width : 0));
        size.height = Math.max(0, size.height);
        LayoutContextExtraData layoutContextExtraData = context.getLayoutContextExtraData();
        Object object = layoutContextExtraData != null ? layoutContextExtraData.getExtraLayoutData() : null;
        LithoLayoutContextExtraData.LithoLayoutExtraData extraLayoutData = object instanceof LithoLayoutContextExtraData.LithoLayoutExtraData ? (LithoLayoutContextExtraData.LithoLayoutExtraData)object : null;
        LithoLayoutContextExtraData.LithoLayoutExtraData lithoLayoutExtraData = extraLayoutData;
        if (lithoLayoutExtraData == null || (lithoLayoutExtraData = lithoLayoutExtraData.getLayoutDirection()) == null) {
            lithoLayoutExtraData = DEFAULT_LAYOUT_DIRECTION;
        }
        Intrinsics.checkNotNullExpressionValue((Object)lithoLayoutExtraData, (String)"extraLayoutData?.layoutD\u2026 DEFAULT_LAYOUT_DIRECTION");
        LithoLayoutContextExtraData.LithoLayoutExtraData direction = lithoLayoutExtraData;
        return new MeasureResult(size.width, size.height, (Object)new HorizontalScrollLayoutData(size.width, size.height, (YogaDirection)direction));
    }

    public void mount(@NotNull Context c, @NotNull HorizontalScrollLithoView content, @Nullable Object layoutData) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Object object = layoutData;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.facebook.litho.kotlin.widget.HorizontalScrollLayoutData");
            }
            HorizontalScrollLayoutData horizontalScrollLayoutData = (HorizontalScrollLayoutData)object;
            content.setHorizontalScrollBarEnabled(this.scrollbarEnabled);
            content.setOverScrollMode(this.overScrollMode);
            content.mount(this.childComponentTree, this.lastScrollPosition, horizontalScrollLayoutData.getMeasuredWidth(), horizontalScrollLayoutData.getMeasuredHeight(), this.onScrollChangeListener, this.scrollStateListener);
            ViewTreeObserver viewTreeObserver = content.getViewTreeObserver();
            Intrinsics.checkNotNullExpressionValue((Object)viewTreeObserver, (String)"content.viewTreeObserver");
            ViewTreeObserver viewTreeObserver2 = viewTreeObserver;
            viewTreeObserver2.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(content, this, horizontalScrollLayoutData){
                final /* synthetic */ HorizontalScrollLithoView $content;
                final /* synthetic */ HorizontalScrollMountable this$0;
                final /* synthetic */ HorizontalScrollLayoutData $horizontalScrollLayoutData;
                {
                    this.$content = $content;
                    this.this$0 = $receiver;
                    this.$horizontalScrollLayoutData = $horizontalScrollLayoutData;
                }

                public boolean onPreDraw() {
                    this.$content.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    if (HorizontalScrollMountable.access$getLastScrollPosition$p((HorizontalScrollMountable)this.this$0).x == -1) {
                        if (this.$horizontalScrollLayoutData.getLayoutDirection() == YogaDirection.RTL) {
                            this.$content.fullScroll(66);
                        }
                        HorizontalScrollMountable.access$getLastScrollPosition$p((HorizontalScrollMountable)this.this$0).x = this.$content.getScrollX();
                    } else {
                        this.$content.setScrollX(HorizontalScrollMountable.access$getLastScrollPosition$p((HorizontalScrollMountable)this.this$0).x);
                    }
                    return true;
                }
            });
            HorizontalScrollEventsController horizontalScrollEventsController = this.eventsController;
            if (horizontalScrollEventsController == null) break block1;
            horizontalScrollEventsController.setScrollableView(content);
        }
    }

    public void unmount(@NotNull Context c, @NotNull HorizontalScrollLithoView content, @Nullable Object layoutData) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            content.unmount();
            HorizontalScrollEventsController horizontalScrollEventsController = this.eventsController;
            if (horizontalScrollEventsController == null) break block0;
            horizontalScrollEventsController.setScrollableView(null);
        }
    }

    public static final /* synthetic */ HorizontalScrollLithoView.ScrollPosition access$getLastScrollPosition$p(HorizontalScrollMountable $this) {
        return $this.lastScrollPosition;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/litho/kotlin/widget/HorizontalScrollMountable$Companion;", "", "()V", "DEFAULT_LAYOUT_DIRECTION", "Lcom/facebook/yoga/YogaDirection;", "litho-widget-kotlin_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

