/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.kotlin.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.facebook.litho.DrawableMatrix;
import com.facebook.litho.MatrixDrawable;
import com.facebook.litho.SimpleMountable;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.drawable.DrawableUtils;
import com.facebook.litho.kotlin.widget.ImageLayoutData;
import com.facebook.litho.utils.MeasureUtils;
import com.facebook.rendercore.MeasureResult;
import com.facebook.rendercore.RenderState;
import com.facebook.rendercore.RenderUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u00020\u00102\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016JD\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\b\u0010!\u001a\u0004\u0018\u00010\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0016J(\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/facebook/litho/kotlin/widget/ImageMountable;", "Lcom/facebook/litho/SimpleMountable;", "Lcom/facebook/litho/MatrixDrawable;", "Landroid/graphics/drawable/Drawable;", "drawable", "scaleType", "Landroid/widget/ImageView$ScaleType;", "(Landroid/graphics/drawable/Drawable;Landroid/widget/ImageView$ScaleType;)V", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "getScaleType", "()Landroid/widget/ImageView$ScaleType;", "createContent", "context", "Landroid/content/Context;", "measure", "Lcom/facebook/rendercore/MeasureResult;", "Lcom/facebook/rendercore/RenderState$LayoutContext;", "widthSpec", "", "heightSpec", "previousLayoutData", "", "mount", "", "c", "content", "layoutData", "poolSize", "shouldUpdate", "", "currentMountable", "newMountable", "currentLayoutData", "nextLayoutData", "unmount", "litho-widget-kotlin_release"})
public final class ImageMountable
extends SimpleMountable<MatrixDrawable<Drawable>> {
    @NotNull
    private final Drawable drawable;
    @NotNull
    private final ImageView.ScaleType scaleType;

    public ImageMountable(@NotNull Drawable drawable, @NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        super(RenderUnit.RenderType.DRAWABLE);
        this.drawable = drawable;
        this.scaleType = scaleType;
    }

    @NotNull
    public final Drawable getDrawable() {
        return this.drawable;
    }

    @NotNull
    public final ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    @NotNull
    public MatrixDrawable<Drawable> createContent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new MatrixDrawable();
    }

    @NotNull
    protected MeasureResult measure(@NotNull RenderState.LayoutContext<?> context, int widthSpec, int heightSpec, @Nullable Object previousLayoutData) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Size size = new Size();
        int intrinsicWidth = this.drawable.getIntrinsicWidth();
        int intrinsicHeight = this.drawable.getIntrinsicHeight();
        if (SizeSpec.getMode((int)widthSpec) == 0 && SizeSpec.getMode((int)heightSpec) == 0) {
            size.width = intrinsicWidth;
            size.height = intrinsicHeight;
        } else {
            float aspectRatio = (float)intrinsicWidth / (float)intrinsicHeight;
            MeasureUtils.measureWithAspectRatio((int)widthSpec, (int)heightSpec, (int)intrinsicWidth, (int)intrinsicHeight, (float)aspectRatio, (Size)size);
        }
        DrawableMatrix matrix = this.scaleType == ImageView.ScaleType.FIT_XY || intrinsicWidth <= 0 || intrinsicHeight <= 0 ? (DrawableMatrix)null : DrawableMatrix.create((Drawable)this.drawable, (ImageView.ScaleType)this.scaleType, (int)size.width, (int)size.height);
        boolean useLayoutSize = ImageView.ScaleType.FIT_XY == this.scaleType || intrinsicWidth <= 0 || intrinsicHeight <= 0;
        return new MeasureResult(size.width, size.height, (Object)new ImageLayoutData(useLayoutSize ? size.width : intrinsicWidth, useLayoutSize ? size.height : intrinsicHeight, matrix));
    }

    public void mount(@NotNull Context c, @NotNull MatrixDrawable<Drawable> content, @Nullable Object layoutData) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        Object object = layoutData;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.facebook.litho.kotlin.widget.ImageLayoutData");
        }
        ImageLayoutData cfr_ignored_0 = (ImageLayoutData)object;
        content.mount(this.drawable, ((ImageLayoutData)layoutData).getMatrix());
        content.bind(((ImageLayoutData)layoutData).getWidth(), ((ImageLayoutData)layoutData).getHeight());
    }

    public void unmount(@NotNull Context c, @NotNull MatrixDrawable<Drawable> content, @Nullable Object layoutData) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        content.unmount();
    }

    public boolean shouldUpdate(@NotNull SimpleMountable<MatrixDrawable<Drawable>> currentMountable, @NotNull SimpleMountable<MatrixDrawable<Drawable>> newMountable, @Nullable Object currentLayoutData, @Nullable Object nextLayoutData) {
        Intrinsics.checkNotNullParameter(currentMountable, (String)"currentMountable");
        Intrinsics.checkNotNullParameter(newMountable, (String)"newMountable");
        ImageMountable cfr_ignored_0 = (ImageMountable)currentMountable;
        ImageMountable cfr_ignored_1 = (ImageMountable)newMountable;
        return ((ImageMountable)newMountable).scaleType != ((ImageMountable)currentMountable).scaleType || !DrawableUtils.isEquivalentTo((Drawable)((ImageMountable)newMountable).drawable, (Drawable)((ImageMountable)currentMountable).drawable);
    }

    public int poolSize() {
        return 30;
    }
}

