/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.kotlin.widget;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import com.facebook.litho.SimpleMountable;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.widget.ProgressView;
import com.facebook.rendercore.MeasureResult;
import com.facebook.rendercore.RenderState;
import com.facebook.rendercore.RenderUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J.\u0010\u000b\u001a\u00020\f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016J8\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/litho/kotlin/widget/ProgressMountable;", "Lcom/facebook/litho/SimpleMountable;", "Lcom/facebook/litho/widget/ProgressView;", "color", "", "indeterminateDrawable", "Landroid/graphics/drawable/Drawable;", "(ILandroid/graphics/drawable/Drawable;)V", "createContent", "context", "Landroid/content/Context;", "measure", "Lcom/facebook/rendercore/MeasureResult;", "Lcom/facebook/rendercore/RenderState$LayoutContext;", "widthSpec", "heightSpec", "previousLayoutData", "", "mount", "", "c", "content", "layoutData", "shouldUpdate", "", "currentMountable", "newMountable", "currentLayoutData", "nextLayoutData", "unmount", "litho-widget-kotlin_release"})
public final class ProgressMountable
extends SimpleMountable<ProgressView> {
    private final int color;
    @Nullable
    private final Drawable indeterminateDrawable;

    public ProgressMountable(int color, @Nullable Drawable indeterminateDrawable) {
        super(RenderUnit.RenderType.VIEW);
        this.color = color;
        this.indeterminateDrawable = indeterminateDrawable;
    }

    @NotNull
    public ProgressView createContent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new ProgressView(context);
    }

    @NotNull
    protected MeasureResult measure(@NotNull RenderState.LayoutContext<?> context, int widthSpec, int heightSpec, @Nullable Object previousLayoutData) {
        MeasureResult measureResult;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (SizeSpec.getMode((int)widthSpec) == 0 && SizeSpec.getMode((int)heightSpec) == 0) {
            measureResult = new MeasureResult(50, 50);
        } else {
            MeasureResult measureResult2 = MeasureResult.withEqualDimensions((int)widthSpec, (int)heightSpec, null);
            measureResult = measureResult2;
            Intrinsics.checkNotNullExpressionValue((Object)measureResult2, (String)"{\n      MeasureResult.wi\u2026, heightSpec, null)\n    }");
        }
        return measureResult;
    }

    public void mount(@NotNull Context c, @NotNull ProgressView content, @Nullable Object layoutData) {
        block2: {
            Drawable it;
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Drawable drawable = this.indeterminateDrawable;
            if (drawable != null) {
                it = drawable;
                boolean bl = false;
                content.setIndeterminateDrawable(this.indeterminateDrawable);
            }
            Drawable drawable2 = content.getIndeterminateDrawable();
            if (drawable2 == null) break block2;
            it = drawable2;
            boolean bl = false;
            if (this.color != 0) {
                content.getIndeterminateDrawable().mutate().setColorFilter(this.color, PorterDuff.Mode.MULTIPLY);
            }
        }
    }

    public void unmount(@NotNull Context c, @NotNull ProgressView content, @Nullable Object layoutData) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.color != 0 && content.getIndeterminateDrawable() != null) {
            content.getIndeterminateDrawable().mutate().clearColorFilter();
        }
        content.setIndeterminateDrawable(null);
    }

    public boolean shouldUpdate(@NotNull SimpleMountable<ProgressView> currentMountable, @NotNull SimpleMountable<ProgressView> newMountable, @Nullable Object currentLayoutData, @Nullable Object nextLayoutData) {
        Intrinsics.checkNotNullParameter(currentMountable, (String)"currentMountable");
        Intrinsics.checkNotNullParameter(newMountable, (String)"newMountable");
        ProgressMountable cfr_ignored_0 = (ProgressMountable)currentMountable;
        ProgressMountable cfr_ignored_1 = (ProgressMountable)newMountable;
        return ((ProgressMountable)newMountable).color != ((ProgressMountable)currentMountable).color || !Intrinsics.areEqual((Object)((ProgressMountable)newMountable).indeterminateDrawable, (Object)((ProgressMountable)currentMountable).indeterminateDrawable);
    }
}

