/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardSpec;
import java.util.BitSet;

@Generated
public final class Card
extends SpecGeneratedComponent {
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int cardBackgroundColor = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    DynamicValue<Integer> cardBackgroundColorDv;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    String cardBackgroundTransitionKey;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int clippingColor = Integer.MIN_VALUE;
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=10)
    Component content;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float cornerRadius = -1.0f;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disableClipBottomLeft;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disableClipBottomRight;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disableClipTopLeft;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disableClipTopRight;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float elevation = -1.0f;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=3)
    int shadowBottomOverride = -1;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int shadowEndColor = 0x3000000;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowLeftOverride = -1.0f;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowRightOverride = -1.0f;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int shadowStartColor = 0x37000000;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=3)
    int shadowTopOverride = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean transparencyEnabled = false;

    private Card() {
        super("Card");
    }

    public Card makeShallowCopy() {
        Card component = (Card)super.makeShallowCopy();
        component.content = component.content != null ? component.content.makeShallowCopy() : null;
        return component;
    }

    protected Component onCreateLayout(ComponentContext c) {
        Component _result = CardSpec.onCreateLayout(c, this.content, this.cardBackgroundTransitionKey, this.cardBackgroundColor, this.cardBackgroundColorDv, this.clippingColor, this.shadowStartColor, this.shadowEndColor, this.cornerRadius, this.elevation, this.shadowTopOverride, this.shadowBottomOverride, this.shadowLeftOverride, this.shadowRightOverride, this.transparencyEnabled, this.disableClipTopLeft, this.disableClipTopRight, this.disableClipBottomLeft, this.disableClipBottomRight);
        return _result;
    }

    public static Builder create(ComponentContext context) {
        return Card.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Card instance = new Card();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        Card mCard;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"content"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, Card cardRef) {
            super(context, defStyleAttr, defStyleRes, (Component)cardRef);
            this.mCard = cardRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mCard = (Card)component;
        }

        @PropSetter(value="cardBackgroundColor", required=false)
        public Builder cardBackgroundColor(@ColorInt int cardBackgroundColor) {
            this.mCard.cardBackgroundColor = cardBackgroundColor;
            return this;
        }

        @PropSetter(value="cardBackgroundColor", required=false)
        public Builder cardBackgroundColorRes(@ColorRes int resId) {
            this.mCard.cardBackgroundColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="cardBackgroundColor", required=false)
        public Builder cardBackgroundColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCard.cardBackgroundColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="cardBackgroundColor", required=false)
        public Builder cardBackgroundColorAttr(@AttrRes int attrResId) {
            this.mCard.cardBackgroundColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="cardBackgroundColorDv", required=false)
        public Builder cardBackgroundColorDv(@Nullable DynamicValue<Integer> cardBackgroundColorDv) {
            this.mCard.cardBackgroundColorDv = cardBackgroundColorDv;
            return this;
        }

        @PropSetter(value="cardBackgroundTransitionKey", required=false)
        public Builder cardBackgroundTransitionKey(@Nullable String cardBackgroundTransitionKey) {
            this.mCard.cardBackgroundTransitionKey = cardBackgroundTransitionKey;
            return this;
        }

        @PropSetter(value="clippingColor", required=false)
        public Builder clippingColor(@ColorInt int clippingColor) {
            this.mCard.clippingColor = clippingColor;
            return this;
        }

        @PropSetter(value="clippingColor", required=false)
        public Builder clippingColorRes(@ColorRes int resId) {
            this.mCard.clippingColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="clippingColor", required=false)
        public Builder clippingColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCard.clippingColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="clippingColor", required=false)
        public Builder clippingColorAttr(@AttrRes int attrResId) {
            this.mCard.clippingColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="content", required=true)
        @RequiredProp(value="content")
        public Builder content(Component content) {
            this.mCard.content = content == null ? null : content.makeShallowCopy();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="content", required=true)
        @RequiredProp(value="content")
        public Builder content(Component.Builder<?> contentBuilder) {
            this.mCard.content = contentBuilder == null ? null : contentBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusPx(@Px float cornerRadius) {
            this.mCard.cornerRadius = cornerRadius;
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusDip(@Dimension(unit=0) float dip) {
            this.mCard.cornerRadius = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusSp(@Dimension(unit=2) float sip) {
            this.mCard.cornerRadius = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusRes(@DimenRes int resId) {
            this.mCard.cornerRadius = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCard.cornerRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCard.cornerRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="disableClipBottomLeft", required=false)
        public Builder disableClipBottomLeft(boolean disableClipBottomLeft) {
            this.mCard.disableClipBottomLeft = disableClipBottomLeft;
            return this;
        }

        @PropSetter(value="disableClipBottomRight", required=false)
        public Builder disableClipBottomRight(boolean disableClipBottomRight) {
            this.mCard.disableClipBottomRight = disableClipBottomRight;
            return this;
        }

        @PropSetter(value="disableClipTopLeft", required=false)
        public Builder disableClipTopLeft(boolean disableClipTopLeft) {
            this.mCard.disableClipTopLeft = disableClipTopLeft;
            return this;
        }

        @PropSetter(value="disableClipTopRight", required=false)
        public Builder disableClipTopRight(boolean disableClipTopRight) {
            this.mCard.disableClipTopRight = disableClipTopRight;
            return this;
        }

        @PropSetter(value="elevation", required=false)
        public Builder elevationPx(@Px float elevation) {
            this.mCard.elevation = elevation;
            return this;
        }

        @PropSetter(value="elevation", required=false)
        public Builder elevationDip(@Dimension(unit=0) float dip) {
            this.mCard.elevation = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="elevation", required=false)
        public Builder elevationSp(@Dimension(unit=2) float sip) {
            this.mCard.elevation = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="elevation", required=false)
        public Builder elevationRes(@DimenRes int resId) {
            this.mCard.elevation = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="elevation", required=false)
        public Builder elevationAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCard.elevation = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="elevation", required=false)
        public Builder elevationAttr(@AttrRes int attrResId) {
            this.mCard.elevation = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowBottomOverride", required=false)
        public Builder shadowBottomOverridePx(@Px int shadowBottomOverride) {
            this.mCard.shadowBottomOverride = shadowBottomOverride;
            return this;
        }

        @PropSetter(value="shadowBottomOverride", required=false)
        public Builder shadowBottomOverrideDip(@Dimension(unit=0) float dip) {
            this.mCard.shadowBottomOverride = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowBottomOverride", required=false)
        public Builder shadowBottomOverrideSp(@Dimension(unit=2) float sip) {
            this.mCard.shadowBottomOverride = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowBottomOverride", required=false)
        public Builder shadowBottomOverrideRes(@DimenRes int resId) {
            this.mCard.shadowBottomOverride = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowBottomOverride", required=false)
        public Builder shadowBottomOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCard.shadowBottomOverride = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowBottomOverride", required=false)
        public Builder shadowBottomOverrideAttr(@AttrRes int attrResId) {
            this.mCard.shadowBottomOverride = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowEndColor", required=false)
        public Builder shadowEndColor(@ColorInt int shadowEndColor) {
            this.mCard.shadowEndColor = shadowEndColor;
            return this;
        }

        @PropSetter(value="shadowEndColor", required=false)
        public Builder shadowEndColorRes(@ColorRes int resId) {
            this.mCard.shadowEndColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="shadowEndColor", required=false)
        public Builder shadowEndColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCard.shadowEndColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowEndColor", required=false)
        public Builder shadowEndColorAttr(@AttrRes int attrResId) {
            this.mCard.shadowEndColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowLeftOverride", required=false)
        public Builder shadowLeftOverridePx(@Px float shadowLeftOverride) {
            this.mCard.shadowLeftOverride = shadowLeftOverride;
            return this;
        }

        @PropSetter(value="shadowLeftOverride", required=false)
        public Builder shadowLeftOverrideDip(@Dimension(unit=0) float dip) {
            this.mCard.shadowLeftOverride = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowLeftOverride", required=false)
        public Builder shadowLeftOverrideSp(@Dimension(unit=2) float sip) {
            this.mCard.shadowLeftOverride = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowLeftOverride", required=false)
        public Builder shadowLeftOverrideRes(@DimenRes int resId) {
            this.mCard.shadowLeftOverride = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowLeftOverride", required=false)
        public Builder shadowLeftOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCard.shadowLeftOverride = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowLeftOverride", required=false)
        public Builder shadowLeftOverrideAttr(@AttrRes int attrResId) {
            this.mCard.shadowLeftOverride = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowRightOverride", required=false)
        public Builder shadowRightOverridePx(@Px float shadowRightOverride) {
            this.mCard.shadowRightOverride = shadowRightOverride;
            return this;
        }

        @PropSetter(value="shadowRightOverride", required=false)
        public Builder shadowRightOverrideDip(@Dimension(unit=0) float dip) {
            this.mCard.shadowRightOverride = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowRightOverride", required=false)
        public Builder shadowRightOverrideSp(@Dimension(unit=2) float sip) {
            this.mCard.shadowRightOverride = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowRightOverride", required=false)
        public Builder shadowRightOverrideRes(@DimenRes int resId) {
            this.mCard.shadowRightOverride = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowRightOverride", required=false)
        public Builder shadowRightOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCard.shadowRightOverride = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowRightOverride", required=false)
        public Builder shadowRightOverrideAttr(@AttrRes int attrResId) {
            this.mCard.shadowRightOverride = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowStartColor", required=false)
        public Builder shadowStartColor(@ColorInt int shadowStartColor) {
            this.mCard.shadowStartColor = shadowStartColor;
            return this;
        }

        @PropSetter(value="shadowStartColor", required=false)
        public Builder shadowStartColorRes(@ColorRes int resId) {
            this.mCard.shadowStartColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="shadowStartColor", required=false)
        public Builder shadowStartColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCard.shadowStartColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowStartColor", required=false)
        public Builder shadowStartColorAttr(@AttrRes int attrResId) {
            this.mCard.shadowStartColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowTopOverride", required=false)
        public Builder shadowTopOverridePx(@Px int shadowTopOverride) {
            this.mCard.shadowTopOverride = shadowTopOverride;
            return this;
        }

        @PropSetter(value="shadowTopOverride", required=false)
        public Builder shadowTopOverrideDip(@Dimension(unit=0) float dip) {
            this.mCard.shadowTopOverride = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowTopOverride", required=false)
        public Builder shadowTopOverrideSp(@Dimension(unit=2) float sip) {
            this.mCard.shadowTopOverride = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowTopOverride", required=false)
        public Builder shadowTopOverrideRes(@DimenRes int resId) {
            this.mCard.shadowTopOverride = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowTopOverride", required=false)
        public Builder shadowTopOverrideAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCard.shadowTopOverride = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowTopOverride", required=false)
        public Builder shadowTopOverrideAttr(@AttrRes int attrResId) {
            this.mCard.shadowTopOverride = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="transparencyEnabled", required=false)
        public Builder transparencyEnabled(boolean transparencyEnabled) {
            this.mCard.transparencyEnabled = transparencyEnabled;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Card build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mCard;
        }
    }
}

