/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.EmptyComponent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.RenderCompleteEvent;
import com.facebook.litho.widget.BaseRenderInfo;
import com.facebook.litho.widget.RenderInfo;

public class ComponentRenderInfo
extends BaseRenderInfo {
    public static final String LAYOUT_DIFFING_ENABLED = "layout_diffing_enabled";
    public static final String RECONCILIATION_ENABLED = "is_reconciliation_enabled";
    public static final String ERROR_EVENT_HANDLER = "error_event_handler";
    private final Component mComponent;
    @Nullable
    private final EventHandler<RenderCompleteEvent> mRenderCompleteEventHandler;
    @Nullable
    private final ComponentsLogger mComponentsLogger;
    @Nullable
    private final String mLogTag;

    public static Builder create() {
        return new Builder();
    }

    private ComponentRenderInfo(Builder builder) {
        super(builder);
        if (builder.mComponent == null) {
            throw new IllegalStateException("Component must be provided.");
        }
        this.mComponent = builder.mComponent;
        this.mRenderCompleteEventHandler = builder.mRenderCompleteEventEventHandler;
        this.mComponentsLogger = builder.mComponentsLogger;
        this.mLogTag = builder.mLogTag;
    }

    public static RenderInfo createEmpty() {
        return ComponentRenderInfo.create().component((Component)new EmptyComponent()).build();
    }

    @Override
    public Component getComponent() {
        return this.mComponent;
    }

    @Override
    @Nullable
    public EventHandler<RenderCompleteEvent> getRenderCompleteEventHandler() {
        return this.mRenderCompleteEventHandler;
    }

    @Override
    @Nullable
    public ComponentsLogger getComponentsLogger() {
        return this.mComponentsLogger;
    }

    @Override
    @Nullable
    public String getLogTag() {
        return this.mLogTag;
    }

    @Override
    public boolean rendersComponent() {
        return true;
    }

    @Override
    public String getName() {
        return this.mComponent.getSimpleName();
    }

    public static class Builder
    extends BaseRenderInfo.Builder<Builder> {
        private Component mComponent;
        private EventHandler<RenderCompleteEvent> mRenderCompleteEventEventHandler;
        @Nullable
        private ComponentsLogger mComponentsLogger;
        @Nullable
        private String mLogTag;

        public Builder component(Component component) {
            this.mComponent = component;
            return this;
        }

        public Builder renderCompleteHandler(EventHandler<RenderCompleteEvent> renderCompleteEventHandler) {
            this.mRenderCompleteEventEventHandler = renderCompleteEventHandler;
            return this;
        }

        public Builder component(Component.Builder builder) {
            return this.component(builder.build());
        }

        public Builder componentsLogger(@Nullable ComponentsLogger componentsLogger) {
            this.mComponentsLogger = componentsLogger;
            return this;
        }

        public Builder logTag(@Nullable String logTag) {
            this.mLogTag = logTag;
            return this;
        }

        public ComponentRenderInfo build() {
            return new ComponentRenderInfo(this);
        }
    }
}

