/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ErrorEventHandler;
import com.facebook.litho.LithoLifecycleListener;
import com.facebook.litho.LithoLifecycleProvider;
import com.facebook.litho.LithoLifecycleProviderDelegate;
import com.facebook.litho.Size;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TreeProps;
import com.facebook.litho.TreeState;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.widget.ComponentRenderInfo;
import com.facebook.litho.widget.RenderInfo;
import com.facebook.litho.widget.TreePropsWrappedRenderInfo;
import com.facebook.rendercore.RunnableHandler;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ComponentTreeHolder {
    private static final int UNINITIALIZED = -1;
    private static final AtomicInteger sIdGenerator = new AtomicInteger(1);
    private final boolean mCanInterruptAndMoveLayoutsBetweenThreads;
    private final boolean mIsReconciliationEnabled;
    private final boolean mIsLayoutDiffingEnabled;
    public static final String PREVENT_RELEASE_TAG = "prevent_release";
    public static final String ACQUIRE_STATE_HANDLER_ON_RELEASE = "acquire_state_handler";
    @Nullable
    private final LithoLifecycleProvider mParentLifecycle;
    @Nullable
    private ComponentTreeHolderLifecycleProvider mComponentTreeHolderLifecycleProvider;
    @Nullable
    private final ErrorEventHandler mErrorEventHandler;
    private final ComponentsConfiguration mComponentsConfiguration;
    static final int RENDER_UNINITIALIZED = 0;
    static final int RENDER_ADDED = 1;
    static final int RENDER_DRAWN = 2;
    @Nullable
    private final ComponentTreeMeasureListenerFactory mComponentTreeMeasureListenerFactory;
    private final AtomicInteger mRenderState = new AtomicInteger(0);
    private final int mId;
    private final RunnableHandler mPreallocateMountContentHandler;
    private final boolean mShouldPreallocatePerMountSpec;
    private final boolean mIncrementalMount;
    private final boolean mVisibilityProcessingEnabled;
    @GuardedBy(value="this")
    private boolean mIsTreeValid;
    @Nullable
    @GuardedBy(value="this")
    private RunnableHandler mLayoutHandler;
    @GuardedBy(value="this")
    private boolean mIsInserted = true;
    @GuardedBy(value="this")
    private boolean mHasMounted = false;
    @GuardedBy(value="this")
    private int mLastMeasuredHeight;
    @Nullable
    @GuardedBy(value="this")
    private ComponentTree mComponentTree;
    @GuardedBy(value="this")
    private TreeState mTreeState;
    @GuardedBy(value="this")
    private RenderInfo mRenderInfo;
    @Nullable
    @GuardedBy(value="this")
    private ComponentTree.NewLayoutStateReadyListener mPendingNewLayoutListener;
    @GuardedBy(value="this")
    private int mLastRequestedWidthSpec = -1;
    @GuardedBy(value="this")
    private int mLastRequestedHeightSpec = -1;

    public static Builder create() {
        return new Builder();
    }

    @VisibleForTesting
    ComponentTreeHolder(Builder builder) {
        this.mRenderInfo = builder.renderInfo;
        this.mLayoutHandler = builder.layoutHandler;
        this.mPreallocateMountContentHandler = builder.preallocateMountContentHandler;
        this.mShouldPreallocatePerMountSpec = builder.shouldPreallocatePerMountSpec;
        this.mComponentTreeMeasureListenerFactory = builder.componentTreeMeasureListenerFactory;
        this.mCanInterruptAndMoveLayoutsBetweenThreads = builder.canInterruptAndMoveLayoutsBetweenThreads;
        this.mId = sIdGenerator.getAndIncrement();
        this.mIncrementalMount = builder.incrementalMount;
        this.mVisibilityProcessingEnabled = builder.visibilityProcessingEnabled;
        this.mIsReconciliationEnabled = builder.isReconciliationEnabled;
        this.mIsLayoutDiffingEnabled = builder.isLayoutDiffingEnabled;
        this.mParentLifecycle = builder.parentLifecycle;
        this.mErrorEventHandler = builder.errorEventHandler;
        this.mComponentsConfiguration = builder.componentsConfiguration;
    }

    @VisibleForTesting
    @UiThread
    public synchronized void acquireStateAndReleaseTree(boolean acquireTreeStateOnRelease) {
        if (acquireTreeStateOnRelease || this.shouldAcquireTreeStateOnRelease()) {
            this.acquireTreeState();
        }
        this.acquireAnimationState();
        this.releaseTree();
    }

    synchronized void invalidateTree() {
        this.mIsTreeValid = false;
    }

    synchronized void setNewLayoutReadyListener(@Nullable ComponentTree.NewLayoutStateReadyListener listener) {
        if (this.mComponentTree != null) {
            this.mComponentTree.setNewLayoutStateReadyListener(listener);
        } else {
            this.mPendingNewLayoutListener = listener;
        }
    }

    int getId() {
        return this.mId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeLayoutSync(ComponentContext context, int widthSpec, int heightSpec, Size size) {
        TreeProps treeProps;
        Component component;
        ComponentTree componentTree;
        ComponentTreeHolder componentTreeHolder = this;
        synchronized (componentTreeHolder) {
            if (this.mRenderInfo.rendersView()) {
                return;
            }
            this.mLastRequestedWidthSpec = widthSpec;
            this.mLastRequestedHeightSpec = heightSpec;
            this.ensureComponentTree(context);
            componentTree = this.mComponentTree;
            component = this.mRenderInfo.getComponent();
            treeProps = this.mRenderInfo instanceof TreePropsWrappedRenderInfo ? ((TreePropsWrappedRenderInfo)this.mRenderInfo).getTreeProps() : null;
        }
        componentTree.setRootAndSizeSpecSync(component, widthSpec, heightSpec, size, treeProps);
        componentTreeHolder = this;
        synchronized (componentTreeHolder) {
            if (componentTree == this.mComponentTree && component == this.mRenderInfo.getComponent()) {
                this.mIsTreeValid = true;
                if (size != null) {
                    this.mLastMeasuredHeight = size.height;
                }
            }
        }
    }

    public void computeLayoutAsync(ComponentContext context, int widthSpec, int heightSpec) {
        this.computeLayoutAsync(context, widthSpec, heightSpec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeLayoutAsync(ComponentContext context, int widthSpec, int heightSpec, @Nullable ComponentTree.MeasureListener measureListener) {
        TreeProps treeProps;
        Component component;
        ComponentTree componentTree;
        ComponentTreeHolder componentTreeHolder = this;
        synchronized (componentTreeHolder) {
            if (this.mRenderInfo.rendersView()) {
                return;
            }
            this.mLastRequestedWidthSpec = widthSpec;
            this.mLastRequestedHeightSpec = heightSpec;
            this.ensureComponentTree(context);
            componentTree = this.mComponentTree;
            component = this.mRenderInfo.getComponent();
            treeProps = this.mRenderInfo instanceof TreePropsWrappedRenderInfo ? ((TreePropsWrappedRenderInfo)this.mRenderInfo).getTreeProps() : null;
        }
        if (measureListener != null) {
            componentTree.addMeasureListener(measureListener);
        }
        componentTree.setRootAndSizeSpecAsync(component, widthSpec, heightSpec, treeProps);
        componentTreeHolder = this;
        synchronized (componentTreeHolder) {
            if (this.mComponentTree == componentTree && component == this.mRenderInfo.getComponent()) {
                this.mIsTreeValid = true;
            }
        }
    }

    public synchronized void addMeasureListener(@Nullable ComponentTree.MeasureListener measureListener) {
        if (this.mComponentTree != null) {
            this.mComponentTree.addMeasureListener(measureListener);
        }
    }

    public synchronized void clearMeasureListener(@Nullable ComponentTree.MeasureListener measureListener) {
        if (this.mComponentTree != null) {
            this.mComponentTree.clearMeasureListener(measureListener);
        }
    }

    public synchronized RenderInfo getRenderInfo() {
        return this.mRenderInfo;
    }

    public synchronized boolean isTreeValid() {
        return this.mIsTreeValid;
    }

    public synchronized boolean isTreeValidForSizeSpecs(int widthSpec, int heightSpec) {
        return this.isTreeValid() && this.mLastRequestedWidthSpec == widthSpec && this.mLastRequestedHeightSpec == heightSpec;
    }

    @Nullable
    public synchronized ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    @Nullable
    @VisibleForTesting
    TreeState getTreeState() {
        return this.mTreeState;
    }

    public synchronized void setRenderInfo(RenderInfo renderInfo) {
        this.invalidateTree();
        this.mRenderInfo = renderInfo;
    }

    public synchronized void updateLayoutHandler(@Nullable RunnableHandler layoutHandler) {
        this.mLayoutHandler = layoutHandler;
        if (this.mComponentTree != null) {
            this.mComponentTree.updateLayoutThreadHandler(layoutHandler);
        }
    }

    synchronized int getMeasuredHeight() {
        return this.mLastMeasuredHeight;
    }

    synchronized void setMeasuredHeight(int height) {
        this.mLastMeasuredHeight = height;
    }

    synchronized void checkWorkingRangeAndDispatch(int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        if (this.mComponentTree != null) {
            this.mComponentTree.checkWorkingRangeAndDispatch(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex);
        }
    }

    int getRenderState() {
        return this.mRenderState.get();
    }

    void setRenderState(@RenderState int renderState) {
        this.mRenderState.set(renderState);
    }

    public synchronized boolean hasCompletedLatestLayout() {
        return this.mRenderInfo.rendersView() || this.mComponentTree != null && this.mComponentTree.hasCompatibleLayout(this.mLastRequestedWidthSpec, this.mLastRequestedHeightSpec);
    }

    public synchronized boolean isInserted() {
        return this.mIsInserted;
    }

    public synchronized void setInserted(boolean inserted) {
        this.mIsInserted = inserted;
    }

    @GuardedBy(value="this")
    private void ensureComponentTree(ComponentContext context) {
        if (this.mComponentTree == null) {
            if (this.mParentLifecycle != null) {
                this.mComponentTreeHolderLifecycleProvider = new ComponentTreeHolderLifecycleProvider();
            }
            ComponentTree.Builder builder = ComponentTree.create((ComponentContext)context, (Component)this.mRenderInfo.getComponent(), (LithoLifecycleProvider)this.mComponentTreeHolderLifecycleProvider);
            this.applyCustomAttributesIfProvided(builder);
            builder.layoutThreadHandler(this.mLayoutHandler).treeState(this.mTreeState).preAllocateMountContentHandler(this.mPreallocateMountContentHandler).shouldPreallocateMountContentPerMountSpec(this.mShouldPreallocatePerMountSpec).measureListener(this.mComponentTreeMeasureListenerFactory == null ? null : this.mComponentTreeMeasureListenerFactory.create(this)).hasMounted(this.mHasMounted).incrementalMount(this.mIncrementalMount).visibilityProcessing(this.mVisibilityProcessingEnabled).canInterruptAndMoveLayoutsBetweenThreads(this.mCanInterruptAndMoveLayoutsBetweenThreads).logger(this.mRenderInfo.getComponentsLogger(), this.mRenderInfo.getLogTag()).componentsConfiguration(this.mComponentsConfiguration).build();
            this.mComponentTree = builder.build();
            if (this.mPendingNewLayoutListener != null) {
                this.mComponentTree.setNewLayoutStateReadyListener(this.mPendingNewLayoutListener);
            }
        }
    }

    private void applyCustomAttributesIfProvided(ComponentTree.Builder builder) {
        Object isReconciliationEnabledAttr = this.mRenderInfo.getCustomAttribute("is_reconciliation_enabled");
        Object layoutDiffingEnabledAttr = this.mRenderInfo.getCustomAttribute("layout_diffing_enabled");
        Object errorEventHandlerAttr = this.mRenderInfo.getCustomAttribute("error_event_handler");
        if (isReconciliationEnabledAttr != null) {
            builder.isReconciliationEnabled(((Boolean)isReconciliationEnabledAttr).booleanValue());
        } else {
            builder.isReconciliationEnabled(this.mIsReconciliationEnabled);
        }
        if (layoutDiffingEnabledAttr != null) {
            builder.layoutDiffing(((Boolean)layoutDiffingEnabledAttr).booleanValue());
        } else {
            builder.layoutDiffing(this.mIsLayoutDiffingEnabled);
        }
        if (errorEventHandlerAttr instanceof ErrorEventHandler) {
            builder.errorHandler((ErrorEventHandler)errorEventHandlerAttr);
        } else if (this.mErrorEventHandler != null) {
            builder.errorHandler(this.mErrorEventHandler);
        }
    }

    @UiThread
    public synchronized void releaseTree() {
        if (this.mComponentTree != null) {
            if (this.mComponentTreeHolderLifecycleProvider != null) {
                this.mComponentTreeHolderLifecycleProvider.moveToLifecycle(LithoLifecycleProvider.LithoLifecycle.DESTROYED);
                return;
            }
            this.mComponentTree.release();
            this.mComponentTree = null;
        }
        this.mIsTreeValid = false;
    }

    boolean shouldPreventRelease() {
        Object preventRelease = this.mRenderInfo.getCustomAttribute(PREVENT_RELEASE_TAG);
        if (preventRelease instanceof Boolean) {
            return (Boolean)preventRelease;
        }
        return false;
    }

    private boolean shouldAcquireTreeStateOnRelease() {
        Object acquireTreeState = this.mRenderInfo.getCustomAttribute(ACQUIRE_STATE_HANDLER_ON_RELEASE);
        if (acquireTreeState instanceof Boolean) {
            return (Boolean)acquireTreeState;
        }
        return false;
    }

    @GuardedBy(value="this")
    private void acquireTreeState() {
        if (this.mComponentTree == null) {
            return;
        }
        this.mTreeState = this.mComponentTree.acquireTreeState();
    }

    @GuardedBy(value="this")
    private void acquireAnimationState() {
        if (this.mComponentTree == null) {
            return;
        }
        this.mHasMounted = this.mComponentTree.hasMounted();
    }

    private class ComponentTreeHolderLifecycleProvider
    implements LithoLifecycleProvider,
    LithoLifecycleListener {
        public LithoLifecycleProviderDelegate mLithoLifecycleProviderDelegate;

        public ComponentTreeHolderLifecycleProvider() {
            ComponentTreeHolder.this.mParentLifecycle.addListener((LithoLifecycleListener)this);
            this.mLithoLifecycleProviderDelegate = new LithoLifecycleProviderDelegate();
        }

        public LithoLifecycleProvider.LithoLifecycle getLifecycleStatus() {
            return this.mLithoLifecycleProviderDelegate.getLifecycleStatus();
        }

        public void onMovedToState(LithoLifecycleProvider.LithoLifecycle state) {
            switch (state) {
                case HINT_VISIBLE: {
                    this.moveToLifecycle(LithoLifecycleProvider.LithoLifecycle.HINT_VISIBLE);
                    return;
                }
                case HINT_INVISIBLE: {
                    this.moveToLifecycle(LithoLifecycleProvider.LithoLifecycle.HINT_INVISIBLE);
                    return;
                }
                case DESTROYED: {
                    this.moveToLifecycle(LithoLifecycleProvider.LithoLifecycle.DESTROYED);
                    return;
                }
            }
            throw new IllegalStateException("Illegal state: " + state);
        }

        @UiThread
        public void moveToLifecycle(LithoLifecycleProvider.LithoLifecycle lithoLifecycle) {
            ThreadUtils.assertMainThread();
            this.mLithoLifecycleProviderDelegate.moveToLifecycle(lithoLifecycle);
            if (lithoLifecycle == LithoLifecycleProvider.LithoLifecycle.DESTROYED) {
                ComponentTreeHolder.this.mParentLifecycle.removeListener((LithoLifecycleListener)this);
                ComponentTreeHolder.this.mComponentTree = null;
                ComponentTreeHolder.this.mIsTreeValid = false;
            }
        }

        public synchronized void addListener(LithoLifecycleListener listener) {
            this.mLithoLifecycleProviderDelegate.addListener(listener);
        }

        public synchronized void removeListener(LithoLifecycleListener listener) {
            this.mLithoLifecycleProviderDelegate.removeListener(listener);
        }
    }

    public static class Builder {
        private RenderInfo renderInfo;
        private ComponentsConfiguration componentsConfiguration = ComponentsConfiguration.getDefaultComponentsConfiguration();
        private RunnableHandler layoutHandler;
        private ComponentTreeMeasureListenerFactory componentTreeMeasureListenerFactory;
        @Nullable
        private RunnableHandler preallocateMountContentHandler;
        private boolean shouldPreallocatePerMountSpec;
        private boolean incrementalMount = true;
        private boolean canInterruptAndMoveLayoutsBetweenThreads;
        private boolean isReconciliationEnabled = ComponentsConfiguration.isReconciliationEnabled;
        private boolean isLayoutDiffingEnabled = ComponentsConfiguration.isLayoutDiffingEnabled;
        private int recyclingMode;
        private boolean visibilityProcessingEnabled = true;
        @Nullable
        private LithoLifecycleProvider parentLifecycle;
        @Nullable
        private ErrorEventHandler errorEventHandler;

        private Builder() {
        }

        public Builder renderInfo(RenderInfo renderInfo) {
            this.renderInfo = renderInfo == null ? ComponentRenderInfo.createEmpty() : renderInfo;
            return this;
        }

        public Builder componentsConfiguration(ComponentsConfiguration componentsConfiguration) {
            this.componentsConfiguration = componentsConfiguration;
            return this;
        }

        public Builder layoutHandler(@Nullable RunnableHandler layoutHandler) {
            this.layoutHandler = layoutHandler;
            return this;
        }

        public Builder componentTreeMeasureListenerFactory(@Nullable ComponentTreeMeasureListenerFactory componentTreeMeasureListenerFactory) {
            this.componentTreeMeasureListenerFactory = componentTreeMeasureListenerFactory;
            return this;
        }

        public Builder preallocateMountContentHandler(@Nullable RunnableHandler preallocateMountContentHandler) {
            this.preallocateMountContentHandler = preallocateMountContentHandler;
            return this;
        }

        public Builder shouldPreallocatePerMountSpec(boolean shouldPreallocatePerMountSpec) {
            this.shouldPreallocatePerMountSpec = shouldPreallocatePerMountSpec;
            return this;
        }

        public Builder incrementalMount(boolean incrementalMount) {
            this.incrementalMount = incrementalMount;
            return this;
        }

        public Builder visibilityProcessingEnabled(boolean visibilityProcessingEnabled) {
            this.visibilityProcessingEnabled = visibilityProcessingEnabled;
            return this;
        }

        public Builder canInterruptAndMoveLayoutsBetweenThreads(boolean isEnabled) {
            this.canInterruptAndMoveLayoutsBetweenThreads = isEnabled;
            return this;
        }

        public Builder isReconciliationEnabled(boolean isEnabled) {
            this.isReconciliationEnabled = isEnabled;
            return this;
        }

        public Builder recyclingMode(int recyclingMode) {
            this.recyclingMode = recyclingMode;
            return this;
        }

        public Builder isLayoutDiffingEnabled(boolean isEnabled) {
            this.isLayoutDiffingEnabled = isEnabled;
            return this;
        }

        public Builder parentLifecycleProvider(LithoLifecycleProvider parentLifecycle) {
            this.parentLifecycle = parentLifecycle;
            return this;
        }

        public Builder errorEventHandler(ErrorEventHandler errorEventHandler) {
            this.errorEventHandler = errorEventHandler;
            return this;
        }

        public ComponentTreeHolder build() {
            this.ensureMandatoryParams();
            return new ComponentTreeHolder(this);
        }

        private void ensureMandatoryParams() {
            if (this.renderInfo == null) {
                throw new IllegalArgumentException("A RenderInfo must be specified to create a ComponentTreeHolder");
            }
        }
    }

    static interface ComponentTreeMeasureListenerFactory {
        @Nullable
        public ComponentTree.MeasureListener create(ComponentTreeHolder var1);
    }

    public static @interface RenderState {
    }
}

