/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LruCache;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.Size;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.widget.ComponentRenderInfo;
import com.facebook.litho.widget.ComponentTreeHolder;
import com.facebook.litho.widget.RecyclerBinder;
import com.facebook.rendercore.RunnableHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;

public class ComponentWarmer {
    public static final String COMPONENT_WARMER_TAG = "component_warmer_tag";
    public static final String COMPONENT_WARMER_PREPARE_HANDLER = "component_warmer_prepare_handler";
    public static final int DEFAULT_MAX_SIZE = 10;
    private static final String COMPONENT_WARMER_LOG_TAG = "ComponentWarmer";
    private Cache mCache;
    @Nullable
    private ComponentTreeHolderPreparer mFactory;
    private boolean mIsReady;
    @Nullable
    private ComponentWarmerReadyListener mReadyListener;
    private BlockingQueue<ComponentRenderInfo> mPendingRenderInfos;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private volatile boolean mReleaseEvictedEntries;

    public ComponentWarmer(ComponentContext c, int widthSpec, int heightSpec) {
        this.init(new ComponentTreeHolderPreparerWithSizeImpl(c, widthSpec, heightSpec), null);
    }

    public ComponentWarmer() {
        this.init(null, null);
    }

    public ComponentWarmer(Cache cache) {
        this.init(null, cache);
    }

    public ComponentWarmer(RecyclerBinder recyclerBinder) {
        this(recyclerBinder, null);
    }

    public ComponentWarmer(RecyclerBinder recyclerBinder, @Nullable Cache cache) {
        this(recyclerBinder.getComponentTreeHolderPreparer(), cache);
        recyclerBinder.setComponentWarmer(this);
    }

    public ComponentWarmer(ComponentTreeHolderPreparer factory) {
        this(factory, null);
    }

    public ComponentWarmer(ComponentTreeHolderPreparer factory, @Nullable Cache cache) {
        if (factory == null) {
            throw new NullPointerException("factory == null");
        }
        this.init(factory, cache);
    }

    public void setComponentWarmerReadyListener(ComponentWarmerReadyListener listener) {
        this.mReadyListener = listener;
    }

    public void setReleaseEvictedEntries(boolean releaseEvictedEntries) {
        this.mReleaseEvictedEntries = releaseEvictedEntries;
    }

    public synchronized boolean isReady() {
        return this.mIsReady;
    }

    private void init(@Nullable ComponentTreeHolderPreparer factory, @Nullable Cache cache) {
        CacheListener cacheListener = new CacheListener(){

            @Override
            public void onEntryEvicted(String tag, final ComponentTreeHolder holder) {
                if (ComponentWarmer.this.mReleaseEvictedEntries) {
                    if (ThreadUtils.isMainThread()) {
                        holder.releaseTree();
                    } else {
                        ComponentWarmer.this.mMainThreadHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                holder.releaseTree();
                            }
                        });
                    }
                }
            }
        };
        if (cache != null) {
            this.mCache = cache;
            this.mCache.setCacheListener(cacheListener);
        } else {
            this.mCache = new DefaultCache(10, cacheListener);
        }
        if (factory != null) {
            this.mIsReady = true;
            this.setComponentTreeHolderFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setComponentTreeHolderFactory(ComponentTreeHolderPreparer factory) {
        if (factory == null) {
            throw new NullPointerException("factory == null");
        }
        this.mFactory = factory;
        if (!this.isReady()) {
            if (this.mReadyListener != null) {
                this.mReadyListener.onInstanceReadyToPrepare();
            }
            this.executePending();
            ComponentWarmer componentWarmer = this;
            synchronized (componentWarmer) {
                this.mIsReady = true;
            }
        }
    }

    public void prepare(String tag, ComponentRenderInfo componentRenderInfo, @Nullable Size size, RunnableHandler handler) {
        if (!this.isReady()) {
            ComponentsReporter.emitMessage((ComponentsReporter.LogLevel)ComponentsReporter.LogLevel.WARNING, (String)COMPONENT_WARMER_LOG_TAG, (String)"ComponentWarmer not ready: unable to prepare sync. This will be executed asynchronously when the ComponentWarmer is ready.");
            this.addToPending(tag, componentRenderInfo, handler);
            return;
        }
        this.executePrepare(tag, componentRenderInfo, size, false, handler);
    }

    public void prepare(String tag, ComponentRenderInfo componentRenderInfo, @Nullable Size size) {
        this.prepare(tag, componentRenderInfo, size, null);
    }

    public void prepareAsync(String tag, ComponentRenderInfo componentRenderInfo) {
        if (!this.isReady()) {
            this.addToPending(tag, componentRenderInfo, null);
            return;
        }
        this.executePrepare(tag, componentRenderInfo, null, true, null);
    }

    private void executePrepare(String tag, ComponentRenderInfo renderInfo, final @Nullable Size size, boolean isAsync, @Nullable RunnableHandler handler) {
        if (this.mFactory == null) {
            throw new IllegalStateException("ComponentWarmer: trying to execute prepare but ComponentWarmer is not ready.");
        }
        renderInfo.addCustomAttribute(COMPONENT_WARMER_TAG, tag);
        final ComponentTreeHolder holder = this.mFactory.create(renderInfo);
        this.mCache.put(tag, holder);
        if (isAsync) {
            this.mFactory.prepareAsync(holder);
        } else if (handler != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ComponentWarmer.this.mFactory.prepareSync(holder, size);
                }
            }, "prepare");
        } else {
            this.mFactory.prepareSync(holder, size);
        }
    }

    private void addToPending(String tag, ComponentRenderInfo componentRenderInfo, @Nullable RunnableHandler handler) {
        this.ensurePendingQueue();
        componentRenderInfo.addCustomAttribute(COMPONENT_WARMER_TAG, tag);
        if (handler != null) {
            componentRenderInfo.addCustomAttribute(COMPONENT_WARMER_PREPARE_HANDLER, handler);
        }
        this.mPendingRenderInfos.offer(componentRenderInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePending() {
        ComponentWarmer componentWarmer = this;
        synchronized (componentWarmer) {
            if (this.mPendingRenderInfos == null) {
                this.mIsReady = true;
                return;
            }
        }
        while (!this.mPendingRenderInfos.isEmpty()) {
            ComponentRenderInfo renderInfo = (ComponentRenderInfo)this.mPendingRenderInfos.poll();
            Object customAttrTag = renderInfo.getCustomAttribute(COMPONENT_WARMER_TAG);
            if (customAttrTag == null) continue;
            String tag = (String)customAttrTag;
            if (renderInfo.getCustomAttribute(COMPONENT_WARMER_PREPARE_HANDLER) != null) {
                RunnableHandler handler = (RunnableHandler)renderInfo.getCustomAttribute(COMPONENT_WARMER_PREPARE_HANDLER);
                this.executePrepare(tag, renderInfo, null, false, handler);
            } else {
                this.executePrepare(tag, renderInfo, null, true, null);
            }
            ComponentWarmer componentWarmer2 = this;
            synchronized (componentWarmer2) {
                if (this.mPendingRenderInfos.isEmpty()) {
                    this.mIsReady = true;
                }
            }
        }
    }

    public void evictAll() {
        this.mCache.evictAll();
    }

    public void remove(String tag) {
        this.mCache.remove(tag);
    }

    @Nullable
    public ComponentTreeHolder consume(String tag) {
        return this.mCache.remove(tag);
    }

    public void cancelPrepare(String tag) {
        ComponentTreeHolder holder = this.mCache.remove(tag);
        if (holder == null || holder.getComponentTree() == null) {
            return;
        }
        holder.getComponentTree().cancelLayoutAndReleaseTree();
    }

    @Nullable
    @VisibleForTesting
    ComponentTreeHolderPreparer getFactory() {
        return this.mFactory;
    }

    private synchronized void ensurePendingQueue() {
        if (this.mPendingRenderInfos == null) {
            this.mPendingRenderInfos = new LinkedBlockingQueue<ComponentRenderInfo>(10);
        }
    }

    @VisibleForTesting
    BlockingQueue<ComponentRenderInfo> getPending() {
        return this.mPendingRenderInfos;
    }

    @VisibleForTesting
    Cache getCache() {
        return this.mCache;
    }

    @VisibleForTesting
    ComponentTreeHolderPreparer getPrepareImpl() {
        return this.mFactory;
    }

    private static class DefaultCache
    implements Cache {
        private final LruCache<String, ComponentTreeHolder> mCache;
        private final CacheListener mCacheListener;

        DefaultCache(int maxSize, CacheListener cacheListener) {
            this.mCacheListener = cacheListener;
            this.mCache = new LruCache<String, ComponentTreeHolder>(maxSize){

                protected void entryRemoved(boolean evicted, @NonNull String key, @NonNull ComponentTreeHolder oldValue, @Nullable ComponentTreeHolder newValue) {
                    if (evicted && mCacheListener != null) {
                        mCacheListener.onEntryEvicted(key, oldValue);
                    }
                }
            };
        }

        @Override
        @Nullable
        public ComponentTreeHolder remove(String tag) {
            return (ComponentTreeHolder)this.mCache.remove((Object)tag);
        }

        @Override
        public void put(String tag, ComponentTreeHolder holder) {
            this.mCache.put((Object)tag, (Object)holder);
        }

        @Override
        @Nullable
        public ComponentTreeHolder get(String tag) {
            return (ComponentTreeHolder)this.mCache.get((Object)tag);
        }

        @Override
        public void evictAll() {
            this.mCache.evictAll();
        }

        @Override
        public void setCacheListener(CacheListener cacheListener) {
        }
    }

    public static interface Cache {
        @Nullable
        public ComponentTreeHolder remove(String var1);

        public void put(String var1, ComponentTreeHolder var2);

        @Nullable
        public ComponentTreeHolder get(String var1);

        public void evictAll();

        public void setCacheListener(CacheListener var1);
    }

    public static interface CacheListener {
        public void onEntryEvicted(String var1, ComponentTreeHolder var2);
    }

    public static interface ComponentWarmerReadyListener {
        public void onInstanceReadyToPrepare();
    }

    public class ComponentTreeHolderPreparerWithSizeImpl
    implements ComponentTreeHolderPreparer {
        private final int mHeightSpec;
        private final int mWidthSpec;
        private final ComponentContext mComponentContext;

        public ComponentTreeHolderPreparerWithSizeImpl(ComponentContext c, int widthSpec, int heightSpec) {
            this.mWidthSpec = widthSpec;
            this.mHeightSpec = heightSpec;
            this.mComponentContext = c;
        }

        @Override
        public ComponentTreeHolder create(ComponentRenderInfo renderInfo) {
            return ComponentTreeHolder.create().renderInfo(renderInfo).build();
        }

        @Override
        public void prepareSync(ComponentTreeHolder holder, @Nullable Size size) {
            holder.computeLayoutSync(this.mComponentContext, this.mWidthSpec, this.mHeightSpec, size);
        }

        @Override
        public void prepareAsync(ComponentTreeHolder holder) {
            holder.computeLayoutAsync(this.mComponentContext, this.mWidthSpec, this.mHeightSpec);
        }
    }

    public static interface ComponentTreeHolderPreparer {
        public ComponentTreeHolder create(ComponentRenderInfo var1);

        public void prepareSync(ComponentTreeHolder var1, @Nullable Size var2);

        public void prepareAsync(ComponentTreeHolder var1);
    }
}

