/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.text.InputFilter;
import android.text.Layout;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.EventTriggerTarget;
import com.facebook.litho.EventTriggersContainer;
import com.facebook.litho.Handle;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.ClearFocusEvent;
import com.facebook.litho.widget.EditTextSpec;
import com.facebook.litho.widget.EditTextStateUpdatePolicy;
import com.facebook.litho.widget.KeyUpEvent;
import com.facebook.litho.widget.RequestFocusEvent;
import com.facebook.litho.widget.SelectionChangedEvent;
import com.facebook.litho.widget.SetTextEvent;
import com.facebook.litho.widget.TextChangedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
@Generated
public final class EditText
extends SpecGeneratedComponent {
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int cursorDrawableRes = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean editable = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    TextView.OnEditorActionListener editorActionListener;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    TextUtils.TruncateAt ellipsize;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float extraSpacing;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int gravity = 8388627;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int highlightColor;
    @Prop(resType=ResType.STRING, optional=true)
    @Comparable(type=13)
    CharSequence hint;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int hintColor = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ColorStateList hintColorStateList = EditTextSpec.hintColorStateList;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int imeOptions = 0;
    @Prop(resType=ResType.STRING, optional=true)
    @Comparable(type=13)
    CharSequence initialText;
    @Prop(resType=ResType.NONE, optional=true, varArg="inputFilter")
    @Comparable(type=5)
    List<InputFilter> inputFilters = Collections.emptyList();
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int inputType = 131073;
    @Prop(resType=ResType.BOOL, optional=true)
    @Comparable(type=3)
    boolean isSingleLine;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean isSingleLineWrap = false;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int linkColor = 0;
    @Prop(resType=ResType.INT, optional=true)
    @Comparable(type=3)
    int maxLength = Integer.MAX_VALUE;
    @Prop(resType=ResType.INT, optional=true)
    @Comparable(type=3)
    int maxLines = Integer.MAX_VALUE;
    @Prop(resType=ResType.INT, optional=true)
    @Comparable(type=3)
    int minLines = Integer.MIN_VALUE;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int rawInputType = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean requestFocus = false;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int selection = -1;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int shadowColor = -7829368;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowDx;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowDy;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowRadius;
    @Prop(resType=ResType.FLOAT, optional=true)
    @Comparable(type=0)
    float spacingMultiplier = 1.0f;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    EditTextStateUpdatePolicy stateUpdatePolicy = EditTextSpec.stateUpdatePolicy;
    @Prop(resType=ResType.STRING, optional=true)
    @Comparable(type=13)
    CharSequence text;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    Layout.Alignment textAlignment = EditTextSpec.textAlignment;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int textColor = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ColorStateList textColorStateList = EditTextSpec.textColorStateList;
    @Prop(resType=ResType.DIMEN_TEXT, optional=true)
    @Comparable(type=3)
    int textSize = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int textStyle = EditTextSpec.textStyle;
    @Prop(resType=ResType.NONE, optional=true, varArg="textWatcher")
    @Comparable(type=5)
    List<TextWatcher> textWatchers = Collections.emptyList();
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ColorStateList tintColorStateList;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    Typeface typeface = EditTextSpec.typeface;
    @Nullable
    EventHandler<TextChangedEvent> textChangedEventHandler;
    @Nullable
    EventHandler<SelectionChangedEvent> selectionChangedEventHandler;
    @Nullable
    EventHandler<KeyUpEvent> keyUpEventHandler;
    @Nullable
    EventHandler<SetTextEvent> setTextEventHandler;
    EventTrigger requestFocusTrigger;
    EventTrigger clearFocusTrigger;
    EventTrigger setTextTrigger;

    private EditText() {
        super("EditText");
    }

    private EditTextStateContainer getStateContainerImpl(ComponentContext c) {
        return (EditTextStateContainer)c.getScopedComponentInfo().getStateContainer();
    }

    protected EditTextStateContainer createStateContainer() {
        return new EditTextStateContainer();
    }

    public boolean isEquivalentProps(Component other, boolean shouldCompareCommonProps) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        EditText editTextRef = (EditText)other;
        if (this.cursorDrawableRes != editTextRef.cursorDrawableRes) {
            return false;
        }
        if (this.editable != editTextRef.editable) {
            return false;
        }
        if (this.editorActionListener != null ? !this.editorActionListener.equals(editTextRef.editorActionListener) : editTextRef.editorActionListener != null) {
            return false;
        }
        if (this.ellipsize != null ? !this.ellipsize.equals((Object)editTextRef.ellipsize) : editTextRef.ellipsize != null) {
            return false;
        }
        if (Float.compare(this.extraSpacing, editTextRef.extraSpacing) != 0) {
            return false;
        }
        if (this.gravity != editTextRef.gravity) {
            return false;
        }
        if (this.highlightColor != editTextRef.highlightColor) {
            return false;
        }
        if (this.hint != null ? !this.hint.equals(editTextRef.hint) : editTextRef.hint != null) {
            return false;
        }
        if (this.hintColor != editTextRef.hintColor) {
            return false;
        }
        if (this.hintColorStateList != null ? !this.hintColorStateList.equals(editTextRef.hintColorStateList) : editTextRef.hintColorStateList != null) {
            return false;
        }
        if (this.imeOptions != editTextRef.imeOptions) {
            return false;
        }
        if (this.initialText != null ? !this.initialText.equals(editTextRef.initialText) : editTextRef.initialText != null) {
            return false;
        }
        if (this.inputFilters != null ? !this.inputFilters.equals(editTextRef.inputFilters) : editTextRef.inputFilters != null) {
            return false;
        }
        if (this.inputType != editTextRef.inputType) {
            return false;
        }
        if (this.isSingleLine != editTextRef.isSingleLine) {
            return false;
        }
        if (this.isSingleLineWrap != editTextRef.isSingleLineWrap) {
            return false;
        }
        if (this.linkColor != editTextRef.linkColor) {
            return false;
        }
        if (this.maxLength != editTextRef.maxLength) {
            return false;
        }
        if (this.maxLines != editTextRef.maxLines) {
            return false;
        }
        if (this.minLines != editTextRef.minLines) {
            return false;
        }
        if (this.rawInputType != editTextRef.rawInputType) {
            return false;
        }
        if (this.requestFocus != editTextRef.requestFocus) {
            return false;
        }
        if (this.selection != editTextRef.selection) {
            return false;
        }
        if (this.shadowColor != editTextRef.shadowColor) {
            return false;
        }
        if (Float.compare(this.shadowDx, editTextRef.shadowDx) != 0) {
            return false;
        }
        if (Float.compare(this.shadowDy, editTextRef.shadowDy) != 0) {
            return false;
        }
        if (Float.compare(this.shadowRadius, editTextRef.shadowRadius) != 0) {
            return false;
        }
        if (Float.compare(this.spacingMultiplier, editTextRef.spacingMultiplier) != 0) {
            return false;
        }
        if (this.stateUpdatePolicy != null ? !this.stateUpdatePolicy.equals((Object)editTextRef.stateUpdatePolicy) : editTextRef.stateUpdatePolicy != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(editTextRef.text) : editTextRef.text != null) {
            return false;
        }
        if (this.textAlignment != null ? !this.textAlignment.equals((Object)editTextRef.textAlignment) : editTextRef.textAlignment != null) {
            return false;
        }
        if (this.textColor != editTextRef.textColor) {
            return false;
        }
        if (this.textColorStateList != null ? !this.textColorStateList.equals(editTextRef.textColorStateList) : editTextRef.textColorStateList != null) {
            return false;
        }
        if (this.textSize != editTextRef.textSize) {
            return false;
        }
        if (this.textStyle != editTextRef.textStyle) {
            return false;
        }
        if (this.textWatchers != null ? !this.textWatchers.equals(editTextRef.textWatchers) : editTextRef.textWatchers != null) {
            return false;
        }
        if (this.tintColorStateList != null ? !this.tintColorStateList.equals(editTextRef.tintColorStateList) : editTextRef.tintColorStateList != null) {
            return false;
        }
        return !(this.typeface != null ? !this.typeface.equals((Object)editTextRef.typeface) : editTextRef.typeface != null);
    }

    public EditText makeShallowCopy() {
        EditText component = (EditText)super.makeShallowCopy();
        return component;
    }

    protected void onLoadStyle(ComponentContext c) {
        Output ellipsizeTmp = new Output();
        Output spacingMultiplierTmp = new Output();
        Output minLinesTmp = new Output();
        Output maxLinesTmp = new Output();
        Output isSingleLineTmp = new Output();
        Output textTmp = new Output();
        Output textColorStateListTmp = new Output();
        Output linkColorTmp = new Output();
        Output highlightColorTmp = new Output();
        Output textSizeTmp = new Output();
        Output textAlignmentTmp = new Output();
        Output textStyleTmp = new Output();
        Output shadowRadiusTmp = new Output();
        Output shadowDxTmp = new Output();
        Output shadowDyTmp = new Output();
        Output shadowColorTmp = new Output();
        Output gravityTmp = new Output();
        Output inputTypeTmp = new Output();
        Output imeOptionsTmp = new Output();
        EditTextSpec.onLoadStyle(c, (Output<TextUtils.TruncateAt>)ellipsizeTmp, (Output<Float>)spacingMultiplierTmp, (Output<Integer>)minLinesTmp, (Output<Integer>)maxLinesTmp, (Output<Boolean>)isSingleLineTmp, (Output<CharSequence>)textTmp, (Output<ColorStateList>)textColorStateListTmp, (Output<Integer>)linkColorTmp, (Output<Integer>)highlightColorTmp, (Output<Integer>)textSizeTmp, (Output<Layout.Alignment>)textAlignmentTmp, (Output<Integer>)textStyleTmp, (Output<Float>)shadowRadiusTmp, (Output<Float>)shadowDxTmp, (Output<Float>)shadowDyTmp, (Output<Integer>)shadowColorTmp, (Output<Integer>)gravityTmp, (Output<Integer>)inputTypeTmp, (Output<Integer>)imeOptionsTmp);
        if (ellipsizeTmp.get() != null) {
            this.ellipsize = (TextUtils.TruncateAt)ellipsizeTmp.get();
        }
        if (spacingMultiplierTmp.get() != null) {
            this.spacingMultiplier = ((Float)spacingMultiplierTmp.get()).floatValue();
        }
        if (minLinesTmp.get() != null) {
            this.minLines = (Integer)minLinesTmp.get();
        }
        if (maxLinesTmp.get() != null) {
            this.maxLines = (Integer)maxLinesTmp.get();
        }
        if (isSingleLineTmp.get() != null) {
            this.isSingleLine = (Boolean)isSingleLineTmp.get();
        }
        if (textTmp.get() != null) {
            this.text = (CharSequence)textTmp.get();
        }
        if (textColorStateListTmp.get() != null) {
            this.textColorStateList = (ColorStateList)textColorStateListTmp.get();
        }
        if (linkColorTmp.get() != null) {
            this.linkColor = (Integer)linkColorTmp.get();
        }
        if (highlightColorTmp.get() != null) {
            this.highlightColor = (Integer)highlightColorTmp.get();
        }
        if (textSizeTmp.get() != null) {
            this.textSize = (Integer)textSizeTmp.get();
        }
        if (textAlignmentTmp.get() != null) {
            this.textAlignment = (Layout.Alignment)textAlignmentTmp.get();
        }
        if (textStyleTmp.get() != null) {
            this.textStyle = (Integer)textStyleTmp.get();
        }
        if (shadowRadiusTmp.get() != null) {
            this.shadowRadius = ((Float)shadowRadiusTmp.get()).floatValue();
        }
        if (shadowDxTmp.get() != null) {
            this.shadowDx = ((Float)shadowDxTmp.get()).floatValue();
        }
        if (shadowDyTmp.get() != null) {
            this.shadowDy = ((Float)shadowDyTmp.get()).floatValue();
        }
        if (shadowColorTmp.get() != null) {
            this.shadowColor = (Integer)shadowColorTmp.get();
        }
        if (gravityTmp.get() != null) {
            this.gravity = (Integer)gravityTmp.get();
        }
        if (inputTypeTmp.get() != null) {
            this.inputType = (Integer)inputTypeTmp.get();
        }
        if (imeOptionsTmp.get() != null) {
            this.imeOptions = (Integer)imeOptionsTmp.get();
        }
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size, InterStagePropsContainer _5) {
        EditTextStateContainer _state = this.getStateContainerImpl(c);
        EditTextSpec.onMeasure(c, layout, widthSpec, heightSpec, size, this.text, this.initialText, this.hint, this.ellipsize, this.minLines, this.maxLines, this.maxLength, this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor, this.isSingleLine, this.textColor, this.textColorStateList, this.hintColor, this.hintColorStateList, this.linkColor, this.highlightColor, this.tintColorStateList, this.textSize, this.extraSpacing, this.spacingMultiplier, this.textStyle, this.typeface, this.textAlignment, this.gravity, this.editable, this.selection, this.inputType, this.rawInputType, this.imeOptions, this.editorActionListener, this.isSingleLineWrap, this.requestFocus, this.cursorDrawableRes, this.inputFilters, _state.input);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected Object onCreateMountContent(Context c) {
        EditTextSpec.EditTextWithEventHandlers _result = EditTextSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object editText, InterStagePropsContainer _2) {
        EditTextStateContainer _state = this.getStateContainerImpl(c);
        EditTextSpec.onMount(c, (EditTextSpec.EditTextWithEventHandlers)((Object)editText), this.text, this.initialText, this.hint, this.ellipsize, this.minLines, this.maxLines, this.maxLength, this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor, this.isSingleLine, this.textColor, this.textColorStateList, this.hintColor, this.hintColorStateList, this.linkColor, this.highlightColor, this.tintColorStateList, this.textSize, this.extraSpacing, this.spacingMultiplier, this.textStyle, this.typeface, this.textAlignment, this.gravity, this.editable, this.selection, this.inputType, this.rawInputType, this.imeOptions, this.editorActionListener, this.isSingleLineWrap, this.requestFocus, this.cursorDrawableRes, this.inputFilters, _state.mountedView, _state.configuredInitialText, _state.input);
    }

    protected void onBind(ComponentContext c, Object editText, InterStagePropsContainer _2) {
        EditTextSpec.onBind(c, (EditTextSpec.EditTextWithEventHandlers)((Object)editText), this.stateUpdatePolicy, this.textWatchers);
    }

    protected void onUnbind(ComponentContext c, Object editText, InterStagePropsContainer _2) {
        EditTextSpec.onUnbind(c, (EditTextSpec.EditTextWithEventHandlers)((Object)editText));
    }

    protected void onUnmount(ComponentContext c, Object editText, InterStagePropsContainer _2) {
        EditTextStateContainer _state = this.getStateContainerImpl(c);
        EditTextSpec.onUnmount(c, (EditTextSpec.EditTextWithEventHandlers)((Object)editText), _state.mountedView);
    }

    protected void createInitialState(ComponentContext _0) {
        EditTextStateContainer _state = this.getStateContainerImpl(_0);
        StateValue mountedView = new StateValue();
        StateValue configuredInitialText = new StateValue();
        EditTextSpec.onCreateInitialState((StateValue<AtomicReference<EditTextSpec.EditTextWithEventHandlers>>)mountedView, (StateValue<AtomicBoolean>)configuredInitialText);
        _state.mountedView = (AtomicReference)mountedView.get();
        _state.configuredInitialText = (AtomicBoolean)configuredInitialText.get();
    }

    public Component.MountType getMountType() {
        return Component.MountType.VIEW;
    }

    public int poolSize() {
        return 3;
    }

    public boolean canPreallocate() {
        return false;
    }

    public boolean isPureRender() {
        return true;
    }

    @Nullable
    public static EventHandler<TextChangedEvent> getTextChangedEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((EditText)context.getComponentScope()).textChangedEventHandler;
    }

    @Nullable
    public static EventHandler<SelectionChangedEvent> getSelectionChangedEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((EditText)context.getComponentScope()).selectionChangedEventHandler;
    }

    @Nullable
    public static EventHandler<KeyUpEvent> getKeyUpEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((EditText)context.getComponentScope()).keyUpEventHandler;
    }

    @Nullable
    public static EventHandler<SetTextEvent> getSetTextEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((EditText)context.getComponentScope()).setTextEventHandler;
    }

    static void dispatchTextChangedEvent(EventHandler _eventHandler, android.widget.EditText view, String text) {
        TextChangedEvent _eventState = new TextChangedEvent();
        _eventState.view = view;
        _eventState.text = text;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static void dispatchSelectionChangedEvent(EventHandler _eventHandler, int start, int end) {
        SelectionChangedEvent _eventState = new SelectionChangedEvent();
        _eventState.start = start;
        _eventState.end = end;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static Boolean dispatchKeyUpEvent(EventHandler _eventHandler, int keyCode, KeyEvent keyEvent) {
        KeyUpEvent _eventState = new KeyUpEvent();
        _eventState.keyCode = keyCode;
        _eventState.keyEvent = keyEvent;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        return (Boolean)_dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static void dispatchSetTextEvent(EventHandler _eventHandler, CharSequence text) {
        SetTextEvent _eventState = new SetTextEvent();
        _eventState.text = text;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    private static EventTrigger<RequestFocusEvent> createRequestFocusTrigger(ComponentContext c, Component component) {
        int methodId = 1670729240;
        return EditText.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<RequestFocusEvent> requestFocusTrigger(ComponentContext c, String key) {
        int methodId = 1670729240;
        return EditText.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<ClearFocusEvent> createClearFocusTrigger(ComponentContext c, Component component) {
        int methodId = -1050780906;
        return EditText.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<ClearFocusEvent> clearFocusTrigger(ComponentContext c, String key) {
        int methodId = -1050780906;
        return EditText.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<SetTextEvent> createSetTextTrigger(ComponentContext c, Component component) {
        int methodId = 638451776;
        return EditText.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<SetTextEvent> setTextTrigger(ComponentContext c, String key) {
        int methodId = 638451776;
        return EditText.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private void requestFocus(ComponentContext c, EventTriggerTarget _abstract) {
        EditText _ref = (EditText)_abstract;
        EditTextSpec.requestFocus(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView);
    }

    private void clearFocus(ComponentContext c, EventTriggerTarget _abstract) {
        EditText _ref = (EditText)_abstract;
        EditTextSpec.clearFocus(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView);
    }

    private void setText(ComponentContext c, EventTriggerTarget _abstract, CharSequence text) {
        EditText _ref = (EditText)_abstract;
        EditTextSpec.setText(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView, text);
    }

    public static void requestFocus(ComponentContext c, Handle handle) {
        int methodId = 1670729240;
        EventTrigger trigger = EditText.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        RequestFocusEvent _eventState = new RequestFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void requestFocus(ComponentContext c, String key) {
        int methodId = 1670729240;
        EventTrigger trigger = EditText.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        RequestFocusEvent _eventState = new RequestFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void requestFocus(EventTrigger trigger) {
        RequestFocusEvent _eventState = new RequestFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void requestFocus(ComponentContext c) {
        EditText component = (EditText)c.getComponentScope();
        component.requestFocus(c, (EventTriggerTarget)component);
    }

    public static void clearFocus(ComponentContext c, Handle handle) {
        int methodId = -1050780906;
        EventTrigger trigger = EditText.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        ClearFocusEvent _eventState = new ClearFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void clearFocus(ComponentContext c, String key) {
        int methodId = -1050780906;
        EventTrigger trigger = EditText.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        ClearFocusEvent _eventState = new ClearFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void clearFocus(EventTrigger trigger) {
        ClearFocusEvent _eventState = new ClearFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void clearFocus(ComponentContext c) {
        EditText component = (EditText)c.getComponentScope();
        component.clearFocus(c, (EventTriggerTarget)component);
    }

    public static void setText(ComponentContext c, Handle handle, CharSequence text) {
        int methodId = 638451776;
        EventTrigger trigger = EditText.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        SetTextEvent _eventState = new SetTextEvent();
        _eventState.text = text;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void setText(ComponentContext c, String key, CharSequence text) {
        int methodId = 638451776;
        EventTrigger trigger = EditText.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        SetTextEvent _eventState = new SetTextEvent();
        _eventState.text = text;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void setText(EventTrigger trigger, CharSequence text) {
        SetTextEvent _eventState = new SetTextEvent();
        _eventState.text = text;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void setText(ComponentContext c, CharSequence text) {
        EditText component = (EditText)c.getComponentScope();
        component.setText(c, (EventTriggerTarget)component, text);
    }

    protected Object acceptTriggerEventImpl(EventTrigger eventTrigger, Object eventState, Object[] params) {
        int id = eventTrigger.mId;
        switch (id) {
            case 1670729240: {
                RequestFocusEvent _event = (RequestFocusEvent)eventState;
                this.requestFocus(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget);
                return null;
            }
            case -1050780906: {
                ClearFocusEvent _event = (ClearFocusEvent)eventState;
                this.clearFocus(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget);
                return null;
            }
            case 638451776: {
                SetTextEvent _event = (SetTextEvent)eventState;
                this.setText(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget, _event.text);
                return null;
            }
        }
        return null;
    }

    public void recordEventTrigger(ComponentContext c, EventTriggersContainer container) {
        if (this.requestFocusTrigger != null) {
            this.requestFocusTrigger.mComponentContext = c;
            this.requestFocusTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.requestFocusTrigger);
        }
        if (this.clearFocusTrigger != null) {
            this.clearFocusTrigger.mComponentContext = c;
            this.clearFocusTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.clearFocusTrigger);
        }
        if (this.setTextTrigger != null) {
            this.setTextTrigger.mComponentContext = c;
            this.setTextTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.setTextTrigger);
        }
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(StateContainer _prevStateContainer, StateContainer _nextStateContainer) {
        EditTextStateContainer prevStateContainer = (EditTextStateContainer)_prevStateContainer;
        EditTextStateContainer nextStateContainer = (EditTextStateContainer)_nextStateContainer;
        nextStateContainer.configuredInitialText = prevStateContainer.configuredInitialText;
        nextStateContainer.input = prevStateContainer.input;
        nextStateContainer.mountedView = prevStateContainer.mountedView;
    }

    protected static void updateInput(ComponentContext c, CharSequence newInput) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{newInput});
        c.updateStateAsync(_stateUpdate, "updateState:EditText.updateInput");
    }

    protected static void updateInputAsync(ComponentContext c, CharSequence newInput) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{newInput});
        c.updateStateAsync(_stateUpdate, "updateState:EditText.updateInput");
    }

    protected static void updateInputSync(ComponentContext c, CharSequence newInput) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{newInput});
        c.updateStateSync(_stateUpdate, "updateState:EditText.updateInput");
    }

    protected static void lazyUpdateInput(ComponentContext c, CharSequence lazyUpdateValue) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(Integer.MIN_VALUE, new Object[]{lazyUpdateValue});
        c.updateStateLazy(_stateUpdate);
    }

    public static Builder create(ComponentContext context) {
        return EditText.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        EditText instance = new EditText();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        EditText mEditText;
        ComponentContext mContext;

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, EditText editTextRef) {
            super(context, defStyleAttr, defStyleRes, (Component)editTextRef);
            this.mEditText = editTextRef;
            this.mContext = context;
        }

        protected void setComponent(Component component) {
            this.mEditText = (EditText)component;
        }

        @PropSetter(value="cursorDrawableRes", required=false)
        public Builder cursorDrawableRes(int cursorDrawableRes) {
            this.mEditText.cursorDrawableRes = cursorDrawableRes;
            return this;
        }

        @PropSetter(value="editable", required=false)
        public Builder editable(boolean editable) {
            this.mEditText.editable = editable;
            return this;
        }

        @PropSetter(value="editorActionListener", required=false)
        public Builder editorActionListener(TextView.OnEditorActionListener editorActionListener) {
            this.mEditText.editorActionListener = editorActionListener;
            return this;
        }

        @PropSetter(value="ellipsize", required=false)
        public Builder ellipsize(TextUtils.TruncateAt ellipsize) {
            this.mEditText.ellipsize = ellipsize;
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingPx(@Px float extraSpacing) {
            this.mEditText.extraSpacing = extraSpacing;
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingDip(@Dimension(unit=0) float dip) {
            this.mEditText.extraSpacing = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingSp(@Dimension(unit=2) float sip) {
            this.mEditText.extraSpacing = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingRes(@DimenRes int resId) {
            this.mEditText.extraSpacing = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditText.extraSpacing = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingAttr(@AttrRes int attrResId) {
            this.mEditText.extraSpacing = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="gravity", required=false)
        public Builder gravity(int gravity) {
            this.mEditText.gravity = gravity;
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColor(@ColorInt int highlightColor) {
            this.mEditText.highlightColor = highlightColor;
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorRes(@ColorRes int resId) {
            this.mEditText.highlightColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditText.highlightColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorAttr(@AttrRes int attrResId) {
            this.mEditText.highlightColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hint(CharSequence hint) {
            this.mEditText.hint = hint;
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hintRes(@StringRes int resId) {
            this.mEditText.hint = this.mResourceResolver.resolveStringRes(resId);
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hintRes(@StringRes int resId, Object ... formatArgs) {
            this.mEditText.hint = this.mResourceResolver.resolveStringRes(resId, formatArgs);
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hintAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mEditText.hint = this.mResourceResolver.resolveStringAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hintAttr(@AttrRes int attrResId) {
            this.mEditText.hint = this.mResourceResolver.resolveStringAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="hintColor", required=false)
        public Builder hintColor(@ColorInt int hintColor) {
            this.mEditText.hintColor = hintColor;
            return this;
        }

        @PropSetter(value="hintColor", required=false)
        public Builder hintColorRes(@ColorRes int resId) {
            this.mEditText.hintColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="hintColor", required=false)
        public Builder hintColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditText.hintColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="hintColor", required=false)
        public Builder hintColorAttr(@AttrRes int attrResId) {
            this.mEditText.hintColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="hintColorStateList", required=false)
        public Builder hintColorStateList(ColorStateList hintColorStateList) {
            this.mEditText.hintColorStateList = hintColorStateList;
            return this;
        }

        @PropSetter(value="imeOptions", required=false)
        public Builder imeOptions(int imeOptions) {
            this.mEditText.imeOptions = imeOptions;
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialText(CharSequence initialText) {
            this.mEditText.initialText = initialText;
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialTextRes(@StringRes int resId) {
            this.mEditText.initialText = this.mResourceResolver.resolveStringRes(resId);
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialTextRes(@StringRes int resId, Object ... formatArgs) {
            this.mEditText.initialText = this.mResourceResolver.resolveStringRes(resId, formatArgs);
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialTextAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mEditText.initialText = this.mResourceResolver.resolveStringAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialTextAttr(@AttrRes int attrResId) {
            this.mEditText.initialText = this.mResourceResolver.resolveStringAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="inputFilters", required=false)
        public Builder inputFilter(InputFilter inputFilter) {
            if (inputFilter == null) {
                return this;
            }
            if (this.mEditText.inputFilters == Collections.EMPTY_LIST) {
                this.mEditText.inputFilters = new ArrayList<InputFilter>();
            }
            this.mEditText.inputFilters.add(inputFilter);
            return this;
        }

        @PropSetter(value="inputFilters", required=false)
        public Builder inputFilters(List<InputFilter> inputFilters) {
            if (inputFilters == null) {
                return this;
            }
            if (this.mEditText.inputFilters.isEmpty()) {
                this.mEditText.inputFilters = inputFilters;
            } else {
                this.mEditText.inputFilters.addAll(inputFilters);
            }
            return this;
        }

        @PropSetter(value="inputType", required=false)
        public Builder inputType(int inputType) {
            this.mEditText.inputType = inputType;
            return this;
        }

        @PropSetter(value="isSingleLine", required=false)
        public Builder isSingleLine(boolean isSingleLine) {
            this.mEditText.isSingleLine = isSingleLine;
            return this;
        }

        @PropSetter(value="isSingleLine", required=false)
        public Builder isSingleLineRes(@BoolRes int resId) {
            this.mEditText.isSingleLine = this.mResourceResolver.resolveBoolRes(resId);
            return this;
        }

        @PropSetter(value="isSingleLine", required=false)
        public Builder isSingleLineAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mEditText.isSingleLine = this.mResourceResolver.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="isSingleLine", required=false)
        public Builder isSingleLineAttr(@AttrRes int attrResId) {
            this.mEditText.isSingleLine = this.mResourceResolver.resolveBoolAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="isSingleLineWrap", required=false)
        public Builder isSingleLineWrap(boolean isSingleLineWrap) {
            this.mEditText.isSingleLineWrap = isSingleLineWrap;
            return this;
        }

        @PropSetter(value="linkColor", required=false)
        public Builder linkColor(@ColorInt int linkColor) {
            this.mEditText.linkColor = linkColor;
            return this;
        }

        @PropSetter(value="linkColor", required=false)
        public Builder linkColorRes(@ColorRes int resId) {
            this.mEditText.linkColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="linkColor", required=false)
        public Builder linkColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditText.linkColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="linkColor", required=false)
        public Builder linkColorAttr(@AttrRes int attrResId) {
            this.mEditText.linkColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="maxLength", required=false)
        public Builder maxLength(int maxLength) {
            this.mEditText.maxLength = maxLength;
            return this;
        }

        @PropSetter(value="maxLength", required=false)
        public Builder maxLengthRes(@IntegerRes int resId) {
            this.mEditText.maxLength = this.mResourceResolver.resolveIntRes(resId);
            return this;
        }

        @PropSetter(value="maxLength", required=false)
        public Builder maxLengthAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mEditText.maxLength = this.mResourceResolver.resolveIntAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="maxLength", required=false)
        public Builder maxLengthAttr(@AttrRes int attrResId) {
            this.mEditText.maxLength = this.mResourceResolver.resolveIntAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLines(int maxLines) {
            this.mEditText.maxLines = maxLines;
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLinesRes(@IntegerRes int resId) {
            this.mEditText.maxLines = this.mResourceResolver.resolveIntRes(resId);
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mEditText.maxLines = this.mResourceResolver.resolveIntAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLinesAttr(@AttrRes int attrResId) {
            this.mEditText.maxLines = this.mResourceResolver.resolveIntAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLines(int minLines) {
            this.mEditText.minLines = minLines;
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLinesRes(@IntegerRes int resId) {
            this.mEditText.minLines = this.mResourceResolver.resolveIntRes(resId);
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mEditText.minLines = this.mResourceResolver.resolveIntAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLinesAttr(@AttrRes int attrResId) {
            this.mEditText.minLines = this.mResourceResolver.resolveIntAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="rawInputType", required=false)
        public Builder rawInputType(int rawInputType) {
            this.mEditText.rawInputType = rawInputType;
            return this;
        }

        @PropSetter(value="requestFocus", required=false)
        public Builder requestFocus(boolean requestFocus) {
            this.mEditText.requestFocus = requestFocus;
            return this;
        }

        @PropSetter(value="selection", required=false)
        public Builder selection(int selection) {
            this.mEditText.selection = selection;
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColor(@ColorInt int shadowColor) {
            this.mEditText.shadowColor = shadowColor;
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorRes(@ColorRes int resId) {
            this.mEditText.shadowColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditText.shadowColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorAttr(@AttrRes int attrResId) {
            this.mEditText.shadowColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxPx(@Px float shadowDx) {
            this.mEditText.shadowDx = shadowDx;
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxDip(@Dimension(unit=0) float dip) {
            this.mEditText.shadowDx = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxSp(@Dimension(unit=2) float sip) {
            this.mEditText.shadowDx = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxRes(@DimenRes int resId) {
            this.mEditText.shadowDx = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditText.shadowDx = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxAttr(@AttrRes int attrResId) {
            this.mEditText.shadowDx = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyPx(@Px float shadowDy) {
            this.mEditText.shadowDy = shadowDy;
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyDip(@Dimension(unit=0) float dip) {
            this.mEditText.shadowDy = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDySp(@Dimension(unit=2) float sip) {
            this.mEditText.shadowDy = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyRes(@DimenRes int resId) {
            this.mEditText.shadowDy = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditText.shadowDy = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyAttr(@AttrRes int attrResId) {
            this.mEditText.shadowDy = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusPx(@Px float shadowRadius) {
            this.mEditText.shadowRadius = shadowRadius;
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusDip(@Dimension(unit=0) float dip) {
            this.mEditText.shadowRadius = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusSp(@Dimension(unit=2) float sip) {
            this.mEditText.shadowRadius = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusRes(@DimenRes int resId) {
            this.mEditText.shadowRadius = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditText.shadowRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusAttr(@AttrRes int attrResId) {
            this.mEditText.shadowRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="spacingMultiplier", required=false)
        public Builder spacingMultiplier(float spacingMultiplier) {
            this.mEditText.spacingMultiplier = spacingMultiplier;
            return this;
        }

        @PropSetter(value="spacingMultiplier", required=false)
        public Builder spacingMultiplierRes(@DimenRes int resId) {
            this.mEditText.spacingMultiplier = this.mResourceResolver.resolveFloatRes(resId);
            return this;
        }

        @PropSetter(value="spacingMultiplier", required=false)
        public Builder spacingMultiplierAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditText.spacingMultiplier = this.mResourceResolver.resolveFloatAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="spacingMultiplier", required=false)
        public Builder spacingMultiplierAttr(@AttrRes int attrResId) {
            this.mEditText.spacingMultiplier = this.mResourceResolver.resolveFloatAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="stateUpdatePolicy", required=false)
        public Builder stateUpdatePolicy(EditTextStateUpdatePolicy stateUpdatePolicy) {
            this.mEditText.stateUpdatePolicy = stateUpdatePolicy;
            return this;
        }

        @PropSetter(value="text", required=false)
        public Builder text(CharSequence text) {
            this.mEditText.text = text;
            return this;
        }

        @PropSetter(value="text", required=false)
        public Builder textRes(@StringRes int resId) {
            this.mEditText.text = this.mResourceResolver.resolveStringRes(resId);
            return this;
        }

        @PropSetter(value="text", required=false)
        public Builder textRes(@StringRes int resId, Object ... formatArgs) {
            this.mEditText.text = this.mResourceResolver.resolveStringRes(resId, formatArgs);
            return this;
        }

        @PropSetter(value="text", required=false)
        public Builder textAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mEditText.text = this.mResourceResolver.resolveStringAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="text", required=false)
        public Builder textAttr(@AttrRes int attrResId) {
            this.mEditText.text = this.mResourceResolver.resolveStringAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="textAlignment", required=false)
        public Builder textAlignment(Layout.Alignment textAlignment) {
            this.mEditText.textAlignment = textAlignment;
            return this;
        }

        @PropSetter(value="textColor", required=false)
        public Builder textColor(@ColorInt int textColor) {
            this.mEditText.textColor = textColor;
            return this;
        }

        @PropSetter(value="textColor", required=false)
        public Builder textColorRes(@ColorRes int resId) {
            this.mEditText.textColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="textColor", required=false)
        public Builder textColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mEditText.textColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="textColor", required=false)
        public Builder textColorAttr(@AttrRes int attrResId) {
            this.mEditText.textColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="textColorStateList", required=false)
        public Builder textColorStateList(ColorStateList textColorStateList) {
            this.mEditText.textColorStateList = textColorStateList;
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizePx(@Px int textSize) {
            this.mEditText.textSize = textSize;
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeDip(@Dimension(unit=0) float dip) {
            this.mEditText.textSize = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeSp(@Dimension(unit=2) float sip) {
            this.mEditText.textSize = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeRes(@DimenRes int resId) {
            this.mEditText.textSize = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mEditText.textSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeAttr(@AttrRes int attrResId) {
            this.mEditText.textSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="textStyle", required=false)
        public Builder textStyle(int textStyle) {
            this.mEditText.textStyle = textStyle;
            return this;
        }

        @PropSetter(value="textWatchers", required=false)
        public Builder textWatcher(TextWatcher textWatcher) {
            if (textWatcher == null) {
                return this;
            }
            if (this.mEditText.textWatchers == Collections.EMPTY_LIST) {
                this.mEditText.textWatchers = new ArrayList<TextWatcher>();
            }
            this.mEditText.textWatchers.add(textWatcher);
            return this;
        }

        @PropSetter(value="textWatchers", required=false)
        public Builder textWatchers(List<TextWatcher> textWatchers) {
            if (textWatchers == null) {
                return this;
            }
            if (this.mEditText.textWatchers.isEmpty()) {
                this.mEditText.textWatchers = textWatchers;
            } else {
                this.mEditText.textWatchers.addAll(textWatchers);
            }
            return this;
        }

        @PropSetter(value="tintColorStateList", required=false)
        public Builder tintColorStateList(ColorStateList tintColorStateList) {
            this.mEditText.tintColorStateList = tintColorStateList;
            return this;
        }

        @PropSetter(value="typeface", required=false)
        public Builder typeface(Typeface typeface) {
            this.mEditText.typeface = typeface;
            return this;
        }

        public Builder textChangedEventHandler(@Nullable EventHandler<TextChangedEvent> textChangedEventHandler) {
            this.mEditText.textChangedEventHandler = textChangedEventHandler;
            return this;
        }

        public Builder selectionChangedEventHandler(@Nullable EventHandler<SelectionChangedEvent> selectionChangedEventHandler) {
            this.mEditText.selectionChangedEventHandler = selectionChangedEventHandler;
            return this;
        }

        public Builder keyUpEventHandler(@Nullable EventHandler<KeyUpEvent> keyUpEventHandler) {
            this.mEditText.keyUpEventHandler = keyUpEventHandler;
            return this;
        }

        public Builder setTextEventHandler(@Nullable EventHandler<SetTextEvent> setTextEventHandler) {
            this.mEditText.setTextEventHandler = setTextEventHandler;
            return this;
        }

        @Deprecated
        public Builder requestFocusTrigger(EventTrigger requestFocusTrigger) {
            this.mEditText.requestFocusTrigger = requestFocusTrigger;
            return this;
        }

        private void registerRequestFocusTrigger() {
            EventTrigger requestFocusTrigger = this.mEditText.requestFocusTrigger;
            if (requestFocusTrigger == null) {
                requestFocusTrigger = EditText.createRequestFocusTrigger(this.mContext, (Component)this.mEditText);
            }
            this.requestFocusTrigger(requestFocusTrigger);
        }

        @Deprecated
        public Builder clearFocusTrigger(EventTrigger clearFocusTrigger) {
            this.mEditText.clearFocusTrigger = clearFocusTrigger;
            return this;
        }

        private void registerClearFocusTrigger() {
            EventTrigger clearFocusTrigger = this.mEditText.clearFocusTrigger;
            if (clearFocusTrigger == null) {
                clearFocusTrigger = EditText.createClearFocusTrigger(this.mContext, (Component)this.mEditText);
            }
            this.clearFocusTrigger(clearFocusTrigger);
        }

        @Deprecated
        public Builder setTextTrigger(EventTrigger setTextTrigger) {
            this.mEditText.setTextTrigger = setTextTrigger;
            return this;
        }

        private void registerSetTextTrigger() {
            EventTrigger setTextTrigger = this.mEditText.setTextTrigger;
            if (setTextTrigger == null) {
                setTextTrigger = EditText.createSetTextTrigger(this.mContext, (Component)this.mEditText);
            }
            this.setTextTrigger(setTextTrigger);
        }

        private void registerEventTriggers() {
            this.registerRequestFocusTrigger();
            this.registerClearFocusTrigger();
            this.registerSetTextTrigger();
        }

        public Builder getThis() {
            return this;
        }

        public EditText build() {
            this.registerEventTriggers();
            return this.mEditText;
        }
    }

    @Generated
    @VisibleForTesting(otherwise=2)
    static class EditTextStateContainer
    extends StateContainer {
        @State
        @Comparable(type=13)
        AtomicBoolean configuredInitialText;
        @State
        @Comparable(type=13)
        CharSequence input;
        @State
        @Comparable(type=13)
        AtomicReference<EditTextSpec.EditTextWithEventHandlers> mountedView;

        EditTextStateContainer() {
        }

        public void applyStateUpdate(StateContainer.StateUpdate stateUpdate) {
            Object[] params = stateUpdate.params;
            switch (stateUpdate.type) {
                case 0: {
                    StateValue input = new StateValue();
                    input.set((Object)this.input);
                    EditTextSpec.updateInput((StateValue<CharSequence>)input, (CharSequence)params[0]);
                    this.input = (CharSequence)input.get();
                    break;
                }
                case -2147483648: {
                    this.input = (CharSequence)params[0];
                }
            }
        }
    }
}

