/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.HorizontalScrollEventsController;
import com.facebook.litho.widget.HorizontalScrollLithoView;
import com.facebook.litho.widget.HorizontalScrollSpec;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.yoga.YogaDirection;
import java.util.BitSet;

@Generated
public final class HorizontalScroll
extends SpecGeneratedComponent {
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=10)
    Component contentProps;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    HorizontalScrollEventsController eventsController;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean fillViewport;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean incrementalMountEnabled = false;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int initialScrollPosition = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    HorizontalScrollLithoView.OnScrollChangeListener onScrollChangeListener;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int overScrollMode = 1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    ScrollStateListener scrollStateListener;
    @Prop(resType=ResType.BOOL, optional=true)
    @Comparable(type=3)
    boolean scrollbarEnabled = true;

    private HorizontalScroll() {
        super("HorizontalScroll");
    }

    private HorizontalScrollStateContainer getStateContainerImpl(ComponentContext c) {
        return (HorizontalScrollStateContainer)c.getScopedComponentInfo().getStateContainer();
    }

    protected HorizontalScrollStateContainer createStateContainer() {
        return new HorizontalScrollStateContainer();
    }

    protected HorizontalScrollInterStagePropsContainer createInterStagePropsContainer() {
        return new HorizontalScrollInterStagePropsContainer();
    }

    private HorizontalScrollInterStagePropsContainer getInterStagePropsContainerImpl(ComponentContext c, InterStagePropsContainer interStageProps) {
        return (HorizontalScrollInterStagePropsContainer)super.getInterStagePropsContainer(c, interStageProps);
    }

    public boolean isEquivalentProps(Component other, boolean shouldCompareCommonProps) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        HorizontalScroll horizontalScrollRef = (HorizontalScroll)other;
        if (this.contentProps != null ? !this.contentProps.isEquivalentTo(horizontalScrollRef.contentProps) : horizontalScrollRef.contentProps != null) {
            return false;
        }
        if (this.eventsController != null ? !this.eventsController.equals(horizontalScrollRef.eventsController) : horizontalScrollRef.eventsController != null) {
            return false;
        }
        if (this.fillViewport != horizontalScrollRef.fillViewport) {
            return false;
        }
        if (this.incrementalMountEnabled != horizontalScrollRef.incrementalMountEnabled) {
            return false;
        }
        if (this.initialScrollPosition != horizontalScrollRef.initialScrollPosition) {
            return false;
        }
        if (this.onScrollChangeListener != null ? !this.onScrollChangeListener.equals(horizontalScrollRef.onScrollChangeListener) : horizontalScrollRef.onScrollChangeListener != null) {
            return false;
        }
        if (this.overScrollMode != horizontalScrollRef.overScrollMode) {
            return false;
        }
        if (this.scrollStateListener != null ? !this.scrollStateListener.equals(horizontalScrollRef.scrollStateListener) : horizontalScrollRef.scrollStateListener != null) {
            return false;
        }
        return this.scrollbarEnabled == horizontalScrollRef.scrollbarEnabled;
    }

    protected void copyInterStageImpl(InterStagePropsContainer copyIntoInterStagePropsContainer, InterStagePropsContainer copyFromInterStagePropsContainer) {
        HorizontalScrollInterStagePropsContainer copyIntoInterStagePropsContainer_ref = (HorizontalScrollInterStagePropsContainer)copyIntoInterStagePropsContainer;
        HorizontalScrollInterStagePropsContainer copyFromInterStagePropsContainer_ref = (HorizontalScrollInterStagePropsContainer)copyFromInterStagePropsContainer;
        copyIntoInterStagePropsContainer_ref.componentHeight = copyFromInterStagePropsContainer_ref.componentHeight;
        copyIntoInterStagePropsContainer_ref.componentWidth = copyFromInterStagePropsContainer_ref.componentWidth;
        copyIntoInterStagePropsContainer_ref.layoutDirection = copyFromInterStagePropsContainer_ref.layoutDirection;
        copyIntoInterStagePropsContainer_ref.measuredComponentHeight = copyFromInterStagePropsContainer_ref.measuredComponentHeight;
        copyIntoInterStagePropsContainer_ref.measuredComponentWidth = copyFromInterStagePropsContainer_ref.measuredComponentWidth;
    }

    public HorizontalScroll makeShallowCopy() {
        HorizontalScroll component = (HorizontalScroll)super.makeShallowCopy();
        component.contentProps = component.contentProps != null ? component.contentProps.makeShallowCopy() : null;
        return component;
    }

    protected void onLoadStyle(ComponentContext c) {
        Output scrollbarEnabledTmp = new Output();
        HorizontalScrollSpec.onLoadStyle(c, (Output<Boolean>)scrollbarEnabledTmp);
        if (scrollbarEnabledTmp.get() != null) {
            this.scrollbarEnabled = (Boolean)scrollbarEnabledTmp.get();
        }
    }

    protected void onMeasure(ComponentContext context, ComponentLayout layout, int widthSpec, int heightSpec, Size size, InterStagePropsContainer _5) {
        InterStagePropsContainer _interStageProps = _5;
        HorizontalScrollStateContainer _state = this.getStateContainerImpl(context);
        Output measuredComponentWidthTmp = new Output();
        Output measuredComponentHeightTmp = new Output();
        HorizontalScrollSpec.onMeasure(context, layout, widthSpec, heightSpec, size, this.contentProps, _state.childComponentTree, (Output<Integer>)measuredComponentWidthTmp, (Output<Integer>)measuredComponentHeightTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).measuredComponentWidth = (Integer)measuredComponentWidthTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).measuredComponentHeight = (Integer)measuredComponentHeightTmp.get();
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext context, ComponentLayout layout, InterStagePropsContainer _2) {
        InterStagePropsContainer _interStageProps = _2;
        HorizontalScrollStateContainer _state = this.getStateContainerImpl(context);
        Output componentWidthTmp = new Output();
        Output componentHeightTmp = new Output();
        Output layoutDirectionTmp = new Output();
        HorizontalScrollSpec.onBoundsDefined(context, layout, this.contentProps, this.fillViewport, _state.childComponentTree, this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).measuredComponentWidth, this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).measuredComponentHeight, (Output<Integer>)componentWidthTmp, (Output<Integer>)componentHeightTmp, (Output<YogaDirection>)layoutDirectionTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).componentWidth = (Integer)componentWidthTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).componentHeight = (Integer)componentHeightTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).layoutDirection = (YogaDirection)layoutDirectionTmp.get();
    }

    protected Object onCreateMountContent(Context c) {
        HorizontalScrollLithoView _result = HorizontalScrollSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext context, Object horizontalScrollLithoView, InterStagePropsContainer _2) {
        InterStagePropsContainer _interStageProps = _2;
        HorizontalScrollStateContainer _state = this.getStateContainerImpl(context);
        HorizontalScrollSpec.onMount(context, (HorizontalScrollLithoView)((Object)horizontalScrollLithoView), this.scrollbarEnabled, this.eventsController, this.onScrollChangeListener, this.scrollStateListener, this.incrementalMountEnabled, this.overScrollMode, _state.lastScrollPosition, _state.childComponentTree, this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).componentWidth, this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).componentHeight, this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).layoutDirection);
    }

    protected void onUnmount(ComponentContext context, Object mountedView, InterStagePropsContainer _2) {
        HorizontalScrollSpec.onUnmount(context, (HorizontalScrollLithoView)((Object)mountedView), this.eventsController);
    }

    protected void createInitialState(ComponentContext c) {
        HorizontalScrollStateContainer _state = this.getStateContainerImpl(c);
        StateValue lastScrollPosition = new StateValue();
        StateValue childComponentTree = new StateValue();
        HorizontalScrollSpec.onCreateInitialState(c, (StateValue<HorizontalScrollLithoView.ScrollPosition>)lastScrollPosition, (StateValue<ComponentTree>)childComponentTree, this.contentProps, this.initialScrollPosition, this.incrementalMountEnabled);
        _state.lastScrollPosition = (HorizontalScrollLithoView.ScrollPosition)lastScrollPosition.get();
        _state.childComponentTree = (ComponentTree)childComponentTree.get();
    }

    public Component.MountType getMountType() {
        return Component.MountType.VIEW;
    }

    public int poolSize() {
        return 3;
    }

    public boolean canPreallocate() {
        return false;
    }

    protected boolean isMountSizeDependent() {
        return true;
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(StateContainer _prevStateContainer, StateContainer _nextStateContainer) {
        HorizontalScrollStateContainer prevStateContainer = (HorizontalScrollStateContainer)_prevStateContainer;
        HorizontalScrollStateContainer nextStateContainer = (HorizontalScrollStateContainer)_nextStateContainer;
        nextStateContainer.childComponentTree = prevStateContainer.childComponentTree;
        nextStateContainer.lastScrollPosition = prevStateContainer.lastScrollPosition;
    }

    public static Builder create(ComponentContext context) {
        return HorizontalScroll.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        HorizontalScroll instance = new HorizontalScroll();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        HorizontalScroll mHorizontalScroll;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"contentProps"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, HorizontalScroll horizontalScrollRef) {
            super(context, defStyleAttr, defStyleRes, (Component)horizontalScrollRef);
            this.mHorizontalScroll = horizontalScrollRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mHorizontalScroll = (HorizontalScroll)component;
        }

        @PropSetter(value="contentProps", required=true)
        @RequiredProp(value="contentProps")
        public Builder contentProps(Component contentProps) {
            this.mHorizontalScroll.contentProps = contentProps == null ? null : contentProps.makeShallowCopy();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="contentProps", required=true)
        @RequiredProp(value="contentProps")
        public Builder contentProps(Component.Builder<?> contentPropsBuilder) {
            this.mHorizontalScroll.contentProps = contentPropsBuilder == null ? null : contentPropsBuilder.build();
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="eventsController", required=false)
        public Builder eventsController(@Nullable HorizontalScrollEventsController eventsController) {
            this.mHorizontalScroll.eventsController = eventsController;
            return this;
        }

        @PropSetter(value="fillViewport", required=false)
        public Builder fillViewport(boolean fillViewport) {
            this.mHorizontalScroll.fillViewport = fillViewport;
            return this;
        }

        @PropSetter(value="incrementalMountEnabled", required=false)
        public Builder incrementalMountEnabled(boolean incrementalMountEnabled) {
            this.mHorizontalScroll.incrementalMountEnabled = incrementalMountEnabled;
            return this;
        }

        @PropSetter(value="initialScrollPosition", required=false)
        public Builder initialScrollPosition(int initialScrollPosition) {
            this.mHorizontalScroll.initialScrollPosition = initialScrollPosition;
            return this;
        }

        @PropSetter(value="onScrollChangeListener", required=false)
        public Builder onScrollChangeListener(@Nullable HorizontalScrollLithoView.OnScrollChangeListener onScrollChangeListener) {
            this.mHorizontalScroll.onScrollChangeListener = onScrollChangeListener;
            return this;
        }

        @PropSetter(value="overScrollMode", required=false)
        public Builder overScrollMode(int overScrollMode) {
            this.mHorizontalScroll.overScrollMode = overScrollMode;
            return this;
        }

        @PropSetter(value="scrollStateListener", required=false)
        public Builder scrollStateListener(@Nullable ScrollStateListener scrollStateListener) {
            this.mHorizontalScroll.scrollStateListener = scrollStateListener;
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabled(boolean scrollbarEnabled) {
            this.mHorizontalScroll.scrollbarEnabled = scrollbarEnabled;
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabledRes(@BoolRes int resId) {
            this.mHorizontalScroll.scrollbarEnabled = this.mResourceResolver.resolveBoolRes(resId);
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabledAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mHorizontalScroll.scrollbarEnabled = this.mResourceResolver.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="scrollbarEnabled", required=false)
        public Builder scrollbarEnabledAttr(@AttrRes int attrResId) {
            this.mHorizontalScroll.scrollbarEnabled = this.mResourceResolver.resolveBoolAttr(attrResId, 0);
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public HorizontalScroll build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mHorizontalScroll;
        }
    }

    @Generated
    @VisibleForTesting(otherwise=2)
    static class HorizontalScrollStateContainer
    extends StateContainer {
        @State
        @Comparable(type=13)
        ComponentTree childComponentTree;
        @State
        @Comparable(type=13)
        HorizontalScrollLithoView.ScrollPosition lastScrollPosition;

        HorizontalScrollStateContainer() {
        }

        public void applyStateUpdate(StateContainer.StateUpdate stateUpdate) {
            Object[] params = stateUpdate.params;
            int cfr_ignored_0 = stateUpdate.type;
        }
    }

    @Generated
    static class HorizontalScrollInterStagePropsContainer
    implements InterStagePropsContainer {
        Integer componentHeight;
        Integer componentWidth;
        YogaDirection layoutDirection;
        Integer measuredComponentHeight;
        Integer measuredComponentWidth;

        HorizontalScrollInterStagePropsContainer() {
        }
    }
}

