/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.Output;
import com.facebook.litho.R;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.FromMeasure;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMeasure;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.HorizontalScrollEventsController;
import com.facebook.litho.widget.HorizontalScrollLithoView;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.yoga.YogaDirection;

@MountSpec
class HorizontalScrollSpec {
    private static final int LAST_SCROLL_POSITION_UNSET = -1;
    @PropDefault
    static final boolean scrollbarEnabled = true;
    @PropDefault
    static final int initialScrollPosition = -1;
    @PropDefault
    static final boolean incrementalMountEnabled = false;
    @PropDefault
    static final int overScrollMode = 1;

    HorizontalScrollSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<Boolean> scrollbarEnabled) {
        TypedArray a = c.obtainStyledAttributes(R.styleable.HorizontalScroll, 0);
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 != R.styleable.HorizontalScroll_android_scrollbars) continue;
            scrollbarEnabled.set((Object)(a.getInt(attr2, 0) != 0 ? 1 : 0));
        }
        a.recycle();
    }

    @OnMeasure
    static void onMeasure(ComponentContext context, ComponentLayout layout, int widthSpec, int heightSpec, Size size, @Prop Component contentProps, @State ComponentTree childComponentTree, Output<Integer> measuredComponentWidth, Output<Integer> measuredComponentHeight) {
        Size contentSize = new Size();
        childComponentTree.setRootAndSizeSpecSync(contentProps, SizeSpec.makeSizeSpec((int)0, (int)0), heightSpec, contentSize);
        int measuredWidth = contentSize.width;
        int measuredHeight = contentSize.height;
        measuredComponentWidth.set((Object)measuredWidth);
        measuredComponentHeight.set((Object)measuredHeight);
        size.width = SizeSpec.getMode((int)widthSpec) == 0 ? measuredWidth : SizeSpec.getSize((int)widthSpec);
        size.height = measuredHeight;
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext context, ComponentLayout layout, @Prop Component contentProps, @Prop(optional=true) boolean fillViewport, @State ComponentTree childComponentTree, @FromMeasure @Nullable Integer measuredComponentWidth, @FromMeasure @Nullable Integer measuredComponentHeight, Output<Integer> componentWidth, Output<Integer> componentHeight, Output<YogaDirection> layoutDirection) {
        int layoutWidth = layout.getWidth() - layout.getPaddingLeft() - layout.getPaddingRight();
        if (measuredComponentWidth != null && measuredComponentHeight != null) {
            componentWidth.set((Object)Math.max(measuredComponentWidth, fillViewport ? layoutWidth : 0));
            componentHeight.set((Object)measuredComponentHeight);
        } else {
            Size contentSize = new Size();
            childComponentTree.setRootAndSizeSpecSync(contentProps, SizeSpec.makeSizeSpec((int)0, (int)0), SizeSpec.makeSizeSpec((int)layout.getHeight(), (int)0x40000000), contentSize);
            int measuredWidth = Math.max(contentSize.width, fillViewport ? layoutWidth : 0);
            int measuredHeight = contentSize.height;
            componentWidth.set((Object)measuredWidth);
            componentHeight.set((Object)measuredHeight);
        }
        layoutDirection.set((Object)layout.getResolvedLayoutDirection());
    }

    @OnCreateMountContent
    static HorizontalScrollLithoView onCreateMountContent(Context c) {
        return new HorizontalScrollLithoView(c);
    }

    @OnMount
    static void onMount(ComponentContext context, final HorizontalScrollLithoView horizontalScrollLithoView, @Prop(optional=true, resType=ResType.BOOL) boolean scrollbarEnabled, @Prop(optional=true) @Nullable HorizontalScrollEventsController eventsController, @Prop(optional=true) @Nullable HorizontalScrollLithoView.OnScrollChangeListener onScrollChangeListener, @Prop(optional=true) @Nullable ScrollStateListener scrollStateListener, @Prop(optional=true) boolean incrementalMountEnabled, @Prop(optional=true) int overScrollMode, final @State HorizontalScrollLithoView.ScrollPosition lastScrollPosition, @State ComponentTree childComponentTree, @Nullable Integer componentWidth, @Nullable Integer componentHeight, final YogaDirection layoutDirection) {
        horizontalScrollLithoView.setHorizontalScrollBarEnabled(scrollbarEnabled);
        horizontalScrollLithoView.setOverScrollMode(overScrollMode);
        horizontalScrollLithoView.mount(childComponentTree, lastScrollPosition, componentWidth != null ? componentWidth : 0, componentHeight != null ? componentHeight : 0, onScrollChangeListener, scrollStateListener);
        ViewTreeObserver viewTreeObserver = horizontalScrollLithoView.getViewTreeObserver();
        viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                horizontalScrollLithoView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                if (lastScrollPosition.x == -1) {
                    if (layoutDirection == YogaDirection.RTL) {
                        horizontalScrollLithoView.fullScroll(66);
                    }
                    lastScrollPosition.x = horizontalScrollLithoView.getScrollX();
                } else {
                    horizontalScrollLithoView.setScrollX(lastScrollPosition.x);
                }
                return true;
            }
        });
        if (eventsController != null) {
            eventsController.setScrollableView(horizontalScrollLithoView);
        }
    }

    @OnUnmount
    static void onUnmount(ComponentContext context, HorizontalScrollLithoView mountedView, @Prop(optional=true) @Nullable HorizontalScrollEventsController eventsController) {
        mountedView.unmount();
        if (eventsController != null) {
            eventsController.setScrollableView(null);
        }
    }

    @OnCreateInitialState
    static void onCreateInitialState(ComponentContext c, StateValue<HorizontalScrollLithoView.ScrollPosition> lastScrollPosition, StateValue<ComponentTree> childComponentTree, @Prop Component contentProps, @Prop(optional=true) int initialScrollPosition, @Prop(optional=true) boolean incrementalMountEnabled) {
        lastScrollPosition.set((Object)new HorizontalScrollLithoView.ScrollPosition(initialScrollPosition));
        childComponentTree.set((Object)ComponentTree.createNestedComponentTree((ComponentContext)c, (Component)contentProps).incrementalMount(incrementalMountEnabled).build());
    }
}

