/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.litho.widget.HasPostDispatchDrawListener;
import com.facebook.litho.widget.PostDispatchDrawListener;

public class LithoRecyclerView
extends RecyclerView
implements HasPostDispatchDrawListener {
    @Nullable
    private TouchInterceptor mTouchInterceptor;
    @Nullable
    private PostDispatchDrawListener mPostDispatchDrawListener;

    public LithoRecyclerView(Context context) {
        this(context, null);
    }

    public LithoRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LithoRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setTouchInterceptor(@Nullable TouchInterceptor touchInterceptor) {
        this.mTouchInterceptor = touchInterceptor;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mTouchInterceptor == null) {
            return super.onInterceptTouchEvent(ev);
        }
        TouchInterceptor.Result result = this.mTouchInterceptor.onInterceptTouchEvent(this, ev);
        switch (result) {
            case INTERCEPT_TOUCH_EVENT: {
                return true;
            }
            case IGNORE_TOUCH_EVENT: {
                return false;
            }
            case CALL_SUPER: {
                return super.onInterceptTouchEvent(ev);
            }
        }
        throw new IllegalArgumentException("Unknown TouchInterceptor.Result: " + (Object)((Object)result));
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mPostDispatchDrawListener != null) {
            this.mPostDispatchDrawListener.postDispatchDraw();
        }
    }

    @Override
    public void registerPostDispatchDrawListener(PostDispatchDrawListener listener) {
        this.mPostDispatchDrawListener = listener;
    }

    @Override
    public void unregisterPostDispatchDrawListener(PostDispatchDrawListener listener) {
        this.mPostDispatchDrawListener = null;
    }

    public static interface TouchInterceptor {
        public Result onInterceptTouchEvent(RecyclerView var1, MotionEvent var2);

        public static enum Result {
            INTERCEPT_TOUCH_EVENT,
            IGNORE_TOUCH_EVENT,
            CALL_SUPER;

        }
    }
}

