/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.AnyThread;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLogParams;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.ErrorEventHandler;
import com.facebook.litho.EventHandler;
import com.facebook.litho.LithoLifecycleProvider;
import com.facebook.litho.LithoStartupLogger;
import com.facebook.litho.LithoView;
import com.facebook.litho.LogTreePopulator;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.MountHelper;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.RenderCompleteEvent;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.ThreadPoolLayoutHandler;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.choreographercompat.ChoreographerCompat;
import com.facebook.litho.choreographercompat.ChoreographerCompatImpl;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.config.LayoutThreadPoolConfiguration;
import com.facebook.litho.viewcompat.ViewBinder;
import com.facebook.litho.viewcompat.ViewCreator;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.ChangeSetCompleteCallback;
import com.facebook.litho.widget.ComponentRenderInfo;
import com.facebook.litho.widget.ComponentTreeHolder;
import com.facebook.litho.widget.ComponentWarmer;
import com.facebook.litho.widget.HasPostDispatchDrawListener;
import com.facebook.litho.widget.HasStickyHeader;
import com.facebook.litho.widget.LayoutHandlerFactory;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.LinearLayoutInfo;
import com.facebook.litho.widget.LithoViewFactory;
import com.facebook.litho.widget.NeedsBgPaddingInfo;
import com.facebook.litho.widget.PostDispatchDrawListener;
import com.facebook.litho.widget.ReMeasureEvent;
import com.facebook.litho.widget.RecyclerBinderAdapter;
import com.facebook.litho.widget.RecyclerBinderAdapterDelegate;
import com.facebook.litho.widget.RecyclerBinderViewHolder;
import com.facebook.litho.widget.RecyclerRangeTraverser;
import com.facebook.litho.widget.RenderInfo;
import com.facebook.litho.widget.RenderInfoDebugInfoRegistry;
import com.facebook.litho.widget.RenderInfoViewCreatorController;
import com.facebook.litho.widget.SectionsDebug;
import com.facebook.litho.widget.SectionsRecyclerView;
import com.facebook.litho.widget.SmoothScrollAlignmentType;
import com.facebook.litho.widget.SnapUtil;
import com.facebook.litho.widget.StickyHeaderController;
import com.facebook.litho.widget.StickyHeaderControllerFactory;
import com.facebook.litho.widget.StickyHeaderControllerImpl;
import com.facebook.litho.widget.ViewportInfo;
import com.facebook.litho.widget.ViewportManager;
import com.facebook.rendercore.RunnableHandler;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RecyclerBinder
implements Binder<RecyclerView>,
LayoutInfo.RenderInfoCollection,
HasStickyHeader {
    private static final Size sDummySize = new Size();
    private static final Rect sDummyRect = new Rect();
    private static final Rect sEmptyRect = new Rect();
    private static final String TAG = RecyclerBinder.class.getSimpleName();
    private static final int POST_UPDATE_VIEWPORT_AND_COMPUTE_RANGE_MAX_ATTEMPTS = 3;
    private static final int DATA_RENDERED_CALLBACKS_QUEUE_MAX_SIZE = 20;
    private static final String DATA_RENDERED_NOT_TRIGGERED = "RecyclerBinder:DataRenderedNotTriggered";
    static final int UNSET = -1;
    static final int APPLY_READY_BATCHES_RETRY_LIMIT = 100;
    public static final String ID_CUSTOM_ATTR_KEY = "id";
    private static Field mViewHolderField;
    @GuardedBy(value="this")
    private final List<ComponentTreeHolder> mComponentTreeHolders = new ArrayList<ComponentTreeHolder>();
    @GuardedBy(value="this")
    private final List<ComponentTreeHolder> mAsyncComponentTreeHolders = new ArrayList<ComponentTreeHolder>();
    private volatile LayoutInfo mLayoutInfo;
    private final RecyclerView.Adapter mInternalAdapter;
    private final ComponentContext mComponentContext;
    @Nullable
    private final LayoutHandlerFactory mLayoutHandlerFactory;
    @Nullable
    private final LithoViewFactory mLithoViewFactory;
    private final ComponentTreeHolderFactory mComponentTreeHolderFactory;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final float mRangeRatio;
    private final AtomicBoolean mIsMeasured = new AtomicBoolean(false);
    private final AtomicBoolean mRequiresRemeasure = new AtomicBoolean(false);
    private final boolean mEnableStableIds;
    @Nullable
    private final RunnableHandler mAsyncInsertHandler;
    private final boolean mVisibilityProcessingEnabled;
    private final boolean mAcquireStateHandlerOnRelease;
    @Nullable
    private final LithoLifecycleProvider mParentLifecycle;
    @Nullable
    private List<ComponentLogParams> mInvalidStateLogParamsList;
    private final RecyclerRangeTraverser mRangeTraverser;
    private final boolean mHScrollAsyncMode;
    private final boolean mIncrementalMountEnabled;
    private final boolean mMoveLayoutsBetweenThreads;
    private final boolean mIsSubAdapter;
    private final boolean mHasManualEstimatedViewportCount;
    private final boolean mIsReconciliationEnabled;
    private final boolean mIsLayoutDiffingEnabled;
    private final boolean mRecyclerViewItemPrefetch;
    private final int mItemViewCacheSize;
    @Nullable
    private final ErrorEventHandler mErrorEventHandler;
    private final ComponentsConfiguration mComponentsConfiguration;
    private AtomicLong mCurrentChangeSetThreadId = new AtomicLong(-1L);
    @VisibleForTesting
    final boolean mTraverseLayoutBackwards;
    @GuardedBy(value="this")
    private final Deque<AsyncBatch> mAsyncBatches = new ArrayDeque<AsyncBatch>();
    private final AtomicBoolean mHasAsyncBatchesToCheck = new AtomicBoolean(false);
    private final AtomicBoolean mIsInMeasure = new AtomicBoolean(false);
    @ThreadConfined(value="UI")
    @VisibleForTesting
    final Deque<ChangeSetCompleteCallback> mDataRenderedCallbacks = new ArrayDeque<ChangeSetCompleteCallback>();
    @VisibleForTesting
    final Runnable mRemeasureRunnable = new Runnable(){

        @Override
        public void run() {
            if (RecyclerBinder.this.mReMeasureEventEventHandler != null) {
                RecyclerBinder.this.mReMeasureEventEventHandler.dispatchEvent((Object)new ReMeasureEvent());
            }
        }
    };
    private final PostDispatchDrawListener mPostDispatchDrawListener = new PostDispatchDrawListener(){

        @Override
        public void postDispatchDraw() {
            RecyclerBinder.this.maybeDispatchDataRendered();
        }
    };
    private final ViewTreeObserver.OnPreDrawListener mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        public boolean onPreDraw() {
            RecyclerBinder.this.maybeDispatchDataRendered();
            return true;
        }
    };
    private final View.OnAttachStateChangeListener mOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            RecyclerBinder.this.unregisterDrawListener((RecyclerView)v);
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    };
    private final Runnable mNotifyDatasetChangedRunnable = new Runnable(){

        @Override
        public void run() {
            RecyclerBinder.this.mInternalAdapter.notifyDataSetChanged();
        }
    };
    @Nullable
    private final ComponentTreeHolder.ComponentTreeMeasureListenerFactory mComponentTreeMeasureListenerFactory;
    @Nullable
    private ComponentWarmer mComponentWarmer;
    private final RunnableHandler mPreallocateMountContentHandler;
    private final boolean mPreallocatePerMountSpec;
    private final ComponentTree.NewLayoutStateReadyListener mAsyncLayoutReadyListener = new ComponentTree.NewLayoutStateReadyListener(){

        @UiThread
        public void onNewLayoutStateReady(ComponentTree componentTree) {
            RecyclerBinder.this.applyReadyBatches();
            componentTree.setNewLayoutStateReadyListener(null);
        }
    };
    private final ChoreographerCompat.FrameCallback mApplyReadyBatchesCallback = new ChoreographerCompat.FrameCallback(){

        @UiThread
        public void doFrame(long frameTimeNanos) {
            RecyclerBinder.this.applyReadyBatches();
        }
    };
    private final boolean mIsCircular;
    private final boolean mHasDynamicItemHeight;
    private final boolean mWrapContent;
    private boolean mCanMeasure;
    private int mLastWidthSpec = -1;
    private int mLastHeightSpec = -1;
    private Size mMeasuredSize;
    private RecyclerView mMountedView;
    @Nullable
    private RecyclerView mSubAdapterRecyclerView;
    @VisibleForTesting
    int mCurrentFirstVisiblePosition = -1;
    @VisibleForTesting
    int mCurrentLastVisiblePosition = -1;
    private int mCurrentOffset;
    private SmoothScrollAlignmentType mSmoothScrollAlignmentType;
    @VisibleForTesting
    int mEstimatedViewportCount = -1;
    @Nullable
    @VisibleForTesting
    volatile Size mSizeForMeasure;
    private StickyHeaderController mStickyHeaderController;
    @Nullable
    private StickyHeaderControllerFactory mStickyHeaderControllerFactory;
    @Nullable
    private final RunnableHandler mThreadPoolHandler;
    @Nullable
    private final LayoutThreadPoolConfiguration mThreadPoolConfig;
    private EventHandler<ReMeasureEvent> mReMeasureEventEventHandler;
    private volatile boolean mHasAsyncOperations = false;
    private boolean mIsInitMounted = false;
    private int mCommitPolicy = 0;
    private boolean mHasFilledViewport = false;
    @Nullable
    private LithoStartupLogger mStartupLogger;
    private String mStartupLoggerAttribution = "";
    private final boolean[] mFirstMountLogged = new boolean[1];
    private final boolean[] mLastMountLogged = new boolean[1];
    private final RecyclerBinderAdapterDelegate mRecyclerBinderAdapterDelegate;
    @Nullable
    @GuardedBy(value="this")
    private AsyncBatch mCurrentBatch = null;
    @VisibleForTesting
    final ViewportManager mViewportManager;
    private final ViewportInfo.ViewportChanged mViewportChangedListener = new ViewportInfo.ViewportChanged(){

        @Override
        public void viewportChanged(int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex, int state) {
            RecyclerBinder.this.onNewVisibleRange(firstVisibleIndex, lastVisibleIndex);
            RecyclerBinder.this.onNewWorkingRange(firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex);
        }
    };
    private int mPostUpdateViewportAttempts;
    @VisibleForTesting
    final RenderInfoViewCreatorController mRenderInfoViewCreatorController;
    private final Runnable mUpdateViewportRunnable = new Runnable(){

        @Override
        public void run() {
            if (RecyclerBinder.this.mMountedView == null || !RecyclerBinder.this.mMountedView.hasPendingAdapterUpdates()) {
                if (RecyclerBinder.this.mViewportManager.shouldUpdate()) {
                    RecyclerBinder.this.mViewportManager.onViewportChanged(1);
                }
                RecyclerBinder.this.mPostUpdateViewportAttempts = 0;
                return;
            }
            if (!RecyclerBinder.this.mMountedView.isAttachedToWindow() || RecyclerBinder.this.mMountedView.getVisibility() == 8) {
                RecyclerBinder.this.mPostUpdateViewportAttempts = 0;
                return;
            }
            if (RecyclerBinder.this.mPostUpdateViewportAttempts >= 3) {
                RecyclerBinder.this.mPostUpdateViewportAttempts = 0;
                if (RecyclerBinder.this.mViewportManager.shouldUpdate()) {
                    RecyclerBinder.this.mViewportManager.onViewportChanged(1);
                }
                return;
            }
            RecyclerBinder.this.mPostUpdateViewportAttempts++;
            ViewCompat.postOnAnimation((View)RecyclerBinder.this.mMountedView, (Runnable)RecyclerBinder.this.mUpdateViewportRunnable);
        }
    };
    static final ComponentTreeHolderFactory DEFAULT_COMPONENT_TREE_HOLDER_FACTORY;

    private ComponentTree.MeasureListener getMeasureListener(final ComponentTreeHolder holder) {
        return new ComponentTree.MeasureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSetRootAndSizeSpec(int layoutVersion, int width, int height, boolean stateUpdate) {
                if (holder.getMeasuredHeight() == height) {
                    return;
                }
                holder.setMeasuredHeight(height);
                int sizeForMeasure = RecyclerBinder.this.getSizeForMeasuring();
                if (sizeForMeasure != -1 && holder.getMeasuredHeight() <= sizeForMeasure) {
                    return;
                }
                RecyclerBinder recyclerBinder = RecyclerBinder.this;
                synchronized (recyclerBinder) {
                    RecyclerBinder.this.resetMeasuredSize(width);
                    RecyclerBinder.this.requestRemeasure();
                }
            }
        };
    }

    @Override
    public boolean isWrapContent() {
        return this.mWrapContent;
    }

    @Override
    public boolean canMeasure() {
        return this.mCanMeasure;
    }

    @Override
    public void setCanMeasure(boolean canMeasure) {
        this.mCanMeasure = canMeasure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() {
        if (this.mParentLifecycle != null) {
            return;
        }
        if (ThreadUtils.isMainThread()) {
            RecyclerBinder.releaseComponentTreeHolders(this.mComponentTreeHolders);
        } else {
            ArrayList<ComponentTreeHolder> toRelease;
            RecyclerBinder recyclerBinder = this;
            synchronized (recyclerBinder) {
                toRelease = new ArrayList<ComponentTreeHolder>(this.mComponentTreeHolders);
            }
            this.postReleaseComponentTreeHolders(toRelease);
        }
    }

    @UiThread
    private static void releaseComponentTreeHolders(List<ComponentTreeHolder> holders) {
        int size = holders.size();
        for (int i = 0; i < size; ++i) {
            holders.get(i).releaseTree();
        }
    }

    private void postReleaseComponentTreeHolders(final List<ComponentTreeHolder> holders) {
        this.mMainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                RecyclerBinder.releaseComponentTreeHolders(holders);
            }
        });
    }

    @UiThread
    public void notifyItemRenderCompleteAt(int position, long timestampMillis) {
        ComponentTreeHolder holder = this.mComponentTreeHolders.get(position);
        EventHandler<RenderCompleteEvent> renderCompleteEventHandler = holder.getRenderInfo().getRenderCompleteEventHandler();
        if (renderCompleteEventHandler == null) {
            return;
        }
        int state = holder.getRenderState();
        if (state != 0) {
            return;
        }
        ViewCompat.postOnAnimation((View)this.mMountedView, (Runnable)new RenderCompleteRunnable(renderCompleteEventHandler, RenderCompleteEvent.RenderState.RENDER_DRAWN, timestampMillis));
        holder.setRenderState(2);
    }

    @UiThread
    private static void dispatchRenderCompleteEvent(EventHandler<RenderCompleteEvent> renderCompleteEventHandler, RenderCompleteEvent.RenderState renderState, long timestampMillis) {
        ThreadUtils.assertMainThread();
        RenderCompleteEvent event = new RenderCompleteEvent();
        event.renderState = renderState;
        event.timestampMillis = timestampMillis;
        renderCompleteEventHandler.dispatchEvent((Object)event);
    }

    private RecyclerBinder(Builder builder) {
        this.mComponentContext = builder.componentContext;
        this.mParentLifecycle = builder.lifecycleProvider;
        this.mComponentTreeHolderFactory = builder.componentTreeHolderFactory;
        this.mEnableStableIds = builder.enableStableIds;
        this.mRecyclerBinderAdapterDelegate = builder.adapterDelegate != null ? builder.adapterDelegate : new DefaultRecyclerBinderAdapterDelegate();
        this.mInternalAdapter = builder.overrideInternalAdapter != null ? builder.overrideInternalAdapter : new InternalAdapter();
        this.mRangeRatio = builder.rangeRatio;
        this.mLayoutInfo = builder.layoutInfo;
        this.mLayoutHandlerFactory = builder.layoutHandlerFactory;
        this.mAsyncInsertHandler = builder.mAsyncInsertLayoutHandler;
        this.mLithoViewFactory = builder.lithoViewFactory;
        this.mAcquireStateHandlerOnRelease = builder.acquireStateHandlerOnRelease;
        this.mRecyclerViewItemPrefetch = builder.recyclerViewItemPrefetch;
        this.mItemViewCacheSize = builder.itemViewCacheSize;
        this.mComponentsConfiguration = builder.componentsConfiguration;
        if (this.mLayoutHandlerFactory == null) {
            if (builder.threadPoolConfig != null) {
                this.mThreadPoolConfig = builder.threadPoolConfig;
                this.mThreadPoolHandler = ThreadPoolLayoutHandler.getNewInstance((LayoutThreadPoolConfiguration)this.mThreadPoolConfig);
            } else if (ComponentsConfiguration.threadPoolConfiguration != null) {
                this.mThreadPoolConfig = ComponentsConfiguration.threadPoolConfiguration;
                this.mThreadPoolHandler = ThreadPoolLayoutHandler.getNewInstance((LayoutThreadPoolConfiguration)this.mThreadPoolConfig);
            } else {
                this.mThreadPoolConfig = null;
                this.mThreadPoolHandler = null;
            }
        } else {
            this.mThreadPoolConfig = null;
            this.mThreadPoolHandler = null;
        }
        this.mRenderInfoViewCreatorController = new RenderInfoViewCreatorController(builder.componentViewType);
        this.mIsCircular = builder.isCircular;
        this.mHasDynamicItemHeight = this.mLayoutInfo.getScrollDirection() == 0 ? builder.hasDynamicItemHeight : false;
        this.mComponentTreeMeasureListenerFactory = !this.mHasDynamicItemHeight ? null : new ComponentTreeHolder.ComponentTreeMeasureListenerFactory(){

            @Override
            @Nullable
            public ComponentTree.MeasureListener create(ComponentTreeHolder holder) {
                return RecyclerBinder.this.getMeasureListener(holder);
            }
        };
        this.mWrapContent = builder.wrapContent;
        this.mCanMeasure = builder.canMeasure;
        this.mTraverseLayoutBackwards = this.getStackFromEnd();
        this.mRangeTraverser = builder.recyclerRangeTraverser != null ? builder.recyclerRangeTraverser : (this.mTraverseLayoutBackwards ? RecyclerRangeTraverser.BACKWARD_TRAVERSER : RecyclerRangeTraverser.FORWARD_TRAVERSER);
        this.mViewportManager = new ViewportManager(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition, builder.layoutInfo);
        this.mInvalidStateLogParamsList = builder.invalidStateLogParamsList;
        if (builder.estimatedViewportCount != -1) {
            this.mEstimatedViewportCount = builder.estimatedViewportCount;
            this.mHasManualEstimatedViewportCount = true;
        } else {
            this.mHasManualEstimatedViewportCount = false;
        }
        this.mHScrollAsyncMode = builder.hscrollAsyncMode;
        this.mIncrementalMountEnabled = builder.incrementalMount;
        this.mVisibilityProcessingEnabled = builder.visibilityProcessing;
        this.mStickyHeaderControllerFactory = builder.stickyHeaderControllerFactory;
        this.mMoveLayoutsBetweenThreads = builder.canInterruptAndMoveLayoutsBetweenThreads;
        this.mIsSubAdapter = builder.isSubAdapter;
        this.mIsReconciliationEnabled = builder.isReconciliationEnabled;
        this.mIsLayoutDiffingEnabled = builder.isLayoutDiffingEnabled;
        this.mPreallocateMountContentHandler = builder.preallocateMountContentHandler;
        this.mPreallocatePerMountSpec = builder.shouldPreallocatePerMountSpec;
        this.mComponentWarmer = builder.mComponentWarmer;
        this.mStartupLogger = builder.startupLogger;
        this.mErrorEventHandler = builder.errorEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateItemAtAsync(int position, RenderInfo renderInfo) {
        this.assertSingleThreadForChangeSet();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") updateItemAtAsync " + position));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.addToCurrentBatch(new AsyncUpdateOperation(position, renderInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateRangeAtAsync(int position, List<RenderInfo> renderInfos) {
        this.assertSingleThreadForChangeSet();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") updateRangeAtAsync " + position + ", count: " + renderInfos.size()));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.addToCurrentBatch(new AsyncUpdateRangeOperation(position, renderInfos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertItemAtAsync(int position, RenderInfo renderInfo) {
        this.assertSingleThreadForChangeSet();
        this.assertNoInsertOperationIfCircular();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") insertItemAtAsync " + position + ", name: " + renderInfo.getName()));
        }
        RecyclerBinder.assertNotNullRenderInfo(renderInfo);
        AsyncInsertOperation operation = this.createAsyncInsertOperation(position, renderInfo);
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.mHasAsyncOperations = true;
            this.mAsyncComponentTreeHolders.add(position, operation.mHolder);
            this.registerAsyncInsert(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertRangeAtAsync(int position, List<RenderInfo> renderInfos) {
        int i;
        this.assertSingleThreadForChangeSet();
        this.assertNoInsertOperationIfCircular();
        if (SectionsDebug.ENABLED) {
            Object[] names = new String[renderInfos.size()];
            for (i = 0; i < renderInfos.size(); ++i) {
                names[i] = renderInfos.get(i).getName();
            }
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") insertRangeAtAsync " + position + ", size: " + renderInfos.size() + ", names: " + Arrays.toString(names)));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.mHasAsyncOperations = true;
            int size = renderInfos.size();
            for (i = 0; i < size; ++i) {
                RenderInfo renderInfo = renderInfos.get(i);
                RecyclerBinder.assertNotNullRenderInfo(renderInfo);
                AsyncInsertOperation operation = this.createAsyncInsertOperation(position + i, renderInfo);
                this.mAsyncComponentTreeHolders.add(position + i, operation.mHolder);
                this.registerAsyncInsert(operation);
            }
        }
    }

    private void ensureApplyReadyBatches() {
        if (ThreadUtils.isMainThread()) {
            this.applyReadyBatches();
        } else {
            ChoreographerCompatImpl.getInstance().postFrameCallback(this.mApplyReadyBatchesCallback);
        }
    }

    private boolean isRecyclerViewTargetComputingLayout() {
        if (this.mMountedView != null) {
            return this.mMountedView.isComputingLayout();
        }
        if (this.mSubAdapterRecyclerView != null) {
            return this.mSubAdapterRecyclerView.isComputingLayout();
        }
        return false;
    }

    public void setSubAdapterModeRecyclerView(RecyclerView recyclerView) {
        if (!this.mIsSubAdapter) {
            throw new IllegalStateException("Cannot set a subadapter RecyclerView on a RecyclerBinder which is not in subadapter mode.");
        }
        this.registerDrawListener(recyclerView);
        this.mSubAdapterRecyclerView = recyclerView;
        this.mIsInitMounted = true;
    }

    public void removeSubAdapterModeRecyclerView(RecyclerView recyclerView) {
        if (!this.mIsSubAdapter) {
            throw new IllegalStateException("Cannot remove a subadapter RecyclerView on a RecyclerBinder which is not in subadapter mode.");
        }
        this.unregisterDrawListener(recyclerView);
        this.maybeDispatchDataRendered();
        this.mSubAdapterRecyclerView = null;
    }

    @UiThread
    @VisibleForTesting
    void applyReadyBatches() {
        this.applyReadyBatchesWithRetry(0);
    }

    private String getState(RecyclerView recyclerView) {
        try {
            Field field = RecyclerView.class.getDeclaredField("mState");
            field.setAccessible(true);
            Object state = field.get(recyclerView);
            return state == null ? "null" : state.toString();
        }
        catch (Exception e) {
            return "Exception getting state: " + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    private void applyReadyBatchesWithRetry(final int retryCount) {
        ThreadUtils.assertMainThread();
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"applyReadyBatches");
        }
        try {
            if (!this.mHasAsyncBatchesToCheck.get() || !this.mIsMeasured.get() || this.mIsInMeasure.get()) {
                return;
            }
            if (this.isRecyclerViewTargetComputingLayout()) {
                if (retryCount > 100) {
                    RecyclerView mountedView = this.mIsSubAdapter ? this.mSubAdapterRecyclerView : this.mMountedView;
                    String exceptionMessage = "Too many retries -- RecyclerView is stuck in layout. Batch size: " + this.mAsyncBatches.size() + ", isSubAdapter: " + this.mIsSubAdapter;
                    exceptionMessage = mountedView == null ? exceptionMessage + ", mountedView: null" : exceptionMessage + ", isAttachedToWindow: " + mountedView.isAttachedToWindow() + ", isAnimating: " + mountedView.isAnimating() + ", state: " + this.getState(mountedView) + ", mountedView: " + mountedView;
                    throw ComponentUtils.wrapWithMetadata((ComponentContext)this.mComponentContext, (Exception)new RuntimeException(exceptionMessage));
                }
                ChoreographerCompatImpl.getInstance().postFrameCallback(new ChoreographerCompat.FrameCallback(){

                    public void doFrame(long frameTimeNanos) {
                        RecyclerBinder.this.applyReadyBatchesWithRetry(retryCount + 1);
                    }
                });
                return;
            }
            boolean appliedBatch = false;
            while (true) {
                AsyncBatch batch;
                RecyclerBinder recyclerBinder = this;
                synchronized (recyclerBinder) {
                    if (this.mAsyncBatches.isEmpty()) {
                        this.mHasAsyncBatchesToCheck.set(false);
                        break;
                    }
                    batch = this.mAsyncBatches.peekFirst();
                    if (!RecyclerBinder.isBatchReady(batch)) {
                        break;
                    }
                    this.mAsyncBatches.pollFirst();
                }
                this.applyBatch(batch);
                appliedBatch |= batch.mIsDataChanged;
            }
            if (appliedBatch) {
                if (LithoStartupLogger.isEnabled((LithoStartupLogger)this.mStartupLogger)) {
                    this.mStartupLoggerAttribution = this.mStartupLogger.getLatestDataAttribution();
                }
                this.maybeUpdateRangeOrRemeasureForMutation();
            }
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    private static boolean isBatchReady(AsyncBatch batch) {
        if (batch.mCommitPolicy == 0) {
            return true;
        }
        int size = batch.mOperations.size();
        for (int i = 0; i < size; ++i) {
            AsyncOperation operation = (AsyncOperation)batch.mOperations.get(i);
            if (!(operation instanceof AsyncInsertOperation) || ((AsyncInsertOperation)operation).mHolder.hasCompletedLatestLayout()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    private void applyBatch(AsyncBatch batch) {
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            int size = batch.mOperations.size();
            block11: for (int i = 0; i < size; ++i) {
                AsyncOperation operation = (AsyncOperation)batch.mOperations.get(i);
                switch (operation.mOperation) {
                    case 0: {
                        this.applyAsyncInsert((AsyncInsertOperation)operation);
                        continue block11;
                    }
                    case 1: {
                        AsyncUpdateOperation updateOperation = (AsyncUpdateOperation)operation;
                        this.updateItemAt(updateOperation.mPosition, updateOperation.mRenderInfo);
                        continue block11;
                    }
                    case 2: {
                        AsyncUpdateRangeOperation updateRangeOperation = (AsyncUpdateRangeOperation)operation;
                        this.updateRangeAt(updateRangeOperation.mPosition, updateRangeOperation.mRenderInfos);
                        continue block11;
                    }
                    case 3: {
                        this.removeItemAt(((AsyncRemoveOperation)operation).mPosition);
                        continue block11;
                    }
                    case 4: {
                        AsyncRemoveRangeOperation removeRangeOperation = (AsyncRemoveRangeOperation)operation;
                        this.removeRangeAt(removeRangeOperation.mPosition, removeRangeOperation.mCount);
                        continue block11;
                    }
                    case 5: {
                        AsyncMoveOperation moveOperation = (AsyncMoveOperation)operation;
                        this.moveItem(moveOperation.mFromPosition, moveOperation.mToPosition);
                        continue block11;
                    }
                    default: {
                        throw new RuntimeException("Unhandled operation type: " + operation.mOperation);
                    }
                }
            }
        }
        batch.mChangeSetCompleteCallback.onDataBound();
        this.mDataRenderedCallbacks.addLast(batch.mChangeSetCompleteCallback);
        this.maybeDispatchDataRendered();
    }

    @GuardedBy(value="this")
    @UiThread
    private void applyAsyncInsert(AsyncInsertOperation operation) {
        if (operation.mHolder.isInserted()) {
            return;
        }
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") applyAsyncInsert " + operation.mPosition));
        }
        this.mRenderInfoViewCreatorController.maybeTrackViewCreator(operation.mHolder.getRenderInfo());
        this.mComponentTreeHolders.add(operation.mPosition, operation.mHolder);
        operation.mHolder.setInserted(true);
        this.mInternalAdapter.notifyItemInserted(operation.mPosition);
        boolean shouldUpdate = this.mViewportManager.insertAffectsVisibleRange(operation.mPosition, 1, this.mEstimatedViewportCount);
        this.mViewportManager.setShouldUpdate(shouldUpdate);
    }

    @GuardedBy(value="this")
    private void registerAsyncInsert(AsyncInsertOperation operation) {
        this.addToCurrentBatch(operation);
        ComponentTreeHolder holder = operation.mHolder;
        holder.setNewLayoutReadyListener(this.mAsyncLayoutReadyListener);
        if (this.isMeasured()) {
            this.computeLayoutAsync(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void moveItemAsync(int fromPosition, int toPosition) {
        this.assertSingleThreadForChangeSet();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") moveItemAsync " + fromPosition + " to " + toPosition));
        }
        AsyncMoveOperation operation = new AsyncMoveOperation(fromPosition, toPosition);
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.mHasAsyncOperations = true;
            this.mAsyncComponentTreeHolders.add(toPosition, this.mAsyncComponentTreeHolders.remove(fromPosition));
            this.addToCurrentBatch(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeItemAtAsync(int position) {
        this.assertSingleThreadForChangeSet();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") removeItemAtAsync " + position));
        }
        AsyncRemoveOperation asyncRemoveOperation = new AsyncRemoveOperation(position);
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.mHasAsyncOperations = true;
            this.mAsyncComponentTreeHolders.remove(position);
            this.addToCurrentBatch(asyncRemoveOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRangeAtAsync(int position, int count) {
        this.assertSingleThreadForChangeSet();
        this.assertNoRemoveOperationIfCircular(count);
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") removeRangeAtAsync " + position + ", size: " + count));
        }
        AsyncRemoveRangeOperation operation = new AsyncRemoveRangeOperation(position, count);
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.mHasAsyncOperations = true;
            for (int i = 0; i < count; ++i) {
                this.mAsyncComponentTreeHolders.remove(position);
            }
            this.addToCurrentBatch(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearAsync() {
        this.assertSingleThreadForChangeSet();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") clear"));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            this.mHasAsyncOperations = true;
            int count = this.mAsyncComponentTreeHolders.size();
            this.mAsyncComponentTreeHolders.clear();
            AsyncRemoveRangeOperation operation = new AsyncRemoveRangeOperation(0, count);
            this.addToCurrentBatch(operation);
        }
    }

    @GuardedBy(value="this")
    private void addToCurrentBatch(AsyncOperation operation) {
        if (this.mCurrentBatch == null) {
            this.mCurrentBatch = new AsyncBatch(this.mCommitPolicy);
        }
        this.mCurrentBatch.mOperations.add(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void replaceAll(List<RenderInfo> renderInfos) {
        ArrayList<ComponentTreeHolder> toRelease;
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            if (this.mHasAsyncOperations) {
                throw new RuntimeException("Trying to do a sync replaceAll when using asynchronous mutations!");
            }
            toRelease = new ArrayList<ComponentTreeHolder>(this.mComponentTreeHolders);
            this.mComponentTreeHolders.clear();
            for (RenderInfo renderInfo : renderInfos) {
                this.mComponentTreeHolders.add(this.createComponentTreeHolder(renderInfo));
            }
        }
        this.mInternalAdapter.notifyDataSetChanged();
        this.mViewportManager.setShouldUpdate(true);
        this.postReleaseComponentTreeHolders(toRelease);
    }

    @UiThread
    public final void appendItem(Component component) {
        this.insertItemAt(this.getItemCount(), component);
    }

    @UiThread
    public final void appendItem(RenderInfo renderInfo) {
        this.insertItemAt(this.getItemCount(), renderInfo);
    }

    @UiThread
    public final void insertItemAt(int position, Component component) {
        this.insertItemAt(position, ComponentRenderInfo.create().component(component).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void insertItemAt(int position, RenderInfo renderInfo) {
        ThreadUtils.assertMainThread();
        this.assertNoInsertOperationIfCircular();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") insertItemAt " + position + ", name: " + renderInfo.getName()));
        }
        RecyclerBinder.assertNotNullRenderInfo(renderInfo);
        ComponentTreeHolder holder = this.createComponentTreeHolder(renderInfo);
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            if (this.mHasAsyncOperations) {
                throw new RuntimeException("Trying to do a sync insert when using asynchronous mutations!");
            }
            this.mComponentTreeHolders.add(position, holder);
            this.mRenderInfoViewCreatorController.maybeTrackViewCreator(renderInfo);
        }
        this.mInternalAdapter.notifyItemInserted(position);
        this.mViewportManager.setShouldUpdate(this.mViewportManager.insertAffectsVisibleRange(position, 1, this.mEstimatedViewportCount));
    }

    private Size getInitialMeasuredSize(int parentWidthSpec, int parentHeightSpec, boolean canRemeasure) {
        int measuredWidth;
        int measuredHeight;
        Size out = new Size();
        int scrollDirection = this.mLayoutInfo.getScrollDirection();
        boolean shouldMeasureItemForSize = RecyclerBinder.shouldMeasureItemForSize(parentWidthSpec, parentHeightSpec, scrollDirection, canRemeasure);
        switch (scrollDirection) {
            case 1: {
                measuredHeight = SizeSpec.getSize((int)parentHeightSpec);
                if (!shouldMeasureItemForSize) {
                    measuredWidth = SizeSpec.getSize((int)parentWidthSpec);
                    break;
                }
                if (this.mSizeForMeasure != null) {
                    measuredWidth = this.mSizeForMeasure.width;
                    break;
                }
                measuredWidth = 0;
                break;
            }
            default: {
                measuredWidth = SizeSpec.getSize((int)parentWidthSpec);
                measuredHeight = !shouldMeasureItemForSize ? SizeSpec.getSize((int)parentHeightSpec) : (this.mSizeForMeasure != null ? this.mSizeForMeasure.height : 0);
            }
        }
        out.width = measuredWidth;
        out.height = measuredHeight;
        return out;
    }

    private void maybeRequestRemeasureIfBoundsChanged() {
        if (this.mMeasuredSize.width == 0 || this.mMeasuredSize.height == 0) {
            this.requestRemeasure();
            return;
        }
        Size initialSize = this.getInitialMeasuredSize(this.mLastWidthSpec, this.mLastHeightSpec, true);
        Size wrapSize = new Size();
        this.fillListViewport(initialSize.width, initialSize.height, wrapSize);
        if (wrapSize.width != this.mMeasuredSize.width || wrapSize.height != this.mMeasuredSize.height) {
            this.requestRemeasure();
        }
    }

    private void requestRemeasure() {
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") requestRemeasure"));
        }
        if (this.mMountedView != null) {
            this.mMainThreadHandler.removeCallbacks(this.mRemeasureRunnable);
            this.mMountedView.removeCallbacks(this.mRemeasureRunnable);
            ViewCompat.postOnAnimation((View)this.mMountedView, (Runnable)this.mRemeasureRunnable);
        } else {
            this.mMainThreadHandler.removeCallbacks(this.mRemeasureRunnable);
            this.mMainThreadHandler.post(this.mRemeasureRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void insertRangeAt(int position, List<RenderInfo> renderInfos) {
        int i;
        ThreadUtils.assertMainThread();
        this.assertNoInsertOperationIfCircular();
        if (SectionsDebug.ENABLED) {
            Object[] names = new String[renderInfos.size()];
            for (i = 0; i < renderInfos.size(); ++i) {
                names[i] = renderInfos.get(i).getName();
            }
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") insertRangeAt " + position + ", size: " + renderInfos.size() + ", names: " + Arrays.toString(names)));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            int size = renderInfos.size();
            for (i = 0; i < size; ++i) {
                RenderInfo renderInfo = renderInfos.get(i);
                RecyclerBinder.assertNotNullRenderInfo(renderInfo);
                ComponentTreeHolder holder = this.createComponentTreeHolder(renderInfo);
                if (this.mHasAsyncOperations) {
                    throw new RuntimeException("Trying to do a sync insert when using asynchronous mutations!");
                }
                this.mComponentTreeHolders.add(position + i, holder);
                this.mRenderInfoViewCreatorController.maybeTrackViewCreator(renderInfo);
            }
        }
        this.mInternalAdapter.notifyItemRangeInserted(position, renderInfos.size());
        this.mViewportManager.setShouldUpdate(this.mViewportManager.insertAffectsVisibleRange(position, renderInfos.size(), this.mEstimatedViewportCount));
    }

    @UiThread
    public final void updateItemAt(int position, Component component) {
        this.updateItemAt(position, ComponentRenderInfo.create().component(component).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void updateItemAt(int position, RenderInfo renderInfo) {
        boolean renderInfoWasView;
        ThreadUtils.assertMainThread();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") updateItemAt " + position + ", name: " + renderInfo.getName()));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            if (this.mComponentTreeHolders.isEmpty()) {
                throw new RuntimeException("Trying to update an item while the list of components is empty (index=" + position + ", size=" + this.mComponentTreeHolders.size() + "). This likely means data passed to the section had duplicates or a mutable data model. Component involved in the error whose backing data model may have duplicates: " + renderInfo.getName() + ". Read more here: https://fblitho.com/docs/sections/best-practices/#avoiding-indexoutofboundsexception");
            }
            ComponentTreeHolder holder = this.mComponentTreeHolders.get(position);
            renderInfoWasView = holder.getRenderInfo().rendersView();
            RecyclerBinder.assertNotNullRenderInfo(renderInfo);
            this.mRenderInfoViewCreatorController.maybeTrackViewCreator(renderInfo);
            this.updateHolder(holder, renderInfo);
        }
        if (renderInfoWasView || renderInfo.rendersView()) {
            this.mInternalAdapter.notifyItemChanged(position);
        }
        this.mViewportManager.setShouldUpdate(this.mViewportManager.updateAffectsVisibleRange(position, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void updateRangeAt(int position, List<RenderInfo> renderInfos) {
        int i;
        ThreadUtils.assertMainThread();
        if (SectionsDebug.ENABLED) {
            Object[] names = new String[renderInfos.size()];
            for (i = 0; i < renderInfos.size(); ++i) {
                names[i] = renderInfos.get(i).getName();
            }
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") updateRangeAt " + position + ", size: " + renderInfos.size() + ", names: " + Arrays.toString(names)));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            try {
                int size = renderInfos.size();
                for (i = 0; i < size; ++i) {
                    ComponentTreeHolder holder = this.mComponentTreeHolders.get(position + i);
                    RenderInfo newRenderInfo = renderInfos.get(i);
                    RecyclerBinder.assertNotNullRenderInfo(newRenderInfo);
                    if (newRenderInfo.rendersView() || holder.getRenderInfo().rendersView()) {
                        this.mInternalAdapter.notifyItemChanged(position + i);
                    }
                    this.mRenderInfoViewCreatorController.maybeTrackViewCreator(newRenderInfo);
                    this.updateHolder(holder, newRenderInfo);
                }
            }
            catch (IndexOutOfBoundsException e) {
                Object[] names = new String[renderInfos.size()];
                for (int i2 = 0; i2 < renderInfos.size(); ++i2) {
                    names[i2] = renderInfos.get(i2).getName();
                }
                String debugInfo = "(" + this.hashCode() + ") updateRangeAt " + position + ", size: " + renderInfos.size() + ", names: " + Arrays.toString(names);
                throw new IndexOutOfBoundsException(debugInfo + e.getMessage());
            }
        }
        this.mViewportManager.setShouldUpdate(this.mViewportManager.updateAffectsVisibleRange(position, renderInfos.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void moveItem(int fromPosition, int toPosition) {
        boolean isNewPositionInRange;
        ComponentTreeHolder holder;
        ThreadUtils.assertMainThread();
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") moveItem " + fromPosition + " to " + toPosition));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            holder = this.mComponentTreeHolders.remove(fromPosition);
            this.mComponentTreeHolders.add(toPosition, holder);
            isNewPositionInRange = this.mEstimatedViewportCount != -1 && (float)toPosition >= (float)this.mCurrentFirstVisiblePosition - (float)this.mEstimatedViewportCount * this.mRangeRatio && (float)toPosition <= (float)this.mCurrentLastVisiblePosition + (float)this.mEstimatedViewportCount * this.mRangeRatio;
        }
        boolean isTreeValid = holder.isTreeValid();
        if (isTreeValid && !isNewPositionInRange) {
            holder.acquireStateAndReleaseTree(this.mAcquireStateHandlerOnRelease);
        }
        this.mInternalAdapter.notifyItemMoved(fromPosition, toPosition);
        this.mViewportManager.setShouldUpdate(this.mViewportManager.moveAffectsVisibleRange(fromPosition, toPosition, this.mCurrentLastVisiblePosition - this.mCurrentFirstVisiblePosition + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void removeItemAt(int position) {
        ComponentTreeHolder holder;
        ThreadUtils.assertMainThread();
        this.assertNoRemoveOperationIfCircular(1);
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") removeItemAt " + position));
        }
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            holder = this.mComponentTreeHolders.remove(position);
        }
        this.mInternalAdapter.notifyItemRemoved(position);
        this.mViewportManager.setShouldUpdate(this.mViewportManager.removeAffectsVisibleRange(position, 1));
        this.mMainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                holder.releaseTree();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public final void removeRangeAt(int position, int count) {
        ThreadUtils.assertMainThread();
        this.assertNoRemoveOperationIfCircular(count);
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") removeRangeAt " + position + ", size: " + count));
        }
        ArrayList<ComponentTreeHolder> toRelease = new ArrayList<ComponentTreeHolder>();
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            for (int i = 0; i < count; ++i) {
                ComponentTreeHolder holder = this.mComponentTreeHolders.remove(position);
                toRelease.add(holder);
            }
        }
        this.mInternalAdapter.notifyItemRangeRemoved(position, count);
        this.mViewportManager.setShouldUpdate(this.mViewportManager.removeAffectsVisibleRange(position, count));
        this.postReleaseComponentTreeHolders(toRelease);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChangeSetCompleteAsync(boolean isDataChanged, ChangeSetCompleteCallback changeSetCompleteCallback) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"notifyChangeSetCompleteAsync");
        }
        try {
            if (SectionsDebug.ENABLED) {
                Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") notifyChangeSetCompleteAsync"));
            }
            this.mHasAsyncOperations = true;
            this.assertSingleThreadForChangeSet();
            this.closeCurrentBatch(isDataChanged, changeSetCompleteCallback);
            if (ThreadUtils.isMainThread()) {
                this.applyReadyBatches();
                if (isDataChanged) {
                    if (LithoStartupLogger.isEnabled((LithoStartupLogger)this.mStartupLogger)) {
                        this.mStartupLoggerAttribution = this.mStartupLogger.getLatestDataAttribution();
                    }
                    this.maybeUpdateRangeOrRemeasureForMutation();
                }
            } else if (this.mIsMeasured.get()) {
                ChoreographerCompatImpl.getInstance().postFrameCallback(this.mApplyReadyBatchesCallback);
            }
            this.clearThreadForChangeSet();
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public void notifyChangeSetComplete(boolean isDataChanged, @Nullable ChangeSetCompleteCallback changeSetCompleteCallback) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"notifyChangeSetComplete");
        }
        try {
            if (SectionsDebug.ENABLED) {
                Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") notifyChangeSetComplete"));
            }
            ThreadUtils.assertMainThread();
            if (this.mHasAsyncOperations) {
                throw new RuntimeException("Trying to do a sync notifyChangeSetComplete when using asynchronous mutations!");
            }
            if (changeSetCompleteCallback != null) {
                changeSetCompleteCallback.onDataBound();
                this.mDataRenderedCallbacks.addLast(changeSetCompleteCallback);
            }
            this.maybeDispatchDataRendered();
            if (isDataChanged) {
                if (LithoStartupLogger.isEnabled((LithoStartupLogger)this.mStartupLogger)) {
                    this.mStartupLoggerAttribution = this.mStartupLogger.getLatestDataAttribution();
                }
                this.maybeUpdateRangeOrRemeasureForMutation();
            }
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    @GuardedBy(value="this")
    private void maybeFillHScrollViewport() {
        if (!this.mHScrollAsyncMode || this.mHasFilledViewport) {
            return;
        }
        this.mCommitPolicy = 1;
        if (ThreadUtils.isMainThread()) {
            this.applyReadyBatches();
        } else {
            if (!this.mComponentTreeHolders.isEmpty()) {
                this.fillListViewport(this.mMeasuredSize.width, this.mMeasuredSize.height, null);
            } else if (!this.mAsyncBatches.isEmpty()) {
                ArrayList<ComponentTreeHolder> insertsInFirstBatch = new ArrayList<ComponentTreeHolder>();
                for (AsyncOperation operation : this.mAsyncBatches.getFirst().mOperations) {
                    if (!(operation instanceof AsyncInsertOperation)) continue;
                    insertsInFirstBatch.add(((AsyncInsertOperation)operation).mHolder);
                }
                this.computeLayoutsToFillListViewport(insertsInFirstBatch, 0, this.mMeasuredSize.width, this.mMeasuredSize.height, null);
            }
            ChoreographerCompatImpl.getInstance().postFrameCallback(this.mApplyReadyBatchesCallback);
        }
        this.mHasFilledViewport = true;
    }

    @ThreadConfined(value="UI")
    private void maybeDispatchDataRendered() {
        RecyclerView recyclerView;
        ThreadUtils.assertMainThread();
        if (this.mDataRenderedCallbacks.isEmpty()) {
            return;
        }
        if (!this.mIsInitMounted) {
            return;
        }
        RecyclerView recyclerView2 = recyclerView = this.mIsSubAdapter ? this.mSubAdapterRecyclerView : this.mMountedView;
        if (!(recyclerView != null && recyclerView.hasPendingAdapterUpdates() && recyclerView.isAttachedToWindow() && RecyclerBinder.isVisibleToUser((View)recyclerView))) {
            final boolean isMounted = recyclerView != null;
            final ArrayDeque<ChangeSetCompleteCallback> snapshotCallbacks = new ArrayDeque<ChangeSetCompleteCallback>(this.mDataRenderedCallbacks);
            this.mDataRenderedCallbacks.clear();
            this.mMainThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    long uptimeMillis = SystemClock.uptimeMillis();
                    while (!snapshotCallbacks.isEmpty()) {
                        ((ChangeSetCompleteCallback)snapshotCallbacks.pollFirst()).onDataRendered(isMounted, uptimeMillis);
                    }
                }
            });
        } else if (this.mDataRenderedCallbacks.size() > 20) {
            this.mDataRenderedCallbacks.clear();
            StringBuilder messageBuilder = new StringBuilder();
            if (recyclerView == null) {
                messageBuilder.append("recyclerView == null");
            } else {
                messageBuilder.append("recyclerView: ").append(recyclerView).append(", hasPendingAdapterUpdates(): ").append(recyclerView.hasPendingAdapterUpdates()).append(", isAttachedToWindow(): ").append(recyclerView.isAttachedToWindow()).append(", getWindowVisibility(): ").append(recyclerView.getWindowVisibility()).append(", vie visible hierarchy: ").append(RecyclerBinder.getVisibleHierarchy((View)recyclerView)).append(", getGlobalVisibleRect(): ").append(recyclerView.getGlobalVisibleRect(sDummyRect)).append(", isComputingLayout(): ").append(recyclerView.isComputingLayout()).append(", isSubAdapter: ").append(this.mIsSubAdapter);
            }
            messageBuilder.append(", visible range: [").append(this.mCurrentFirstVisiblePosition).append(", ").append(this.mCurrentLastVisiblePosition).append("]");
            ComponentsReporter.emitMessage((ComponentsReporter.LogLevel)ComponentsReporter.LogLevel.ERROR, (String)DATA_RENDERED_NOT_TRIGGERED, (String)("@OnDataRendered callbacks aren't triggered as expected: " + messageBuilder));
        }
    }

    private synchronized void closeCurrentBatch(boolean isDataChanged, ChangeSetCompleteCallback changeSetCompleteCallback) {
        if (this.mCurrentBatch == null) {
            this.mCurrentBatch = new AsyncBatch(this.mCommitPolicy);
        }
        this.mCurrentBatch.mIsDataChanged = isDataChanged;
        this.mCurrentBatch.mChangeSetCompleteCallback = changeSetCompleteCallback;
        this.mAsyncBatches.addLast(this.mCurrentBatch);
        this.mHasAsyncBatchesToCheck.set(true);
        this.mCurrentBatch = null;
    }

    private void maybeUpdateRangeOrRemeasureForMutation() {
        int initialComponentPosition;
        if (!this.mIsMeasured.get()) {
            return;
        }
        if (this.mRequiresRemeasure.get() || this.mWrapContent) {
            this.maybeRequestRemeasureIfBoundsChanged();
            if (!this.mWrapContent) {
                return;
            }
        }
        if (!this.hasComputedRange() && (initialComponentPosition = RecyclerBinder.findInitialComponentPosition(this.mComponentTreeHolders, this.mTraverseLayoutBackwards)) >= 0) {
            ComponentTreeHolderRangeInfo holderRangeInfo = new ComponentTreeHolderRangeInfo(initialComponentPosition, this.mComponentTreeHolders);
            this.initRange(this.mMeasuredSize.width, this.mMeasuredSize.height, holderRangeInfo, this.mLayoutInfo.getScrollDirection());
        }
        this.maybePostUpdateViewportAndComputeRange();
    }

    private void assertSingleThreadForChangeSet() {
        long previousThreadId;
        if (!ComponentsConfiguration.isDebugModeEnabled && !ComponentsConfiguration.isEndToEndTestRun) {
            return;
        }
        long currentThreadId = Thread.currentThread().getId();
        if (currentThreadId != (previousThreadId = this.mCurrentChangeSetThreadId.getAndSet(currentThreadId)) && previousThreadId != -1L) {
            throw new IllegalStateException("Multiple threads applying change sets at once! (" + previousThreadId + " and " + currentThreadId + ")");
        }
    }

    private void clearThreadForChangeSet() {
        if (!ComponentsConfiguration.isDebugModeEnabled && !ComponentsConfiguration.isEndToEndTestRun) {
            return;
        }
        this.mCurrentChangeSetThreadId.set(-1L);
    }

    @Override
    @Nullable
    public final synchronized ComponentTree getComponentAt(int position) {
        return this.mComponentTreeHolders.get(position).getComponentTree();
    }

    @Override
    public final synchronized ComponentTree getComponentForStickyHeaderAt(int position) {
        int childrenHeightSpec;
        int childrenWidthSpec;
        ComponentTreeHolder holder = this.mComponentTreeHolders.get(position);
        if (holder.isTreeValidForSizeSpecs(childrenWidthSpec = this.getActualChildrenWidthSpec(holder), childrenHeightSpec = this.getActualChildrenHeightSpec(holder))) {
            return holder.getComponentTree();
        }
        holder.computeLayoutSync(this.mComponentContext, childrenWidthSpec, childrenHeightSpec, null);
        return holder.getComponentTree();
    }

    @Override
    @UiThread
    public final synchronized RenderInfo getRenderInfoAt(int position) {
        ThreadUtils.assertMainThread();
        return this.mComponentTreeHolders.get(position).getRenderInfo();
    }

    @UiThread
    public final synchronized ComponentTreeHolder getComponentTreeHolderAt(int position) {
        ThreadUtils.assertMainThread();
        return this.mComponentTreeHolders.get(position);
    }

    @VisibleForTesting
    final synchronized List<ComponentTreeHolder> getComponentTreeHolders() {
        return this.mComponentTreeHolders;
    }

    private static void assertNotNullRenderInfo(RenderInfo renderInfo) {
        if (renderInfo == null) {
            throw new RuntimeException("Received null RenderInfo to insert/update!");
        }
    }

    @Override
    public void bind(RecyclerView view) {
    }

    @Override
    public void unbind(RecyclerView view) {
    }

    private static void validateMeasureSpecs(int widthSpec, int heightSpec, boolean canRemeasure, int scrollDirection) {
        switch (scrollDirection) {
            case 0: {
                if (SizeSpec.getMode((int)widthSpec) == 0) {
                    throw new IllegalStateException("Width mode has to be EXACTLY OR AT MOST for an horizontal scrolling RecyclerView");
                }
                if (canRemeasure || SizeSpec.getMode((int)heightSpec) != 0) break;
                throw new IllegalStateException("Can't use Unspecified height on an horizontal scrolling Recycler if dynamic measurement is not allowed");
            }
            case 1: {
                if (SizeSpec.getMode((int)heightSpec) == 0) {
                    throw new IllegalStateException("Height mode has to be EXACTLY OR AT MOST for a vertical scrolling RecyclerView");
                }
                if (canRemeasure || SizeSpec.getMode((int)widthSpec) != 0) break;
                throw new IllegalStateException("Can't use Unspecified width on a vertical scrolling Recycler if dynamic measurement is not allowed");
            }
            default: {
                throw new UnsupportedOperationException("The orientation defined by LayoutInfo should be either OrientationHelper.HORIZONTAL or OrientationHelper.VERTICAL");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void measure(Size outSize, int widthSpec, int heightSpec, @Nullable EventHandler<ReMeasureEvent> reMeasureEventHandler) {
        canRemeasure = reMeasureEventHandler != null;
        scrollDirection = this.mLayoutInfo.getScrollDirection();
        RecyclerBinder.validateMeasureSpecs(widthSpec, heightSpec, canRemeasure, scrollDirection);
        shouldMeasureItemForSize = RecyclerBinder.shouldMeasureItemForSize(widthSpec, heightSpec, scrollDirection, canRemeasure);
        if (this.mHasManualEstimatedViewportCount && shouldMeasureItemForSize) {
            throw new RuntimeException("Cannot use manual estimated viewport count when the RecyclerBinder needs an item to determine its size!");
        }
        this.mIsInMeasure.set(true);
        var8_8 = this;
        synchronized (var8_8) {
            if (this.mLastWidthSpec == -1 || this.mRequiresRemeasure.get() || this.mWrapContent) break block24;
            switch (scrollDirection) {
                case 1: {
                    if (this.mMeasuredSize != null && MeasureComparisonUtils.isMeasureSpecCompatible((int)this.mLastWidthSpec, (int)widthSpec, (int)this.mMeasuredSize.width)) {
                        outSize.width = this.mMeasuredSize.width;
                        outSize.height = this.mWrapContent != false ? this.mMeasuredSize.height : SizeSpec.getSize((int)heightSpec);
                        // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 7, 23] lbl17 : MonitorExitStatement: MONITOREXIT : var8_8
                        this.mIsInMeasure.set(false);
                        if (this.mHasAsyncOperations == false) return;
                        this.ensureApplyReadyBatches();
                        return;
                    }
                    break block25;
                }
                default: {
                    if (this.mMeasuredSize == null) break block25;
                    break;
                }
            }
        }
        {
            block24: {
                block25: {
                    if (MeasureComparisonUtils.isMeasureSpecCompatible((int)this.mLastHeightSpec, (int)heightSpec, (int)this.mMeasuredSize.height)) {
                        outSize.width = this.mWrapContent != false ? this.mMeasuredSize.width : SizeSpec.getSize((int)widthSpec);
                        outSize.height = this.mMeasuredSize.height;
                        // MONITOREXIT @DISABLED, blocks:[21, 5] lbl32 : MonitorExitStatement: MONITOREXIT : var8_8
                        this.mIsInMeasure.set(false);
                        if (this.mHasAsyncOperations == false) return;
                        this.ensureApplyReadyBatches();
                        return;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [6 : 292->681)] { 
lbl39:
                // 1 sources

                this.mIsMeasured.set(false);
                this.invalidateLayoutData();
            }
            this.mLastWidthSpec = widthSpec;
            this.mLastHeightSpec = heightSpec;
            if (!this.hasComputedRange() && (holderForRangeInfo = this.getHolderForRangeInfo()) != null) {
                this.initRange(SizeSpec.getSize((int)widthSpec), SizeSpec.getSize((int)heightSpec), holderForRangeInfo, scrollDirection);
            }
            initialMeasuredSize = this.getInitialMeasuredSize(widthSpec, heightSpec, canRemeasure);
            switch (scrollDirection) {
                case 1: {
                    if (!shouldMeasureItemForSize || this.mSizeForMeasure != null) {
                        this.mReMeasureEventEventHandler = this.mWrapContent != false ? reMeasureEventHandler : null;
                        break;
                    }
                    this.mReMeasureEventEventHandler = reMeasureEventHandler;
                    this.mRequiresRemeasure.set(this.mWrapContent == false);
                    break;
                }
                default: {
                    if (!shouldMeasureItemForSize || this.mSizeForMeasure != null) {
                        this.mReMeasureEventEventHandler = this.mHasDynamicItemHeight != false || this.mWrapContent != false ? reMeasureEventHandler : null;
                        this.mRequiresRemeasure.set(this.mHasDynamicItemHeight);
                        break;
                    }
                    this.mReMeasureEventEventHandler = reMeasureEventHandler;
                    this.mRequiresRemeasure.set(this.mWrapContent == false);
                }
            }
            if (this.mWrapContent) {
                wrapSize = new Size();
                this.fillListViewport(initialMeasuredSize.width, initialMeasuredSize.height, wrapSize);
                outSize.width = wrapSize.width;
                outSize.height = wrapSize.height;
            } else {
                outSize.width = initialMeasuredSize.width;
                outSize.height = initialMeasuredSize.height;
            }
            this.mMeasuredSize = new Size(outSize.width, outSize.height);
            this.mIsMeasured.set(true);
            if (this.mComponentWarmer != null) {
                this.mComponentWarmer.setComponentTreeHolderFactory(this.getComponentTreeHolderPreparer());
            }
            this.maybeFillHScrollViewport();
            this.updateAsyncInsertOperations();
            if (this.mEstimatedViewportCount == -1) return;
            this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
            return;
lbl79:
            // 1 sources

            finally {
                this.mIsInMeasure.set(false);
                if (this.mHasAsyncOperations) {
                    this.ensureApplyReadyBatches();
                }
            }
        }
    }

    private boolean isMeasured() {
        return this.mIsMeasured.get() && !this.mRequiresRemeasure.get();
    }

    static boolean shouldMeasureItemForSize(int widthSpec, int heightSpec, int scrollDirection, boolean canRemeasure) {
        boolean canUseSizeSpec = scrollDirection == 1 ? SizeSpec.getMode((int)widthSpec) == 0x40000000 : SizeSpec.getMode((int)heightSpec) == 0x40000000;
        return !canUseSizeSpec && canRemeasure;
    }

    @GuardedBy(value="this")
    private void fillListViewport(int maxWidth, int maxHeight, @Nullable Size outSize) {
        ComponentTreeHolderRangeInfo holderForRangeInfo;
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"fillListViewport");
        }
        int firstVisiblePosition = this.mWrapContent ? 0 : this.mLayoutInfo.findFirstVisibleItemPosition();
        int startIndex = firstVisiblePosition != -1 ? firstVisiblePosition : 0;
        this.computeLayoutsToFillListViewport(this.mComponentTreeHolders, startIndex, maxWidth, maxHeight, outSize);
        if (!this.hasComputedRange() && (holderForRangeInfo = this.getHolderForRangeInfo()) != null) {
            this.initRange(maxWidth, maxHeight, holderForRangeInfo, this.mLayoutInfo.getScrollDirection());
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    @VisibleForTesting
    @GuardedBy(value="this")
    int computeLayoutsToFillListViewport(List<ComponentTreeHolder> holders, int offset, int maxWidth, int maxHeight, @Nullable Size outputSize) {
        ComponentTreeHolder holder;
        RenderInfo renderInfo;
        LayoutInfo.ViewportFiller filler = this.mLayoutInfo.createViewportFiller(maxWidth, maxHeight);
        if (filler == null) {
            return 0;
        }
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"computeLayoutsToFillListViewport");
        }
        int widthSpec = SizeSpec.makeSizeSpec((int)maxWidth, (int)0x40000000);
        int heightSpec = SizeSpec.makeSizeSpec((int)maxHeight, (int)0x40000000);
        Size outSize = new Size();
        int numInserted = 0;
        int index = offset;
        while (filler.wantsMore() && index < holders.size() && !(renderInfo = (holder = holders.get(index)).getRenderInfo()).rendersView()) {
            holder.computeLayoutSync(this.mComponentContext, this.mLayoutInfo.getChildWidthSpec(widthSpec, renderInfo), this.mLayoutInfo.getChildHeightSpec(heightSpec, renderInfo), outSize);
            filler.add(renderInfo, outSize.width, outSize.height);
            ++index;
            ++numInserted;
        }
        if (outputSize != null) {
            int fill = filler.getFill();
            if (this.mLayoutInfo.getScrollDirection() == 1) {
                outputSize.width = maxWidth;
                outputSize.height = Math.min(fill, maxHeight);
            } else {
                outputSize.width = Math.min(fill, maxWidth);
                outputSize.height = maxHeight;
            }
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        this.logFillViewportInserted(numInserted, holders.size());
        return numInserted;
    }

    private void logFillViewportInserted(int numInserted, int totalSize) {
        if (SectionsDebug.ENABLED) {
            Log.d((String)"SectionsDebug", (String)("(" + this.hashCode() + ") filled viewport with " + numInserted + " items (holder.size() = " + totalSize + ")"));
        }
    }

    @GuardedBy(value="this")
    private void updateAsyncInsertOperations() {
        for (AsyncBatch batch : this.mAsyncBatches) {
            this.updateBatch(batch);
        }
        if (this.mCurrentBatch != null) {
            this.updateBatch(this.mCurrentBatch);
        }
    }

    @GuardedBy(value="this")
    private void updateBatch(AsyncBatch batch) {
        for (AsyncOperation operation : batch.mOperations) {
            if (!(operation instanceof AsyncInsertOperation)) continue;
            ComponentTreeHolder holder = ((AsyncInsertOperation)operation).mHolder;
            this.computeLayoutAsync(holder);
        }
    }

    @GuardedBy(value="this")
    private void computeLayoutAsync(final ComponentTreeHolder holder) {
        int heightSpec;
        final int widthSpec = this.getActualChildrenWidthSpec(holder);
        if (holder.isTreeValidForSizeSpecs(widthSpec, heightSpec = this.getActualChildrenHeightSpec(holder))) {
            ComponentTree componentTree;
            ComponentTree.NewLayoutStateReadyListener listener;
            if (holder.hasCompletedLatestLayout() && (listener = (componentTree = holder.getComponentTree()).getNewLayoutStateReadyListener()) != null) {
                componentTree.setNewLayoutStateReadyListener(null);
            }
            return;
        }
        if (this.mAsyncInsertHandler != null) {
            this.mAsyncInsertHandler.post(new Runnable(){

                @Override
                public void run() {
                    holder.computeLayoutSync(RecyclerBinder.this.mComponentContext, widthSpec, heightSpec, new Size());
                }
            }, "AsyncInsertLayout");
        } else {
            holder.computeLayoutAsync(this.mComponentContext, widthSpec, heightSpec);
        }
    }

    static int findInitialComponentPosition(List<ComponentTreeHolder> holders, boolean traverseBackwards) {
        if (traverseBackwards) {
            for (int i = holders.size() - 1; i >= 0; --i) {
                if (!holders.get(i).getRenderInfo().rendersComponent()) continue;
                return i;
            }
        } else {
            int size = holders.size();
            for (int i = 0; i < size; ++i) {
                if (!holders.get(i).getRenderInfo().rendersComponent()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int getItemCount() {
        return this.mInternalAdapter.getItemCount();
    }

    private void assertNoInsertOperationIfCircular() {
        if (this.mIsCircular && !this.mComponentTreeHolders.isEmpty()) {
            throw new UnsupportedOperationException("Circular lists do not support insert operation");
        }
    }

    @GuardedBy(value="this")
    private void assertNoRemoveOperationIfCircular(int removeCount) {
        if (this.mIsCircular && !this.mComponentTreeHolders.isEmpty() && this.mComponentTreeHolders.size() != removeCount) {
            throw new UnsupportedOperationException("Circular lists do not support insert operation");
        }
    }

    @GuardedBy(value="this")
    private void invalidateLayoutData() {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"invalidateLayoutData");
        }
        if (!this.mHasManualEstimatedViewportCount) {
            this.mEstimatedViewportCount = -1;
        }
        this.mSizeForMeasure = null;
        int size = this.mComponentTreeHolders.size();
        for (int i = 0; i < size; ++i) {
            this.mComponentTreeHolders.get(i).invalidateTree();
        }
        if (Looper.myLooper() == Looper.getMainLooper() && !this.isRecyclerViewTargetComputingLayout()) {
            this.mInternalAdapter.notifyDataSetChanged();
        } else {
            this.mMainThreadHandler.removeCallbacks(this.mNotifyDatasetChangedRunnable);
            this.mMainThreadHandler.post(this.mNotifyDatasetChangedRunnable);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    @GuardedBy(value="this")
    private void maybeScheduleAsyncLayoutsDuringInitRange(ComponentAsyncInitRangeIterator asyncRangeIterator) {
        if (this.mComponentTreeHolders == null || this.mComponentTreeHolders.isEmpty()) {
            return;
        }
        int numItemsToSchedule = this.mThreadPoolConfig == null ? 1 : this.mThreadPoolConfig.getCorePoolSize();
        for (int i = 0; i < numItemsToSchedule; ++i) {
            this.maybeScheduleOneAsyncLayoutDuringInitRange(asyncRangeIterator);
        }
    }

    private void maybeScheduleOneAsyncLayoutDuringInitRange(final ComponentAsyncInitRangeIterator asyncRangeIterator) {
        int childHeightSpec;
        final ComponentTreeHolder nextHolder = asyncRangeIterator.next();
        if (this.mComponentTreeHolders == null || this.mComponentTreeHolders.isEmpty() || nextHolder == null || this.mEstimatedViewportCount != -1) {
            return;
        }
        int childWidthSpec = this.getActualChildrenWidthSpec(nextHolder);
        if (nextHolder.isTreeValidForSizeSpecs(childWidthSpec, childHeightSpec = this.getActualChildrenHeightSpec(nextHolder))) {
            return;
        }
        ComponentTree.MeasureListener measureListener = new ComponentTree.MeasureListener(){

            public void onSetRootAndSizeSpec(int layoutVersion, int w, int h, boolean stateUpdate) {
                RecyclerBinder.this.maybeScheduleOneAsyncLayoutDuringInitRange(asyncRangeIterator);
                nextHolder.clearMeasureListener(this);
            }
        };
        nextHolder.computeLayoutAsync(this.mComponentContext, childWidthSpec, childHeightSpec, measureListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @GuardedBy(value="this")
    void initRange(int width, int height, ComponentTreeHolderRangeInfo holderRangeInfo, int scrollDirection) {
        String logTag;
        ComponentsLogger logger;
        if (this.mHasManualEstimatedViewportCount) {
            return;
        }
        boolean isTracing = ComponentsSystrace.isTracing();
        boolean loggingForStartup = LithoStartupLogger.isEnabled((LithoStartupLogger)this.mStartupLogger);
        ComponentAsyncInitRangeIterator asyncInitRangeIterator = new ComponentAsyncInitRangeIterator(holderRangeInfo.mHolders, holderRangeInfo.mPosition, this.mComponentTreeHolders.size() - 1, this.mTraverseLayoutBackwards);
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"maybeScheduleAsyncLayoutsDuringInitRange");
        }
        this.maybeScheduleAsyncLayoutsDuringInitRange(asyncInitRangeIterator);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        ComponentTreeHolder holder = (ComponentTreeHolder)holderRangeInfo.mHolders.get(holderRangeInfo.mPosition);
        int childWidthSpec = this.getActualChildrenWidthSpec(holder);
        int childHeightSpec = this.getActualChildrenHeightSpec(holder);
        if (loggingForStartup) {
            this.mStartupLogger.markPoint("_firstlayout", "_start", this.mStartupLoggerAttribution);
        }
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"firstLayout");
        }
        if (this.mComponentContext.getLogger() != null) {
            logger = this.mComponentContext.getLogger();
            logTag = this.mComponentContext.getLogTag();
        } else {
            logger = holder.getRenderInfo().getComponentsLogger();
            logTag = holder.getRenderInfo().getLogTag();
        }
        PerfEvent logInitRange = logger == null ? null : LogTreePopulator.populatePerfEventFromLogger((ComponentContext)this.mComponentContext, (ComponentsLogger)logger, (String)logTag, (PerfEvent)logger.newPerformanceEvent(this.mComponentContext, 20));
        try {
            Size size = new Size();
            holder.computeLayoutSync(this.mComponentContext, childWidthSpec, childHeightSpec, size);
            int rangeSize = Math.max(this.mLayoutInfo.approximateRangeSize(size.width, size.height, width, height), 1);
            this.mSizeForMeasure = size;
            this.mEstimatedViewportCount = rangeSize;
        }
        finally {
            if (logInitRange != null) {
                logger.logPerfEvent(logInitRange);
            }
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            if (loggingForStartup) {
                this.mStartupLogger.markPoint("_firstlayout", "_end", this.mStartupLoggerAttribution);
            }
        }
    }

    private void setRangeSize(int itemWidth, int itemHeight, int width, int height) {
        if (this.mHasManualEstimatedViewportCount) {
            throw new RuntimeException("Cannot override range size when manual estimated viewport count is set");
        }
        this.mEstimatedViewportCount = Math.max(this.mLayoutInfo.approximateRangeSize(itemWidth, itemHeight, width, height), 1);
    }

    @GuardedBy(value="this")
    private void resetMeasuredSize(int width) {
        if (this.mSizeForMeasure == null || this.mHasManualEstimatedViewportCount) {
            return;
        }
        int maxHeight = 0;
        int size = this.mComponentTreeHolders.size();
        for (int i = 0; i < size; ++i) {
            ComponentTreeHolder holder = this.mComponentTreeHolders.get(i);
            int measuredItemHeight = holder.getMeasuredHeight();
            if (measuredItemHeight <= maxHeight) continue;
            maxHeight = measuredItemHeight;
        }
        if (maxHeight == this.mSizeForMeasure.height) {
            return;
        }
        int rangeSize = Math.max(this.mLayoutInfo.approximateRangeSize(SizeSpec.getSize((int)this.mLastWidthSpec), SizeSpec.getSize((int)this.mLastHeightSpec), width, maxHeight), 1);
        this.mSizeForMeasure.height = maxHeight;
        this.mEstimatedViewportCount = rangeSize;
    }

    @Override
    public synchronized void setSize(int width, int height) {
        if (this.mLastWidthSpec == -1 || !this.isCompatibleSize(SizeSpec.makeSizeSpec((int)width, (int)0x40000000), SizeSpec.makeSizeSpec((int)height, (int)0x40000000))) {
            this.measure(sDummySize, SizeSpec.makeSizeSpec((int)width, (int)0x40000000), SizeSpec.makeSizeSpec((int)height, (int)0x40000000), this.mReMeasureEventEventHandler);
        }
    }

    @Override
    @UiThread
    public void mount(RecyclerView view) {
        ThreadUtils.assertMainThread();
        if (this.mIsSubAdapter) {
            throw new RuntimeException("Can't mount a RecyclerView in sub adapter mode");
        }
        if (this.mMountedView == view) {
            return;
        }
        if (this.mMountedView != null) {
            this.unmount(this.mMountedView);
        }
        if (this.mHasAsyncOperations) {
            this.applyReadyBatches();
        }
        if (this.mIsCircular && (!this.mIsInitMounted || this.mCurrentFirstVisiblePosition < 0)) {
            int jumpToMiddle = 0x3FFFFFFF;
            int offsetFirstItem = this.mComponentTreeHolders.isEmpty() ? 0 : 0x3FFFFFFF % this.mComponentTreeHolders.size();
            this.mCurrentFirstVisiblePosition = Math.max(0, this.mCurrentFirstVisiblePosition) + 0x3FFFFFFF - offsetFirstItem;
        }
        this.mMountedView = view;
        this.mIsInitMounted = true;
        final RecyclerView.LayoutManager layoutManager = this.mLayoutInfo.getLayoutManager();
        layoutManager.setItemPrefetchEnabled(this.mRecyclerViewItemPrefetch);
        if (this.mRecyclerViewItemPrefetch) {
            this.mMountedView.setItemViewCacheSize(this.mItemViewCacheSize);
        }
        view.getPaddingLeft();
        view.setLayoutManager(layoutManager);
        view.setAdapter(this.mInternalAdapter);
        view.addOnScrollListener((RecyclerView.OnScrollListener)this.mViewportManager.getScrollListener());
        if (layoutManager instanceof NeedsBgPaddingInfo) {
            ((NeedsBgPaddingInfo)layoutManager).setBgPaddingInfo(new Rect(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom()));
        }
        this.registerDrawListener(view);
        this.mLayoutInfo.setRenderInfoCollection(this);
        this.mViewportManager.addViewportChangedListener(this.mViewportChangedListener);
        if (this.mCurrentFirstVisiblePosition != -1 && this.mCurrentFirstVisiblePosition >= 0 && !this.mIsCircular) {
            if (this.mSmoothScrollAlignmentType != null) {
                this.scrollSmoothToPosition(this.mCurrentFirstVisiblePosition, this.mCurrentOffset, this.mSmoothScrollAlignmentType);
            } else {
                this.mLayoutInfo.scrollToPositionWithOffset(this.mCurrentFirstVisiblePosition, this.mCurrentOffset);
            }
        } else if (this.mIsCircular) {
            view.scrollToPosition(this.mCurrentFirstVisiblePosition);
            view.setAccessibilityDelegateCompat(new RecyclerViewAccessibilityDelegate(view){

                public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                    super.onInitializeAccessibilityNodeInfo(host, info);
                    int itemCount = RecyclerBinder.this.getComponentTreeHolders().size();
                    int rowCount = layoutManager.canScrollVertically() ? itemCount : 1;
                    int colCount = layoutManager.canScrollHorizontally() ? itemCount : 1;
                    AccessibilityNodeInfoCompat.CollectionInfoCompat collectionInfo = AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)rowCount, (int)colCount, (boolean)false, (int)0);
                    info.setCollectionInfo((Object)collectionInfo);
                }
            });
        }
        this.enableStickyHeader(this.mMountedView);
    }

    private void enableStickyHeader(RecyclerView recyclerView) {
        if (this.mIsCircular) {
            Log.w((String)TAG, (String)"Sticky header is not supported for circular RecyclerViews");
            return;
        }
        if (Build.VERSION.SDK_INT < 14) {
            Log.w((String)TAG, (String)"Sticky header is supported only on ICS (API14) and above");
            return;
        }
        if (recyclerView == null) {
            return;
        }
        SectionsRecyclerView sectionsRecycler = SectionsRecyclerView.getParentRecycler(recyclerView);
        if (sectionsRecycler == null) {
            return;
        }
        this.mStickyHeaderController = this.mStickyHeaderControllerFactory == null ? new StickyHeaderControllerImpl(this) : this.mStickyHeaderControllerFactory.getController(this);
        this.mStickyHeaderController.init(sectionsRecycler);
    }

    @Override
    @UiThread
    public void unmount(RecyclerView view) {
        ThreadUtils.assertMainThread();
        if (this.mIsSubAdapter) {
            throw new RuntimeException("Can't unmount a RecyclerView in sub adapter mode");
        }
        RecyclerView.LayoutManager layoutManager = this.mLayoutInfo.getLayoutManager();
        View firstView = layoutManager.findViewByPosition(this.mCurrentFirstVisiblePosition);
        if (firstView != null) {
            boolean reverseLayout = this.getReverseLayout();
            this.mCurrentOffset = this.mLayoutInfo.getScrollDirection() == 0 ? (reverseLayout ? view.getWidth() - layoutManager.getPaddingRight() - layoutManager.getDecoratedRight(firstView) : layoutManager.getDecoratedLeft(firstView) - layoutManager.getPaddingLeft()) : (reverseLayout ? view.getHeight() - layoutManager.getPaddingBottom() - layoutManager.getDecoratedBottom(firstView) : layoutManager.getDecoratedTop(firstView) - layoutManager.getPaddingTop());
        } else {
            this.mCurrentOffset = 0;
        }
        view.removeOnScrollListener((RecyclerView.OnScrollListener)this.mViewportManager.getScrollListener());
        this.unregisterDrawListener(view);
        this.maybeDispatchDataRendered();
        view.setAdapter(null);
        view.setLayoutManager(null);
        this.mViewportManager.removeViewportChangedListener(this.mViewportChangedListener);
        if (this.mMountedView != view) {
            return;
        }
        this.mMountedView = null;
        if (this.mStickyHeaderController != null) {
            this.mStickyHeaderController.reset();
        }
        this.mLayoutInfo.setRenderInfoCollection(null);
    }

    private void registerDrawListener(RecyclerView view) {
        if (view instanceof HasPostDispatchDrawListener) {
            ((HasPostDispatchDrawListener)view).registerPostDispatchDrawListener(this.mPostDispatchDrawListener);
        } else if (view.getViewTreeObserver() != null) {
            view.getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
            if (ComponentsConfiguration.fixMemoryLeakInRecyclerBinder) {
                view.addOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
            }
        }
    }

    private void unregisterDrawListener(RecyclerView view) {
        if (view instanceof HasPostDispatchDrawListener) {
            ((HasPostDispatchDrawListener)view).unregisterPostDispatchDrawListener(this.mPostDispatchDrawListener);
        } else if (view.getViewTreeObserver() != null) {
            view.getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
        }
    }

    @UiThread
    public void scrollToPosition(int position) {
        if (this.mMountedView == null) {
            this.mCurrentFirstVisiblePosition = position;
            return;
        }
        this.mMountedView.scrollToPosition(position);
    }

    @UiThread
    public void scrollSmoothToPosition(Object id, int offset, SmoothScrollAlignmentType type) {
        int index = this.getPositionForId(id);
        this.scrollSmoothToPosition(index, offset, type);
    }

    @UiThread
    public void scrollSmoothToPosition(int position, int offset, SmoothScrollAlignmentType type) {
        if (this.mMountedView == null) {
            this.mCurrentFirstVisiblePosition = position;
            this.mCurrentOffset = offset;
            this.mSmoothScrollAlignmentType = type;
            return;
        }
        RecyclerView.SmoothScroller smoothScroller = SnapUtil.getSmoothScrollerWithOffset(this.mComponentContext.getAndroidContext(), offset, type);
        smoothScroller.setTargetPosition(position);
        this.mMountedView.getLayoutManager().startSmoothScroll(smoothScroller);
    }

    @UiThread
    private synchronized int getPositionForId(Object id) {
        if (id == null) {
            return -1;
        }
        for (int i = 0; i < this.mComponentTreeHolders.size(); ++i) {
            Object childId;
            ComponentTreeHolder componentTreeHolder = this.mComponentTreeHolders.get(i);
            RenderInfo renderInfo = componentTreeHolder.getRenderInfo();
            if (renderInfo == null || !id.equals(childId = renderInfo.getCustomAttribute(ID_CUSTOM_ATTR_KEY))) continue;
            return i;
        }
        return -1;
    }

    @UiThread
    public void scrollToPositionWithOffset(Object id, int offset) {
        int index = this.getPositionForId(id);
        this.scrollToPositionWithOffset(index, offset);
    }

    @UiThread
    public void scrollToPositionWithOffset(int position, int offset) {
        if (this.mMountedView == null) {
            this.mCurrentFirstVisiblePosition = position;
            this.mCurrentOffset = offset;
            return;
        }
        this.mLayoutInfo.scrollToPositionWithOffset(position, offset);
    }

    @GuardedBy(value="this")
    private boolean isCompatibleSize(int widthSpec, int heightSpec) {
        if (this.mMeasuredSize == null) {
            return false;
        }
        int scrollDirection = this.mLayoutInfo.getScrollDirection();
        if (this.mLastWidthSpec != -1) {
            switch (scrollDirection) {
                case 0: {
                    return MeasureComparisonUtils.isMeasureSpecCompatible((int)this.mLastHeightSpec, (int)heightSpec, (int)this.mMeasuredSize.height);
                }
                case 1: {
                    return MeasureComparisonUtils.isMeasureSpecCompatible((int)this.mLastWidthSpec, (int)widthSpec, (int)this.mMeasuredSize.width);
                }
            }
        }
        return false;
    }

    @Override
    public int findFirstVisibleItemPosition() {
        return this.mLayoutInfo.findFirstVisibleItemPosition();
    }

    @Override
    public int findFirstFullyVisibleItemPosition() {
        return this.mLayoutInfo.findFirstFullyVisibleItemPosition();
    }

    @Override
    public int findLastVisibleItemPosition() {
        return this.mLayoutInfo.findLastVisibleItemPosition();
    }

    @Override
    public int findLastFullyVisibleItemPosition() {
        return this.mLayoutInfo.findLastFullyVisibleItemPosition();
    }

    @Override
    @UiThread
    @GuardedBy(value="this")
    public boolean isSticky(int position) {
        return this.isValidPosition(position) && this.mComponentTreeHolders.get(position).getRenderInfo().isSticky();
    }

    @Override
    @UiThread
    @GuardedBy(value="this")
    public boolean isValidPosition(int position) {
        return position >= 0 && position < this.mComponentTreeHolders.size();
    }

    public RecyclerView.Adapter getInternalAdapter() {
        return this.mInternalAdapter;
    }

    @Override
    @UiThread
    public void setViewportChangedListener(@Nullable ViewportInfo.ViewportChanged viewportChangedListener) {
        this.mViewportManager.addViewportChangedListener(viewportChangedListener);
    }

    @VisibleForTesting
    void onNewVisibleRange(int firstVisiblePosition, int lastVisiblePosition) {
        this.mCurrentFirstVisiblePosition = firstVisiblePosition;
        this.mCurrentLastVisiblePosition = lastVisiblePosition;
        this.mViewportManager.resetShouldUpdate();
        this.maybePostUpdateViewportAndComputeRange();
    }

    public void updateSubAdapterVisibleRange(int firstVisiblePosition, int lastVisiblePosition) {
        if (!this.mIsSubAdapter) {
            throw new RuntimeException("updateSubAdapterVisibleRange can only be called in sub adapter mode");
        }
        this.onNewVisibleRange(firstVisiblePosition, lastVisiblePosition);
    }

    public void updateSubAdapterWorkingRange(int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        if (!this.mIsSubAdapter) {
            throw new RuntimeException("updateSubAdapterWorkingRange can only be called in sub adapter mode");
        }
        this.onNewWorkingRange(firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex);
    }

    @VisibleForTesting
    void onNewWorkingRange(int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        if (this.mEstimatedViewportCount == -1 || firstVisibleIndex == -1 || lastVisibleIndex == -1) {
            return;
        }
        int rangeSize = Math.max(this.mEstimatedViewportCount, lastVisibleIndex - firstVisibleIndex);
        int layoutRangeSize = (int)((float)rangeSize * this.mRangeRatio);
        int rangeStart = Math.max(0, firstVisibleIndex - layoutRangeSize);
        int rangeEnd = Math.min(firstVisibleIndex + rangeSize + layoutRangeSize, this.mComponentTreeHolders.size() - 1);
        for (int position = rangeStart; position <= rangeEnd; ++position) {
            ComponentTreeHolder holder = this.mComponentTreeHolders.get(position);
            holder.checkWorkingRangeAndDispatch(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex);
        }
    }

    private void maybePostUpdateViewportAndComputeRange() {
        if (this.mMountedView != null && this.mViewportManager.shouldUpdate()) {
            this.mMountedView.removeCallbacks(this.mUpdateViewportRunnable);
            ViewCompat.postOnAnimation((View)this.mMountedView, (Runnable)this.mUpdateViewportRunnable);
        }
        this.computeRange(this.mCurrentFirstVisiblePosition, this.mCurrentLastVisiblePosition);
    }

    private void computeRange(int firstVisible, int lastVisible) {
        this.computeRange(firstVisible, lastVisible, this.mRangeTraverser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRange(int firstVisible, int lastVisible, RecyclerRangeTraverser traverser) {
        int rangeEnd;
        int rangeStart;
        int treeHoldersSize;
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            if (!this.isMeasured() || this.mEstimatedViewportCount == -1) {
                return;
            }
            if (firstVisible == -1 || lastVisible == -1) {
                lastVisible = 0;
                firstVisible = 0;
            }
            int rangeSize = Math.max(this.mEstimatedViewportCount, lastVisible - firstVisible);
            treeHoldersSize = this.mComponentTreeHolders.size();
            if (this.mIsCircular) {
                rangeStart = 0;
                rangeEnd = treeHoldersSize;
            } else {
                rangeStart = firstVisible - (int)((float)rangeSize * this.mRangeRatio);
                rangeEnd = firstVisible + rangeSize + (int)((float)rangeSize * this.mRangeRatio);
            }
        }
        traverser.traverse(0, treeHoldersSize, firstVisible, lastVisible, new RecyclerRangeTraverser.Processor(){

            @Override
            public boolean process(int index) {
                return RecyclerBinder.this.computeRangeLayoutAt(index, rangeStart, rangeEnd, treeHoldersSize);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean computeRangeLayoutAt(int index, int rangeStart, int rangeEnd, int treeHoldersSize) {
        int childrenHeightSpec;
        int childrenWidthSpec;
        ComponentTreeHolder holder;
        RecyclerBinder recyclerBinder = this;
        synchronized (recyclerBinder) {
            if (treeHoldersSize != this.mComponentTreeHolders.size()) {
                return false;
            }
            holder = this.mComponentTreeHolders.get(index);
            if (holder.getRenderInfo().rendersView()) {
                return true;
            }
            childrenWidthSpec = this.getActualChildrenWidthSpec(holder);
            childrenHeightSpec = this.getActualChildrenHeightSpec(holder);
        }
        if ((index >= rangeStart || holder.getRenderInfo().isSticky()) && index <= rangeEnd) {
            if (!holder.isTreeValidForSizeSpecs(childrenWidthSpec, childrenHeightSpec)) {
                holder.computeLayoutAsync(this.mComponentContext, childrenWidthSpec, childrenHeightSpec);
            }
        } else if (ThreadUtils.isMainThread()) {
            RecyclerBinder.maybeAcquireStateAndReleaseTree(holder, this.mAcquireStateHandlerOnRelease);
        } else {
            this.mMainThreadHandler.post(this.getMaybeAcquireStateAndReleaseTreeRunnable(holder));
        }
        return true;
    }

    private Runnable getMaybeAcquireStateAndReleaseTreeRunnable(final ComponentTreeHolder holder) {
        return new Runnable(){

            @Override
            public void run() {
                RecyclerBinder.maybeAcquireStateAndReleaseTree(holder, RecyclerBinder.this.mAcquireStateHandlerOnRelease);
            }
        };
    }

    @UiThread
    private static void maybeAcquireStateAndReleaseTree(ComponentTreeHolder holder, boolean acquireStateAndReleaseTree) {
        if (holder.isTreeValid() && !holder.shouldPreventRelease() && !holder.getRenderInfo().isSticky() && holder.getComponentTree() != null && holder.getComponentTree().getLithoView() == null) {
            holder.acquireStateAndReleaseTree(acquireStateAndReleaseTree);
        }
    }

    private boolean getReverseLayout() {
        RecyclerView.LayoutManager layoutManager = this.mLayoutInfo.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).getReverseLayout();
        }
        return false;
    }

    private boolean getStackFromEnd() {
        RecyclerView.LayoutManager layoutManager = this.mLayoutInfo.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).getStackFromEnd();
        }
        return false;
    }

    @Nullable
    @VisibleForTesting
    RangeCalculationResult getRangeCalculationResult() {
        if (this.mSizeForMeasure == null && this.mEstimatedViewportCount == -1) {
            return null;
        }
        RangeCalculationResult range = new RangeCalculationResult();
        range.measuredSize = this.getSizeForMeasuring();
        range.estimatedViewportCount = this.mEstimatedViewportCount;
        return range;
    }

    private boolean hasComputedRange() {
        return this.mSizeForMeasure != null && this.mEstimatedViewportCount != -1 || this.mHasManualEstimatedViewportCount;
    }

    private int getSizeForMeasuring() {
        if (this.mSizeForMeasure == null) {
            return -1;
        }
        return this.mLayoutInfo.getScrollDirection() == 0 ? this.mSizeForMeasure.height : this.mSizeForMeasure.width;
    }

    @GuardedBy(value="this")
    private int getActualChildrenWidthSpec(ComponentTreeHolder treeHolder) {
        if (this.isMeasured()) {
            return this.mLayoutInfo.getChildWidthSpec(SizeSpec.makeSizeSpec((int)this.mMeasuredSize.width, (int)0x40000000), treeHolder.getRenderInfo());
        }
        return this.mLayoutInfo.getChildWidthSpec(this.mLastWidthSpec, treeHolder.getRenderInfo());
    }

    @GuardedBy(value="this")
    private int getActualChildrenHeightSpec(ComponentTreeHolder treeHolder) {
        if (this.mHasDynamicItemHeight) {
            return 0;
        }
        if (this.isMeasured()) {
            return this.mLayoutInfo.getChildHeightSpec(SizeSpec.makeSizeSpec((int)this.mMeasuredSize.height, (int)0x40000000), treeHolder.getRenderInfo());
        }
        return this.mLayoutInfo.getChildHeightSpec(this.mLastHeightSpec, treeHolder.getRenderInfo());
    }

    @AnyThread
    public void setCommitPolicy(int commitPolicy) {
        this.mCommitPolicy = commitPolicy;
    }

    private AsyncInsertOperation createAsyncInsertOperation(int position, RenderInfo renderInfo) {
        ComponentTreeHolder holder = this.createComponentTreeHolder(renderInfo);
        holder.setInserted(false);
        return new AsyncInsertOperation(position, holder);
    }

    @GuardedBy(value="this")
    private int getNormalizedPosition(int position) {
        return this.mIsCircular ? position % this.mComponentTreeHolders.size() : position;
    }

    public void resetLayoutInfo(LayoutInfo layoutInfo) {
        if (layoutInfo == null) {
            throw new IllegalArgumentException("LayoutInfo must not be null.");
        }
        ThreadUtils.assertMainThread();
        this.mLayoutInfo = layoutInfo;
    }

    @Nullable
    private static RecyclerView.ViewHolder getViewHolderFromLayoutParam(RecyclerView.LayoutParams layoutParams) {
        try {
            if (mViewHolderField == null) {
                mViewHolderField = RecyclerView.LayoutParams.class.getDeclaredField("mViewHolder");
                mViewHolderField.setAccessible(true);
            }
            RecyclerView.ViewHolder viewHolder = (RecyclerView.ViewHolder)mViewHolderField.get(layoutParams);
            return viewHolder;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ComponentTreeHolder createComponentTreeHolder(RenderInfo renderInfo) {
        ComponentTreeHolder holder;
        Object tag;
        if (this.mComponentWarmer != null && (tag = renderInfo.getCustomAttribute("component_warmer_tag")) instanceof String && (holder = this.mComponentWarmer.consume((String)tag)) != null) {
            Object preventRelease;
            if (SectionsDebug.ENABLED) {
                Log.d((String)"SectionsDebug", (String)("Got ComponentTreeHolder from ComponentWarner for key " + tag));
            }
            if ((preventRelease = renderInfo.getCustomAttribute("prevent_release")) != null) {
                holder.getRenderInfo().addCustomAttribute("prevent_release", preventRelease);
            }
            return holder;
        }
        Object layoutHandler = this.mLayoutHandlerFactory != null ? this.mLayoutHandlerFactory.createLayoutCalculationHandler(renderInfo) : (this.mThreadPoolHandler != null ? this.mThreadPoolHandler : null);
        return this.mComponentTreeHolderFactory.create(renderInfo, (RunnableHandler)layoutHandler, this.mComponentTreeMeasureListenerFactory, this.mComponentsConfiguration, this.mIncrementalMountEnabled, this.mVisibilityProcessingEnabled, this.mMoveLayoutsBetweenThreads, this.mIsReconciliationEnabled, this.mIsLayoutDiffingEnabled, this.mPreallocateMountContentHandler, this.mPreallocatePerMountSpec, this.mParentLifecycle, this.mErrorEventHandler);
    }

    ComponentWarmer.ComponentTreeHolderPreparer getComponentTreeHolderPreparer() {
        return new ComponentWarmer.ComponentTreeHolderPreparer(){

            @Override
            public ComponentTreeHolder create(ComponentRenderInfo renderInfo) {
                return RecyclerBinder.this.createComponentTreeHolder(renderInfo);
            }

            @Override
            public void prepareSync(ComponentTreeHolder holder, @Nullable Size size) {
                int childrenWidthSpec = RecyclerBinder.this.getActualChildrenWidthSpec(holder);
                int childrenHeightSpec = RecyclerBinder.this.getActualChildrenHeightSpec(holder);
                if (size != null && holder.isTreeValidForSizeSpecs(childrenWidthSpec, childrenHeightSpec)) {
                    size.width = SizeSpec.getSize((int)childrenWidthSpec);
                    size.height = SizeSpec.getSize((int)childrenHeightSpec);
                    return;
                }
                holder.computeLayoutSync(RecyclerBinder.this.mComponentContext, childrenWidthSpec, childrenHeightSpec, size);
            }

            @Override
            public void prepareAsync(ComponentTreeHolder holder) {
                int childrenHeightSpec;
                int childrenWidthSpec = RecyclerBinder.this.getActualChildrenWidthSpec(holder);
                if (holder.isTreeValidForSizeSpecs(childrenWidthSpec, childrenHeightSpec = RecyclerBinder.this.getActualChildrenHeightSpec(holder))) {
                    return;
                }
                holder.computeLayoutAsync(RecyclerBinder.this.mComponentContext, childrenWidthSpec, childrenHeightSpec);
            }
        };
    }

    void setComponentWarmer(ComponentWarmer componentWarmer) {
        this.mComponentWarmer = componentWarmer;
    }

    @Nullable
    @VisibleForTesting
    ComponentWarmer getComponentWarmer() {
        return this.mComponentWarmer;
    }

    @UiThread
    private void updateHolder(ComponentTreeHolder holder, RenderInfo renderInfo) {
        RenderInfo previousRenderInfo = holder.getRenderInfo();
        holder.setRenderInfo(renderInfo);
        if (this.mLayoutHandlerFactory != null && this.mLayoutHandlerFactory.shouldUpdateLayoutHandler(previousRenderInfo, renderInfo)) {
            holder.updateLayoutHandler(this.mLayoutHandlerFactory.createLayoutCalculationHandler(renderInfo));
        }
    }

    @Nullable
    private ComponentTreeHolderRangeInfo getHolderForRangeInfo() {
        int positionToComputeLayout;
        ComponentTreeHolderRangeInfo holderForRangeInfo = null;
        if (!this.mComponentTreeHolders.isEmpty()) {
            int positionToComputeLayout2 = RecyclerBinder.findInitialComponentPosition(this.mComponentTreeHolders, this.mTraverseLayoutBackwards);
            if (this.mCurrentFirstVisiblePosition < this.mComponentTreeHolders.size() && positionToComputeLayout2 >= 0) {
                holderForRangeInfo = new ComponentTreeHolderRangeInfo(positionToComputeLayout2, this.mComponentTreeHolders);
            }
        } else if (!this.mAsyncComponentTreeHolders.isEmpty() && (positionToComputeLayout = RecyclerBinder.findInitialComponentPosition(this.mAsyncComponentTreeHolders, this.mTraverseLayoutBackwards)) >= 0) {
            holderForRangeInfo = new ComponentTreeHolderRangeInfo(positionToComputeLayout, this.mAsyncComponentTreeHolders);
        }
        return holderForRangeInfo;
    }

    private static boolean isVisibleToUser(View view) {
        if (view.getWindowVisibility() != 0) {
            return false;
        }
        View current = view;
        while (current instanceof View) {
            View currentView = current;
            if (currentView.getAlpha() <= 0.0f || currentView.getVisibility() != 0) {
                return false;
            }
            current = currentView.getParent();
        }
        return view.getGlobalVisibleRect(sDummyRect);
    }

    private static List<String> getVisibleHierarchy(View view) {
        ArrayList<String> hierarchy = new ArrayList<String>();
        View current = view;
        while (current instanceof View) {
            View currentView = current;
            hierarchy.add("view=" + currentView.getClass().getSimpleName() + ", alpha=" + currentView.getAlpha() + ", visibility=" + currentView.getVisibility());
            if (currentView.getAlpha() <= 0.0f || currentView.getVisibility() != 0) break;
            current = currentView.getParent();
        }
        return hierarchy;
    }

    static {
        DEFAULT_COMPONENT_TREE_HOLDER_FACTORY = new ComponentTreeHolderFactory(){

            @Override
            public ComponentTreeHolder create(RenderInfo renderInfo, @Nullable RunnableHandler layoutHandler, @Nullable ComponentTreeHolder.ComponentTreeMeasureListenerFactory measureListenerFactory, ComponentsConfiguration componentsConfiguration, boolean incrementalMountEnabled, boolean visibilityProcessingEnabled, boolean canInterruptAndMoveLayoutsBetweenThreads, boolean isReconciliationEnabled, boolean isLayoutDiffingEnabled, @Nullable RunnableHandler preallocateHandler, boolean preallocatePerMountSpec, @Nullable LithoLifecycleProvider lifecycleProvider, @Nullable ErrorEventHandler errorEventHandler) {
                return ComponentTreeHolder.create().renderInfo(renderInfo).layoutHandler(layoutHandler).componentTreeMeasureListenerFactory(measureListenerFactory).componentsConfiguration(componentsConfiguration).incrementalMount(incrementalMountEnabled).visibilityProcessingEnabled(visibilityProcessingEnabled).canInterruptAndMoveLayoutsBetweenThreads(canInterruptAndMoveLayoutsBetweenThreads).isReconciliationEnabled(isReconciliationEnabled).isLayoutDiffingEnabled(isLayoutDiffingEnabled).preallocateMountContentHandler(preallocateHandler).shouldPreallocatePerMountSpec(preallocatePerMountSpec).parentLifecycleProvider(lifecycleProvider).errorEventHandler(errorEventHandler).build();
            }
        };
    }

    @VisibleForTesting
    static class ComponentAsyncInitRangeIterator
    implements Iterator<ComponentTreeHolder> {
        private final boolean mTraverseLayoutBackwards;
        private final List<ComponentTreeHolder> mHolders;
        private int mCurrentPosition;
        private int mNumberOfItemsToProcess;

        ComponentAsyncInitRangeIterator(List<ComponentTreeHolder> holders, int initialPosition, int numberOfItemsToProcess, boolean traverseLayoutBackwards) {
            this.mHolders = new ArrayList<ComponentTreeHolder>(holders);
            this.mCurrentPosition = traverseLayoutBackwards ? initialPosition - 1 : initialPosition + 1;
            this.mNumberOfItemsToProcess = numberOfItemsToProcess;
            this.mTraverseLayoutBackwards = traverseLayoutBackwards;
        }

        @Override
        public boolean hasNext() {
            while (this.mNumberOfItemsToProcess > 0 && this.isValidPosition(this.mCurrentPosition)) {
                ComponentTreeHolder holder = this.mHolders.get(this.mCurrentPosition);
                if (holder.getRenderInfo().rendersComponent() && !holder.isTreeValid()) {
                    return true;
                }
                this.shiftToNextPosition();
            }
            return false;
        }

        boolean isValidPosition(int position) {
            return position >= 0 && position < this.mHolders.size();
        }

        @Override
        @Nullable
        public synchronized ComponentTreeHolder next() {
            if (!this.hasNext()) {
                return null;
            }
            ComponentTreeHolder holder = this.mHolders.get(this.mCurrentPosition);
            this.shiftToNextPosition();
            --this.mNumberOfItemsToProcess;
            return holder;
        }

        private void shiftToNextPosition() {
            this.mCurrentPosition = this.mTraverseLayoutBackwards ? --this.mCurrentPosition : ++this.mCurrentPosition;
        }

        @Override
        public void remove() {
        }
    }

    @VisibleForTesting
    static class ComponentTreeHolderRangeInfo {
        private final int mPosition;
        private final List<ComponentTreeHolder> mHolders;

        @VisibleForTesting
        ComponentTreeHolderRangeInfo(int position, List<ComponentTreeHolder> holders) {
            this.mPosition = position;
            this.mHolders = holders;
        }
    }

    public static class RecyclerViewLayoutManagerOverrideParams
    extends RecyclerView.LayoutParams
    implements LithoView.LayoutManagerOverrideParams {
        private final int mWidthMeasureSpec;
        private final int mHeightMeasureSpec;
        private final boolean mIsFullSpan;

        private RecyclerViewLayoutManagerOverrideParams(int width, int height, int overrideWidthMeasureSpec, int overrideHeightMeasureSpec, boolean isFullSpan) {
            super(width, height);
            this.mWidthMeasureSpec = overrideWidthMeasureSpec;
            this.mHeightMeasureSpec = overrideHeightMeasureSpec;
            this.mIsFullSpan = isFullSpan;
        }

        public int getWidthMeasureSpec() {
            return this.mWidthMeasureSpec;
        }

        public int getHeightMeasureSpec() {
            return this.mHeightMeasureSpec;
        }

        public boolean isFullSpan() {
            return this.mIsFullSpan;
        }

        public boolean hasValidAdapterPosition() {
            RecyclerView.ViewHolder viewHolder = RecyclerBinder.getViewHolderFromLayoutParam(this);
            return viewHolder != null && viewHolder.getAdapterPosition() == -1;
        }
    }

    private class InternalAdapter
    extends RecyclerView.Adapter<RecyclerBinderViewHolder>
    implements RecyclerBinderAdapter {
        InternalAdapter() {
            this.setHasStableIds(RecyclerBinder.this.mRecyclerBinderAdapterDelegate.hasStableIds());
        }

        public RecyclerBinderViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            ViewCreator viewCreator = RecyclerBinder.this.mRenderInfoViewCreatorController.getViewCreator(viewType);
            if (viewCreator != null) {
                View view = viewCreator.createView(RecyclerBinder.this.mComponentContext.getAndroidContext(), parent);
                try {
                    return new BaseViewHolder(view, false);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("createView() may not return null from :" + this.getClassNameForDebug(viewCreator.getClass()), ex);
                }
            }
            return RecyclerBinder.this.mRecyclerBinderAdapterDelegate.onCreateViewHolder(parent, viewType);
        }

        @GuardedBy(value="RecyclerBinder.this")
        public void onBindViewHolder(RecyclerBinderViewHolder holder, int position) {
            BaseViewHolder baseViewHolder;
            boolean loggingForStartup = LithoStartupLogger.isEnabled((LithoStartupLogger)RecyclerBinder.this.mStartupLogger) && !RecyclerBinder.this.mStartupLoggerAttribution.isEmpty();
            int normalizedPosition = RecyclerBinder.this.getNormalizedPosition(position);
            ComponentTreeHolder componentTreeHolder = (ComponentTreeHolder)RecyclerBinder.this.mComponentTreeHolders.get(normalizedPosition);
            RenderInfo renderInfo = componentTreeHolder.getRenderInfo();
            if (renderInfo.rendersComponent()) {
                boolean isOrientationVertical;
                final LithoView lithoView = holder.getLithoView();
                lithoView.setInvalidStateLogParamsList(RecyclerBinder.this.mInvalidStateLogParamsList);
                int childrenWidthSpec = RecyclerBinder.this.getActualChildrenWidthSpec(componentTreeHolder);
                int childrenHeightSpec = RecyclerBinder.this.getActualChildrenHeightSpec(componentTreeHolder);
                if (!componentTreeHolder.isTreeValidForSizeSpecs(childrenWidthSpec, childrenHeightSpec)) {
                    if (ComponentsConfiguration.computeRangeOnSyncLayout && RecyclerBinder.this.mCurrentFirstVisiblePosition != -1 && RecyclerBinder.this.mCurrentLastVisiblePosition != -1) {
                        int range = RecyclerBinder.this.mCurrentLastVisiblePosition - RecyclerBinder.this.mCurrentFirstVisiblePosition;
                        if (position > RecyclerBinder.this.mCurrentLastVisiblePosition) {
                            RecyclerBinder.this.computeRange(position, position + range, RecyclerRangeTraverser.FORWARD_TRAVERSER);
                        } else if (position < RecyclerBinder.this.mCurrentFirstVisiblePosition) {
                            RecyclerBinder.this.computeRange(position - range, position, RecyclerRangeTraverser.BACKWARD_TRAVERSER);
                        }
                    }
                    Size size = new Size();
                    componentTreeHolder.computeLayoutSync(RecyclerBinder.this.mComponentContext, childrenWidthSpec, childrenHeightSpec, size);
                }
                boolean bl = isOrientationVertical = RecyclerBinder.this.mLayoutInfo.getScrollDirection() == 1;
                int width = SizeSpec.getMode((int)childrenWidthSpec) == 0x40000000 ? SizeSpec.getSize((int)childrenWidthSpec) : (isOrientationVertical ? -1 : -2);
                int height = SizeSpec.getMode((int)childrenHeightSpec) == 0x40000000 ? SizeSpec.getSize((int)childrenHeightSpec) : (isOrientationVertical ? -2 : -1);
                holder.setLithoViewLayoutParams(lithoView, width, height, childrenWidthSpec, childrenHeightSpec, renderInfo.isFullSpan());
                lithoView.setComponentTree(componentTreeHolder.getComponentTree());
                if (componentTreeHolder.getRenderInfo().getRenderCompleteEventHandler() != null && componentTreeHolder.getRenderState() == 0) {
                    lithoView.setOnPostDrawListener(new LithoView.OnPostDrawListener(){

                        public void onPostDraw() {
                            int position = RecyclerBinder.this.mMountedView.getChildAdapterPosition((View)lithoView);
                            if (position != -1) {
                                RecyclerBinder.this.notifyItemRenderCompleteAt(position, SystemClock.uptimeMillis());
                                lithoView.setOnPostDrawListener(null);
                            }
                        }
                    });
                }
                if (loggingForStartup) {
                    lithoView.setMountStartupLoggingInfo(RecyclerBinder.this.mStartupLogger, RecyclerBinder.this.mStartupLoggerAttribution, RecyclerBinder.this.mFirstMountLogged, RecyclerBinder.this.mLastMountLogged, position == this.getItemCount(), isOrientationVertical);
                } else {
                    lithoView.resetMountStartupLoggingInfo();
                }
                RecyclerBinder.this.mRecyclerBinderAdapterDelegate.onBindViewHolder(holder, normalizedPosition, componentTreeHolder.getComponentTree(), renderInfo);
                RecyclerBinder.this.mComponentsConfiguration;
                if (ComponentsConfiguration.requestMountForPrefetchedItems) {
                    MountHelper.requestMount((ComponentTree)componentTreeHolder.getComponentTree(), (Rect)sEmptyRect, (boolean)false);
                }
            } else if (holder instanceof BaseViewHolder && !(baseViewHolder = (BaseViewHolder)holder).isLithoViewType) {
                ViewBinder viewBinder = renderInfo.getViewBinder();
                baseViewHolder.viewBinder = viewBinder;
                viewBinder.bind(baseViewHolder.itemView);
            }
            if (ComponentsConfiguration.isRenderInfoDebuggingEnabled()) {
                RenderInfoDebugInfoRegistry.setRenderInfoToViewMapping(holder.itemView, renderInfo.getDebugInfo("SONAR_SECTIONS_DEBUG_INFO"));
            }
        }

        @Nullable
        private String getClassNameForDebug(Class c) {
            Class<?> enclosingClass = c.getEnclosingClass();
            if (enclosingClass == null) {
                return c.getCanonicalName();
            }
            return enclosingClass.getCanonicalName();
        }

        @GuardedBy(value="RecyclerBinder.this")
        public int getItemViewType(int position) {
            RenderInfo renderInfo = this.getRenderInfoAt(position);
            if (renderInfo.rendersComponent()) {
                return RecyclerBinder.this.mRenderInfoViewCreatorController.getComponentViewType();
            }
            return renderInfo.getViewType();
        }

        @Override
        @GuardedBy(value="RecyclerBinder.this")
        public int getItemCount() {
            int size = RecyclerBinder.this.mComponentTreeHolders.size();
            return RecyclerBinder.this.mIsCircular && size > 0 ? Integer.MAX_VALUE : size;
        }

        public void onViewRecycled(RecyclerBinderViewHolder holder) {
            BaseViewHolder baseViewHolder;
            LithoView lithoView = holder.getLithoView();
            if (lithoView != null) {
                RecyclerBinder.this.mRecyclerBinderAdapterDelegate.onViewRecycled(holder);
                lithoView.unmountAllItems();
                lithoView.setComponentTree(null);
                lithoView.setInvalidStateLogParamsList(null);
                lithoView.resetMountStartupLoggingInfo();
            } else if (holder instanceof BaseViewHolder && !(baseViewHolder = (BaseViewHolder)holder).isLithoViewType && baseViewHolder.viewBinder != null) {
                baseViewHolder.viewBinder.unbind(baseViewHolder.itemView);
                baseViewHolder.viewBinder = null;
            }
        }

        public long getItemId(int position) {
            return RecyclerBinder.this.mRecyclerBinderAdapterDelegate.getItemId(position);
        }

        @Override
        public int findFirstVisibleItemPosition() {
            return RecyclerBinder.this.mLayoutInfo.findFirstVisibleItemPosition();
        }

        @Override
        public int findLastVisibleItemPosition() {
            return RecyclerBinder.this.mLayoutInfo.findLastVisibleItemPosition();
        }

        @Override
        public RenderInfo getRenderInfoAt(int position) {
            return ((ComponentTreeHolder)RecyclerBinder.this.mComponentTreeHolders.get(RecyclerBinder.this.getNormalizedPosition(position))).getRenderInfo();
        }
    }

    private class DefaultRecyclerBinderAdapterDelegate
    implements RecyclerBinderAdapterDelegate<BaseViewHolder> {
        private DefaultRecyclerBinderAdapterDelegate() {
        }

        @Override
        public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LithoView lithoView = RecyclerBinder.this.mLithoViewFactory == null ? new LithoView(RecyclerBinder.this.mComponentContext, null) : RecyclerBinder.this.mLithoViewFactory.createLithoView(RecyclerBinder.this.mComponentContext);
            return new BaseViewHolder((View)lithoView, true);
        }

        @Override
        public void onBindViewHolder(BaseViewHolder viewHolder, int position, @Nullable ComponentTree componentTree, RenderInfo renderInfo) {
        }

        @Override
        public void onViewRecycled(BaseViewHolder viewHolder) {
        }

        @Override
        public boolean hasStableIds() {
            return RecyclerBinder.this.mEnableStableIds;
        }

        @Override
        public long getItemId(int position) {
            return ((ComponentTreeHolder)RecyclerBinder.this.mComponentTreeHolders.get(position)).getId();
        }
    }

    private static class BaseViewHolder
    extends RecyclerBinderViewHolder {
        private final boolean isLithoViewType;
        @Nullable
        private ViewBinder viewBinder;

        public BaseViewHolder(View itemView, boolean isLithoViewType) {
            super(itemView);
            this.isLithoViewType = isLithoViewType;
        }

        @Override
        @Nullable
        public LithoView getLithoView() {
            if (this.isLithoViewType) {
                return (LithoView)this.itemView;
            }
            return null;
        }

        @Override
        public void setLithoViewLayoutParams(LithoView lithoView, int width, int height, int widthSpec, int heightSpec, boolean isFullSpan) {
            RecyclerViewLayoutManagerOverrideParams layoutParams = new RecyclerViewLayoutManagerOverrideParams(width, height, widthSpec, heightSpec, isFullSpan);
            lithoView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    private static final class AsyncBatch {
        private final ArrayList<AsyncOperation> mOperations = new ArrayList();
        private boolean mIsDataChanged;
        private ChangeSetCompleteCallback mChangeSetCompleteCallback;
        private int mCommitPolicy;

        public AsyncBatch(int commitPolicy) {
            this.mCommitPolicy = commitPolicy;
        }
    }

    private static final class AsyncMoveOperation
    extends AsyncOperation {
        private final int mFromPosition;
        private final int mToPosition;

        public AsyncMoveOperation(int fromPosition, int toPosition) {
            super(5);
            this.mFromPosition = fromPosition;
            this.mToPosition = toPosition;
        }
    }

    private static final class AsyncRemoveRangeOperation
    extends AsyncOperation {
        private final int mPosition;
        private final int mCount;

        public AsyncRemoveRangeOperation(int position, int count) {
            super(4);
            this.mPosition = position;
            this.mCount = count;
        }
    }

    private static final class AsyncRemoveOperation
    extends AsyncOperation {
        private final int mPosition;

        public AsyncRemoveOperation(int position) {
            super(3);
            this.mPosition = position;
        }
    }

    private static final class AsyncUpdateRangeOperation
    extends AsyncOperation {
        private final int mPosition;
        private final List<RenderInfo> mRenderInfos;

        public AsyncUpdateRangeOperation(int position, List<RenderInfo> renderInfos) {
            super(2);
            this.mPosition = position;
            this.mRenderInfos = renderInfos;
        }
    }

    private static final class AsyncUpdateOperation
    extends AsyncOperation {
        private final int mPosition;
        private final RenderInfo mRenderInfo;

        public AsyncUpdateOperation(int position, RenderInfo renderInfo) {
            super(1);
            this.mPosition = position;
            this.mRenderInfo = renderInfo;
        }
    }

    private static final class AsyncInsertOperation
    extends AsyncOperation {
        private final int mPosition;
        private final ComponentTreeHolder mHolder;

        public AsyncInsertOperation(int position, ComponentTreeHolder holder) {
            super(0);
            this.mPosition = position;
            this.mHolder = holder;
        }
    }

    private static abstract class AsyncOperation {
        private final int mOperation;

        public AsyncOperation(int operation) {
            this.mOperation = operation;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CommitPolicy {
        public static final int IMMEDIATE = 0;
        public static final int LAYOUT_BEFORE_INSERT = 1;
    }

    private static class RangeCalculationResult {
        private int estimatedViewportCount;
        private int measuredSize;

        private RangeCalculationResult() {
        }
    }

    public static class Builder {
        public static final float DEFAULT_RANGE_RATIO = 2.0f;
        private float rangeRatio = 2.0f;
        private LayoutInfo layoutInfo;
        private ComponentsConfiguration componentsConfiguration = ComponentsConfiguration.getDefaultComponentsConfiguration();
        @Nullable
        private LayoutHandlerFactory layoutHandlerFactory;
        private ComponentTreeHolderFactory componentTreeHolderFactory = DEFAULT_COMPONENT_TREE_HOLDER_FACTORY;
        private ComponentContext componentContext;
        @Nullable
        private LithoViewFactory lithoViewFactory;
        private boolean isCircular;
        private boolean hasDynamicItemHeight;
        private boolean wrapContent;
        private int componentViewType = 0;
        @Nullable
        private RecyclerView.Adapter overrideInternalAdapter;
        private boolean enableStableIds;
        @Nullable
        private List<ComponentLogParams> invalidStateLogParamsList;
        private RecyclerRangeTraverser recyclerRangeTraverser;
        @Nullable
        private LayoutThreadPoolConfiguration threadPoolConfig;
        private boolean canMeasure;
        private boolean hscrollAsyncMode = false;
        private boolean incrementalMount = true;
        @Nullable
        private StickyHeaderControllerFactory stickyHeaderControllerFactory;
        private boolean canInterruptAndMoveLayoutsBetweenThreads = ComponentsConfiguration.canInterruptAndMoveLayoutsBetweenThreads;
        private boolean isSubAdapter;
        private int estimatedViewportCount = -1;
        private boolean isReconciliationEnabled = ComponentsConfiguration.isReconciliationEnabled;
        private boolean isLayoutDiffingEnabled = ComponentsConfiguration.isLayoutDiffingEnabled;
        private RunnableHandler preallocateMountContentHandler;
        private boolean shouldPreallocatePerMountSpec;
        @Nullable
        private ComponentWarmer mComponentWarmer;
        @Nullable
        private LithoStartupLogger startupLogger;
        private RunnableHandler mAsyncInsertLayoutHandler;
        private boolean visibilityProcessing = true;
        private boolean acquireStateHandlerOnRelease = true;
        private boolean recyclerViewItemPrefetch = false;
        private int itemViewCacheSize = 0;
        @Nullable
        private LithoLifecycleProvider lifecycleProvider;
        @Nullable
        private ErrorEventHandler errorEventHandler;
        @Nullable
        private RecyclerBinderAdapterDelegate adapterDelegate = null;

        public Builder rangeRatio(float rangeRatio) {
            this.rangeRatio = rangeRatio;
            return this;
        }

        public Builder acquireStateHandlerOnRelease(boolean acquireStateHandlerOnRelease) {
            this.acquireStateHandlerOnRelease = acquireStateHandlerOnRelease;
            return this;
        }

        public Builder layoutInfo(LayoutInfo layoutInfo) {
            this.layoutInfo = layoutInfo;
            return this;
        }

        public Builder componentsConfiguration(ComponentsConfiguration componentsConfiguration) {
            this.componentsConfiguration = componentsConfiguration;
            return this;
        }

        public Builder layoutHandlerFactory(@Nullable LayoutHandlerFactory layoutHandlerFactory) {
            this.layoutHandlerFactory = layoutHandlerFactory;
            return this;
        }

        public Builder lithoViewFactory(@Nullable LithoViewFactory lithoViewFactory) {
            this.lithoViewFactory = lithoViewFactory;
            return this;
        }

        public Builder isCircular(boolean isCircular) {
            this.isCircular = isCircular;
            return this;
        }

        public Builder wrapContent(boolean wrapContent) {
            this.wrapContent = wrapContent;
            return this;
        }

        public Builder componentTreeHolderFactory(ComponentTreeHolderFactory componentTreeHolderFactory) {
            this.componentTreeHolderFactory = componentTreeHolderFactory;
            return this;
        }

        public Builder preallocateMountContentHandler(@Nullable RunnableHandler preallocateMountContentHandler) {
            this.preallocateMountContentHandler = preallocateMountContentHandler;
            return this;
        }

        public Builder shouldPreallocatePerMountSpec(boolean shouldPreallocatePerMountSpec) {
            this.shouldPreallocatePerMountSpec = shouldPreallocatePerMountSpec;
            return this;
        }

        public Builder recyclerViewItemPrefetch(boolean recyclerViewItemPrefetch) {
            this.recyclerViewItemPrefetch = recyclerViewItemPrefetch;
            return this;
        }

        public Builder setItemViewCacheSize(int size) {
            this.itemViewCacheSize = size;
            return this;
        }

        public Builder hasDynamicItemHeight(boolean hasDynamicItemHeight) {
            this.hasDynamicItemHeight = hasDynamicItemHeight;
            return this;
        }

        public Builder enableCustomViewType(int componentViewType) {
            this.componentViewType = componentViewType;
            return this;
        }

        public Builder enableStableIds(boolean enableStableIds) {
            this.enableStableIds = enableStableIds;
            return this;
        }

        public Builder invalidStateLogParamsList(@Nullable List<ComponentLogParams> logParamsList) {
            this.invalidStateLogParamsList = logParamsList;
            return this;
        }

        public Builder threadPoolConfig(@Nullable LayoutThreadPoolConfiguration config) {
            this.threadPoolConfig = config;
            return this;
        }

        public Builder recyclerRangeTraverser(RecyclerRangeTraverser traverser) {
            this.recyclerRangeTraverser = traverser;
            return this;
        }

        @VisibleForTesting
        Builder overrideInternalAdapter(RecyclerView.Adapter overrideInternalAdapter) {
            this.overrideInternalAdapter = overrideInternalAdapter;
            return this;
        }

        public Builder setAdapterDelegate(@Nullable RecyclerBinderAdapterDelegate delegate) {
            this.adapterDelegate = delegate;
            return this;
        }

        public Builder estimatedViewportCount(int estimatedViewportCount) {
            if (estimatedViewportCount <= 0) {
                throw new IllegalArgumentException("Estimated viewport count must be > 0: " + estimatedViewportCount);
            }
            this.estimatedViewportCount = estimatedViewportCount;
            return this;
        }

        public Builder canMeasure(boolean canMeasure) {
            this.canMeasure = canMeasure;
            return this;
        }

        public Builder hscrollAsyncMode(boolean hscrollAsyncMode) {
            this.hscrollAsyncMode = hscrollAsyncMode;
            return this;
        }

        public Builder incrementalMount(boolean incrementalMount) {
            this.incrementalMount = incrementalMount;
            return this;
        }

        public Builder stickyHeaderControllerFactory(@Nullable StickyHeaderControllerFactory stickyHeaderControllerFactory) {
            this.stickyHeaderControllerFactory = stickyHeaderControllerFactory;
            return this;
        }

        public Builder canInterruptAndMoveLayoutsBetweenThreads(boolean isEnabled) {
            this.canInterruptAndMoveLayoutsBetweenThreads = isEnabled;
            return this;
        }

        public Builder isSubAdapter(boolean isSubAdapter) {
            this.isSubAdapter = isSubAdapter;
            return this;
        }

        public Builder isReconciliationEnabled(boolean isEnabled) {
            this.isReconciliationEnabled = isEnabled;
            return this;
        }

        public Builder isLayoutDiffingEnabled(boolean isEnabled) {
            this.isLayoutDiffingEnabled = isEnabled;
            return this;
        }

        public Builder componentWarmer(@Nullable ComponentWarmer componentWarmer) {
            this.mComponentWarmer = componentWarmer;
            return this;
        }

        public Builder startupLogger(@Nullable LithoStartupLogger logger) {
            this.startupLogger = logger;
            return this;
        }

        public Builder asyncInsertLayoutHandler(RunnableHandler handler) {
            this.mAsyncInsertLayoutHandler = handler;
            return this;
        }

        public Builder errorEventHandler(@Nullable ErrorEventHandler errorEventHandler) {
            this.errorEventHandler = errorEventHandler;
            return this;
        }

        public Builder lithoLifecycleProvider(LithoLifecycleProvider lithoLifecycleProvider) {
            this.lifecycleProvider = lithoLifecycleProvider;
            return this;
        }

        public RecyclerBinder build(ComponentContext c) {
            this.componentContext = ComponentContext.makeCopyForNestedTree((ComponentContext)c);
            if (this.lifecycleProvider == null) {
                this.lifecycleProvider = ComponentTree.getLifecycleProvider((ComponentContext)c);
            }
            boolean bl = this.incrementalMount = this.incrementalMount && ComponentContext.isIncrementalMountEnabled((ComponentContext)c);
            if (this.preallocateMountContentHandler == null && ComponentsConfiguration.enableNestedTreePreallocation) {
                this.preallocateMountContentHandler = ComponentContext.getMountContentPreallocationHandler((ComponentContext)c);
            }
            boolean bl2 = this.visibilityProcessing = this.visibilityProcessing && ComponentContext.isVisibilityProcessingEnabled((ComponentContext)c);
            if (this.layoutInfo == null) {
                this.layoutInfo = new LinearLayoutInfo(c.getAndroidContext(), 1, false);
            }
            return new RecyclerBinder(this);
        }
    }

    static interface ComponentTreeHolderFactory {
        public ComponentTreeHolder create(RenderInfo var1, @Nullable RunnableHandler var2, ComponentTreeHolder.ComponentTreeMeasureListenerFactory var3, ComponentsConfiguration var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, RunnableHandler var10, boolean var11, @Nullable LithoLifecycleProvider var12, @Nullable ErrorEventHandler var13);
    }

    static class RenderCompleteRunnable
    implements Runnable {
        private final EventHandler<RenderCompleteEvent> renderCompleteEventHandler;
        private final RenderCompleteEvent.RenderState renderState;
        private final long timestampMillis;

        RenderCompleteRunnable(EventHandler<RenderCompleteEvent> renderCompleteEventHandler, RenderCompleteEvent.RenderState renderState, long timestampMillis) {
            this.renderCompleteEventHandler = renderCompleteEventHandler;
            this.renderState = renderState;
            this.timestampMillis = timestampMillis;
        }

        @Override
        public void run() {
            RecyclerBinder.dispatchRenderCompleteEvent((EventHandler<RenderCompleteEvent>)this.renderCompleteEventHandler, this.renderState, this.timestampMillis);
        }
    }
}

