/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.UiThread;
import com.facebook.litho.widget.ScrollStateListener;
import javax.annotation.Nullable;

class ScrollStateDetector {
    private final View mHostView;
    @Nullable
    private ScrollStateListener scrollStateListener;
    private boolean mScrollStarted;
    private boolean mFlingStarted;
    private boolean mScrollStopped;
    private boolean mHasScrolledBetweenDraw;

    ScrollStateDetector(View view) {
        this.mHostView = view;
    }

    @UiThread
    void onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0 || motionEvent.getAction() == 2) {
            if (this.mScrollStopped) {
                this.reset();
            } else {
                this.mFlingStarted = false;
                this.mHasScrolledBetweenDraw = true;
            }
        } else if (!(motionEvent.getAction() != 1 && motionEvent.getAction() != 3 || this.mFlingStarted || !this.mScrollStarted || this.mScrollStopped)) {
            this.mScrollStopped = true;
            if (this.scrollStateListener != null) {
                this.scrollStateListener.onScrollStateChanged(this.mHostView, 1);
            }
        }
    }

    @UiThread
    void onScrollChanged() {
        if (!this.mScrollStarted && !this.mScrollStopped) {
            this.mScrollStarted = true;
            if (this.scrollStateListener != null) {
                this.scrollStateListener.onScrollStateChanged(this.mHostView, 0);
            }
        }
        this.mHasScrolledBetweenDraw = true;
    }

    @UiThread
    void onDraw() {
        if (this.mFlingStarted && !this.mScrollStopped) {
            if (!this.mHasScrolledBetweenDraw) {
                this.mScrollStopped = true;
                this.mFlingStarted = false;
                if (this.scrollStateListener != null) {
                    this.scrollStateListener.onScrollStateChanged(this.mHostView, 1);
                }
            }
            this.mHasScrolledBetweenDraw = false;
        }
    }

    @UiThread
    void fling() {
        this.mFlingStarted = true;
    }

    @UiThread
    void setListener(@Nullable ScrollStateListener listener) {
        this.scrollStateListener = listener;
    }

    @UiThread
    private void reset() {
        this.mScrollStarted = false;
        this.mFlingStarted = false;
        this.mScrollStopped = false;
    }
}

