/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.text.method.MovementMethod;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.Diff;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.EventTriggerTarget;
import com.facebook.litho.EventTriggersContainer;
import com.facebook.litho.Handle;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.ClearFocusEvent;
import com.facebook.litho.widget.DispatchKeyEvent;
import com.facebook.litho.widget.EditorActionEvent;
import com.facebook.litho.widget.GetLineCountEvent;
import com.facebook.litho.widget.GetTextEvent;
import com.facebook.litho.widget.InputConnectionEvent;
import com.facebook.litho.widget.InputFocusChangedEvent;
import com.facebook.litho.widget.KeyPreImeEvent;
import com.facebook.litho.widget.KeyUpEvent;
import com.facebook.litho.widget.ReplaceTextEvent;
import com.facebook.litho.widget.RequestFocusEvent;
import com.facebook.litho.widget.SelectionChangedEvent;
import com.facebook.litho.widget.SetSelectionEvent;
import com.facebook.litho.widget.SetTextEvent;
import com.facebook.litho.widget.TextChangedEvent;
import com.facebook.litho.widget.TextInputSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Generated
public final class TextInput
extends SpecGeneratedComponent {
    @javax.annotation.Nullable
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=2)
    String[] autofillHints;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int cursorDrawableRes = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean editable = true;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    TextUtils.TruncateAt ellipsize;
    @Prop(resType=ResType.STRING, optional=true)
    @Comparable(type=13)
    CharSequence error;
    @Prop(resType=ResType.DRAWABLE, optional=true)
    @Comparable(type=13)
    Drawable errorDrawable;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int gravity = 8388627;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=13)
    Integer highlightColor;
    @Prop(resType=ResType.STRING, optional=true)
    @Comparable(type=13)
    CharSequence hint = TextInputSpec.hint;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ColorStateList hintColorStateList = TextInputSpec.hintColorStateList;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int imeOptions = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int importantForAutofill = 0;
    @Prop(resType=ResType.STRING, optional=true)
    @Comparable(type=13)
    CharSequence initialText = TextInputSpec.initialText;
    @Prop(resType=ResType.DRAWABLE, optional=true)
    @Comparable(type=13)
    Drawable inputBackground = TextInputSpec.inputBackground;
    @Prop(resType=ResType.NONE, optional=true, varArg="inputFilter")
    @Comparable(type=5)
    List<InputFilter> inputFilters = Collections.emptyList();
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int inputType = 1;
    @javax.annotation.Nullable
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    KeyListener keyListener;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int maxLines = Integer.MAX_VALUE;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int minLines = 1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    MovementMethod movementMethod = TextInputSpec.movementMethod;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean multiline = false;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int rawInputType = 0;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int shadowColor = -7829368;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowDx;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowDy;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowRadius;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int textAlignment = 1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ColorStateList textColorStateList = TextInputSpec.textColorStateList;
    @Prop(resType=ResType.DIMEN_TEXT, optional=true)
    @Comparable(type=3)
    int textSize = -1;
    @Prop(resType=ResType.NONE, optional=true, varArg="textWatcher")
    @Comparable(type=5)
    List<TextWatcher> textWatchers = Collections.emptyList();
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    Typeface typeface = TextInputSpec.typeface;
    @Nullable
    EventHandler<TextChangedEvent> textChangedEventHandler;
    @Nullable
    EventHandler<SelectionChangedEvent> selectionChangedEventHandler;
    @Nullable
    EventHandler<InputFocusChangedEvent> inputFocusChangedEventHandler;
    @Nullable
    EventHandler<KeyUpEvent> keyUpEventHandler;
    @Nullable
    EventHandler<KeyPreImeEvent> keyPreImeEventHandler;
    @Nullable
    EventHandler<EditorActionEvent> editorActionEventHandler;
    @Nullable
    EventHandler<SetTextEvent> setTextEventHandler;
    @Nullable
    EventHandler<InputConnectionEvent> inputConnectionEventHandler;
    EventTrigger requestFocusTrigger;
    EventTrigger clearFocusTrigger;
    EventTrigger getTextTrigger;
    EventTrigger getLineCountTrigger;
    EventTrigger setTextTrigger;
    EventTrigger replaceTextTrigger;
    EventTrigger dispatchKeyTrigger;
    EventTrigger setSelectionTrigger;

    private TextInput() {
        super("TextInput");
    }

    private TextInputStateContainer getStateContainerImpl(ComponentContext c) {
        return (TextInputStateContainer)c.getScopedComponentInfo().getStateContainer();
    }

    protected TextInputStateContainer createStateContainer() {
        return new TextInputStateContainer();
    }

    public boolean isEquivalentProps(Component other, boolean shouldCompareCommonProps) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        TextInput textInputRef = (TextInput)other;
        if (!Arrays.equals(this.autofillHints, textInputRef.autofillHints)) {
            return false;
        }
        if (this.cursorDrawableRes != textInputRef.cursorDrawableRes) {
            return false;
        }
        if (this.editable != textInputRef.editable) {
            return false;
        }
        if (this.ellipsize != null ? !this.ellipsize.equals((Object)textInputRef.ellipsize) : textInputRef.ellipsize != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(textInputRef.error) : textInputRef.error != null) {
            return false;
        }
        if (this.errorDrawable != null ? !this.errorDrawable.equals(textInputRef.errorDrawable) : textInputRef.errorDrawable != null) {
            return false;
        }
        if (this.gravity != textInputRef.gravity) {
            return false;
        }
        if (this.highlightColor != null ? !this.highlightColor.equals(textInputRef.highlightColor) : textInputRef.highlightColor != null) {
            return false;
        }
        if (this.hint != null ? !this.hint.equals(textInputRef.hint) : textInputRef.hint != null) {
            return false;
        }
        if (this.hintColorStateList != null ? !this.hintColorStateList.equals(textInputRef.hintColorStateList) : textInputRef.hintColorStateList != null) {
            return false;
        }
        if (this.imeOptions != textInputRef.imeOptions) {
            return false;
        }
        if (this.importantForAutofill != textInputRef.importantForAutofill) {
            return false;
        }
        if (this.initialText != null ? !this.initialText.equals(textInputRef.initialText) : textInputRef.initialText != null) {
            return false;
        }
        if (this.inputBackground != null ? !this.inputBackground.equals(textInputRef.inputBackground) : textInputRef.inputBackground != null) {
            return false;
        }
        if (this.inputFilters != null ? !this.inputFilters.equals(textInputRef.inputFilters) : textInputRef.inputFilters != null) {
            return false;
        }
        if (this.inputType != textInputRef.inputType) {
            return false;
        }
        if (this.keyListener != null ? !this.keyListener.equals(textInputRef.keyListener) : textInputRef.keyListener != null) {
            return false;
        }
        if (this.maxLines != textInputRef.maxLines) {
            return false;
        }
        if (this.minLines != textInputRef.minLines) {
            return false;
        }
        if (this.movementMethod != null ? !this.movementMethod.equals(textInputRef.movementMethod) : textInputRef.movementMethod != null) {
            return false;
        }
        if (this.multiline != textInputRef.multiline) {
            return false;
        }
        if (this.rawInputType != textInputRef.rawInputType) {
            return false;
        }
        if (this.shadowColor != textInputRef.shadowColor) {
            return false;
        }
        if (Float.compare(this.shadowDx, textInputRef.shadowDx) != 0) {
            return false;
        }
        if (Float.compare(this.shadowDy, textInputRef.shadowDy) != 0) {
            return false;
        }
        if (Float.compare(this.shadowRadius, textInputRef.shadowRadius) != 0) {
            return false;
        }
        if (this.textAlignment != textInputRef.textAlignment) {
            return false;
        }
        if (this.textColorStateList != null ? !this.textColorStateList.equals(textInputRef.textColorStateList) : textInputRef.textColorStateList != null) {
            return false;
        }
        if (this.textSize != textInputRef.textSize) {
            return false;
        }
        if (this.textWatchers != null ? !this.textWatchers.equals(textInputRef.textWatchers) : textInputRef.textWatchers != null) {
            return false;
        }
        return !(this.typeface != null ? !this.typeface.equals((Object)textInputRef.typeface) : textInputRef.typeface != null);
    }

    public TextInput makeShallowCopy() {
        TextInput component = (TextInput)super.makeShallowCopy();
        return component;
    }

    protected void createInitialState(ComponentContext _0) {
        TextInputStateContainer _state = this.getStateContainerImpl(_0);
        StateValue mountedView = new StateValue();
        StateValue savedText = new StateValue();
        StateValue measureSeqNumber = new StateValue();
        TextInputSpec.onCreateInitialState((StateValue<AtomicReference<TextInputSpec.EditTextWithEventHandlers>>)mountedView, (StateValue<AtomicReference<CharSequence>>)savedText, (StateValue<Integer>)measureSeqNumber, this.initialText);
        _state.mountedView = (AtomicReference)mountedView.get();
        _state.savedText = (AtomicReference)savedText.get();
        _state.measureSeqNumber = (Integer)measureSeqNumber.get();
    }

    protected void onLoadStyle(ComponentContext c) {
        Output highlightColorTmp = new Output();
        TextInputSpec.onLoadStyle(c, (Output<Integer>)highlightColorTmp);
        if (highlightColorTmp.get() != null) {
            this.highlightColor = (Integer)highlightColorTmp.get();
        }
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout2, int widthSpec, int heightSpec, Size size, InterStagePropsContainer _5) {
        TextInputStateContainer _state = this.getStateContainerImpl(c);
        TextInputSpec.onMeasure(c, layout2, widthSpec, heightSpec, size, this.hint, this.inputBackground, this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor, this.textColorStateList, this.hintColorStateList, this.highlightColor, this.textSize, this.typeface, this.textAlignment, this.gravity, this.editable, this.inputType, this.rawInputType, this.imeOptions, this.inputFilters, this.multiline, this.ellipsize, this.minLines, this.maxLines, this.cursorDrawableRes, this.error, this.errorDrawable, this.keyListener, this.importantForAutofill, this.autofillHints, _state.savedText);
    }

    protected boolean canMeasure() {
        return true;
    }

    protected boolean shouldUpdate(Component _prevAbstractImpl, StateContainer _prevStateContainer, Component _nextAbstractImpl, StateContainer _nextStateContainer) {
        if (!this.isPureRender()) {
            return true;
        }
        TextInput _prevImpl = (TextInput)_prevAbstractImpl;
        TextInput _nextImpl = (TextInput)_nextAbstractImpl;
        Diff initialText = new Diff((Object)(_prevImpl == null ? null : _prevImpl.initialText), (Object)(_nextImpl == null ? null : _nextImpl.initialText));
        Diff hint = new Diff((Object)(_prevImpl == null ? null : _prevImpl.hint), (Object)(_nextImpl == null ? null : _nextImpl.hint));
        Diff inputBackground = new Diff((Object)(_prevImpl == null ? null : _prevImpl.inputBackground), (Object)(_nextImpl == null ? null : _nextImpl.inputBackground));
        Diff shadowRadius = new Diff((Object)(_prevImpl == null ? null : Float.valueOf(_prevImpl.shadowRadius)), _nextImpl == null ? null : Float.valueOf(_nextImpl.shadowRadius));
        Diff shadowDx = new Diff((Object)(_prevImpl == null ? null : Float.valueOf(_prevImpl.shadowDx)), _nextImpl == null ? null : Float.valueOf(_nextImpl.shadowDx));
        Diff shadowDy = new Diff((Object)(_prevImpl == null ? null : Float.valueOf(_prevImpl.shadowDy)), _nextImpl == null ? null : Float.valueOf(_nextImpl.shadowDy));
        Diff shadowColor = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.shadowColor)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.shadowColor));
        Diff textColorStateList = new Diff((Object)(_prevImpl == null ? null : _prevImpl.textColorStateList), (Object)(_nextImpl == null ? null : _nextImpl.textColorStateList));
        Diff hintColorStateList = new Diff((Object)(_prevImpl == null ? null : _prevImpl.hintColorStateList), (Object)(_nextImpl == null ? null : _nextImpl.hintColorStateList));
        Diff highlightColor = new Diff((Object)(_prevImpl == null ? null : _prevImpl.highlightColor), (Object)(_nextImpl == null ? null : _nextImpl.highlightColor));
        Diff textSize = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.textSize)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.textSize));
        Diff typeface = new Diff((Object)(_prevImpl == null ? null : _prevImpl.typeface), (Object)(_nextImpl == null ? null : _nextImpl.typeface));
        Diff textAlignment = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.textAlignment)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.textAlignment));
        Diff gravity = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.gravity)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.gravity));
        Diff editable = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.editable)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.editable));
        Diff inputType = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.inputType)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.inputType));
        Diff rawInputType = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.rawInputType)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.rawInputType));
        Diff imeOptions = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.imeOptions)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.imeOptions));
        Diff inputFilters = new Diff(_prevImpl == null ? null : _prevImpl.inputFilters, _nextImpl == null ? null : _nextImpl.inputFilters);
        Diff ellipsize = new Diff((Object)(_prevImpl == null ? null : _prevImpl.ellipsize), (Object)(_nextImpl == null ? null : _nextImpl.ellipsize));
        Diff multiline = new Diff((Object)(_prevImpl == null ? null : Boolean.valueOf(_prevImpl.multiline)), _nextImpl == null ? null : Boolean.valueOf(_nextImpl.multiline));
        Diff minLines = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.minLines)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.minLines));
        Diff maxLines = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.maxLines)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.maxLines));
        Diff cursorDrawableRes = new Diff((Object)(_prevImpl == null ? null : Integer.valueOf(_prevImpl.cursorDrawableRes)), _nextImpl == null ? null : Integer.valueOf(_nextImpl.cursorDrawableRes));
        Diff movementMethod = new Diff((Object)(_prevImpl == null ? null : _prevImpl.movementMethod), (Object)(_nextImpl == null ? null : _nextImpl.movementMethod));
        Diff error = new Diff((Object)(_prevImpl == null ? null : _prevImpl.error), (Object)(_nextImpl == null ? null : _nextImpl.error));
        Diff keyListener = new Diff((Object)(_prevImpl == null ? null : _prevImpl.keyListener), (Object)(_nextImpl == null ? null : _nextImpl.keyListener));
        Diff measureSeqNumber = new Diff((Object)(_prevImpl == null ? null : ((TextInputStateContainer)_prevStateContainer).measureSeqNumber), _nextImpl == null ? null : ((TextInputStateContainer)_nextStateContainer).measureSeqNumber);
        Diff mountedView = new Diff(_prevImpl == null ? null : ((TextInputStateContainer)_prevStateContainer).mountedView, _nextImpl == null ? null : ((TextInputStateContainer)_nextStateContainer).mountedView);
        Diff savedText = new Diff(_prevImpl == null ? null : ((TextInputStateContainer)_prevStateContainer).savedText, _nextImpl == null ? null : ((TextInputStateContainer)_nextStateContainer).savedText);
        boolean _result = TextInputSpec.shouldUpdate((Diff<CharSequence>)initialText, (Diff<CharSequence>)hint, (Diff<Drawable>)inputBackground, (Diff<Float>)shadowRadius, (Diff<Float>)shadowDx, (Diff<Float>)shadowDy, (Diff<Integer>)shadowColor, (Diff<ColorStateList>)textColorStateList, (Diff<ColorStateList>)hintColorStateList, (Diff<Integer>)highlightColor, (Diff<Integer>)textSize, (Diff<Typeface>)typeface, (Diff<Integer>)textAlignment, (Diff<Integer>)gravity, (Diff<Boolean>)editable, (Diff<Integer>)inputType, (Diff<Integer>)rawInputType, (Diff<Integer>)imeOptions, (Diff<List<InputFilter>>)inputFilters, (Diff<TextUtils.TruncateAt>)ellipsize, (Diff<Boolean>)multiline, (Diff<Integer>)minLines, (Diff<Integer>)maxLines, (Diff<Integer>)cursorDrawableRes, (Diff<MovementMethod>)movementMethod, (Diff<CharSequence>)error, (Diff<KeyListener>)keyListener, (Diff<Integer>)measureSeqNumber, (Diff<AtomicReference<TextInputSpec.EditTextWithEventHandlers>>)mountedView, (Diff<AtomicReference<CharSequence>>)savedText);
        return _result;
    }

    public boolean implementsShouldUpdate() {
        return true;
    }

    protected Object onCreateMountContent(Context c) {
        TextInputSpec.EditTextWithEventHandlers _result = TextInputSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object editText, InterStagePropsContainer _2) {
        TextInputStateContainer _state = this.getStateContainerImpl(c);
        TextInputSpec.onMount(c, (TextInputSpec.EditTextWithEventHandlers)((Object)editText), this.hint, this.inputBackground, this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor, this.textColorStateList, this.hintColorStateList, this.highlightColor, this.textSize, this.typeface, this.textAlignment, this.gravity, this.editable, this.inputType, this.rawInputType, this.imeOptions, this.inputFilters, this.multiline, this.minLines, this.maxLines, this.ellipsize, this.cursorDrawableRes, this.movementMethod, this.error, this.errorDrawable, this.keyListener, this.importantForAutofill, this.autofillHints, _state.savedText, _state.mountedView);
    }

    protected void onBind(ComponentContext c, Object editText, InterStagePropsContainer _2) {
        TextInputSpec.onBind(c, (TextInputSpec.EditTextWithEventHandlers)((Object)editText), this.textWatchers);
    }

    protected void onUnmount(ComponentContext c, Object editText, InterStagePropsContainer _2) {
        TextInputStateContainer _state = this.getStateContainerImpl(c);
        TextInputSpec.onUnmount(c, (TextInputSpec.EditTextWithEventHandlers)((Object)editText), this.keyListener, _state.mountedView);
    }

    protected void onUnbind(ComponentContext c, Object editText, InterStagePropsContainer _2) {
        TextInputSpec.onUnbind(c, (TextInputSpec.EditTextWithEventHandlers)((Object)editText));
    }

    public Component.MountType getMountType() {
        return Component.MountType.VIEW;
    }

    public int poolSize() {
        return 3;
    }

    public boolean canPreallocate() {
        return false;
    }

    public boolean isPureRender() {
        return true;
    }

    @Nullable
    public static EventHandler<TextChangedEvent> getTextChangedEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextInput)context.getComponentScope()).textChangedEventHandler;
    }

    @Nullable
    public static EventHandler<SelectionChangedEvent> getSelectionChangedEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextInput)context.getComponentScope()).selectionChangedEventHandler;
    }

    @Nullable
    public static EventHandler<InputFocusChangedEvent> getInputFocusChangedEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextInput)context.getComponentScope()).inputFocusChangedEventHandler;
    }

    @Nullable
    public static EventHandler<KeyUpEvent> getKeyUpEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextInput)context.getComponentScope()).keyUpEventHandler;
    }

    @Nullable
    public static EventHandler<KeyPreImeEvent> getKeyPreImeEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextInput)context.getComponentScope()).keyPreImeEventHandler;
    }

    @Nullable
    public static EventHandler<EditorActionEvent> getEditorActionEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextInput)context.getComponentScope()).editorActionEventHandler;
    }

    @Nullable
    public static EventHandler<SetTextEvent> getSetTextEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextInput)context.getComponentScope()).setTextEventHandler;
    }

    @Nullable
    public static EventHandler<InputConnectionEvent> getInputConnectionEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((TextInput)context.getComponentScope()).inputConnectionEventHandler;
    }

    static void dispatchTextChangedEvent(EventHandler _eventHandler, EditText view, String text) {
        TextChangedEvent _eventState = new TextChangedEvent();
        _eventState.view = view;
        _eventState.text = text;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static void dispatchSelectionChangedEvent(EventHandler _eventHandler, int start, int end) {
        SelectionChangedEvent _eventState = new SelectionChangedEvent();
        _eventState.start = start;
        _eventState.end = end;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static void dispatchInputFocusChangedEvent(EventHandler _eventHandler, boolean focused) {
        InputFocusChangedEvent _eventState = new InputFocusChangedEvent();
        _eventState.focused = focused;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static Boolean dispatchKeyUpEvent(EventHandler _eventHandler, int keyCode, KeyEvent keyEvent) {
        KeyUpEvent _eventState = new KeyUpEvent();
        _eventState.keyCode = keyCode;
        _eventState.keyEvent = keyEvent;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        return (Boolean)_dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static Boolean dispatchKeyPreImeEvent(EventHandler _eventHandler, int keyCode, KeyEvent keyEvent) {
        KeyPreImeEvent _eventState = new KeyPreImeEvent();
        _eventState.keyCode = keyCode;
        _eventState.keyEvent = keyEvent;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        return (Boolean)_dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static Boolean dispatchEditorActionEvent(EventHandler _eventHandler, TextView view, int actionId, KeyEvent event) {
        EditorActionEvent _eventState = new EditorActionEvent();
        _eventState.view = view;
        _eventState.actionId = actionId;
        _eventState.event = event;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        return (Boolean)_dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static void dispatchSetTextEvent(EventHandler _eventHandler, CharSequence text) {
        SetTextEvent _eventState = new SetTextEvent();
        _eventState.text = text;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    static InputConnection dispatchInputConnectionEvent(EventHandler _eventHandler, InputConnection inputConnection, EditorInfo editorInfo) {
        InputConnectionEvent _eventState = new InputConnectionEvent();
        _eventState.inputConnection = inputConnection;
        _eventState.editorInfo = editorInfo;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        return (InputConnection)_dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    private static EventTrigger<RequestFocusEvent> createRequestFocusTrigger(ComponentContext c, Component component) {
        int methodId = 1008096338;
        return TextInput.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<RequestFocusEvent> requestFocusTrigger(ComponentContext c, String key) {
        int methodId = 1008096338;
        return TextInput.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<ClearFocusEvent> createClearFocusTrigger(ComponentContext c, Component component) {
        int methodId = -50354224;
        return TextInput.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<ClearFocusEvent> clearFocusTrigger(ComponentContext c, String key) {
        int methodId = -50354224;
        return TextInput.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<GetTextEvent> createGetTextTrigger(ComponentContext c, Component component) {
        int methodId = -430503342;
        return TextInput.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<GetTextEvent> getTextTrigger(ComponentContext c, String key) {
        int methodId = -430503342;
        return TextInput.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<GetLineCountEvent> createGetLineCountTrigger(ComponentContext c, Component component) {
        int methodId = -1410879082;
        return TextInput.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<GetLineCountEvent> getLineCountTrigger(ComponentContext c, String key) {
        int methodId = -1410879082;
        return TextInput.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<SetTextEvent> createSetTextTrigger(ComponentContext c, Component component) {
        int methodId = 2092727750;
        return TextInput.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<SetTextEvent> setTextTrigger(ComponentContext c, String key) {
        int methodId = 2092727750;
        return TextInput.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<ReplaceTextEvent> createReplaceTextTrigger(ComponentContext c, Component component) {
        int methodId = -122250828;
        return TextInput.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<ReplaceTextEvent> replaceTextTrigger(ComponentContext c, String key) {
        int methodId = -122250828;
        return TextInput.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<DispatchKeyEvent> createDispatchKeyTrigger(ComponentContext c, Component component) {
        int methodId = 663828400;
        return TextInput.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<DispatchKeyEvent> dispatchKeyTrigger(ComponentContext c, String key) {
        int methodId = 663828400;
        return TextInput.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private static EventTrigger<SetSelectionEvent> createSetSelectionTrigger(ComponentContext c, Component component) {
        int methodId = -537896591;
        return TextInput.newEventTrigger((ComponentContext)c, (Component)component, (int)methodId);
    }

    @Deprecated
    public static EventTrigger<SetSelectionEvent> setSelectionTrigger(ComponentContext c, String key) {
        int methodId = -537896591;
        return TextInput.newEventTrigger((ComponentContext)c, (String)key, (int)methodId);
    }

    private void requestFocus(ComponentContext c, EventTriggerTarget _abstract) {
        TextInput _ref = (TextInput)_abstract;
        TextInputSpec.requestFocus(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView);
    }

    private void clearFocus(ComponentContext c, EventTriggerTarget _abstract) {
        TextInput _ref = (TextInput)_abstract;
        TextInputSpec.clearFocus(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView);
    }

    private CharSequence getText(ComponentContext c, EventTriggerTarget _abstract) {
        TextInput _ref = (TextInput)_abstract;
        CharSequence _result = TextInputSpec.getText(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView, _ref.getStateContainerImpl((ComponentContext)c).savedText);
        return _result;
    }

    private Integer getLineCount(ComponentContext c, EventTriggerTarget _abstract) {
        TextInput _ref = (TextInput)_abstract;
        Integer _result = TextInputSpec.getLineCount(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView);
        return _result;
    }

    private void setText(ComponentContext c, EventTriggerTarget _abstract, CharSequence text) {
        TextInput _ref = (TextInput)_abstract;
        TextInputSpec.setText(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView, _ref.getStateContainerImpl((ComponentContext)c).savedText, text);
    }

    private void replaceText(ComponentContext c, EventTriggerTarget _abstract, CharSequence text, int startIndex, int endIndex) {
        TextInput _ref = (TextInput)_abstract;
        TextInputSpec.replaceText(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView, _ref.getStateContainerImpl((ComponentContext)c).savedText, text, startIndex, endIndex);
    }

    private void dispatchKey(ComponentContext c, EventTriggerTarget _abstract, KeyEvent keyEvent) {
        TextInput _ref = (TextInput)_abstract;
        TextInputSpec.dispatchKey(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView, keyEvent);
    }

    private void setSelection(ComponentContext c, EventTriggerTarget _abstract, int start, int end) {
        TextInput _ref = (TextInput)_abstract;
        TextInputSpec.setSelection(c, _ref.getStateContainerImpl((ComponentContext)c).mountedView, start, end);
    }

    public static void requestFocus(ComponentContext c, Handle handle) {
        int methodId = 1008096338;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        RequestFocusEvent _eventState = new RequestFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void requestFocus(ComponentContext c, String key) {
        int methodId = 1008096338;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        RequestFocusEvent _eventState = new RequestFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void requestFocus(EventTrigger trigger) {
        RequestFocusEvent _eventState = new RequestFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void requestFocus(ComponentContext c) {
        TextInput component = (TextInput)c.getComponentScope();
        component.requestFocus(c, (EventTriggerTarget)component);
    }

    public static void clearFocus(ComponentContext c, Handle handle) {
        int methodId = -50354224;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        ClearFocusEvent _eventState = new ClearFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void clearFocus(ComponentContext c, String key) {
        int methodId = -50354224;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        ClearFocusEvent _eventState = new ClearFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void clearFocus(EventTrigger trigger) {
        ClearFocusEvent _eventState = new ClearFocusEvent();
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void clearFocus(ComponentContext c) {
        TextInput component = (TextInput)c.getComponentScope();
        component.clearFocus(c, (EventTriggerTarget)component);
    }

    public static CharSequence getText(ComponentContext c, Handle handle) {
        int methodId = -430503342;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return null;
        }
        GetTextEvent _eventState = new GetTextEvent();
        return (CharSequence)trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static CharSequence getText(ComponentContext c, String key) {
        int methodId = -430503342;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return null;
        }
        GetTextEvent _eventState = new GetTextEvent();
        return (CharSequence)trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static CharSequence getText(EventTrigger trigger) {
        GetTextEvent _eventState = new GetTextEvent();
        return (CharSequence)trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static CharSequence getText(ComponentContext c) {
        TextInput component = (TextInput)c.getComponentScope();
        return component.getText(c, (EventTriggerTarget)component);
    }

    public static Integer getLineCount(ComponentContext c, Handle handle) {
        int methodId = -1410879082;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return null;
        }
        GetLineCountEvent _eventState = new GetLineCountEvent();
        return (Integer)trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static Integer getLineCount(ComponentContext c, String key) {
        int methodId = -1410879082;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return null;
        }
        GetLineCountEvent _eventState = new GetLineCountEvent();
        return (Integer)trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static Integer getLineCount(EventTrigger trigger) {
        GetLineCountEvent _eventState = new GetLineCountEvent();
        return (Integer)trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static Integer getLineCount(ComponentContext c) {
        TextInput component = (TextInput)c.getComponentScope();
        return component.getLineCount(c, (EventTriggerTarget)component);
    }

    public static void setText(ComponentContext c, Handle handle, CharSequence text) {
        int methodId = 2092727750;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        SetTextEvent _eventState = new SetTextEvent();
        _eventState.text = text;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void setText(ComponentContext c, String key, CharSequence text) {
        int methodId = 2092727750;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        SetTextEvent _eventState = new SetTextEvent();
        _eventState.text = text;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void setText(EventTrigger trigger, CharSequence text) {
        SetTextEvent _eventState = new SetTextEvent();
        _eventState.text = text;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void setText(ComponentContext c, CharSequence text) {
        TextInput component = (TextInput)c.getComponentScope();
        component.setText(c, (EventTriggerTarget)component, text);
    }

    public static void replaceText(ComponentContext c, Handle handle, CharSequence text, int startIndex, int endIndex) {
        int methodId = -122250828;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        ReplaceTextEvent _eventState = new ReplaceTextEvent();
        _eventState.text = text;
        _eventState.startIndex = startIndex;
        _eventState.endIndex = endIndex;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void replaceText(ComponentContext c, String key, CharSequence text, int startIndex, int endIndex) {
        int methodId = -122250828;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        ReplaceTextEvent _eventState = new ReplaceTextEvent();
        _eventState.text = text;
        _eventState.startIndex = startIndex;
        _eventState.endIndex = endIndex;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void replaceText(EventTrigger trigger, CharSequence text, int startIndex, int endIndex) {
        ReplaceTextEvent _eventState = new ReplaceTextEvent();
        _eventState.text = text;
        _eventState.startIndex = startIndex;
        _eventState.endIndex = endIndex;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void replaceText(ComponentContext c, CharSequence text, int startIndex, int endIndex) {
        TextInput component = (TextInput)c.getComponentScope();
        component.replaceText(c, (EventTriggerTarget)component, text, startIndex, endIndex);
    }

    public static void dispatchKey(ComponentContext c, Handle handle, KeyEvent keyEvent) {
        int methodId = 663828400;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        DispatchKeyEvent _eventState = new DispatchKeyEvent();
        _eventState.keyEvent = keyEvent;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void dispatchKey(ComponentContext c, String key, KeyEvent keyEvent) {
        int methodId = 663828400;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        DispatchKeyEvent _eventState = new DispatchKeyEvent();
        _eventState.keyEvent = keyEvent;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void dispatchKey(EventTrigger trigger, KeyEvent keyEvent) {
        DispatchKeyEvent _eventState = new DispatchKeyEvent();
        _eventState.keyEvent = keyEvent;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void dispatchKey(ComponentContext c, KeyEvent keyEvent) {
        TextInput component = (TextInput)c.getComponentScope();
        component.dispatchKey(c, (EventTriggerTarget)component, keyEvent);
    }

    public static void setSelection(ComponentContext c, Handle handle, int start, int end) {
        int methodId = -537896591;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (Handle)handle);
        if (trigger == null) {
            return;
        }
        SetSelectionEvent _eventState = new SetSelectionEvent();
        _eventState.start = start;
        _eventState.end = end;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void setSelection(ComponentContext c, String key, int start, int end) {
        int methodId = -537896591;
        EventTrigger trigger = TextInput.getEventTrigger((ComponentContext)c, (int)methodId, (String)key);
        if (trigger == null) {
            return;
        }
        SetSelectionEvent _eventState = new SetSelectionEvent();
        _eventState.start = start;
        _eventState.end = end;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    public static void setSelection(EventTrigger trigger, int start, int end) {
        SetSelectionEvent _eventState = new SetSelectionEvent();
        _eventState.start = start;
        _eventState.end = end;
        trigger.dispatchOnTrigger((Object)_eventState, new Object[0]);
    }

    @Deprecated
    static void setSelection(ComponentContext c, int start, int end) {
        TextInput component = (TextInput)c.getComponentScope();
        component.setSelection(c, (EventTriggerTarget)component, start, end);
    }

    protected Object acceptTriggerEventImpl(EventTrigger eventTrigger, Object eventState, Object[] params) {
        int id = eventTrigger.mId;
        switch (id) {
            case 1008096338: {
                RequestFocusEvent _event = (RequestFocusEvent)eventState;
                this.requestFocus(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget);
                return null;
            }
            case -50354224: {
                ClearFocusEvent _event = (ClearFocusEvent)eventState;
                this.clearFocus(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget);
                return null;
            }
            case -430503342: {
                GetTextEvent _event = (GetTextEvent)eventState;
                return this.getText(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget);
            }
            case -1410879082: {
                GetLineCountEvent _event = (GetLineCountEvent)eventState;
                return this.getLineCount(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget);
            }
            case 2092727750: {
                SetTextEvent _event = (SetTextEvent)eventState;
                this.setText(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget, _event.text);
                return null;
            }
            case -122250828: {
                ReplaceTextEvent _event = (ReplaceTextEvent)eventState;
                this.replaceText(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget, _event.text, _event.startIndex, _event.endIndex);
                return null;
            }
            case 663828400: {
                DispatchKeyEvent _event = (DispatchKeyEvent)eventState;
                this.dispatchKey(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget, _event.keyEvent);
                return null;
            }
            case -537896591: {
                SetSelectionEvent _event = (SetSelectionEvent)eventState;
                this.setSelection(eventTrigger.mComponentContext, eventTrigger.mTriggerTarget, _event.start, _event.end);
                return null;
            }
        }
        return null;
    }

    public void recordEventTrigger(ComponentContext c, EventTriggersContainer container) {
        if (this.requestFocusTrigger != null) {
            this.requestFocusTrigger.mComponentContext = c;
            this.requestFocusTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.requestFocusTrigger);
        }
        if (this.clearFocusTrigger != null) {
            this.clearFocusTrigger.mComponentContext = c;
            this.clearFocusTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.clearFocusTrigger);
        }
        if (this.getTextTrigger != null) {
            this.getTextTrigger.mComponentContext = c;
            this.getTextTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.getTextTrigger);
        }
        if (this.getLineCountTrigger != null) {
            this.getLineCountTrigger.mComponentContext = c;
            this.getLineCountTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.getLineCountTrigger);
        }
        if (this.setTextTrigger != null) {
            this.setTextTrigger.mComponentContext = c;
            this.setTextTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.setTextTrigger);
        }
        if (this.replaceTextTrigger != null) {
            this.replaceTextTrigger.mComponentContext = c;
            this.replaceTextTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.replaceTextTrigger);
        }
        if (this.dispatchKeyTrigger != null) {
            this.dispatchKeyTrigger.mComponentContext = c;
            this.dispatchKeyTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.dispatchKeyTrigger);
        }
        if (this.setSelectionTrigger != null) {
            this.setSelectionTrigger.mComponentContext = c;
            this.setSelectionTrigger.mTriggerTarget = this;
            container.recordEventTrigger(this.setSelectionTrigger);
        }
    }

    protected boolean hasState() {
        return true;
    }

    protected void transferState(StateContainer _prevStateContainer, StateContainer _nextStateContainer) {
        TextInputStateContainer prevStateContainer = (TextInputStateContainer)_prevStateContainer;
        TextInputStateContainer nextStateContainer = (TextInputStateContainer)_nextStateContainer;
        nextStateContainer.measureSeqNumber = prevStateContainer.measureSeqNumber;
        nextStateContainer.mountedView = prevStateContainer.mountedView;
        nextStateContainer.savedText = prevStateContainer.savedText;
    }

    protected static void remeasureForUpdatedText(ComponentContext c) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[0]);
        c.updateStateAsync(_stateUpdate, "updateState:TextInput.remeasureForUpdatedText");
    }

    protected static void remeasureForUpdatedTextAsync(ComponentContext c) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[0]);
        c.updateStateAsync(_stateUpdate, "updateState:TextInput.remeasureForUpdatedText");
    }

    protected static void remeasureForUpdatedTextSync(ComponentContext c) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[0]);
        c.updateStateSync(_stateUpdate, "updateState:TextInput.remeasureForUpdatedText");
    }

    public static Builder create(ComponentContext context) {
        return TextInput.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        TextInput instance = new TextInput();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        TextInput mTextInput;
        ComponentContext mContext;

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, TextInput textInputRef) {
            super(context, defStyleAttr, defStyleRes, (Component)textInputRef);
            this.mTextInput = textInputRef;
            this.mContext = context;
        }

        protected void setComponent(Component component) {
            this.mTextInput = (TextInput)component;
        }

        @PropSetter(value="autofillHints", required=false)
        public Builder autofillHints(@javax.annotation.Nullable String[] autofillHints) {
            this.mTextInput.autofillHints = autofillHints;
            return this;
        }

        @PropSetter(value="cursorDrawableRes", required=false)
        public Builder cursorDrawableRes(int cursorDrawableRes) {
            this.mTextInput.cursorDrawableRes = cursorDrawableRes;
            return this;
        }

        @PropSetter(value="editable", required=false)
        public Builder editable(boolean editable) {
            this.mTextInput.editable = editable;
            return this;
        }

        @PropSetter(value="ellipsize", required=false)
        public Builder ellipsize(TextUtils.TruncateAt ellipsize) {
            this.mTextInput.ellipsize = ellipsize;
            return this;
        }

        @PropSetter(value="error", required=false)
        public Builder error(CharSequence error) {
            this.mTextInput.error = error;
            return this;
        }

        @PropSetter(value="error", required=false)
        public Builder errorRes(@StringRes int resId) {
            this.mTextInput.error = this.mResourceResolver.resolveStringRes(resId);
            return this;
        }

        @PropSetter(value="error", required=false)
        public Builder errorRes(@StringRes int resId, Object ... formatArgs) {
            this.mTextInput.error = this.mResourceResolver.resolveStringRes(resId, formatArgs);
            return this;
        }

        @PropSetter(value="error", required=false)
        public Builder errorAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mTextInput.error = this.mResourceResolver.resolveStringAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="error", required=false)
        public Builder errorAttr(@AttrRes int attrResId) {
            this.mTextInput.error = this.mResourceResolver.resolveStringAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="errorDrawable", required=false)
        public Builder errorDrawable(Drawable errorDrawable) {
            this.mTextInput.errorDrawable = errorDrawable;
            return this;
        }

        @PropSetter(value="errorDrawable", required=false)
        public Builder errorDrawableRes(@DrawableRes int resId) {
            this.mTextInput.errorDrawable = this.mResourceResolver.resolveDrawableRes(resId);
            return this;
        }

        @PropSetter(value="errorDrawable", required=false)
        public Builder errorDrawableAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mTextInput.errorDrawable = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="errorDrawable", required=false)
        public Builder errorDrawableAttr(@AttrRes int attrResId) {
            this.mTextInput.errorDrawable = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="gravity", required=false)
        public Builder gravity(int gravity) {
            this.mTextInput.gravity = gravity;
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColor(@ColorInt Integer highlightColor) {
            this.mTextInput.highlightColor = highlightColor;
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorRes(@ColorRes int resId) {
            this.mTextInput.highlightColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTextInput.highlightColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorAttr(@AttrRes int attrResId) {
            this.mTextInput.highlightColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hint(CharSequence hint) {
            this.mTextInput.hint = hint;
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hintRes(@StringRes int resId) {
            this.mTextInput.hint = this.mResourceResolver.resolveStringRes(resId);
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hintRes(@StringRes int resId, Object ... formatArgs) {
            this.mTextInput.hint = this.mResourceResolver.resolveStringRes(resId, formatArgs);
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hintAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mTextInput.hint = this.mResourceResolver.resolveStringAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="hint", required=false)
        public Builder hintAttr(@AttrRes int attrResId) {
            this.mTextInput.hint = this.mResourceResolver.resolveStringAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="hintColorStateList", required=false)
        public Builder hintColorStateList(ColorStateList hintColorStateList) {
            this.mTextInput.hintColorStateList = hintColorStateList;
            return this;
        }

        @PropSetter(value="imeOptions", required=false)
        public Builder imeOptions(int imeOptions) {
            this.mTextInput.imeOptions = imeOptions;
            return this;
        }

        @PropSetter(value="importantForAutofill", required=false)
        public Builder importantForAutofill(int importantForAutofill) {
            this.mTextInput.importantForAutofill = importantForAutofill;
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialText(CharSequence initialText) {
            this.mTextInput.initialText = initialText;
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialTextRes(@StringRes int resId) {
            this.mTextInput.initialText = this.mResourceResolver.resolveStringRes(resId);
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialTextRes(@StringRes int resId, Object ... formatArgs) {
            this.mTextInput.initialText = this.mResourceResolver.resolveStringRes(resId, formatArgs);
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialTextAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mTextInput.initialText = this.mResourceResolver.resolveStringAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="initialText", required=false)
        public Builder initialTextAttr(@AttrRes int attrResId) {
            this.mTextInput.initialText = this.mResourceResolver.resolveStringAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="inputBackground", required=false)
        public Builder inputBackground(Drawable inputBackground) {
            this.mTextInput.inputBackground = inputBackground;
            return this;
        }

        @PropSetter(value="inputBackground", required=false)
        public Builder inputBackgroundRes(@DrawableRes int resId) {
            this.mTextInput.inputBackground = this.mResourceResolver.resolveDrawableRes(resId);
            return this;
        }

        @PropSetter(value="inputBackground", required=false)
        public Builder inputBackgroundAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mTextInput.inputBackground = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="inputBackground", required=false)
        public Builder inputBackgroundAttr(@AttrRes int attrResId) {
            this.mTextInput.inputBackground = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="inputFilters", required=false)
        public Builder inputFilter(InputFilter inputFilter) {
            if (inputFilter == null) {
                return this;
            }
            if (this.mTextInput.inputFilters == Collections.EMPTY_LIST) {
                this.mTextInput.inputFilters = new ArrayList<InputFilter>();
            }
            this.mTextInput.inputFilters.add(inputFilter);
            return this;
        }

        @PropSetter(value="inputFilters", required=false)
        public Builder inputFilters(List<InputFilter> inputFilters) {
            if (inputFilters == null) {
                return this;
            }
            if (this.mTextInput.inputFilters.isEmpty()) {
                this.mTextInput.inputFilters = inputFilters;
            } else {
                this.mTextInput.inputFilters.addAll(inputFilters);
            }
            return this;
        }

        @PropSetter(value="inputType", required=false)
        public Builder inputType(int inputType) {
            this.mTextInput.inputType = inputType;
            return this;
        }

        @PropSetter(value="keyListener", required=false)
        public Builder keyListener(@javax.annotation.Nullable KeyListener keyListener) {
            this.mTextInput.keyListener = keyListener;
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLines(int maxLines) {
            this.mTextInput.maxLines = maxLines;
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLines(int minLines) {
            this.mTextInput.minLines = minLines;
            return this;
        }

        @PropSetter(value="movementMethod", required=false)
        public Builder movementMethod(MovementMethod movementMethod) {
            this.mTextInput.movementMethod = movementMethod;
            return this;
        }

        @PropSetter(value="multiline", required=false)
        public Builder multiline(boolean multiline) {
            this.mTextInput.multiline = multiline;
            return this;
        }

        @PropSetter(value="rawInputType", required=false)
        public Builder rawInputType(int rawInputType) {
            this.mTextInput.rawInputType = rawInputType;
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColor(@ColorInt int shadowColor) {
            this.mTextInput.shadowColor = shadowColor;
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorRes(@ColorRes int resId) {
            this.mTextInput.shadowColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mTextInput.shadowColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorAttr(@AttrRes int attrResId) {
            this.mTextInput.shadowColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxPx(@Px float shadowDx) {
            this.mTextInput.shadowDx = shadowDx;
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxDip(@Dimension(unit=0) float dip) {
            this.mTextInput.shadowDx = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxSp(@Dimension(unit=2) float sip) {
            this.mTextInput.shadowDx = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxRes(@DimenRes int resId) {
            this.mTextInput.shadowDx = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextInput.shadowDx = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxAttr(@AttrRes int attrResId) {
            this.mTextInput.shadowDx = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyPx(@Px float shadowDy) {
            this.mTextInput.shadowDy = shadowDy;
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyDip(@Dimension(unit=0) float dip) {
            this.mTextInput.shadowDy = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDySp(@Dimension(unit=2) float sip) {
            this.mTextInput.shadowDy = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyRes(@DimenRes int resId) {
            this.mTextInput.shadowDy = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextInput.shadowDy = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyAttr(@AttrRes int attrResId) {
            this.mTextInput.shadowDy = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusPx(@Px float shadowRadius) {
            this.mTextInput.shadowRadius = shadowRadius;
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusDip(@Dimension(unit=0) float dip) {
            this.mTextInput.shadowRadius = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusSp(@Dimension(unit=2) float sip) {
            this.mTextInput.shadowRadius = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusRes(@DimenRes int resId) {
            this.mTextInput.shadowRadius = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextInput.shadowRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusAttr(@AttrRes int attrResId) {
            this.mTextInput.shadowRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="textAlignment", required=false)
        public Builder textAlignment(int textAlignment) {
            this.mTextInput.textAlignment = textAlignment;
            return this;
        }

        @PropSetter(value="textColorStateList", required=false)
        public Builder textColorStateList(ColorStateList textColorStateList) {
            this.mTextInput.textColorStateList = textColorStateList;
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizePx(@Px int textSize) {
            this.mTextInput.textSize = textSize;
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeDip(@Dimension(unit=0) float dip) {
            this.mTextInput.textSize = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeSp(@Dimension(unit=2) float sip) {
            this.mTextInput.textSize = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeRes(@DimenRes int resId) {
            this.mTextInput.textSize = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mTextInput.textSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeAttr(@AttrRes int attrResId) {
            this.mTextInput.textSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="textWatchers", required=false)
        public Builder textWatcher(TextWatcher textWatcher) {
            if (textWatcher == null) {
                return this;
            }
            if (this.mTextInput.textWatchers == Collections.EMPTY_LIST) {
                this.mTextInput.textWatchers = new ArrayList<TextWatcher>();
            }
            this.mTextInput.textWatchers.add(textWatcher);
            return this;
        }

        @PropSetter(value="textWatchers", required=false)
        public Builder textWatchers(List<TextWatcher> textWatchers) {
            if (textWatchers == null) {
                return this;
            }
            if (this.mTextInput.textWatchers.isEmpty()) {
                this.mTextInput.textWatchers = textWatchers;
            } else {
                this.mTextInput.textWatchers.addAll(textWatchers);
            }
            return this;
        }

        @PropSetter(value="typeface", required=false)
        public Builder typeface(Typeface typeface) {
            this.mTextInput.typeface = typeface;
            return this;
        }

        public Builder textChangedEventHandler(@Nullable EventHandler<TextChangedEvent> textChangedEventHandler) {
            this.mTextInput.textChangedEventHandler = textChangedEventHandler;
            return this;
        }

        public Builder selectionChangedEventHandler(@Nullable EventHandler<SelectionChangedEvent> selectionChangedEventHandler) {
            this.mTextInput.selectionChangedEventHandler = selectionChangedEventHandler;
            return this;
        }

        public Builder inputFocusChangedEventHandler(@Nullable EventHandler<InputFocusChangedEvent> inputFocusChangedEventHandler) {
            this.mTextInput.inputFocusChangedEventHandler = inputFocusChangedEventHandler;
            return this;
        }

        public Builder keyUpEventHandler(@Nullable EventHandler<KeyUpEvent> keyUpEventHandler) {
            this.mTextInput.keyUpEventHandler = keyUpEventHandler;
            return this;
        }

        public Builder keyPreImeEventHandler(@Nullable EventHandler<KeyPreImeEvent> keyPreImeEventHandler) {
            this.mTextInput.keyPreImeEventHandler = keyPreImeEventHandler;
            return this;
        }

        public Builder editorActionEventHandler(@Nullable EventHandler<EditorActionEvent> editorActionEventHandler) {
            this.mTextInput.editorActionEventHandler = editorActionEventHandler;
            return this;
        }

        public Builder setTextEventHandler(@Nullable EventHandler<SetTextEvent> setTextEventHandler) {
            this.mTextInput.setTextEventHandler = setTextEventHandler;
            return this;
        }

        public Builder inputConnectionEventHandler(@Nullable EventHandler<InputConnectionEvent> inputConnectionEventHandler) {
            this.mTextInput.inputConnectionEventHandler = inputConnectionEventHandler;
            return this;
        }

        @Deprecated
        public Builder requestFocusTrigger(EventTrigger requestFocusTrigger) {
            this.mTextInput.requestFocusTrigger = requestFocusTrigger;
            return this;
        }

        private void registerRequestFocusTrigger() {
            EventTrigger requestFocusTrigger = this.mTextInput.requestFocusTrigger;
            if (requestFocusTrigger == null) {
                requestFocusTrigger = TextInput.createRequestFocusTrigger(this.mContext, (Component)this.mTextInput);
            }
            this.requestFocusTrigger(requestFocusTrigger);
        }

        @Deprecated
        public Builder clearFocusTrigger(EventTrigger clearFocusTrigger) {
            this.mTextInput.clearFocusTrigger = clearFocusTrigger;
            return this;
        }

        private void registerClearFocusTrigger() {
            EventTrigger clearFocusTrigger = this.mTextInput.clearFocusTrigger;
            if (clearFocusTrigger == null) {
                clearFocusTrigger = TextInput.createClearFocusTrigger(this.mContext, (Component)this.mTextInput);
            }
            this.clearFocusTrigger(clearFocusTrigger);
        }

        @Deprecated
        public Builder getTextTrigger(EventTrigger getTextTrigger) {
            this.mTextInput.getTextTrigger = getTextTrigger;
            return this;
        }

        private void registerGetTextTrigger() {
            EventTrigger getTextTrigger = this.mTextInput.getTextTrigger;
            if (getTextTrigger == null) {
                getTextTrigger = TextInput.createGetTextTrigger(this.mContext, (Component)this.mTextInput);
            }
            this.getTextTrigger(getTextTrigger);
        }

        @Deprecated
        public Builder getLineCountTrigger(EventTrigger getLineCountTrigger) {
            this.mTextInput.getLineCountTrigger = getLineCountTrigger;
            return this;
        }

        private void registerGetLineCountTrigger() {
            EventTrigger getLineCountTrigger = this.mTextInput.getLineCountTrigger;
            if (getLineCountTrigger == null) {
                getLineCountTrigger = TextInput.createGetLineCountTrigger(this.mContext, (Component)this.mTextInput);
            }
            this.getLineCountTrigger(getLineCountTrigger);
        }

        @Deprecated
        public Builder setTextTrigger(EventTrigger setTextTrigger) {
            this.mTextInput.setTextTrigger = setTextTrigger;
            return this;
        }

        private void registerSetTextTrigger() {
            EventTrigger setTextTrigger = this.mTextInput.setTextTrigger;
            if (setTextTrigger == null) {
                setTextTrigger = TextInput.createSetTextTrigger(this.mContext, (Component)this.mTextInput);
            }
            this.setTextTrigger(setTextTrigger);
        }

        @Deprecated
        public Builder replaceTextTrigger(EventTrigger replaceTextTrigger) {
            this.mTextInput.replaceTextTrigger = replaceTextTrigger;
            return this;
        }

        private void registerReplaceTextTrigger() {
            EventTrigger replaceTextTrigger = this.mTextInput.replaceTextTrigger;
            if (replaceTextTrigger == null) {
                replaceTextTrigger = TextInput.createReplaceTextTrigger(this.mContext, (Component)this.mTextInput);
            }
            this.replaceTextTrigger(replaceTextTrigger);
        }

        @Deprecated
        public Builder dispatchKeyTrigger(EventTrigger dispatchKeyTrigger) {
            this.mTextInput.dispatchKeyTrigger = dispatchKeyTrigger;
            return this;
        }

        private void registerDispatchKeyTrigger() {
            EventTrigger dispatchKeyTrigger = this.mTextInput.dispatchKeyTrigger;
            if (dispatchKeyTrigger == null) {
                dispatchKeyTrigger = TextInput.createDispatchKeyTrigger(this.mContext, (Component)this.mTextInput);
            }
            this.dispatchKeyTrigger(dispatchKeyTrigger);
        }

        @Deprecated
        public Builder setSelectionTrigger(EventTrigger setSelectionTrigger) {
            this.mTextInput.setSelectionTrigger = setSelectionTrigger;
            return this;
        }

        private void registerSetSelectionTrigger() {
            EventTrigger setSelectionTrigger = this.mTextInput.setSelectionTrigger;
            if (setSelectionTrigger == null) {
                setSelectionTrigger = TextInput.createSetSelectionTrigger(this.mContext, (Component)this.mTextInput);
            }
            this.setSelectionTrigger(setSelectionTrigger);
        }

        private void registerEventTriggers() {
            this.registerRequestFocusTrigger();
            this.registerClearFocusTrigger();
            this.registerGetTextTrigger();
            this.registerGetLineCountTrigger();
            this.registerSetTextTrigger();
            this.registerReplaceTextTrigger();
            this.registerDispatchKeyTrigger();
            this.registerSetSelectionTrigger();
        }

        public Builder getThis() {
            return this;
        }

        public TextInput build() {
            this.registerEventTriggers();
            return this.mTextInput;
        }
    }

    @Generated
    @VisibleForTesting(otherwise=2)
    static class TextInputStateContainer
    extends StateContainer {
        @State
        @Comparable(type=13)
        Integer measureSeqNumber;
        @State
        @Comparable(type=13)
        AtomicReference<TextInputSpec.EditTextWithEventHandlers> mountedView;
        @State
        @Comparable(type=13)
        AtomicReference<CharSequence> savedText;

        TextInputStateContainer() {
        }

        public void applyStateUpdate(StateContainer.StateUpdate stateUpdate) {
            Object[] params = stateUpdate.params;
            switch (stateUpdate.type) {
                case 0: {
                    StateValue measureSeqNumber = new StateValue();
                    measureSeqNumber.set((Object)this.measureSeqNumber);
                    TextInputSpec.remeasureForUpdatedText((StateValue<Integer>)measureSeqNumber);
                    this.measureSeqNumber = (Integer)measureSeqNumber.get();
                }
            }
        }
    }
}

