/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;

public class TransparencyEnabledCardClipDrawable
extends Drawable {
    static final int NONE = 0;
    static final int TOP_LEFT = 1;
    static final int TOP_RIGHT = 2;
    static final int BOTTOM_LEFT = 4;
    static final int BOTTOM_RIGHT = 8;
    private final Paint mBackgroundPaint;
    private final RectF mScratchRect = new RectF();
    private final Path mCornerPath = new Path();
    private Paint mCornerPaint;
    private boolean mDirty = true;
    private int mDisableClipCorners = 0;
    private float mCornerRadius;

    public TransparencyEnabledCardClipDrawable() {
        this.mBackgroundPaint = new Paint(5);
        this.resetCornerPaint();
    }

    public void setAlpha(int alpha) {
        this.mBackgroundPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mBackgroundPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (this.areAllDisableClipFalse()) {
            canvas.drawRect(bounds, this.mCornerPaint);
            this.drawWithRoundRectImplementation(canvas, bounds);
        } else {
            this.drawWithClipPathImplementation(canvas, bounds);
        }
    }

    private void drawWithClipPathImplementation(Canvas canvas, Rect bounds) {
        int saved;
        if (this.mDirty) {
            this.buildClippingCorners();
            this.mDirty = false;
        }
        canvas.drawRect(bounds, this.mBackgroundPaint);
        if ((this.mDisableClipCorners & 1) == 0) {
            saved = canvas.save();
            canvas.translate((float)bounds.left, (float)bounds.top);
            canvas.drawPath(this.mCornerPath, this.mCornerPaint);
            canvas.restoreToCount(saved);
        }
        if ((this.mDisableClipCorners & 8) == 0) {
            saved = canvas.save();
            canvas.translate((float)bounds.right, (float)bounds.bottom);
            canvas.rotate(180.0f);
            canvas.drawPath(this.mCornerPath, this.mCornerPaint);
            canvas.restoreToCount(saved);
        }
        if ((this.mDisableClipCorners & 4) == 0) {
            saved = canvas.save();
            canvas.translate((float)bounds.left, (float)bounds.bottom);
            canvas.rotate(270.0f);
            canvas.drawPath(this.mCornerPath, this.mCornerPaint);
            canvas.restoreToCount(saved);
        }
        if ((this.mDisableClipCorners & 2) == 0) {
            saved = canvas.save();
            canvas.translate((float)bounds.right, (float)bounds.top);
            canvas.rotate(90.0f);
            canvas.drawPath(this.mCornerPath, this.mCornerPaint);
            canvas.restoreToCount(saved);
        }
    }

    private void drawWithRoundRectImplementation(Canvas canvas, Rect bounds) {
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawRoundRect((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mCornerRadius, this.mCornerRadius, this.mBackgroundPaint);
        } else {
            this.mScratchRect.set(bounds);
            canvas.drawRoundRect(this.mScratchRect, this.mCornerRadius, this.mCornerRadius, this.mBackgroundPaint);
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        if (this.mBackgroundPaint.getColor() == backgroundColor) {
            return;
        }
        this.mBackgroundPaint.setColor(backgroundColor);
        this.invalidateSelf();
    }

    public void setClippingColor(int clippingColor) {
        if (this.mCornerPaint.getColor() == clippingColor) {
            return;
        }
        if (clippingColor == 0 && !this.areAllDisableClipFalse()) {
            this.setAlphaAndXferModeForTransparentClipping();
        } else {
            this.resetCornerPaint();
        }
        this.mCornerPaint.setColor(clippingColor);
        this.mDirty = true;
        this.invalidateSelf();
    }

    private void setAlphaAndXferModeForTransparentClipping() {
        this.mCornerPaint.setAlpha(255);
        this.mCornerPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    public void setCornerRadius(float radius) {
        if (this.mCornerRadius == (radius = (float)((int)(radius + 0.5f)))) {
            return;
        }
        this.mDirty = true;
        this.mCornerRadius = radius;
        this.invalidateSelf();
    }

    private void buildClippingCorners() {
        this.mCornerPath.reset();
        RectF oval = new RectF(0.0f, 0.0f, this.mCornerRadius * 2.0f, this.mCornerRadius * 2.0f);
        this.mCornerPath.setFillType(Path.FillType.EVEN_ODD);
        this.mCornerPath.moveTo(0.0f, 0.0f);
        this.mCornerPath.lineTo(0.0f, this.mCornerRadius);
        this.mCornerPath.arcTo(oval, 180.0f, 90.0f, true);
        this.mCornerPath.lineTo(0.0f, 0.0f);
        this.mCornerPath.close();
    }

    public void setDisableClip(int edge) {
        if (this.mDisableClipCorners == edge) {
            return;
        }
        this.mDisableClipCorners = edge;
        if (this.mCornerPaint.getColor() == 0 && !this.areAllDisableClipFalse()) {
            this.setAlphaAndXferModeForTransparentClipping();
        }
        this.mDirty = true;
        this.invalidateSelf();
    }

    public void resetCornerPaint() {
        this.mCornerPaint = new Paint(1);
    }

    private boolean areAllDisableClipFalse() {
        return this.mDisableClipCorners == 0;
    }
}

