/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.Px;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.CardClipDrawable;
import com.facebook.litho.widget.CardClipSpec;

@Generated
public final class CardClip
extends SpecGeneratedComponent {
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int clippingColor = -1;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float cornerRadius;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disableClipBottomLeft;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disableClipBottomRight;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disableClipTopLeft;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean disableClipTopRight;

    private CardClip() {
        super("CardClip");
    }

    public boolean isEquivalentProps(Component other, boolean shouldCompareCommonProps) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        CardClip cardClipRef = (CardClip)other;
        if (this.clippingColor != cardClipRef.clippingColor) {
            return false;
        }
        if (Float.compare(this.cornerRadius, cardClipRef.cornerRadius) != 0) {
            return false;
        }
        if (this.disableClipBottomLeft != cardClipRef.disableClipBottomLeft) {
            return false;
        }
        if (this.disableClipBottomRight != cardClipRef.disableClipBottomRight) {
            return false;
        }
        if (this.disableClipTopLeft != cardClipRef.disableClipTopLeft) {
            return false;
        }
        return this.disableClipTopRight == cardClipRef.disableClipTopRight;
    }

    protected Object onCreateMountContent(Context c) {
        CardClipDrawable _result = CardClipSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object cardClipDrawable, InterStagePropsContainer _2) {
        CardClipSpec.onMount(c, (CardClipDrawable)((Object)cardClipDrawable), this.clippingColor, this.cornerRadius, this.disableClipTopLeft, this.disableClipTopRight, this.disableClipBottomLeft, this.disableClipBottomRight);
    }

    protected void onUnmount(ComponentContext c, Object cardClipDrawable, InterStagePropsContainer _2) {
        CardClipSpec.onUnmount(c, (CardClipDrawable)((Object)cardClipDrawable));
    }

    public Component.MountType getMountType() {
        return Component.MountType.DRAWABLE;
    }

    public int poolSize() {
        return 3;
    }

    public boolean canPreallocate() {
        return false;
    }

    public boolean isPureRender() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return CardClip.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        CardClip instance = new CardClip();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        CardClip mCardClip;
        ComponentContext mContext;

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, CardClip cardClipRef) {
            super(context, defStyleAttr, defStyleRes, (Component)cardClipRef);
            this.mCardClip = cardClipRef;
            this.mContext = context;
        }

        protected void setComponent(Component component) {
            this.mCardClip = (CardClip)component;
        }

        @PropSetter(value="clippingColor", required=false)
        public Builder clippingColor(@ColorInt int clippingColor) {
            this.mCardClip.clippingColor = clippingColor;
            return this;
        }

        @PropSetter(value="clippingColor", required=false)
        public Builder clippingColorRes(@ColorRes int resId) {
            this.mCardClip.clippingColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="clippingColor", required=false)
        public Builder clippingColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mCardClip.clippingColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="clippingColor", required=false)
        public Builder clippingColorAttr(@AttrRes int attrResId) {
            this.mCardClip.clippingColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusPx(@Px float cornerRadius) {
            this.mCardClip.cornerRadius = cornerRadius;
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusDip(@Dimension(unit=0) float dip) {
            this.mCardClip.cornerRadius = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusSp(@Dimension(unit=2) float sip) {
            this.mCardClip.cornerRadius = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusRes(@DimenRes int resId) {
            this.mCardClip.cornerRadius = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mCardClip.cornerRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="cornerRadius", required=false)
        public Builder cornerRadiusAttr(@AttrRes int attrResId) {
            this.mCardClip.cornerRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="disableClipBottomLeft", required=false)
        public Builder disableClipBottomLeft(boolean disableClipBottomLeft) {
            this.mCardClip.disableClipBottomLeft = disableClipBottomLeft;
            return this;
        }

        @PropSetter(value="disableClipBottomRight", required=false)
        public Builder disableClipBottomRight(boolean disableClipBottomRight) {
            this.mCardClip.disableClipBottomRight = disableClipBottomRight;
            return this;
        }

        @PropSetter(value="disableClipTopLeft", required=false)
        public Builder disableClipTopLeft(boolean disableClipTopLeft) {
            this.mCardClip.disableClipTopLeft = disableClipTopLeft;
            return this;
        }

        @PropSetter(value="disableClipTopRight", required=false)
        public Builder disableClipTopRight(boolean disableClipTopRight) {
            this.mCardClip.disableClipTopRight = disableClipTopRight;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public CardClip build() {
            return this.mCardClip;
        }
    }
}

