/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;

public class CardShadowDrawable
extends Drawable {
    public static final float UNDEFINED = -1.0f;
    private int mShadowStartColor;
    private int mShadowEndColor;
    private final Paint mEdgeShadowPaint;
    private final Path mCornerShadowTopLeftPath = new Path();
    private final Path mCornerShadowBottomLeftPath = new Path();
    private final Path mCornerShadowTopRightPath = new Path();
    private final Path mCornerShadowBottomRightPath = new Path();
    private final Paint mCornerShadowLeftPaint = new Paint(5);
    private final Paint mCornerShadowRightPaint;
    private float mCornerRadius;
    private float mShadowSize;
    private float mShadowLeftSizeOverride = -1.0f;
    private float mShadowRightSizeOverride = -1.0f;
    private float mShadowDx = -1.0f;
    private float mShadowDy = -1.0f;
    private boolean mHideTopShadow;
    private boolean mHideBottomShadow;
    private boolean mDirty = true;

    public CardShadowDrawable() {
        this.mCornerShadowLeftPaint.setStyle(Paint.Style.FILL);
        this.mCornerShadowRightPaint = new Paint(5);
        this.mCornerShadowRightPaint.setStyle(Paint.Style.FILL);
        this.mEdgeShadowPaint = new Paint(this.mCornerShadowLeftPaint);
        this.mEdgeShadowPaint.setAntiAlias(false);
    }

    public void setAlpha(int alpha) {
        this.mCornerShadowLeftPaint.setAlpha(alpha);
        this.mCornerShadowRightPaint.setAlpha(alpha);
        this.mEdgeShadowPaint.setAlpha(alpha);
    }

    public static int getShadowLeft(float shadowSize, float shadowDx) {
        return (int)Math.ceil((float)CardShadowDrawable.toEven(shadowSize) - shadowDx);
    }

    public static int getShadowLeft(float shadowSize) {
        return CardShadowDrawable.getShadowLeft(shadowSize, 0.0f);
    }

    public static int getShadowRight(float shadowSize, float shadowDx) {
        return (int)Math.ceil((float)CardShadowDrawable.toEven(shadowSize) + shadowDx);
    }

    public static int getShadowRight(float shadowSize) {
        return CardShadowDrawable.getShadowRight(shadowSize, 0.0f);
    }

    public static int getShadowTop(float shadowSize, float shadowDy) {
        return (int)Math.ceil((float)CardShadowDrawable.toEven(shadowSize) - shadowDy);
    }

    public static int getShadowTop(float shadowSize) {
        float shadowDy = CardShadowDrawable.getDefaultShadowDy(shadowSize);
        return CardShadowDrawable.getShadowTop(shadowSize, shadowDy);
    }

    private static float getDefaultShadowDy(float shadowSize) {
        return (float)CardShadowDrawable.toEven(shadowSize) * 0.5f;
    }

    public static int getShadowBottom(float shadowSize, float shadowDy) {
        return (int)Math.ceil((float)CardShadowDrawable.toEven(shadowSize) + shadowDy);
    }

    public static int getShadowBottom(float shadowSize) {
        float shadowDy = CardShadowDrawable.getDefaultShadowDy(shadowSize);
        return CardShadowDrawable.getShadowBottom(shadowSize, shadowDy);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mCornerShadowLeftPaint.setColorFilter(cf);
        this.mCornerShadowRightPaint.setColorFilter(cf);
        this.mEdgeShadowPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(Canvas canvas) {
        if (this.mDirty) {
            this.buildShadow();
            this.mDirty = false;
        }
        Rect bounds = this.getBounds();
        this.drawShadowCorners(canvas, bounds);
        this.drawShadowEdges(canvas, bounds);
    }

    public void setShadowStartColor(int shadowStartColor) {
        if (this.mShadowStartColor == shadowStartColor) {
            return;
        }
        this.mShadowStartColor = shadowStartColor;
        this.mDirty = true;
        this.invalidateSelf();
    }

    public void setShadowEndColor(int shadowEndColor) {
        if (this.mShadowEndColor == shadowEndColor) {
            return;
        }
        this.mShadowEndColor = shadowEndColor;
        this.mDirty = true;
        this.invalidateSelf();
    }

    public void setCornerRadius(float radius) {
        if (this.mCornerRadius == (radius = (float)((int)(radius + 0.5f)))) {
            return;
        }
        this.mCornerRadius = radius;
        this.mDirty = true;
        this.invalidateSelf();
    }

    public void setShadowSize(float shadowSize) {
        if (shadowSize < 0.0f) {
            throw new IllegalArgumentException("invalid shadow size");
        }
        if (this.mShadowSize == (shadowSize = (float)CardShadowDrawable.toEven(shadowSize))) {
            return;
        }
        this.mShadowSize = shadowSize;
        this.mDirty = true;
        this.invalidateSelf();
    }

    public void setShadowDx(float shadowDx) {
        if (shadowDx == this.mShadowDx) {
            return;
        }
        this.mShadowDx = shadowDx;
        this.mDirty = true;
        this.invalidateSelf();
    }

    public void setShadowDy(float shadowDy) {
        if (shadowDy == this.mShadowDy) {
            return;
        }
        this.mShadowDy = shadowDy;
        this.mDirty = true;
        this.invalidateSelf();
    }

    public void setHideTopShadow(boolean hideTopShadow) {
        this.mHideTopShadow = hideTopShadow;
    }

    public void setHideBottomShadow(boolean hideBottomShadow) {
        this.mHideBottomShadow = hideBottomShadow;
    }

    public void setShadowLeftSizeOverride(float shadowLeftSize) {
        this.mShadowLeftSizeOverride = shadowLeftSize;
    }

    public void setShadowRightSizeOverride(float shadowRightSizeOverride) {
        this.mShadowRightSizeOverride = shadowRightSizeOverride;
    }

    private static void setPath(Path path, int shadowX, int shadowY, float cornerRadius) {
        RectF innerBounds = new RectF((float)shadowX, (float)shadowY, (float)shadowX + 2.0f * cornerRadius, (float)shadowY + 2.0f * cornerRadius);
        RectF outerBounds = new RectF(0.0f, 0.0f, 2.0f * cornerRadius, 2.0f * cornerRadius);
        path.reset();
        path.setFillType(Path.FillType.EVEN_ODD);
        path.moveTo((float)shadowX + cornerRadius, (float)shadowY);
        path.arcTo(innerBounds, 270.0f, -90.0f, true);
        path.rLineTo((float)(-shadowX), 0.0f);
        path.lineTo(0.0f, cornerRadius);
        path.arcTo(outerBounds, 180.0f, 90.0f, true);
        path.lineTo((float)shadowX + cornerRadius, 0.0f);
        path.rLineTo(0.0f, (float)shadowY);
        path.close();
    }

    private void buildShadow() {
        float shadowLeftSideUnadjusted = this.mShadowLeftSizeOverride == -1.0f ? this.mShadowSize : this.mShadowLeftSizeOverride;
        float shadowRightSideUnadjusted = this.mShadowRightSizeOverride == -1.0f ? this.mShadowSize : this.mShadowRightSizeOverride;
        float shadowCornerLeftRadius = shadowLeftSideUnadjusted + this.mCornerRadius;
        float shadowCornerRightRadius = shadowRightSideUnadjusted + this.mCornerRadius;
        this.mCornerShadowLeftPaint.setShader((Shader)new RadialGradient(shadowCornerLeftRadius, shadowCornerLeftRadius, shadowCornerLeftRadius, new int[]{this.mShadowStartColor, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP));
        this.mCornerShadowRightPaint.setShader((Shader)new RadialGradient(shadowCornerRightRadius, shadowCornerRightRadius, shadowCornerRightRadius, new int[]{this.mShadowStartColor, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP));
        float shadowDx = this.mShadowDx == -1.0f ? 0.0f : this.mShadowDx;
        float shadowDy = this.mShadowDy == -1.0f ? CardShadowDrawable.getDefaultShadowDy(this.mShadowSize) : this.mShadowDy;
        int shadowLeft = CardShadowDrawable.getShadowLeft(shadowLeftSideUnadjusted, shadowDx);
        int shadowRight = CardShadowDrawable.getShadowRight(shadowRightSideUnadjusted, shadowDx);
        int shadowTop = CardShadowDrawable.getShadowTop(this.mShadowSize, shadowDy);
        int shadowBottom = CardShadowDrawable.getShadowBottom(this.mShadowSize, shadowDy);
        CardShadowDrawable.setPath(this.mCornerShadowTopLeftPath, shadowLeft, shadowTop, this.mCornerRadius);
        CardShadowDrawable.setPath(this.mCornerShadowTopRightPath, shadowRight, shadowTop, this.mCornerRadius);
        CardShadowDrawable.setPath(this.mCornerShadowBottomLeftPath, shadowLeft, shadowBottom, this.mCornerRadius);
        CardShadowDrawable.setPath(this.mCornerShadowBottomRightPath, shadowRight, shadowBottom, this.mCornerRadius);
        this.mEdgeShadowPaint.setShader((Shader)new LinearGradient(0.0f, shadowCornerLeftRadius, 0.0f, 0.0f, new int[]{this.mShadowStartColor, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, 0.2f, 1.0f}, Shader.TileMode.CLAMP));
        this.mEdgeShadowPaint.setAntiAlias(false);
    }

    private void drawShadowCorners(Canvas canvas, Rect bounds) {
        int saved = canvas.save();
        if (!this.mHideTopShadow) {
            canvas.translate((float)bounds.left, (float)bounds.top);
            canvas.drawPath(this.mCornerShadowTopLeftPath, this.mCornerShadowLeftPaint);
            canvas.restoreToCount(saved);
            saved = canvas.save();
            canvas.translate((float)bounds.right, (float)bounds.top);
            canvas.scale(-1.0f, 1.0f);
            canvas.drawPath(this.mCornerShadowTopRightPath, this.mCornerShadowLeftPaint);
            canvas.restoreToCount(saved);
        }
        if (!this.mHideBottomShadow) {
            saved = canvas.save();
            canvas.translate((float)bounds.right, (float)bounds.bottom);
            canvas.scale(-1.0f, -1.0f);
            canvas.drawPath(this.mCornerShadowBottomRightPath, this.mCornerShadowRightPaint);
            canvas.restoreToCount(saved);
            saved = canvas.save();
            canvas.translate((float)bounds.left, (float)bounds.bottom);
            canvas.scale(1.0f, -1.0f);
            canvas.drawPath(this.mCornerShadowBottomLeftPath, this.mCornerShadowRightPaint);
            canvas.restoreToCount(saved);
        }
    }

    private void drawShadowEdges(Canvas canvas, Rect bounds) {
        float shadowDx = this.mShadowDx == -1.0f ? 0.0f : this.mShadowDx;
        float shadowDy = this.mShadowDy == -1.0f ? CardShadowDrawable.getDefaultShadowDy(this.mShadowSize) : this.mShadowDy;
        float shadowLeftSideNonAdjusted = this.mShadowLeftSizeOverride == -1.0f ? this.mShadowSize : this.mShadowLeftSizeOverride;
        float shadowRightSideNonAdjusted = this.mShadowRightSizeOverride == -1.0f ? this.mShadowSize : this.mShadowRightSizeOverride;
        int paddingLeft = CardShadowDrawable.getShadowLeft(shadowLeftSideNonAdjusted, shadowDx);
        int paddingRight = CardShadowDrawable.getShadowRight(shadowRightSideNonAdjusted, shadowDx);
        int paddingTop = CardShadowDrawable.getShadowTop(this.mShadowSize, shadowDy);
        int paddingBottom = CardShadowDrawable.getShadowBottom(this.mShadowSize, shadowDy);
        int saved = canvas.save();
        if (!this.mHideTopShadow) {
            canvas.translate((float)bounds.left, (float)bounds.top);
            canvas.drawRect((float)paddingLeft + this.mCornerRadius, 0.0f, (float)bounds.width() - this.mCornerRadius - (float)paddingRight, (float)paddingTop, this.mEdgeShadowPaint);
            canvas.restoreToCount(saved);
        }
        if (!this.mHideBottomShadow) {
            saved = canvas.save();
            canvas.translate((float)bounds.right, (float)bounds.bottom);
            canvas.rotate(180.0f);
            canvas.drawRect((float)paddingRight + this.mCornerRadius, 0.0f, (float)bounds.width() - this.mCornerRadius - (float)paddingLeft, (float)paddingBottom, this.mEdgeShadowPaint);
            canvas.restoreToCount(saved);
        }
        saved = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.bottom);
        canvas.rotate(270.0f);
        canvas.drawRect(this.mHideBottomShadow ? 0.0f : (float)paddingBottom + this.mCornerRadius, 0.0f, (float)bounds.height() - (this.mHideTopShadow ? 0.0f : this.mCornerRadius + (float)paddingTop), (float)paddingLeft, this.mEdgeShadowPaint);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        canvas.translate((float)bounds.right, (float)bounds.top);
        canvas.rotate(90.0f);
        canvas.drawRect(this.mHideTopShadow ? 0.0f : (float)paddingTop + this.mCornerRadius, 0.0f, (float)bounds.height() - (this.mHideBottomShadow ? 0.0f : this.mCornerRadius + (float)paddingBottom), (float)paddingRight, this.mEdgeShadowPaint);
        canvas.restoreToCount(saved);
    }

    private static int toEven(float value) {
        int i = (int)(value + 0.5f);
        if (i % 2 == 1) {
            return i - 1;
        }
        return i;
    }
}

