/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.view.View;
import android.widget.HorizontalScrollView;
import androidx.annotation.Nullable;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.LithoView;
import com.facebook.litho.widget.ScrollStateDetector;
import com.facebook.litho.widget.ScrollStateListener;
import java.util.List;

public class HorizontalScrollLithoView
extends HorizontalScrollView
implements HasLithoViewChildren {
    private final LithoView mLithoView;
    private int mComponentWidth;
    private int mComponentHeight;
    @Nullable
    private ScrollPosition mScrollPosition;
    @Nullable
    private OnScrollChangeListener mOnScrollChangeListener;
    @Nullable
    private ScrollStateDetector mScrollStateDetector;

    public HorizontalScrollLithoView(Context context) {
        super(context);
        this.mLithoView = new LithoView(context);
        this.addView((View)this.mLithoView);
    }

    public void fling(int velocityX) {
        super.fling(velocityX);
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.fling();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.onDraw();
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.mLithoView.notifyVisibleBoundsChanged();
        if (this.mScrollPosition != null) {
            if (this.mOnScrollChangeListener != null) {
                this.mOnScrollChangeListener.onScrollChange((View)this, this.getScrollX(), this.mScrollPosition.x);
            }
            this.mScrollPosition.x = this.getScrollX();
        }
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.onScrollChanged();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean isConsumed = super.onTouchEvent(motionEvent);
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.onTouchEvent(motionEvent);
        }
        return isConsumed;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mLithoView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mComponentWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mComponentHeight, (int)0x40000000));
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    public void obtainLithoViewChildren(List<LithoView> lithoViews) {
        lithoViews.add(this.mLithoView);
    }

    public void mount(ComponentTree componentTree, ScrollPosition scrollPosition, int width, int height, @Nullable OnScrollChangeListener onScrollChangeListener, @Nullable ScrollStateListener scrollStateListener) {
        this.mLithoView.setComponentTree(componentTree);
        this.mScrollPosition = scrollPosition;
        this.mOnScrollChangeListener = onScrollChangeListener;
        this.mComponentWidth = width;
        this.mComponentHeight = height;
        if (scrollStateListener != null) {
            if (this.mScrollStateDetector == null) {
                this.mScrollStateDetector = new ScrollStateDetector((View)this);
            }
            this.mScrollStateDetector.setListener(scrollStateListener);
        }
    }

    public void unmount() {
        this.mLithoView.setComponentTree(null, false);
        this.mComponentWidth = 0;
        this.mComponentHeight = 0;
        this.mScrollPosition = null;
        this.mOnScrollChangeListener = null;
        this.setScrollX(0);
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.setListener(null);
        }
    }

    public static interface OnScrollChangeListener {
        public void onScrollChange(View var1, int var2, int var3);
    }

    public static class ScrollPosition {
        public int x;

        public ScrollPosition(int initialX) {
            this.x = initialX;
        }
    }
}

