/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.ListUpdateCallback;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.Diff;
import com.facebook.litho.widget.DataDiffModelName;
import com.facebook.litho.widget.RecyclerBinder;
import com.facebook.litho.widget.RecyclerBinderOperationExecutor;
import com.facebook.litho.widget.RenderInfo;
import java.util.ArrayList;
import java.util.List;

public class RecyclerBinderUpdateCallback<T>
implements ListUpdateCallback {
    private static final String INCONSISTENT_SIZE = "RecyclerBinderUpdateCallback:InconsistentSize";
    private final int mOldDataSize;
    private final List<? extends T> mPrevData;
    private final List<? extends T> mNextData;
    private final List<Operation> mOperations;
    private final List<ComponentContainer> mPlaceholders;
    private final List<Diff> mDataHolders;
    private final ComponentRenderer mComponentRenderer;
    private final OperationExecutor mOperationExecutor;

    public RecyclerBinderUpdateCallback(List<? extends T> prevData, List<? extends T> nextData, ComponentRenderer<T> componentRenderer, RecyclerBinder recyclerBinder) {
        this(prevData, nextData, componentRenderer, new RecyclerBinderOperationExecutor(recyclerBinder));
    }

    public RecyclerBinderUpdateCallback(List<? extends T> prevData, List<? extends T> nextData, ComponentRenderer<T> componentRenderer, OperationExecutor operationExecutor) {
        this.mPrevData = prevData;
        this.mOldDataSize = prevData != null ? prevData.size() : 0;
        this.mNextData = nextData;
        this.mComponentRenderer = componentRenderer;
        this.mOperationExecutor = operationExecutor;
        this.mOperations = new ArrayList<Operation>();
        this.mPlaceholders = new ArrayList<ComponentContainer>();
        this.mDataHolders = new ArrayList<Diff>();
        for (int i = 0; i < this.mOldDataSize; ++i) {
            this.mPlaceholders.add(new ComponentContainer(null, false));
            this.mDataHolders.add(new Diff(this.mPrevData.get(i), null));
        }
    }

    public void onInserted(int position, int count) {
        ArrayList<ComponentContainer> placeholders = new ArrayList<ComponentContainer>(count);
        ArrayList<Diff> dataHolders = new ArrayList<Diff>(count);
        for (int i = 0; i < count; ++i) {
            int index = position + i;
            ComponentContainer componentContainer = new ComponentContainer(null, true);
            this.mPlaceholders.add(index, componentContainer);
            placeholders.add(componentContainer);
            Diff dataHolder = new Diff(null, null);
            this.mDataHolders.add(index, dataHolder);
            dataHolders.add(dataHolder);
        }
        this.mOperations.add(new Operation(0, position, -1, placeholders, dataHolders));
    }

    public void onRemoved(int position, int count) {
        ArrayList<Diff> dataHolders = new ArrayList<Diff>(count);
        for (int i = 0; i < count; ++i) {
            this.mPlaceholders.remove(position);
            Diff dataHolder = this.mDataHolders.remove(position);
            dataHolders.add(dataHolder);
        }
        this.mOperations.add(new Operation(2, position, count, null, dataHolders));
    }

    public void onMoved(int fromPosition, int toPosition) {
        ArrayList<Diff> dataHolders = new ArrayList<Diff>(1);
        ComponentContainer placeholder = this.mPlaceholders.remove(fromPosition);
        this.mPlaceholders.add(toPosition, placeholder);
        Diff dataHolder = this.mDataHolders.remove(fromPosition);
        dataHolders.add(dataHolder);
        this.mDataHolders.add(toPosition, dataHolder);
        this.mOperations.add(new Operation(3, fromPosition, toPosition, null, dataHolders));
    }

    public void onChanged(int position, int count, @Nullable Object payload) {
        ArrayList<ComponentContainer> placeholders = new ArrayList<ComponentContainer>();
        ArrayList<Diff> dataHolders = new ArrayList<Diff>(count);
        for (int i = 0; i < count; ++i) {
            int index = position + i;
            ComponentContainer placeholder = this.mPlaceholders.get(index);
            placeholder.mNeedsComputation = true;
            placeholders.add(placeholder);
            dataHolders.add(this.mDataHolders.get(index));
        }
        this.mOperations.add(new Operation(1, position, -1, placeholders, dataHolders));
    }

    public void applyChangeset(ComponentContext c) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (this.mNextData != null && this.mNextData.size() != this.mPlaceholders.size()) {
            this.logErrorForInconsistentSize(c);
            this.mOperations.clear();
            this.mDataHolders.clear();
            this.mPlaceholders.clear();
            ArrayList<Diff> prevDataHolders = new ArrayList<Diff>();
            for (int i = 0; i < this.mOldDataSize; ++i) {
                prevDataHolders.add(new Diff(this.mPrevData.get(i), null));
            }
            this.mDataHolders.addAll(prevDataHolders);
            this.mOperations.add(new Operation(2, 0, this.mOldDataSize, null, prevDataHolders));
            int dataSize = this.mNextData.size();
            ArrayList<ComponentContainer> placeholders = new ArrayList<ComponentContainer>(dataSize);
            ArrayList<Diff> dataHolders = new ArrayList<Diff>(dataSize);
            for (int i = 0; i < dataSize; ++i) {
                T model = this.mNextData.get(i);
                if (isTracing) {
                    ComponentsSystrace.beginSection((String)("renderInfo:" + RecyclerBinderUpdateCallback.getModelName(model)));
                }
                RenderInfo renderInfo = this.mComponentRenderer.render(model, i);
                if (isTracing) {
                    ComponentsSystrace.endSection();
                }
                placeholders.add(i, new ComponentContainer(renderInfo, false));
                dataHolders.add(new Diff(null, model));
            }
            this.mPlaceholders.addAll(placeholders);
            this.mDataHolders.addAll(dataHolders);
            this.mOperations.add(new Operation(0, 0, -1, placeholders, dataHolders));
        } else {
            int size = this.mPlaceholders.size();
            for (int i = 0; i < size; ++i) {
                if (!this.mPlaceholders.get(i).mNeedsComputation) continue;
                T model = this.mNextData.get(i);
                if (isTracing) {
                    ComponentsSystrace.beginSection((String)("renderInfo:" + RecyclerBinderUpdateCallback.getModelName(model)));
                }
                this.mPlaceholders.get(i).mRenderInfo = this.mComponentRenderer.render(model, i);
                if (isTracing) {
                    ComponentsSystrace.endSection();
                }
                this.mDataHolders.get(i).setNext(model);
            }
        }
        if (isTracing) {
            ComponentsSystrace.beginSection((String)"executeOperations");
        }
        this.mOperationExecutor.executeOperations(c, this.mOperations);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
    }

    private static String getModelName(@Nullable Object model) {
        if (model == null) {
            return "";
        }
        return model instanceof DataDiffModelName ? ((DataDiffModelName)model).getName() : model.getClass().getSimpleName();
    }

    private void logErrorForInconsistentSize(ComponentContext c) {
        int i;
        StringBuilder message = new StringBuilder();
        message.append("Inconsistent size between mPlaceholders(").append(this.mPlaceholders.size()).append(") and mNextData(").append(this.mNextData.size()).append("); ");
        message.append("mOperations: [");
        int size = this.mOperations.size();
        for (i = 0; i < size; ++i) {
            Operation operation = this.mOperations.get(i);
            message.append("[type=").append(operation.getType()).append(", index=").append(operation.getIndex()).append(", toIndex=").append(operation.getToIndex());
            if (operation.mComponentContainers != null) {
                message.append(", count=").append(operation.mComponentContainers.size());
            }
            message.append("], ");
        }
        message.append("]; ");
        message.append("mNextData: [");
        size = this.mNextData.size();
        for (i = 0; i < size; ++i) {
            message.append("[").append(this.mNextData.get(i)).append("], ");
        }
        message.append("]");
        ComponentsReporter.emitMessage((ComponentsReporter.LogLevel)ComponentsReporter.LogLevel.ERROR, (String)INCONSISTENT_SIZE, (String)message.toString());
    }

    @VisibleForTesting
    List<Operation> getOperations() {
        return this.mOperations;
    }

    public static class ComponentContainer {
        private RenderInfo mRenderInfo;
        private boolean mNeedsComputation;

        public ComponentContainer(@Nullable RenderInfo renderInfo, boolean needsComputation) {
            this.mRenderInfo = renderInfo;
            this.mNeedsComputation = needsComputation;
        }

        public RenderInfo getRenderInfo() {
            return this.mRenderInfo;
        }
    }

    public static class Operation {
        public static final int INSERT = 0;
        public static final int UPDATE = 1;
        public static final int DELETE = 2;
        public static final int MOVE = 3;
        private final int mType;
        private final int mIndex;
        private final int mToIndex;
        private final List<ComponentContainer> mComponentContainers;
        private final List<Diff> mDataContainers;

        private Operation(int type, int index, int toIndex, List<ComponentContainer> placeholder, List<Diff> dataHolders) {
            this.mType = type;
            this.mIndex = index;
            this.mToIndex = toIndex;
            this.mComponentContainers = placeholder;
            this.mDataContainers = dataHolders;
        }

        public int getType() {
            return this.mType;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public int getToIndex() {
            return this.mToIndex;
        }

        public List<ComponentContainer> getComponentContainers() {
            return this.mComponentContainers;
        }

        public List<Diff> getDataContainers() {
            return this.mDataContainers;
        }
    }

    public static interface OperationExecutor {
        public void executeOperations(@Nullable ComponentContext var1, List<Operation> var2);
    }

    public static interface ComponentRenderer<T> {
        public RenderInfo render(T var1, int var2);
    }
}

