/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

public interface RecyclerRangeTraverser {
    public static final RecyclerRangeTraverser FORWARD_TRAVERSER = new RecyclerRangeTraverser(){

        @Override
        public void traverse(int rangeStart, int rangeEnd, int firstVisible, int lastVisible, Processor processor) {
            for (int i = rangeStart; i < rangeEnd; ++i) {
                if (processor.process(i)) continue;
                return;
            }
        }
    };
    public static final RecyclerRangeTraverser BACKWARD_TRAVERSER = new RecyclerRangeTraverser(){

        @Override
        public void traverse(int rangeStart, int rangeEnd, int firstVisible, int lastVisible, Processor processor) {
            for (int i = rangeEnd - 1; i >= rangeStart; --i) {
                if (processor.process(i)) continue;
                return;
            }
        }
    };
    public static final RecyclerRangeTraverser BIDIRECTIONAL_TRAVERSER = new RecyclerRangeTraverser(){

        @Override
        public void traverse(int rangeStart, int rangeEnd, int firstVisible, int lastVisible, Processor processor) {
            boolean lastVisibleValid;
            if (rangeEnd <= rangeStart) {
                return;
            }
            boolean firstVisibleValid = rangeStart <= firstVisible && firstVisible < rangeEnd;
            boolean bl = lastVisibleValid = rangeStart <= lastVisible && lastVisible < rangeEnd;
            int center = !firstVisibleValid && !lastVisibleValid ? (rangeEnd + rangeStart - 1) / 2 : (!firstVisibleValid ? lastVisible : (!lastVisibleValid ? firstVisible : (firstVisible + lastVisible) / 2));
            if (!processor.process(center)) {
                return;
            }
            int distance = 1;
            while (true) {
                boolean tailInRange;
                int head = center - distance;
                int tail = center + distance;
                boolean headInRange = head >= rangeStart;
                boolean bl2 = tailInRange = tail < rangeEnd;
                if (!headInRange && !tailInRange) {
                    return;
                }
                if (headInRange && !processor.process(head)) {
                    return;
                }
                if (tailInRange && !processor.process(tail)) {
                    return;
                }
                ++distance;
            }
        }
    };

    public void traverse(int var1, int var2, int var3, int var4, Processor var5);

    public static interface Processor {
        public boolean process(int var1);
    }
}

