/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.view.View;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.text.TextDirectionHeuristicCompat;
import androidx.core.text.TextDirectionHeuristicsCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.fbui.textlayoutbuilder.TextLayoutBuilder;
import com.facebook.fbui.textlayoutbuilder.util.LayoutMeasureUtil;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentsReporter;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.annotations.FromMeasure;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBindDynamicValue;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMeasure;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.ClickableSpanListener;
import com.facebook.litho.widget.MountableCharSequence;
import com.facebook.litho.widget.Text;
import com.facebook.litho.widget.TextAlignment;
import com.facebook.litho.widget.TextDrawable;
import com.facebook.litho.widget.TextOffsetOnTouchEvent;
import com.facebook.litho.widget.TextStylesHelper;
import com.facebook.litho.widget.TextureWarmer;
import com.facebook.litho.widget.TouchableSpanListener;
import com.facebook.litho.widget.VerticalGravity;
import com.facebook.litho.widget.WidgetAttributes;
import com.facebook.widget.accessibility.delegates.AccessibleClickableSpan;
import com.facebook.widget.accessibility.delegates.ContentDescriptionSpan;
import com.facebook.yoga.YogaDirection;

@MountSpec(isPureRender=true, poolSize=30, events={TextOffsetOnTouchEvent.class})
class TextSpec {
    @Dimension(unit=2)
    public static final int DEFAULT_TEXT_SIZE_SP = 14;
    public static final int UNSET = -1;
    private static final Typeface DEFAULT_TYPEFACE = Typeface.DEFAULT;
    private static final int DEFAULT_COLOR = 0;
    private static final String TAG = "TextSpec";
    private static final String WRONG_TEXT_SIZE = "TextSpec:WrongTextSize";
    private static final int[][] DEFAULT_TEXT_COLOR_STATE_LIST_STATES = new int[][]{{0}};
    private static final int[] DEFAULT_TEXT_COLOR_STATE_LIST_COLORS = new int[]{-16777216};
    @PropDefault
    protected static final int minLines = Integer.MIN_VALUE;
    @PropDefault
    protected static final int maxLines = Integer.MAX_VALUE;
    @PropDefault
    protected static final int minEms = -1;
    @PropDefault
    protected static final int maxEms = -1;
    @PropDefault
    protected static final int minTextWidth = 0;
    @PropDefault
    protected static final int maxTextWidth = Integer.MAX_VALUE;
    @PropDefault
    protected static final int shadowColor = -7829368;
    @PropDefault
    protected static final int textColor = 0;
    @PropDefault
    protected static final int linkColor = -16776961;
    @PropDefault
    protected static final ColorStateList textColorStateList = new ColorStateList(DEFAULT_TEXT_COLOR_STATE_LIST_STATES, DEFAULT_TEXT_COLOR_STATE_LIST_COLORS);
    @PropDefault
    protected static final int textSize = -1;
    @PropDefault
    protected static final int textStyle = DEFAULT_TYPEFACE.getStyle();
    @PropDefault
    protected static final Typeface typeface = DEFAULT_TYPEFACE;
    @PropDefault
    protected static final float spacingMultiplier = 1.0f;
    @PropDefault
    protected static final VerticalGravity verticalGravity = VerticalGravity.TOP;
    @PropDefault
    protected static final boolean glyphWarming = false;
    @PropDefault
    protected static final boolean shouldIncludeFontPadding = true;
    @PropDefault
    protected static final int breakStrategy = 0;
    @PropDefault
    protected static final int hyphenationFrequency = 0;
    @PropDefault
    protected static final int justificationMode = 0;
    @PropDefault
    protected static final int highlightStartOffset = -1;
    @PropDefault
    protected static final int highlightEndOffset = -1;
    @PropDefault
    protected static final boolean clipToBounds = true;
    @PropDefault
    protected static final float lineHeight = Float.MAX_VALUE;
    private static final Path sTempPath = new Path();
    private static final Rect sTempRect = new Rect();
    private static final RectF sTempRectF = new RectF();

    TextSpec() {
    }

    static void onLoadStyle(ComponentContext c, Output<TextUtils.TruncateAt> ellipsize, Output<Float> extraSpacing, Output<Boolean> shouldIncludeFontPadding, Output<Float> spacingMultiplier, Output<Integer> minLines, Output<Integer> maxLines, Output<Integer> minEms, Output<Integer> maxEms, Output<Integer> minTextWidth, Output<Integer> maxTextWidth, Output<Boolean> isSingleLine, Output<CharSequence> text, Output<ColorStateList> textColorStateList, Output<Integer> linkColor, Output<Integer> highlightColor, Output<Integer> textSize, Output<TextAlignment> alignment, Output<Integer> breakStrategy, Output<Integer> hyphenationFrequency, Output<Integer> justificationMode, Output<Integer> textStyle, Output<Float> shadowRadius, Output<Float> shadowDx, Output<Float> shadowDy, Output<Integer> shadowColor, Output<VerticalGravity> verticalGravity, Output<Typeface> typeface) {
        TextStylesHelper.onLoadStyle(c, ellipsize, extraSpacing, shouldIncludeFontPadding, spacingMultiplier, minLines, maxLines, minEms, maxEms, minTextWidth, maxTextWidth, isSingleLine, text, textColorStateList, linkColor, highlightColor, textSize, alignment, breakStrategy, hyphenationFrequency, justificationMode, textStyle, shadowRadius, shadowDx, shadowDy, shadowColor, verticalGravity, typeface);
    }

    @OnMeasure
    static void onMeasure(ComponentContext context, ComponentLayout layout2, int widthSpec, int heightSpec, Size size, @Prop(resType=ResType.STRING) @Nullable CharSequence text, @Prop(optional=true) @Nullable TextUtils.TruncateAt ellipsize, @Prop(optional=true, resType=ResType.BOOL) boolean shouldIncludeFontPadding, @Prop(optional=true, resType=ResType.INT) int minLines, @Prop(optional=true, resType=ResType.INT) int maxLines, @Prop(optional=true, resType=ResType.INT) int minEms, @Prop(optional=true, resType=ResType.INT) int maxEms, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int minTextWidth, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int maxTextWidth, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true, resType=ResType.COLOR) int linkColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float extraSpacing, @Prop(optional=true, resType=ResType.FLOAT) float spacingMultiplier, @Prop(optional=true, resType=ResType.FLOAT) float letterSpacing, @Prop(optional=true) int textStyle, @Prop(optional=true) @Nullable Typeface typeface, @Prop(optional=true) @Deprecated @Nullable Layout.Alignment textAlignment, @Prop(optional=true) @Nullable TextAlignment alignment, @Prop(optional=true) int breakStrategy, @Prop(optional=true) int hyphenationFrequency, @Prop(optional=true) int justificationMode, @Prop(optional=true) boolean glyphWarming, @Prop(optional=true) @Nullable TextDirectionHeuristicCompat textDirection, @Prop(optional=true) boolean minimallyWide, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int minimallyWideThreshold, @Prop(optional=true, resType=ResType.DIMEN_TEXT) float lineHeight, Output<Layout> measureLayout, Output<Integer> measuredWidth, Output<Integer> measuredHeight) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            measureLayout.set(null);
            size.width = 0;
            size.height = 0;
            return;
        }
        Layout newLayout = TextSpec.createTextLayout(context, widthSpec, ellipsize, shouldIncludeFontPadding, maxLines, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, text, textColor, textColorStateList, linkColor, textSize, extraSpacing, spacingMultiplier, letterSpacing, textStyle, typeface, TextSpec.getTextAlignment(textAlignment, alignment), glyphWarming, layout2.getResolvedLayoutDirection(), minEms, maxEms, minTextWidth, maxTextWidth, context.getAndroidContext().getResources().getDisplayMetrics().density, breakStrategy, hyphenationFrequency, justificationMode, textDirection, lineHeight);
        measureLayout.set((Object)newLayout);
        size.width = TextSpec.resolveWidth(widthSpec, newLayout, minimallyWide, minimallyWideThreshold);
        int preferredHeight = LayoutMeasureUtil.getHeight((Layout)newLayout);
        int lineCount = newLayout.getLineCount();
        if (lineCount < minLines) {
            TextPaint paint = newLayout.getPaint();
            int layoutLineHeight = Math.round((float)paint.getFontMetricsInt(null) * spacingMultiplier + extraSpacing);
            preferredHeight += layoutLineHeight * (minLines - lineCount);
        }
        size.height = SizeSpec.resolveSize((int)heightSpec, (int)preferredHeight);
        if (size.width < 0 || size.height < 0) {
            size.width = Math.max(size.width, 0);
            size.height = Math.max(size.height, 0);
            ComponentsReporter.emitMessage((ComponentsReporter.LogLevel)ComponentsReporter.LogLevel.ERROR, (String)WRONG_TEXT_SIZE, (String)"Text layout measured to less than 0 pixels");
        }
        measuredWidth.set((Object)size.width);
        measuredHeight.set((Object)size.height);
    }

    @VisibleForTesting
    public static int resolveWidth(int widthSpec, Layout layout2, boolean minimallyWide, int minimallyWideThreshold) {
        int minimalWidth;
        int fullWidth = SizeSpec.resolveSize((int)widthSpec, (int)layout2.getWidth());
        if (minimallyWide && layout2.getLineCount() > 1 && fullWidth - (minimalWidth = SizeSpec.resolveSize((int)widthSpec, (int)LayoutMeasureUtil.getWidth((Layout)layout2))) > minimallyWideThreshold) {
            return minimalWidth;
        }
        return fullWidth;
    }

    private static Layout createTextLayout(ComponentContext context, int widthSpec, @Nullable TextUtils.TruncateAt ellipsize, boolean shouldIncludeFontPadding, int maxLines, float shadowRadius, float shadowDx, float shadowDy, int shadowColor, boolean isSingleLine, CharSequence text, int textColor, ColorStateList textColorStateList, int linkColor, int textSize, float extraSpacing, float spacingMultiplier, float letterSpacing, int textStyle, Typeface typeface, TextAlignment textAlignment, boolean glyphWarming, YogaDirection layoutDirection, int minEms, int maxEms, int minTextWidth, int maxTextWidth, float density, int breakStrategy, int hyphenationFrequency, int justificationMode, @Nullable TextDirectionHeuristicCompat textDirection, float lineHeight) {
        Layout newLayout;
        int textMeasureMode;
        TextLayoutBuilder layoutBuilder = new TextLayoutBuilder();
        layoutBuilder.setShouldCacheLayout(false);
        switch (SizeSpec.getMode((int)widthSpec)) {
            case 0: {
                textMeasureMode = 0;
                break;
            }
            case 0x40000000: {
                textMeasureMode = 1;
                break;
            }
            case -2147483648: {
                textMeasureMode = 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected size mode: " + SizeSpec.getMode((int)widthSpec));
            }
        }
        TextUtils.TruncateAt actualEllipsize = ellipsize == null && maxLines != Integer.MAX_VALUE ? TextUtils.TruncateAt.END : ellipsize;
        layoutBuilder.setDensity(density).setEllipsize(actualEllipsize).setMaxLines(maxLines).setShadowLayer(shadowRadius, shadowDx, shadowDy, shadowColor).setSingleLine(isSingleLine).setText(text).setWidth(SizeSpec.getSize((int)widthSpec), textMeasureMode).setIncludeFontPadding(shouldIncludeFontPadding).setTextSpacingExtra(extraSpacing).setTextSpacingMultiplier(spacingMultiplier).setLinkColor(linkColor).setJustificationMode(justificationMode).setBreakStrategy(breakStrategy).setHyphenationFrequency(hyphenationFrequency);
        if (textSize != -1) {
            layoutBuilder.setTextSize(textSize);
        } else {
            int defaultTextSize = context.getResourceResolver().sipsToPixels(14.0f);
            layoutBuilder.setTextSize(defaultTextSize);
        }
        if (lineHeight != Float.MAX_VALUE) {
            layoutBuilder.setLineHeight(lineHeight);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            layoutBuilder.setLetterSpacing(letterSpacing);
        }
        if (minEms != -1) {
            layoutBuilder.setMinEms(minEms);
        } else {
            layoutBuilder.setMinWidth(minTextWidth);
        }
        if (maxEms != -1) {
            layoutBuilder.setMaxEms(maxEms);
        } else {
            layoutBuilder.setMaxWidth(maxTextWidth);
        }
        if (textColor != 0) {
            layoutBuilder.setTextColor(textColor);
        } else {
            layoutBuilder.setTextColor(textColorStateList);
        }
        if (!DEFAULT_TYPEFACE.equals((Object)typeface)) {
            layoutBuilder.setTypeface(typeface);
        } else {
            layoutBuilder.setTextStyle(textStyle);
        }
        textDirection = TextSpec.getTextDirection(textDirection, layoutDirection);
        layoutBuilder.setTextDirection(textDirection);
        layoutBuilder.setAlignment(TextSpec.getLayoutAlignment(textAlignment, textDirection, text, layoutDirection));
        try {
            newLayout = layoutBuilder.build();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("text: " + text.toString(), e);
        }
        if (glyphWarming) {
            TextureWarmer.getInstance().warmLayout(newLayout);
        }
        return newLayout;
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext c, ComponentLayout layout2, @Prop(resType=ResType.STRING) CharSequence text, @Prop(optional=true) @Nullable TextUtils.TruncateAt ellipsize, @Prop(optional=true, resType=ResType.BOOL) boolean shouldIncludeFontPadding, @Prop(optional=true, resType=ResType.INT) int maxLines, @Prop(optional=true, resType=ResType.INT) int minEms, @Prop(optional=true, resType=ResType.INT) int maxEms, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int minTextWidth, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int maxTextWidth, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true, resType=ResType.COLOR) int linkColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float extraSpacing, @Prop(optional=true, resType=ResType.FLOAT) float spacingMultiplier, @Prop(optional=true, resType=ResType.FLOAT) float letterSpacing, @Prop(optional=true) VerticalGravity verticalGravity, @Prop(optional=true) int textStyle, @Prop(optional=true) Typeface typeface, @Prop(optional=true) @Deprecated @Nullable Layout.Alignment textAlignment, @Prop(optional=true) @Nullable TextAlignment alignment, @Prop(optional=true) int breakStrategy, @Prop(optional=true) int hyphenationFrequency, @Prop(optional=true) boolean glyphWarming, @Prop(optional=true) @Nullable TextDirectionHeuristicCompat textDirection, @Prop(optional=true, resType=ResType.STRING) @Nullable CharSequence customEllipsisText, @Prop(optional=true, resType=ResType.DIMEN_TEXT) float lineHeight, @FromMeasure Layout measureLayout, @FromMeasure Integer measuredWidth, @FromMeasure Integer measuredHeight, Output<CharSequence> processedText, Output<Layout> textLayout, Output<Float> textLayoutTranslationY, Output<ClickableSpan[]> clickableSpans, Output<ImageSpan[]> imageSpans) {
        CharSequence resultText;
        int ellipsizedLineNumber;
        processedText.set((Object)text);
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        float layoutWidth = layout2.getWidth() - layout2.getPaddingLeft() - layout2.getPaddingRight();
        float layoutHeight = layout2.getHeight() - layout2.getPaddingTop() - layout2.getPaddingBottom();
        if (measureLayout != null && (float)measuredWidth.intValue() == layoutWidth && (float)measuredHeight.intValue() == layoutHeight) {
            textLayout.set((Object)measureLayout);
        } else {
            textLayout.set((Object)TextSpec.createTextLayout(c, SizeSpec.makeSizeSpec((int)((int)layoutWidth), (int)0x40000000), ellipsize, shouldIncludeFontPadding, maxLines, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, text, textColor, textColorStateList, linkColor, textSize, extraSpacing, spacingMultiplier, letterSpacing, textStyle, typeface, TextSpec.getTextAlignment(textAlignment, alignment), glyphWarming, layout2.getResolvedLayoutDirection(), minEms, maxEms, minTextWidth, maxTextWidth, c.getAndroidContext().getResources().getDisplayMetrics().density, breakStrategy, hyphenationFrequency, 0, textDirection, lineHeight));
        }
        float textHeight = LayoutMeasureUtil.getHeight((Layout)((Layout)textLayout.get()));
        switch (verticalGravity) {
            case CENTER: {
                textLayoutTranslationY.set((Object)Float.valueOf((layoutHeight - textHeight) / 2.0f));
                break;
            }
            case BOTTOM: {
                textLayoutTranslationY.set((Object)Float.valueOf(layoutHeight - textHeight));
                break;
            }
            default: {
                textLayoutTranslationY.set((Object)Float.valueOf(0.0f));
            }
        }
        if (customEllipsisText != null && !customEllipsisText.equals("") && (ellipsizedLineNumber = TextSpec.getEllipsizedLineNumber((Layout)textLayout.get())) != -1) {
            Layout customEllipsisLayout = TextSpec.createTextLayout(c, SizeSpec.makeSizeSpec((int)((int)layoutWidth), (int)0x40000000), ellipsize, shouldIncludeFontPadding, maxLines, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, customEllipsisText, textColor, textColorStateList, linkColor, textSize, extraSpacing, spacingMultiplier, letterSpacing, textStyle, typeface, TextSpec.getTextAlignment(textAlignment, alignment), glyphWarming, layout2.getResolvedLayoutDirection(), minEms, maxEms, minTextWidth, maxTextWidth, c.getAndroidContext().getResources().getDisplayMetrics().density, breakStrategy, hyphenationFrequency, 0, textDirection, lineHeight);
            YogaDirection layoutDirection = layout2.getResolvedLayoutDirection();
            TextDirectionHeuristicCompat finalTextDirection = TextSpec.getTextDirection(textDirection, layoutDirection);
            Layout.Alignment finalLayoutAlignment = customEllipsisLayout.getAlignment();
            boolean isRtl = finalTextDirection.isRtl(text, 0, text.length());
            boolean isAlignedLeft = isRtl ^ finalLayoutAlignment == Layout.Alignment.ALIGN_NORMAL;
            CharSequence truncated = TextSpec.truncateText(text, customEllipsisText, (Layout)textLayout.get(), customEllipsisLayout, ellipsizedLineNumber, layoutWidth, isAlignedLeft, isRtl);
            Layout newLayout = TextSpec.createTextLayout(c, SizeSpec.makeSizeSpec((int)((int)layoutWidth), (int)0x40000000), ellipsize, shouldIncludeFontPadding, maxLines, shadowRadius, shadowDx, shadowDy, shadowColor, isSingleLine, truncated, textColor, textColorStateList, linkColor, textSize, extraSpacing, spacingMultiplier, letterSpacing, textStyle, typeface, TextSpec.getTextAlignment(textAlignment, alignment), glyphWarming, layout2.getResolvedLayoutDirection(), minEms, maxEms, minTextWidth, maxTextWidth, c.getAndroidContext().getResources().getDisplayMetrics().density, breakStrategy, hyphenationFrequency, 0, textDirection, lineHeight);
            processedText.set((Object)truncated);
            textLayout.set((Object)newLayout);
        }
        if ((resultText = (CharSequence)processedText.get()) instanceof Spanned) {
            Spanned spanned = (Spanned)resultText;
            clickableSpans.set((Object)((ClickableSpan[])spanned.getSpans(0, resultText.length(), ClickableSpan.class)));
            imageSpans.set((Object)((ImageSpan[])spanned.getSpans(0, resultText.length(), ImageSpan.class)));
        }
    }

    private static CharSequence truncateText(CharSequence text, CharSequence customEllipsisText, Layout newLayout, Layout ellipsisTextLayout, int ellipsizedLineNumber, float layoutWidth, boolean isAlignedLeft, boolean isRtl) {
        float gap;
        float ellipsisTarget;
        float customEllipsisTextWidth = ellipsisTextLayout.getLineWidth(0);
        if (!isRtl && isAlignedLeft) {
            ellipsisTarget = layoutWidth - customEllipsisTextWidth;
        } else if (!isRtl) {
            gap = layoutWidth - newLayout.getLineWidth(ellipsizedLineNumber);
            ellipsisTarget = layoutWidth - customEllipsisTextWidth + gap;
        } else if (isAlignedLeft) {
            gap = layoutWidth - newLayout.getLineWidth(ellipsizedLineNumber);
            ellipsisTarget = customEllipsisTextWidth - gap;
        } else {
            ellipsisTarget = customEllipsisTextWidth;
        }
        int ellipsisOffset = newLayout.getOffsetForHorizontal(ellipsizedLineNumber, ellipsisTarget);
        if (ellipsisOffset > 0) {
            int ellipsisStart;
            if (newLayout.getEllipsisCount(ellipsizedLineNumber) > 0 && --ellipsisOffset > (ellipsisStart = newLayout.getLineStart(ellipsizedLineNumber) + newLayout.getEllipsisStart(ellipsizedLineNumber))) {
                ellipsisOffset = ellipsisStart;
            }
            if (ellipsisOffset < 0) {
                ellipsisOffset = 0;
            } else if (ellipsisOffset > text.length()) {
                ellipsisOffset = text.length();
            }
            return TextUtils.concat((CharSequence[])new CharSequence[]{text.subSequence(0, ellipsisOffset), customEllipsisText});
        }
        return text;
    }

    private static int getEllipsizedLineNumber(Layout layout2) {
        for (int i = 0; i < layout2.getLineCount(); ++i) {
            if (layout2.getEllipsisCount(i) <= 0) continue;
            return i;
        }
        return -1;
    }

    @OnCreateMountContent
    static TextDrawable onCreateMountContent(Context c) {
        return new TextDrawable();
    }

    @OnMount
    static void onMount(ComponentContext c, TextDrawable textDrawable, @Prop(optional=true, resType=ResType.COLOR) int textColor, @Prop(optional=true, resType=ResType.COLOR) int highlightColor, @Prop(optional=true) ColorStateList textColorStateList, final @Prop(optional=true) @Nullable EventHandler textOffsetOnTouchHandler, @Prop(optional=true) int highlightStartOffset, @Prop(optional=true) int highlightEndOffset, @Prop(optional=true, resType=ResType.DIMEN_TEXT) float clickableSpanExpandedOffset, @Prop(optional=true) boolean clipToBounds, @Prop(optional=true) @Nullable ClickableSpanListener spanListener, @Prop(optional=true) @Nullable TouchableSpanListener touchableSpanListener, final CharSequence processedText, Layout textLayout, Float textLayoutTranslationY, @Nullable ClickableSpan[] clickableSpans, @Nullable ImageSpan[] imageSpans) {
        Component componentScope = c.getComponentScope();
        if (componentScope != null) {
            componentScope.setAttributeKey(WidgetAttributes.Text, (Object)processedText);
        }
        TextDrawable.TextOffsetOnTouchListener textOffsetOnTouchListener = null;
        if (textOffsetOnTouchHandler != null) {
            textOffsetOnTouchListener = new TextDrawable.TextOffsetOnTouchListener(){

                @Override
                public void textOffsetOnTouch(int textOffset) {
                    Text.dispatchTextOffsetOnTouchEvent(textOffsetOnTouchHandler, processedText, textOffset);
                }
            };
        }
        textDrawable.mount(processedText, textLayout, textLayoutTranslationY == null ? 0.0f : textLayoutTranslationY.floatValue(), clipToBounds, textColorStateList, textColor, highlightColor, clickableSpans, imageSpans, spanListener, touchableSpanListener, textOffsetOnTouchListener, highlightStartOffset, highlightEndOffset, clickableSpanExpandedOffset, c.getLogTag());
        if (processedText instanceof MountableCharSequence) {
            ((MountableCharSequence)processedText).onMount(textDrawable);
        }
    }

    @OnUnmount
    static void onUnmount(ComponentContext c, TextDrawable textDrawable, @Prop(resType=ResType.STRING) CharSequence text) {
        textDrawable.unmount();
        if (text instanceof MountableCharSequence) {
            ((MountableCharSequence)text).onUnmount(textDrawable);
        }
    }

    static void onPopulateAccessibilityNode(ComponentContext c, View host, AccessibilityNodeInfoCompat node, @Prop(optional=true, dynamic=true) Integer dynamicTextColor, @Prop(resType=ResType.STRING) CharSequence text, @Prop(optional=true, resType=ResType.BOOL) boolean isSingleLine) {
        if (ViewCompat.getImportantForAccessibility((View)host) == 0) {
            ViewCompat.setImportantForAccessibility((View)host, (int)1);
        }
        CharSequence contentDescription = node.getContentDescription();
        CharSequence textWithContentDescriptions = TextSpec.replaceContentDescriptionSpans(text);
        node.setText(contentDescription != null ? contentDescription : textWithContentDescriptions);
        node.setContentDescription(contentDescription != null ? contentDescription : textWithContentDescriptions);
        node.addAction(256);
        node.addAction(512);
        node.setMovementGranularities(11);
        if (!isSingleLine) {
            node.setMultiLine(true);
        }
    }

    private static CharSequence replaceContentDescriptionSpans(CharSequence text) {
        if (!(text instanceof Spanned)) {
            return text;
        }
        Spanned spanned = (Spanned)text;
        ContentDescriptionSpan[] contentDescriptionSpans = (ContentDescriptionSpan[])spanned.getSpans(0, text.length(), ContentDescriptionSpan.class);
        if (contentDescriptionSpans.length == 0) {
            return text;
        }
        SpannableStringBuilder spannable = new SpannableStringBuilder(text);
        for (ContentDescriptionSpan span : contentDescriptionSpans) {
            String replacementText = span.getContentDescription();
            if (TextUtils.isEmpty((CharSequence)replacementText)) continue;
            int spanReplaceStart = spannable.getSpanStart((Object)span);
            int spanReplaceEnd = spannable.getSpanEnd((Object)span);
            spannable.replace(spanReplaceStart, spanReplaceEnd, (CharSequence)replacementText);
        }
        return spannable.toString();
    }

    static int getExtraAccessibilityNodesCount(ComponentContext c, @Prop(optional=true, resType=ResType.BOOL) boolean accessibleClickableSpans, ClickableSpan[] clickableSpans) {
        return accessibleClickableSpans && clickableSpans != null ? clickableSpans.length : 0;
    }

    static void onPopulateExtraAccessibilityNode(ComponentContext c, AccessibilityNodeInfoCompat node, int extraNodeIndex, int componentBoundsLeft, int componentBoundsTop, @Prop(resType=ResType.STRING) CharSequence text, Layout textLayout, ClickableSpan[] clickableSpans) {
        int endLine;
        if (!(text instanceof Spanned)) {
            return;
        }
        Spanned spanned = (Spanned)text;
        ClickableSpan span = clickableSpans[extraNodeIndex];
        int start = spanned.getSpanStart((Object)span);
        int end = spanned.getSpanEnd((Object)span);
        int startLine = textLayout.getLineForOffset(start);
        int selectionPathEnd = startLine == (endLine = textLayout.getLineForOffset(end)) ? end : textLayout.getLineVisibleEnd(startLine);
        textLayout.getSelectionPath(start, selectionPathEnd, sTempPath);
        sTempPath.computeBounds(sTempRectF, true);
        sTempRect.set(componentBoundsLeft + (int)TextSpec.sTempRectF.left, componentBoundsTop + (int)TextSpec.sTempRectF.top, componentBoundsLeft + (int)TextSpec.sTempRectF.right, componentBoundsTop + (int)TextSpec.sTempRectF.bottom);
        if (sTempRect.isEmpty()) {
            sTempRect.set(0, 0, 1, 1);
            node.setBoundsInParent(sTempRect);
            node.setContentDescription((CharSequence)"");
            return;
        }
        node.setBoundsInParent(sTempRect);
        node.setClickable(true);
        node.setFocusable(true);
        node.setEnabled(true);
        node.setVisibleToUser(true);
        node.setText(spanned.subSequence(start, end));
        if (span instanceof AccessibleClickableSpan) {
            AccessibleClickableSpan accessibleClickableSpan = (AccessibleClickableSpan)span;
            String contentDescription = accessibleClickableSpan.getAccessibilityDescription();
            String roleDescription = accessibleClickableSpan.getRoleDescription();
            String role = accessibleClickableSpan.getAccessibilityRole();
            if (contentDescription != null) {
                node.setContentDescription((CharSequence)contentDescription);
            }
            if (roleDescription != null) {
                node.setRoleDescription((CharSequence)roleDescription);
            }
            if (role != null) {
                node.setClassName((CharSequence)role);
            } else {
                node.setClassName((CharSequence)"android.widget.Button");
            }
        } else {
            node.setClassName((CharSequence)"android.widget.Button");
        }
    }

    static int getExtraAccessibilityNodeAt(ComponentContext c, int x, int y, @Prop(resType=ResType.STRING) CharSequence text, Layout textLayout, ClickableSpan[] clickableSpans) {
        if (!(text instanceof Spanned)) {
            return Integer.MIN_VALUE;
        }
        Spanned spanned = (Spanned)text;
        for (int i = 0; i < clickableSpans.length; ++i) {
            ClickableSpan span = clickableSpans[i];
            int start = spanned.getSpanStart((Object)span);
            int end = spanned.getSpanEnd((Object)span);
            textLayout.getSelectionPath(start, end, sTempPath);
            sTempPath.computeBounds(sTempRectF, true);
            if (!sTempRectF.contains((float)x, (float)y)) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    @OnBindDynamicValue
    static void onBindTextColor(TextDrawable textDrawable, @Prop(optional=true, dynamic=true) Integer dynamicTextColor) {
        if (dynamicTextColor != null) {
            textDrawable.setTextColor(dynamicTextColor);
        }
    }

    private static TextAlignment getTextAlignment(@Nullable Layout.Alignment alignment, @Nullable TextAlignment textAlignment) {
        if (textAlignment != null) {
            return textAlignment;
        }
        if (alignment != null) {
            switch (alignment) {
                default: {
                    return TextAlignment.TEXT_START;
                }
                case ALIGN_OPPOSITE: {
                    return TextAlignment.TEXT_END;
                }
                case ALIGN_CENTER: 
            }
            return TextAlignment.CENTER;
        }
        return TextAlignment.TEXT_START;
    }

    private static TextDirectionHeuristicCompat getTextDirection(TextDirectionHeuristicCompat textDirection, YogaDirection layoutDirection) {
        if (textDirection == null) {
            textDirection = layoutDirection == YogaDirection.RTL ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
        }
        return textDirection;
    }

    private static Layout.Alignment getLayoutAlignment(TextAlignment textAlignment, TextDirectionHeuristicCompat textDirection, CharSequence text, YogaDirection layoutDirection) {
        Layout.Alignment alignment;
        switch (textAlignment) {
            default: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case TEXT_END: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case LAYOUT_START: {
                boolean layoutRtl = layoutDirection == YogaDirection.RTL;
                boolean textRtl = textDirection.isRtl(text, 0, text.length());
                alignment = layoutRtl == textRtl ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case LAYOUT_END: {
                boolean layoutRtl = layoutDirection == YogaDirection.RTL;
                boolean textRtl = textDirection.isRtl(text, 0, text.length());
                alignment = layoutRtl == textRtl ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case LEFT: {
                alignment = textDirection.isRtl(text, 0, text.length()) ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            case RIGHT: {
                alignment = textDirection.isRtl(text, 0, text.length()) ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case CENTER: {
                alignment = Layout.Alignment.ALIGN_CENTER;
            }
        }
        return alignment;
    }
}

