/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import androidx.annotation.ColorInt;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBindDynamicValue;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.TransparencyEnabledCardClipDrawable;

@MountSpec(isPureRender=true)
class TransparencyEnabledCardClipSpec {
    @PropDefault
    static final int cardBackgroundColor = -1;
    @PropDefault
    static final int clippingColor = 0;

    TransparencyEnabledCardClipSpec() {
    }

    @OnCreateMountContent
    static TransparencyEnabledCardClipDrawable onCreateMountContent(Context c) {
        return new TransparencyEnabledCardClipDrawable();
    }

    @OnMount
    static void onMount(ComponentContext c, TransparencyEnabledCardClipDrawable cardClipDrawable, @Prop(optional=true, resType=ResType.COLOR) int cardBackgroundColor, @Prop(optional=true, resType=ResType.COLOR) int clippingColor, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float cornerRadius, @Prop(optional=true) boolean disableClipTopLeft, @Prop(optional=true) boolean disableClipTopRight, @Prop(optional=true) boolean disableClipBottomLeft, @Prop(optional=true) boolean disableClipBottomRight) {
        cardClipDrawable.setBackgroundColor(cardBackgroundColor);
        cardClipDrawable.setClippingColor(clippingColor);
        cardClipDrawable.setCornerRadius(cornerRadius);
        int clipEdge = (disableClipTopLeft ? 1 : 0) | (disableClipTopRight ? 2 : 0) | (disableClipBottomLeft ? 4 : 0) | (disableClipBottomRight ? 8 : 0);
        cardClipDrawable.setDisableClip(clipEdge);
    }

    @OnUnmount
    static void onUnmount(ComponentContext c, TransparencyEnabledCardClipDrawable cardClipDrawable) {
        cardClipDrawable.setCornerRadius(0.0f);
        cardClipDrawable.setBackgroundColor(-1);
        cardClipDrawable.setClippingColor(0);
        cardClipDrawable.resetCornerPaint();
        cardClipDrawable.setDisableClip(0);
    }

    @OnBindDynamicValue
    static void onBindTime(TransparencyEnabledCardClipDrawable cardClipDrawable, @Prop(dynamic=true, optional=true) @ColorInt Integer cardBackgroundColorDv) {
        if (cardBackgroundColorDv != null) {
            cardClipDrawable.setBackgroundColor(cardBackgroundColorDv);
        }
    }
}

