/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.AnyThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.recyclerview.widget.RecyclerView;
import com.facebook.litho.widget.LayoutInfo;
import com.facebook.litho.widget.ViewportInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class ViewportManager {
    private int mCurrentFirstVisiblePosition;
    private int mCurrentLastVisiblePosition;
    private int mCurrentFirstFullyVisiblePosition;
    private int mCurrentLastFullyVisiblePosition;
    private int mTotalItemCount;
    private boolean mShouldUpdate;
    @GuardedBy(value="this")
    private final List<ViewportInfo.ViewportChanged> mViewportChangedListeners;
    private final LayoutInfo mLayoutInfo;
    private final ViewportScrollListener mViewportScrollListener = new ViewportScrollListener();

    ViewportManager(int currentFirstVisiblePosition, int currentLastVisiblePosition, LayoutInfo layoutInfo) {
        this.mCurrentFirstVisiblePosition = currentFirstVisiblePosition;
        this.mCurrentLastVisiblePosition = currentLastVisiblePosition;
        this.mCurrentFirstFullyVisiblePosition = layoutInfo.findFirstFullyVisibleItemPosition();
        this.mCurrentLastFullyVisiblePosition = layoutInfo.findLastFullyVisibleItemPosition();
        this.mTotalItemCount = layoutInfo.getItemCount();
        this.mLayoutInfo = layoutInfo;
        this.mViewportChangedListeners = new ArrayList<ViewportInfo.ViewportChanged>(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    void onViewportChanged(@ViewportInfo.State int state) {
        ArrayList<ViewportInfo.ViewportChanged> viewportChangedListeners;
        int firstVisiblePosition = this.mLayoutInfo.findFirstVisibleItemPosition();
        int lastVisiblePosition = this.mLayoutInfo.findLastVisibleItemPosition();
        int firstFullyVisibleItemPosition = this.mLayoutInfo.findFirstFullyVisibleItemPosition();
        int lastFullyVisibleItemPosition = this.mLayoutInfo.findLastFullyVisibleItemPosition();
        int totalItemCount = this.mLayoutInfo.getItemCount();
        if (firstVisiblePosition < 0 || lastVisiblePosition < 0) {
            return;
        }
        if (firstVisiblePosition == this.mCurrentFirstVisiblePosition && lastVisiblePosition == this.mCurrentLastVisiblePosition && firstFullyVisibleItemPosition == this.mCurrentFirstFullyVisiblePosition && lastFullyVisibleItemPosition == this.mCurrentLastFullyVisiblePosition && totalItemCount == this.mTotalItemCount && state != 1) {
            return;
        }
        this.mCurrentFirstVisiblePosition = firstVisiblePosition;
        this.mCurrentLastVisiblePosition = lastVisiblePosition;
        this.mCurrentFirstFullyVisiblePosition = firstFullyVisibleItemPosition;
        this.mCurrentLastFullyVisiblePosition = lastFullyVisibleItemPosition;
        this.mTotalItemCount = totalItemCount;
        this.mShouldUpdate = false;
        ViewportManager viewportManager = this;
        synchronized (viewportManager) {
            if (this.mViewportChangedListeners.isEmpty()) {
                return;
            }
            viewportChangedListeners = new ArrayList<ViewportInfo.ViewportChanged>(this.mViewportChangedListeners);
        }
        int size = viewportChangedListeners.size();
        for (int i = 0; i < size; ++i) {
            ViewportInfo.ViewportChanged viewportChangedListener = (ViewportInfo.ViewportChanged)viewportChangedListeners.get(i);
            viewportChangedListener.viewportChanged(firstVisiblePosition, lastVisiblePosition, firstFullyVisibleItemPosition, lastFullyVisibleItemPosition, state);
        }
    }

    @UiThread
    void setShouldUpdate(boolean shouldUpdate) {
        this.mShouldUpdate = this.mShouldUpdate || shouldUpdate;
    }

    @UiThread
    void resetShouldUpdate() {
        this.mShouldUpdate = false;
    }

    @UiThread
    boolean insertAffectsVisibleRange(int position, int size, int viewportCount) {
        if (this.shouldUpdate() || viewportCount == -1) {
            return true;
        }
        int lastVisiblePosition = Math.max(this.mCurrentFirstVisiblePosition + viewportCount - 1, this.mCurrentLastVisiblePosition);
        return position <= lastVisiblePosition;
    }

    @UiThread
    boolean updateAffectsVisibleRange(int position, int size) {
        if (this.shouldUpdate()) {
            return true;
        }
        for (int index = position; index < position + size; ++index) {
            if (this.mCurrentFirstVisiblePosition > index || index > this.mCurrentLastVisiblePosition) continue;
            return true;
        }
        return false;
    }

    @UiThread
    boolean moveAffectsVisibleRange(int fromPosition, int toPosition, int viewportCount) {
        if (this.shouldUpdate() || viewportCount == -1) {
            return true;
        }
        boolean isNewPositionInVisibleRange = toPosition >= this.mCurrentFirstVisiblePosition && toPosition <= this.mCurrentFirstVisiblePosition + viewportCount - 1;
        boolean isOldPositionInVisibleRange = fromPosition >= this.mCurrentFirstVisiblePosition && fromPosition <= this.mCurrentFirstVisiblePosition + viewportCount - 1;
        return isNewPositionInVisibleRange || isOldPositionInVisibleRange;
    }

    @UiThread
    boolean removeAffectsVisibleRange(int position, int size) {
        if (this.shouldUpdate()) {
            return true;
        }
        return position <= this.mCurrentLastVisiblePosition;
    }

    @UiThread
    boolean shouldUpdate() {
        return this.mCurrentFirstVisiblePosition < 0 || this.mCurrentLastVisiblePosition < 0 || this.mShouldUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    void addViewportChangedListener(@Nullable ViewportInfo.ViewportChanged viewportChangedListener) {
        if (viewportChangedListener == null) {
            return;
        }
        ViewportManager viewportManager = this;
        synchronized (viewportManager) {
            this.mViewportChangedListeners.add(viewportChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    void removeViewportChangedListener(@Nullable ViewportInfo.ViewportChanged viewportChangedListener) {
        if (viewportChangedListener == null) {
            return;
        }
        ViewportManager viewportManager = this;
        synchronized (viewportManager) {
            if (this.mViewportChangedListeners.isEmpty()) {
                return;
            }
            this.mViewportChangedListeners.remove(viewportChangedListener);
        }
    }

    @UiThread
    ViewportScrollListener getScrollListener() {
        return this.mViewportScrollListener;
    }

    private class ViewportScrollListener
    extends RecyclerView.OnScrollListener {
        private ViewportScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            ViewportManager.this.onViewportChanged(0);
        }
    }
}

