/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import com.facebook.litho.BaseMountingView;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.LithoMetadataExceptionWrapper;
import com.facebook.litho.LithoView;
import com.facebook.litho.widget.ScrollStateDetector;
import com.facebook.litho.widget.ScrollStateListener;
import com.facebook.rendercore.ErrorReporter;
import com.facebook.rendercore.LogLevel;
import java.util.List;

public class LithoScrollView
extends NestedScrollView
implements HasLithoViewChildren {
    private final LithoView mLithoView;
    @Nullable
    private ScrollPosition mScrollPosition;
    @Nullable
    private ViewTreeObserver.OnPreDrawListener mOnPreDrawListener;
    @Nullable
    private OnInterceptTouchListener mOnInterceptTouchListener;
    @Nullable
    private ScrollStateDetector mScrollStateDetector;

    public LithoScrollView(Context context) {
        this(context, null);
    }

    public LithoScrollView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LithoScrollView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mLithoView = new LithoView(context);
        this.addView((View)this.mLithoView);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean result = false;
        if (this.mOnInterceptTouchListener != null) {
            result = this.mOnInterceptTouchListener.onInterceptTouch(this, ev);
        }
        if (!result && super.onInterceptTouchEvent(ev)) {
            result = true;
        }
        return result;
    }

    public void fling(int velocityX) {
        super.fling(velocityX);
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.fling();
        }
    }

    public void draw(Canvas canvas) {
        try {
            super.draw(canvas);
            if (this.mScrollStateDetector != null) {
                this.mScrollStateDetector.onDraw();
            }
        }
        catch (Throwable t) {
            ComponentTree ct = this.mLithoView.getComponentTree();
            if (ct != null) {
                ErrorReporter.getInstance().report(LogLevel.ERROR, "LITHO:NPE:LITHO_SCROLL_VIEW_DRAW", "Root component: " + ct.getSimpleName(), t, 0, null);
                throw new LithoMetadataExceptionWrapper(ct, t);
            }
            throw t;
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.mLithoView.notifyVisibleBoundsChanged();
        if (this.mScrollPosition != null) {
            this.mScrollPosition.y = this.getScrollY();
        }
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.onScrollChanged();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean isConsumed = super.onTouchEvent(motionEvent);
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.onTouchEvent(motionEvent);
        }
        return isConsumed;
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return super.dispatchNestedFling(velocityX, velocityY, true);
    }

    public void setOnInterceptTouchListener(@Nullable OnInterceptTouchListener onInterceptTouchListener) {
        this.mOnInterceptTouchListener = onInterceptTouchListener;
    }

    public void obtainLithoViewChildren(List<BaseMountingView> lithoViews) {
        lithoViews.add((BaseMountingView)this.mLithoView);
    }

    public void mount(ComponentTree contentComponentTree, final ScrollPosition scrollPosition, ScrollStateListener scrollStateListener) {
        this.mLithoView.setComponentTree(contentComponentTree);
        this.mScrollPosition = scrollPosition;
        ViewTreeObserver.OnPreDrawListener onPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                LithoScrollView.this.setScrollY(scrollPosition.y);
                ViewTreeObserver currentViewTreeObserver = LithoScrollView.this.getViewTreeObserver();
                if (currentViewTreeObserver.isAlive()) {
                    currentViewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
                return true;
            }
        };
        this.getViewTreeObserver().addOnPreDrawListener(onPreDrawListener);
        this.mOnPreDrawListener = onPreDrawListener;
        if (scrollStateListener != null) {
            if (this.mScrollStateDetector == null) {
                this.mScrollStateDetector = new ScrollStateDetector((View)this);
            }
            this.mScrollStateDetector.setListener(scrollStateListener);
        }
    }

    public void unmount() {
        this.mLithoView.setComponentTree(null, false);
        this.mScrollPosition = null;
        this.getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
        this.mOnPreDrawListener = null;
        if (this.mScrollStateDetector != null) {
            this.mScrollStateDetector.setListener(null);
        }
    }

    public static interface OnInterceptTouchListener {
        public boolean onInterceptTouch(NestedScrollView var1, MotionEvent var2);
    }

    public static class ScrollPosition {
        public int y;

        public ScrollPosition() {
            this(0);
        }

        public ScrollPosition(int initialScrollOffsetPixels) {
            this.y = initialScrollOffsetPixels;
        }
    }
}

