/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.widget.SectionsRecyclerView;

public class RecyclerEventsController {
    @Nullable
    private SectionsRecyclerView mSectionsRecyclerView;
    @Nullable
    private OnRecyclerUpdateListener mOnRecyclerUpdateListener;
    @Nullable
    private SnapHelper mSnapHelper;
    private final Runnable mClearRefreshRunnable = new Runnable(){

        @Override
        public void run() {
            SectionsRecyclerView sectionsRecyclerView = RecyclerEventsController.this.mSectionsRecyclerView;
            if (sectionsRecyclerView != null && sectionsRecyclerView.isRefreshing()) {
                sectionsRecyclerView.setRefreshing(false);
            }
        }
    };

    public void requestScrollToTop(boolean animated) {
        this.requestScrollToPosition(0, animated);
    }

    public void requestScrollToPosition(int position, boolean animated) {
        SectionsRecyclerView sectionsRecyclerView = this.mSectionsRecyclerView;
        if (sectionsRecyclerView == null) {
            return;
        }
        if (animated) {
            sectionsRecyclerView.getRecyclerView().smoothScrollToPosition(position);
            return;
        }
        sectionsRecyclerView.getRecyclerView().scrollToPosition(position);
    }

    public void requestScrollToPositionWithOffset(int position, int offset) {
        SectionsRecyclerView sectionsRecyclerView = this.mSectionsRecyclerView;
        if (sectionsRecyclerView == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = sectionsRecyclerView.getRecyclerView().getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            this.requestScrollToPosition(position, false);
            return;
        }
        ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(position, offset);
    }

    public void clearRefreshing() {
        SectionsRecyclerView sectionsRecyclerView = this.mSectionsRecyclerView;
        if (sectionsRecyclerView == null || !sectionsRecyclerView.isRefreshing()) {
            return;
        }
        if (ThreadUtils.isMainThread()) {
            sectionsRecyclerView.setRefreshing(false);
            return;
        }
        sectionsRecyclerView.removeCallbacks(this.mClearRefreshRunnable);
        sectionsRecyclerView.post(this.mClearRefreshRunnable);
    }

    public void showRefreshing() {
        SectionsRecyclerView sectionsRecyclerView = this.mSectionsRecyclerView;
        if (sectionsRecyclerView == null || sectionsRecyclerView.isRefreshing()) {
            return;
        }
        ThreadUtils.assertMainThread();
        sectionsRecyclerView.setRefreshing(true);
    }

    public void setSectionsRecyclerView(@Nullable SectionsRecyclerView sectionsRecyclerView) {
        this.mSectionsRecyclerView = sectionsRecyclerView;
        if (this.mOnRecyclerUpdateListener != null) {
            this.mOnRecyclerUpdateListener.onUpdate(sectionsRecyclerView == null ? null : sectionsRecyclerView.getRecyclerView());
        }
    }

    @Nullable
    public RecyclerView getRecyclerView() {
        SectionsRecyclerView sectionsRecyclerView = this.mSectionsRecyclerView;
        return sectionsRecyclerView == null ? null : sectionsRecyclerView.getRecyclerView();
    }

    public void setOnRecyclerUpdateListener(@Nullable OnRecyclerUpdateListener onRecyclerUpdateListener) {
        this.mOnRecyclerUpdateListener = onRecyclerUpdateListener;
    }

    public void setSnapHelper(@Nullable SnapHelper snapHelper) {
        this.mSnapHelper = snapHelper;
    }

    @Nullable
    public SnapHelper getSnapHelper() {
        return this.mSnapHelper;
    }

    public static interface OnRecyclerUpdateListener {
        public void onUpdate(@Nullable RecyclerView var1);
    }
}

