/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.Diff;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Size;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBind;
import com.facebook.litho.annotations.OnBoundsDefined;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnEvent;
import com.facebook.litho.annotations.OnMeasure;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnUnbind;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.OnUpdateState;
import com.facebook.litho.annotations.Param;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.ShouldAlwaysRemeasure;
import com.facebook.litho.annotations.ShouldUpdate;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.Binder;
import com.facebook.litho.widget.LithoRecyclerView;
import com.facebook.litho.widget.PTRRefreshEvent;
import com.facebook.litho.widget.R;
import com.facebook.litho.widget.ReMeasureEvent;
import com.facebook.litho.widget.Recycler;
import com.facebook.litho.widget.RecyclerEventsController;
import com.facebook.litho.widget.SectionsRecyclerView;
import java.util.List;

@MountSpec(hasChildLithoViews=true, isPureRender=true, events={PTRRefreshEvent.class})
class RecyclerSpec {
    @PropDefault
    static final int scrollBarStyle = 0;
    @PropDefault
    static final boolean hasFixedSize = true;
    @PropDefault
    static final boolean nestedScrollingEnabled = true;
    @PropDefault
    static final RecyclerView.ItemAnimator itemAnimator = new NoUpdateItemAnimator();
    @PropDefault
    static final int recyclerViewId = -1;
    @PropDefault
    static final int overScrollMode = 0;
    @PropDefault
    static final int refreshProgressBarColor = -16777216;
    @PropDefault
    static final boolean clipToPadding = true;
    @PropDefault
    static final boolean clipChildren = true;
    @PropDefault
    static final int leftPadding = 0;
    @PropDefault
    static final int rightPadding = 0;
    @PropDefault
    static final int topPadding = 0;
    @PropDefault
    static final int bottomPadding = 0;
    @PropDefault
    static final boolean pullToRefresh = true;
    static final int DEFAULT_REFRESH_SPINNER_BACKGROUND_COLOR = -328966;

    RecyclerSpec() {
    }

    @OnMeasure
    static void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size measureOutput, @Prop Binder<RecyclerView> binder) {
        binder.measure(measureOutput, widthSpec, heightSpec, (EventHandler<ReMeasureEvent>)(binder.canMeasure() || binder.isWrapContent() ? Recycler.onRemeasure(c) : null));
    }

    @OnBoundsDefined
    static void onBoundsDefined(ComponentContext context, ComponentLayout layout, @Prop Binder<RecyclerView> binder) {
        binder.setSize(layout.getWidth(), layout.getHeight());
    }

    @OnCreateMountContent
    static SectionsRecyclerView onCreateMountContent(Context c) {
        SectionsRecyclerView sectionsRecyclerView = new SectionsRecyclerView(c, new LithoRecyclerView(c));
        sectionsRecyclerView.setId(R.id.recycler_view_container_id);
        return sectionsRecyclerView;
    }

    @OnMount
    static void onMount(ComponentContext c, SectionsRecyclerView sectionsRecycler, @Prop Binder<RecyclerView> binder, @Prop(optional=true) boolean hasFixedSize, @Prop(optional=true) boolean clipToPadding, @Prop(optional=true) int leftPadding, @Prop(optional=true) int rightPadding, @Prop(optional=true) int topPadding, @Prop(optional=true) int bottomPadding, @Prop(optional=true) boolean disableAddingPadding, @Prop(optional=true, resType=ResType.COLOR) @Nullable Integer refreshProgressBarBackgroundColor, @Prop(optional=true, resType=ResType.COLOR) int refreshProgressBarColor, @Prop(optional=true) boolean clipChildren, @Prop(optional=true) boolean nestedScrollingEnabled, @Prop(optional=true) int scrollBarStyle, @Prop(optional=true, varArg="itemDecoration") @Nullable List<RecyclerView.ItemDecoration> itemDecorations, @Prop(optional=true) boolean horizontalFadingEdgeEnabled, @Prop(optional=true) boolean verticalFadingEdgeEnabled, @Prop(optional=true, resType=ResType.DIMEN_SIZE) int fadingEdgeLength, @Prop(optional=true) @IdRes int recyclerViewId, @Prop(optional=true) int overScrollMode, @Prop(optional=true, isCommonProp=true) @Nullable CharSequence contentDescription, @Prop(optional=true) @Nullable RecyclerView.ItemAnimator itemAnimator) {
        RecyclerView recyclerView = sectionsRecycler.getRecyclerView();
        if (recyclerView == null) {
            throw new IllegalStateException("RecyclerView not found, it should not be removed from SwipeRefreshLayout");
        }
        recyclerView.setContentDescription(contentDescription);
        recyclerView.setHasFixedSize(hasFixedSize);
        recyclerView.setClipToPadding(clipToPadding);
        sectionsRecycler.setClipToPadding(clipToPadding);
        if (!disableAddingPadding) {
            ViewCompat.setPaddingRelative((View)recyclerView, (int)leftPadding, (int)topPadding, (int)rightPadding, (int)bottomPadding);
        }
        recyclerView.setClipChildren(clipChildren);
        sectionsRecycler.setClipChildren(clipChildren);
        recyclerView.setNestedScrollingEnabled(nestedScrollingEnabled);
        sectionsRecycler.setNestedScrollingEnabled(nestedScrollingEnabled);
        recyclerView.setScrollBarStyle(scrollBarStyle);
        recyclerView.setHorizontalFadingEdgeEnabled(horizontalFadingEdgeEnabled);
        recyclerView.setVerticalFadingEdgeEnabled(verticalFadingEdgeEnabled);
        recyclerView.setFadingEdgeLength(fadingEdgeLength);
        recyclerView.setId(recyclerViewId);
        recyclerView.setOverScrollMode(overScrollMode);
        if (refreshProgressBarBackgroundColor != null) {
            sectionsRecycler.setProgressBackgroundColorSchemeColor(refreshProgressBarBackgroundColor);
        }
        sectionsRecycler.setColorSchemeColors(new int[]{refreshProgressBarColor});
        if (itemDecorations != null) {
            for (RecyclerView.ItemDecoration itemDecoration : itemDecorations) {
                recyclerView.addItemDecoration(itemDecoration);
            }
        }
        sectionsRecycler.setItemAnimator((RecyclerView.ItemAnimator)(itemAnimator != RecyclerSpec.itemAnimator ? itemAnimator : new NoUpdateItemAnimator()));
        binder.mount(recyclerView);
    }

    @OnBind
    protected static void onBind(ComponentContext context, SectionsRecyclerView sectionsRecycler, @Prop Binder<RecyclerView> binder, @Prop(optional=true) RecyclerEventsController recyclerEventsController, @Prop(optional=true, varArg="onScrollListener") @Nullable List<RecyclerView.OnScrollListener> onScrollListeners, @Prop(optional=true) @Nullable SnapHelper snapHelper, @Prop(optional=true) boolean pullToRefresh, @Prop(optional=true) @Nullable LithoRecyclerView.TouchInterceptor touchInterceptor, @Prop(optional=true) @Nullable RecyclerView.OnItemTouchListener onItemTouchListener, final @Prop(optional=true) @Nullable EventHandler refreshHandler, @Prop(optional=true) SectionsRecyclerView.SectionsRecyclerViewLogger sectionsViewLogger) {
        sectionsRecycler.setSectionsRecyclerViewLogger(sectionsViewLogger);
        sectionsRecycler.setContentDescription(null);
        sectionsRecycler.setEnabled(pullToRefresh && refreshHandler != null);
        sectionsRecycler.setOnRefreshListener(refreshHandler != null ? new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                Recycler.dispatchPTRRefreshEvent(refreshHandler);
            }
        } : null);
        LithoRecyclerView recyclerView = (LithoRecyclerView)sectionsRecycler.getRecyclerView();
        if (recyclerView == null) {
            throw new IllegalStateException("RecyclerView not found, it should not be removed from SwipeRefreshLayout before unmounting");
        }
        if (onScrollListeners != null) {
            for (RecyclerView.OnScrollListener onScrollListener : onScrollListeners) {
                recyclerView.addOnScrollListener(onScrollListener);
            }
        }
        if (touchInterceptor != null) {
            recyclerView.setTouchInterceptor(touchInterceptor);
        }
        if (onItemTouchListener != null) {
            recyclerView.addOnItemTouchListener(onItemTouchListener);
        }
        if (snapHelper != null && recyclerView.getOnFlingListener() == null) {
            snapHelper.attachToRecyclerView((RecyclerView)recyclerView);
        }
        binder.bind(recyclerView);
        if (recyclerEventsController != null) {
            recyclerEventsController.setSectionsRecyclerView(sectionsRecycler);
            recyclerEventsController.setSnapHelper(snapHelper);
        }
        if (sectionsRecycler.hasBeenDetachedFromWindow()) {
            recyclerView.requestLayout();
            sectionsRecycler.setHasBeenDetachedFromWindow(false);
        }
    }

    @OnUnbind
    static void onUnbind(ComponentContext context, SectionsRecyclerView sectionsRecycler, @Prop Binder<RecyclerView> binder, @Prop(optional=true) RecyclerEventsController recyclerEventsController, @Prop(optional=true) @Nullable RecyclerView.OnItemTouchListener onItemTouchListener, @Prop(optional=true, varArg="onScrollListener") @Nullable List<RecyclerView.OnScrollListener> onScrollListeners) {
        sectionsRecycler.setSectionsRecyclerViewLogger(null);
        LithoRecyclerView recyclerView = (LithoRecyclerView)sectionsRecycler.getRecyclerView();
        if (recyclerView == null) {
            throw new IllegalStateException("RecyclerView not found, it should not be removed from SwipeRefreshLayout before unmounting");
        }
        binder.unbind(recyclerView);
        if (recyclerEventsController != null) {
            recyclerEventsController.setSectionsRecyclerView(null);
            recyclerEventsController.setSnapHelper(null);
        }
        if (onScrollListeners != null) {
            for (RecyclerView.OnScrollListener onScrollListener : onScrollListeners) {
                recyclerView.removeOnScrollListener(onScrollListener);
            }
        }
        if (onItemTouchListener != null) {
            recyclerView.removeOnItemTouchListener(onItemTouchListener);
        }
        recyclerView.setTouchInterceptor(null);
        sectionsRecycler.setOnRefreshListener(null);
    }

    @OnUnmount
    static void onUnmount(ComponentContext context, SectionsRecyclerView sectionsRecycler, @Prop Binder<RecyclerView> binder, @Prop(optional=true, varArg="itemDecoration") @Nullable List<RecyclerView.ItemDecoration> itemDecorations, @Prop(optional=true, resType=ResType.COLOR) @Nullable Integer refreshProgressBarBackgroundColor, @Prop(optional=true) @Nullable SnapHelper snapHelper) {
        RecyclerView recyclerView = sectionsRecycler.getRecyclerView();
        if (recyclerView == null) {
            throw new IllegalStateException("RecyclerView not found, it should not be removed from SwipeRefreshLayout before unmounting");
        }
        recyclerView.setId(-1);
        if (refreshProgressBarBackgroundColor != null) {
            sectionsRecycler.setProgressBackgroundColorSchemeColor(-328966);
        }
        if (itemDecorations != null) {
            for (RecyclerView.ItemDecoration itemDecoration : itemDecorations) {
                recyclerView.removeItemDecoration(itemDecoration);
            }
        }
        binder.unmount(recyclerView);
        if (snapHelper != null) {
            snapHelper.attachToRecyclerView(null);
        }
        sectionsRecycler.resetItemAnimator();
    }

    @ShouldUpdate(onMount=true)
    protected static boolean shouldUpdate(@Prop Diff<Binder<RecyclerView>> binder, @Prop(optional=true) Diff<Boolean> hasFixedSize, @Prop(optional=true) Diff<Boolean> clipToPadding, @Prop(optional=true) Diff<Integer> leftPadding, @Prop(optional=true) Diff<Integer> rightPadding, @Prop(optional=true) Diff<Integer> topPadding, @Prop(optional=true) Diff<Integer> bottomPadding, @Prop(optional=true, resType=ResType.COLOR) Diff<Integer> refreshProgressBarBackgroundColor, @Prop(optional=true, resType=ResType.COLOR) Diff<Integer> refreshProgressBarColor, @Prop(optional=true) Diff<Boolean> clipChildren, @Prop(optional=true) Diff<Integer> scrollBarStyle, @Prop(optional=true, varArg="itemDecoration") Diff<List<RecyclerView.ItemDecoration>> itemDecorations, @Prop(optional=true) Diff<Boolean> horizontalFadingEdgeEnabled, @Prop(optional=true) Diff<Boolean> verticalFadingEdgeEnabled, @Prop(optional=true, resType=ResType.DIMEN_SIZE) Diff<Integer> fadingEdgeLength, @Prop(optional=true) Diff<RecyclerView.ItemAnimator> itemAnimator, @State Diff<Integer> measureVersion) {
        if (((Integer)measureVersion.getPrevious()).intValue() != ((Integer)measureVersion.getNext()).intValue()) {
            return true;
        }
        if (binder.getPrevious() != binder.getNext()) {
            return true;
        }
        if (!((Boolean)hasFixedSize.getPrevious()).equals(hasFixedSize.getNext())) {
            return true;
        }
        if (!((Boolean)clipToPadding.getPrevious()).equals(clipToPadding.getNext())) {
            return true;
        }
        if (!((Integer)leftPadding.getPrevious()).equals(leftPadding.getNext())) {
            return true;
        }
        if (!((Integer)rightPadding.getPrevious()).equals(rightPadding.getNext())) {
            return true;
        }
        if (!((Integer)topPadding.getPrevious()).equals(topPadding.getNext())) {
            return true;
        }
        if (!((Integer)bottomPadding.getPrevious()).equals(bottomPadding.getNext())) {
            return true;
        }
        if (!((Boolean)clipChildren.getPrevious()).equals(clipChildren.getNext())) {
            return true;
        }
        if (!((Integer)scrollBarStyle.getPrevious()).equals(scrollBarStyle.getNext())) {
            return true;
        }
        if (!((Boolean)horizontalFadingEdgeEnabled.getPrevious()).equals(horizontalFadingEdgeEnabled.getNext())) {
            return true;
        }
        if (!((Boolean)verticalFadingEdgeEnabled.getPrevious()).equals(verticalFadingEdgeEnabled.getNext())) {
            return true;
        }
        if (!((Integer)fadingEdgeLength.getPrevious()).equals(fadingEdgeLength.getNext())) {
            return true;
        }
        Integer previousRefreshBgColor = (Integer)refreshProgressBarBackgroundColor.getPrevious();
        Integer nextRefreshBgColor = (Integer)refreshProgressBarBackgroundColor.getNext();
        if (previousRefreshBgColor == null ? nextRefreshBgColor != null : !previousRefreshBgColor.equals(nextRefreshBgColor)) {
            return true;
        }
        if (!((Integer)refreshProgressBarColor.getPrevious()).equals(refreshProgressBarColor.getNext())) {
            return true;
        }
        RecyclerView.ItemAnimator previousItemAnimator = (RecyclerView.ItemAnimator)itemAnimator.getPrevious();
        RecyclerView.ItemAnimator nextItemAnimator = (RecyclerView.ItemAnimator)itemAnimator.getNext();
        if (previousItemAnimator == null ? nextItemAnimator != null : !previousItemAnimator.getClass().equals(nextItemAnimator.getClass())) {
            return true;
        }
        List previous = (List)itemDecorations.getPrevious();
        List next = (List)itemDecorations.getNext();
        boolean itemDecorationIsEqual = previous == null ? next == null : previous.equals(next);
        return !itemDecorationIsEqual;
    }

    @OnEvent(value=ReMeasureEvent.class)
    protected static void onRemeasure(ComponentContext c, @State int measureVersion) {
        Recycler.onUpdateMeasureAsync(c, measureVersion + 1);
    }

    @OnCreateInitialState
    protected static void onCreateInitialState(StateValue<Integer> measureVersion) {
        measureVersion.set((Object)0);
    }

    @OnUpdateState
    protected static void onUpdateMeasure(@Param int measureVer, StateValue<Integer> measureVersion) {
        measureVersion.set((Object)measureVer);
    }

    @ShouldAlwaysRemeasure
    protected static boolean shouldAlwaysRemeasure(@Prop Binder<RecyclerView> binder) {
        return binder.isWrapContent();
    }

    public static class NoUpdateItemAnimator
    extends DefaultItemAnimator {
        public NoUpdateItemAnimator() {
            this.setSupportsChangeAnimations(false);
        }
    }
}

