/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.facebook.litho.BaseMountingView;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.HasLithoViewChildren;
import com.facebook.litho.LithoView;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.widget.RecyclerBinderViewHolder;
import com.facebook.rendercore.debug.DebugEventDispatcher;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class SectionsRecyclerView
extends SwipeRefreshLayout
implements HasLithoViewChildren {
    private final LithoView mStickyHeader;
    private final RecyclerView mRecyclerView;
    @Nullable
    private SectionsRecyclerViewLogger mSectionsRecyclerViewLogger;
    private boolean mIsFirstLayout = true;
    private boolean mHasBeenDetachedFromWindow = false;
    private RecyclerView.ItemAnimator mDetachedItemAnimator;

    public SectionsRecyclerView(Context context, RecyclerView recyclerView) {
        super(context);
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.setChildDrawingOrderCallback(new RecyclerView.ChildDrawingOrderCallback(){

            public int onGetChildDrawingOrder(int childCount, int i) {
                return childCount - 1 - i;
            }
        });
        this.mRecyclerView.setItemViewCacheSize(0);
        this.addView((View)this.mRecyclerView);
        this.mStickyHeader = new LithoView(new ComponentContext(this.getContext()), null);
        this.mStickyHeader.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.addView((View)this.mStickyHeader);
    }

    public void setSectionsRecyclerViewLogger(SectionsRecyclerViewLogger lithoViewLogger) {
        this.mSectionsRecyclerViewLogger = lithoViewLogger;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public void setStickyComponent(ComponentTree componentTree) {
        LithoView existingLithoView = componentTree.getLithoView();
        this.mStickyHeader.setComponentTree(componentTree);
        if (existingLithoView != null && this.mStickyHeader != existingLithoView) {
            existingLithoView.setTemporaryDetachedComponentTree(componentTree);
        }
        this.measureStickyHeader(this.getWidth());
    }

    public LithoView getStickyHeader() {
        return this.mStickyHeader;
    }

    public void setStickyHeaderVerticalOffset(int verticalOffset) {
        this.mStickyHeader.setTranslationY((float)verticalOffset);
    }

    public void showStickyHeader() {
        this.mStickyHeader.setVisibility(0);
        this.layoutStickyHeader();
    }

    public void hideStickyHeader() {
        this.mStickyHeader.unmountAllItems();
        this.mStickyHeader.setVisibility(8);
    }

    public void maybeRestoreDetachedComponentTree(int stickyHeaderPosition) {
        LithoView lithoView;
        if (stickyHeaderPosition <= -1 || !ComponentsConfiguration.initStickyHeaderInLayoutWhenComponentTreeIsNull || this.mStickyHeader.getComponentTree() == null) {
            return;
        }
        RecyclerView.ViewHolder viewHolder = this.mRecyclerView.findViewHolderForAdapterPosition(stickyHeaderPosition);
        RecyclerBinderViewHolder recyclerBinderViewHolder = viewHolder instanceof RecyclerBinderViewHolder ? (RecyclerBinderViewHolder)viewHolder : null;
        LithoView lithoView2 = lithoView = recyclerBinderViewHolder != null ? recyclerBinderViewHolder.getLithoView() : null;
        if (lithoView != null && lithoView.getComponentTree() == null && lithoView.hasTemporaryDetachedComponentTree()) {
            lithoView.requestLayout();
        }
    }

    public boolean isStickyHeaderHidden() {
        return this.mStickyHeader.getVisibility() == 8;
    }

    public void setItemAnimator(@Nullable RecyclerView.ItemAnimator itemAnimator) {
        this.mDetachedItemAnimator = this.mRecyclerView.getItemAnimator();
        this.mRecyclerView.setItemAnimator(itemAnimator);
    }

    public void resetItemAnimator() {
        this.mRecyclerView.setItemAnimator(this.mDetachedItemAnimator);
        this.mDetachedItemAnimator = null;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureStickyHeader(View.MeasureSpec.getSize((int)widthMeasureSpec));
    }

    private void measureStickyHeader(int parentWidth) {
        this.measureChild((View)this.mStickyHeader, View.MeasureSpec.makeMeasureSpec((int)parentWidth, (int)0x40000000), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        Integer traceId = DebugEventDispatcher.generateTraceIdentifier((String)"RenderCore.View.OnLayout");
        if (traceId != null) {
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
            attributes.put("id", ((Object)((Object)this)).hashCode());
            attributes.put("name", "SectionsRecyclerView");
            attributes.put("bounds", new Rect(left, top, right, bottom));
            DebugEventDispatcher.beginTrace((int)traceId, (String)"RenderCore.View.OnLayout", (String)"-1", attributes);
        }
        try {
            if (this.mSectionsRecyclerViewLogger != null) {
                this.mSectionsRecyclerViewLogger.onLayoutStarted(this.mIsFirstLayout);
            }
            super.onLayout(changed, left, top, right, bottom);
            this.layoutStickyHeader();
        }
        finally {
            if (this.mSectionsRecyclerViewLogger != null) {
                this.mSectionsRecyclerViewLogger.onLayoutEnded(this.mIsFirstLayout);
            }
            this.mIsFirstLayout = false;
            if (traceId != null) {
                DebugEventDispatcher.endTrace((int)traceId);
            }
        }
    }

    private void layoutStickyHeader() {
        if (this.mStickyHeader.getVisibility() == 8) {
            return;
        }
        int stickyHeaderLeft = this.getPaddingLeft();
        int stickyHeaderTop = this.getPaddingTop();
        this.mStickyHeader.layout(stickyHeaderLeft, stickyHeaderTop, stickyHeaderLeft + this.mStickyHeader.getMeasuredWidth(), stickyHeaderTop + this.mStickyHeader.getMeasuredHeight());
    }

    @Nullable
    static SectionsRecyclerView getParentRecycler(RecyclerView recyclerView) {
        if (recyclerView.getParent() instanceof SectionsRecyclerView) {
            return (SectionsRecyclerView)recyclerView.getParent();
        }
        return null;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHasBeenDetachedFromWindow = true;
    }

    public boolean hasBeenDetachedFromWindow() {
        return this.mHasBeenDetachedFromWindow;
    }

    public void setHasBeenDetachedFromWindow(boolean hasBeenDetachedFromWindow) {
        this.mHasBeenDetachedFromWindow = hasBeenDetachedFromWindow;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
        if (this.getParent() != null && !this.isNestedScrollingEnabled()) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mRecyclerView.setOnTouchListener(listener);
    }

    public void obtainLithoViewChildren(List<BaseMountingView> lithoViews) {
        lithoViews.add((BaseMountingView)this.mStickyHeader);
        int size = this.mRecyclerView.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.mRecyclerView.getChildAt(i);
            if (!(child instanceof LithoView)) continue;
            lithoViews.add((BaseMountingView)((LithoView)child));
        }
    }

    public static interface SectionsRecyclerViewLogger {
        public void onLayoutStarted(boolean var1);

        public void onLayoutEnded(boolean var1);
    }
}

