/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.HasEventDispatcher;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.ItemSelectedEvent;
import com.facebook.litho.widget.SpinnerSpec;
import java.util.BitSet;
import java.util.List;

@Generated
@RequiresApi(value=11)
public final class Spinner
extends SpecGeneratedComponent {
    @javax.annotation.Nullable
    @Prop(resType=ResType.DRAWABLE, optional=true)
    @Comparable(type=13)
    Drawable caret;
    @Prop(resType=ResType.INT, optional=true)
    @Comparable(type=3)
    int itemLayout = 17367050;
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=5)
    List<String> options;
    @Prop(resType=ResType.NONE, optional=false)
    @Comparable(type=13)
    String selectedOption;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int selectedTextColor = -570425344;
    @Prop(resType=ResType.DIMEN_TEXT, optional=true)
    @Comparable(type=0)
    float selectedTextSize = -1.0f;
    @Nullable
    EventHandler<ItemSelectedEvent> itemSelectedEventHandler;

    private Spinner() {
        super("Spinner");
    }

    private SpinnerStateContainer getStateContainerImpl(ComponentContext c) {
        return (SpinnerStateContainer)c.getScopedComponentInfo().getStateContainer();
    }

    protected SpinnerStateContainer createStateContainer() {
        return new SpinnerStateContainer();
    }

    public Spinner makeShallowCopy() {
        Spinner component = (Spinner)super.makeShallowCopy();
        return component;
    }

    protected void createInitialState(ComponentContext _0, StateContainer _stateContainer) {
        SpinnerStateContainer _state = (SpinnerStateContainer)_stateContainer;
        StateValue selection = new StateValue();
        SpinnerSpec.onCreateInitialState((StateValue<String>)selection, this.selectedOption);
        _state.selection = (String)selection.get();
    }

    protected Component onCreateLayout(ComponentContext c) {
        SpinnerStateContainer _state = this.getStateContainerImpl(c);
        Component _result = SpinnerSpec.onCreateLayout(c, _state.selection, _state.isShowingDropDown, this.selectedTextSize, this.selectedTextColor, this.caret);
        return _result;
    }

    @Nullable
    public static EventHandler<ItemSelectedEvent> getItemSelectedEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((Spinner)context.getComponentScope()).itemSelectedEventHandler;
    }

    static void dispatchItemSelectedEvent(EventHandler _eventHandler, String newSelection) {
        ItemSelectedEvent _eventState = new ItemSelectedEvent();
        _eventState.newSelection = newSelection;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    private void onClick(HasEventDispatcher _abstract, ComponentContext c, View view) {
        Spinner _ref = (Spinner)_abstract;
        SpinnerSpec.onClick(c, view, _ref.options, _ref.itemLayout);
    }

    public static EventHandler<ClickEvent> onClick(ComponentContext c) {
        return Spinner.newEventHandler(Spinner.class, (String)"Spinner", (ComponentContext)c, (int)-1351902487, null);
    }

    protected Object dispatchOnEventImpl(EventHandler eventHandler, Object eventState) {
        int id2 = eventHandler.id;
        switch (id2) {
            case -1351902487: {
                ClickEvent _event = (ClickEvent)eventState;
                this.onClick(eventHandler.dispatchInfo.hasEventDispatcher, eventHandler.dispatchInfo.componentContext, _event.view);
                return null;
            }
            case -1048037474: {
                Spinner.dispatchErrorEvent((ComponentContext)eventHandler.dispatchInfo.componentContext, (ErrorEvent)((ErrorEvent)eventState));
                return null;
            }
        }
        return null;
    }

    protected boolean hasState() {
        return true;
    }

    protected static void updateSelection(ComponentContext c, String newSelection) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{newSelection});
        c.updateStateAsync(_stateUpdate, "updateState:Spinner.updateSelection");
    }

    protected static void updateSelectionAsync(ComponentContext c, String newSelection) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{newSelection});
        c.updateStateAsync(_stateUpdate, "updateState:Spinner.updateSelection");
    }

    protected static void updateSelectionSync(ComponentContext c, String newSelection) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(0, new Object[]{newSelection});
        c.updateStateSync(_stateUpdate, "updateState:Spinner.updateSelection");
    }

    protected static void updateIsShowingDropDown(ComponentContext c, boolean isShowing) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(1, new Object[]{isShowing});
        c.updateStateAsync(_stateUpdate, "updateState:Spinner.updateIsShowingDropDown");
    }

    protected static void updateIsShowingDropDownAsync(ComponentContext c, boolean isShowing) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(1, new Object[]{isShowing});
        c.updateStateAsync(_stateUpdate, "updateState:Spinner.updateIsShowingDropDown");
    }

    protected static void updateIsShowingDropDownSync(ComponentContext c, boolean isShowing) {
        Component _component = c.getComponentScope();
        if (_component == null) {
            return;
        }
        StateContainer.StateUpdate _stateUpdate = new StateContainer.StateUpdate(1, new Object[]{isShowing});
        c.updateStateSync(_stateUpdate, "updateState:Spinner.updateIsShowingDropDown");
    }

    public static Builder create(ComponentContext context) {
        return Spinner.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Spinner instance = new Spinner();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        Spinner mSpinner;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"options", "selectedOption"};
        private final int REQUIRED_PROPS_COUNT = 2;
        private final BitSet mRequired = new BitSet(2);

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, Spinner spinnerRef) {
            super(context, defStyleAttr, defStyleRes, (Component)spinnerRef);
            this.mSpinner = spinnerRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mSpinner = (Spinner)component;
        }

        @PropSetter(value="caret", required=false)
        public Builder caret(@javax.annotation.Nullable Drawable caret) {
            this.mSpinner.caret = caret;
            return this;
        }

        @PropSetter(value="caret", required=false)
        public Builder caretRes(@DrawableRes int resId) {
            this.mSpinner.caret = this.mResourceResolver.resolveDrawableRes(resId);
            return this;
        }

        @PropSetter(value="caret", required=false)
        public Builder caretAttr(@AttrRes int attrResId, @DrawableRes int defResId) {
            this.mSpinner.caret = this.mResourceResolver.resolveDrawableAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="caret", required=false)
        public Builder caretAttr(@AttrRes int attrResId) {
            this.mSpinner.caret = this.mResourceResolver.resolveDrawableAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="itemLayout", required=false)
        public Builder itemLayout(int itemLayout) {
            this.mSpinner.itemLayout = itemLayout;
            return this;
        }

        @PropSetter(value="itemLayout", required=false)
        public Builder itemLayoutRes(@IntegerRes int resId) {
            this.mSpinner.itemLayout = this.mResourceResolver.resolveIntRes(resId);
            return this;
        }

        @PropSetter(value="itemLayout", required=false)
        public Builder itemLayoutAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mSpinner.itemLayout = this.mResourceResolver.resolveIntAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="itemLayout", required=false)
        public Builder itemLayoutAttr(@AttrRes int attrResId) {
            this.mSpinner.itemLayout = this.mResourceResolver.resolveIntAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="options", required=true)
        @RequiredProp(value="options")
        public Builder options(List<String> options) {
            this.mSpinner.options = options;
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="selectedOption", required=true)
        @RequiredProp(value="selectedOption")
        public Builder selectedOption(String selectedOption) {
            this.mSpinner.selectedOption = selectedOption;
            this.mRequired.set(1);
            return this;
        }

        @PropSetter(value="selectedTextColor", required=false)
        public Builder selectedTextColor(@ColorInt int selectedTextColor) {
            this.mSpinner.selectedTextColor = selectedTextColor;
            return this;
        }

        @PropSetter(value="selectedTextColor", required=false)
        public Builder selectedTextColorRes(@ColorRes int resId) {
            this.mSpinner.selectedTextColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="selectedTextColor", required=false)
        public Builder selectedTextColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mSpinner.selectedTextColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="selectedTextColor", required=false)
        public Builder selectedTextColorAttr(@AttrRes int attrResId) {
            this.mSpinner.selectedTextColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="selectedTextSize", required=false)
        public Builder selectedTextSizePx(@Px float selectedTextSize) {
            this.mSpinner.selectedTextSize = selectedTextSize;
            return this;
        }

        @PropSetter(value="selectedTextSize", required=false)
        public Builder selectedTextSizeDip(@Dimension(unit=0) float dip) {
            this.mSpinner.selectedTextSize = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="selectedTextSize", required=false)
        public Builder selectedTextSizeSp(@Dimension(unit=2) float sip) {
            this.mSpinner.selectedTextSize = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="selectedTextSize", required=false)
        public Builder selectedTextSizeRes(@DimenRes int resId) {
            this.mSpinner.selectedTextSize = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="selectedTextSize", required=false)
        public Builder selectedTextSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mSpinner.selectedTextSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="selectedTextSize", required=false)
        public Builder selectedTextSizeAttr(@AttrRes int attrResId) {
            this.mSpinner.selectedTextSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        public Builder itemSelectedEventHandler(@Nullable EventHandler<ItemSelectedEvent> itemSelectedEventHandler) {
            this.mSpinner.itemSelectedEventHandler = itemSelectedEventHandler;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Spinner build() {
            Builder.checkArgs((int)2, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            return this.mSpinner;
        }
    }

    @Generated
    @VisibleForTesting(otherwise=2)
    static class SpinnerStateContainer
    extends StateContainer {
        @State
        @Comparable(type=3)
        boolean isShowingDropDown;
        @State
        @Comparable(type=13)
        String selection;

        SpinnerStateContainer() {
        }

        public void applyStateUpdate(StateContainer.StateUpdate stateUpdate) {
            Object[] params = stateUpdate.params;
            switch (stateUpdate.type) {
                case 0: {
                    StateValue selection = new StateValue();
                    selection.set((Object)this.selection);
                    SpinnerSpec.updateSelection((StateValue<String>)selection, (String)params[0]);
                    this.selection = (String)selection.get();
                    break;
                }
                case 1: {
                    StateValue isShowingDropDown = new StateValue();
                    isShowingDropDown.set((Object)this.isShowingDropDown);
                    SpinnerSpec.updateIsShowingDropDown((StateValue<Boolean>)isShowingDropDown, (Boolean)params[0]);
                    this.isShowingDropDown = (Boolean)isShowingDropDown.get();
                }
            }
        }
    }
}

