/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Row;
import com.facebook.litho.StateValue;
import com.facebook.litho.annotations.LayoutSpec;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnCreateLayout;
import com.facebook.litho.annotations.OnEvent;
import com.facebook.litho.annotations.OnUpdateState;
import com.facebook.litho.annotations.Param;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.State;
import com.facebook.litho.widget.Image;
import com.facebook.litho.widget.ItemSelectedEvent;
import com.facebook.litho.widget.Spinner;
import com.facebook.litho.widget.Text;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaJustify;
import java.util.List;
import javax.annotation.Nullable;

@LayoutSpec(events={ItemSelectedEvent.class})
@RequiresApi(value=11)
public class SpinnerSpec {
    private static final float MARGIN_SMALL = 8.0f;
    private static final int DEFAULT_CARET_COLOR = -1979711488;
    private static final int DEFAULT_TEXT_SIZE_SP = 16;
    private static final int SPINNER_HEIGHT = 48;
    @PropDefault
    static final int itemLayout = 17367050;
    @PropDefault
    static final float selectedTextSize = -1.0f;
    @PropDefault
    static final int selectedTextColor = -570425344;

    @OnCreateInitialState
    static void onCreateInitialState(StateValue<String> selection, @Prop String selectedOption) {
        selection.set((Object)selectedOption);
    }

    @OnCreateLayout
    static Component onCreateLayout(ComponentContext c, @State String selection, @State boolean isShowingDropDown, @Prop(resType=ResType.DIMEN_TEXT, optional=true) float selectedTextSize, @Prop(resType=ResType.COLOR, optional=true) int selectedTextColor, @Prop(resType=ResType.DRAWABLE, optional=true) @Nullable Drawable caret) {
        caret = caret == null ? new CaretDrawable(c.getAndroidContext(), -1979711488) : caret;
        selectedTextSize = selectedTextSize == -1.0f ? SpinnerSpec.spToPx(c.getAndroidContext(), 16) : selectedTextSize;
        return ((Row.Builder)((Row.Builder)((Row.Builder)((Row.Builder)((Row.Builder)Row.create((ComponentContext)c).minHeightDip(48.0f)).justifyContent(YogaJustify.SPACE_BETWEEN).paddingDip(YogaEdge.START, 8.0f)).backgroundAttr(16843534)).clickHandler(Spinner.onClick(c))).child(SpinnerSpec.createSelectedItemText(c, selection, (int)selectedTextSize, selectedTextColor)).child(SpinnerSpec.createCaret(c, caret, isShowingDropDown)).accessibilityRole("android.widget.Spinner")).build();
    }

    private static Component createCaret(ComponentContext c, Drawable icon, boolean isShowingDropDown) {
        return ((Image.Builder)((Image.Builder)((Image.Builder)((Image.Builder)((Image.Builder)Image.create(c).drawable(icon).widthDip(48.0f)).heightDip(48.0f)).flexShrink(0.0f)).flexGrow(0.0f)).scale(isShowingDropDown ? -1.0f : 1.0f)).build();
    }

    private static Component createSelectedItemText(ComponentContext c, String selection, int textSizePx, @ColorInt int textColor) {
        return ((Text.Builder)Text.create(c).text(selection).alignSelf(YogaAlign.CENTER)).textSizePx(textSizePx).textColor(textColor).build();
    }

    @OnEvent(value=ClickEvent.class)
    static void onClick(final ComponentContext c, View view, final @Prop List<String> options, @Prop(resType=ResType.INT, optional=true) int itemLayout) {
        final EventHandler<ItemSelectedEvent> eventHandler = Spinner.getItemSelectedEventHandler(c);
        final ListPopupWindow popup = new ListPopupWindow(c.getAndroidContext());
        popup.setAnchorView(view);
        popup.setModal(true);
        popup.setPromptPosition(0);
        popup.setAdapter((ListAdapter)new ArrayAdapter(c.getAndroidContext(), itemLayout, options));
        popup.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String newSelection = (String)options.get(position);
                if (eventHandler != null) {
                    Spinner.dispatchItemSelectedEvent(eventHandler, newSelection);
                }
                popup.dismiss();
                Spinner.updateSelectionSync(c, newSelection);
            }
        });
        popup.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                Spinner.updateIsShowingDropDownSync(c, false);
            }
        });
        popup.show();
        Spinner.updateIsShowingDropDownSync(c, true);
    }

    @OnUpdateState
    static void updateSelection(StateValue<String> selection, @Param String newSelection) {
        selection.set((Object)newSelection);
    }

    @OnUpdateState
    static void updateIsShowingDropDown(StateValue<Boolean> isShowingDropDown, @Param boolean isShowing) {
        isShowingDropDown.set((Object)isShowing);
    }

    private static float spToPx(Context context, int spValue) {
        return TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private static float dpToPx(Context context, int dpValue) {
        return TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    private static class CaretDrawable
    extends Drawable {
        private static final int CARET_WIDTH_DP = 5;
        private static final int CARET_HEIGHT_DP = 3;
        private final Paint paint = new Paint();
        private final int mWidth;
        private final int mHeight;
        private final Path mTrianglePath = new Path();
        private final Point mP1 = new Point();
        private final Point mP2 = new Point();
        private final Point mP3 = new Point();

        CaretDrawable(Context context, @ColorInt int caretColor) {
            this.paint.setColor(caretColor);
            this.paint.setFlags(1);
            this.mWidth = (int)SpinnerSpec.dpToPx(context, 5);
            this.mHeight = (int)SpinnerSpec.dpToPx(context, 3);
        }

        protected void onBoundsChange(Rect bounds) {
            super.onBoundsChange(bounds);
            int cx = bounds.centerX();
            int cy = bounds.centerY();
            this.mP1.set(cx - this.mWidth, cy - this.mHeight);
            this.mP2.set(cx + this.mWidth, cy - this.mHeight);
            this.mP3.set(cx, cy + this.mHeight);
            this.mTrianglePath.reset();
            this.mTrianglePath.setFillType(Path.FillType.EVEN_ODD);
            this.mTrianglePath.moveTo((float)this.mP1.x, (float)this.mP1.y);
            this.mTrianglePath.lineTo((float)this.mP2.x, (float)this.mP2.y);
            this.mTrianglePath.lineTo((float)this.mP3.x, (float)this.mP3.y);
            this.mTrianglePath.close();
        }

        public void draw(Canvas canvas) {
            canvas.drawPath(this.mTrianglePath, this.paint);
        }

        public void setAlpha(int alpha) {
            throw new RuntimeException("Not supported");
        }

        public void setColorFilter(@Nullable ColorFilter colorFilter) {
            throw new RuntimeException("Not supported");
        }

        public int getOpacity() {
            return -1;
        }
    }
}

