/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.IntegerRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.core.text.TextDirectionHeuristicCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.InterStagePropsContainer;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.SpecGeneratedComponent;
import com.facebook.litho.annotations.Comparable;
import com.facebook.litho.annotations.Generated;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropSetter;
import com.facebook.litho.annotations.RequiredProp;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.widget.ClickableSpanListener;
import com.facebook.litho.widget.TextAlignment;
import com.facebook.litho.widget.TextDrawable;
import com.facebook.litho.widget.TextOffsetOnTouchEvent;
import com.facebook.litho.widget.TextSpec;
import com.facebook.litho.widget.TouchableSpanListener;
import com.facebook.litho.widget.VerticalGravity;
import java.util.BitSet;

@Generated
public final class Text
extends SpecGeneratedComponent {
    @Prop(resType=ResType.BOOL, optional=true)
    @Comparable(type=3)
    boolean accessibleClickableSpans;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    TextAlignment alignment;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int breakStrategy = 0;
    @Prop(resType=ResType.DIMEN_TEXT, optional=true)
    @Comparable(type=0)
    float clickableSpanExpandedOffset;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean clipToBounds = true;
    @Prop(resType=ResType.STRING, optional=true)
    @Comparable(type=13)
    @Nullable
    CharSequence customEllipsisText;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    DynamicValue<Integer> dynamicTextColor;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    TextUtils.TruncateAt ellipsize;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float extraSpacing;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean glyphWarming = false;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int highlightColor;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int highlightEndOffset = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int highlightStartOffset = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int hyphenationFrequency = 0;
    @Prop(resType=ResType.BOOL, optional=true)
    @Comparable(type=3)
    boolean isSingleLine;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int justificationMode = 0;
    @Prop(resType=ResType.FLOAT, optional=true)
    @Comparable(type=0)
    float letterSpacing;
    @Prop(resType=ResType.DIMEN_TEXT, optional=true)
    @Comparable(type=0)
    float lineHeight = Float.MAX_VALUE;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int linkColor = -16776961;
    @Prop(resType=ResType.INT, optional=true)
    @Comparable(type=3)
    int maxEms = -1;
    @Prop(resType=ResType.INT, optional=true)
    @Comparable(type=3)
    int maxLines = Integer.MAX_VALUE;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int maxTextWidth = Integer.MAX_VALUE;
    @Prop(resType=ResType.INT, optional=true)
    @Comparable(type=3)
    int minEms = -1;
    @Prop(resType=ResType.INT, optional=true)
    @Comparable(type=3)
    int minLines = Integer.MIN_VALUE;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int minTextWidth = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    boolean minimallyWide;
    @Prop(resType=ResType.DIMEN_SIZE, optional=true)
    @Comparable(type=3)
    int minimallyWideThreshold;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int shadowColor = -7829368;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowDx;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowDy;
    @Prop(resType=ResType.DIMEN_OFFSET, optional=true)
    @Comparable(type=0)
    float shadowRadius;
    @Prop(resType=ResType.BOOL, optional=true)
    @Comparable(type=3)
    boolean shouldIncludeFontPadding = true;
    @Prop(resType=ResType.FLOAT, optional=true)
    @Comparable(type=0)
    float spacingMultiplier = 1.0f;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    ClickableSpanListener spanListener;
    @Prop(resType=ResType.STRING, optional=false)
    @Comparable(type=13)
    @Nullable
    CharSequence text;
    @Deprecated
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    Layout.Alignment textAlignment;
    @Prop(resType=ResType.COLOR, optional=true)
    @Comparable(type=3)
    int textColor = 0;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    ColorStateList textColorStateList = TextSpec.textColorStateList;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    TextDirectionHeuristicCompat textDirection;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=11)
    @Nullable
    EventHandler textOffsetOnTouchHandler;
    @Prop(resType=ResType.DIMEN_TEXT, optional=true)
    @Comparable(type=3)
    int textSize = -1;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=3)
    int textStyle = TextSpec.textStyle;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    TouchableSpanListener touchableSpanListener;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    @Nullable
    Typeface typeface = TextSpec.typeface;
    @Prop(resType=ResType.NONE, optional=true)
    @Comparable(type=13)
    VerticalGravity verticalGravity = TextSpec.verticalGravity;
    private DynamicValue[] mDynamicProps;
    @Nullable
    EventHandler<TextOffsetOnTouchEvent> textOffsetOnTouchEventHandler;

    private Text() {
        super("Text");
    }

    protected TextInterStagePropsContainer createInterStagePropsContainer() {
        return new TextInterStagePropsContainer();
    }

    private TextInterStagePropsContainer getInterStagePropsContainerImpl(ComponentContext c, InterStagePropsContainer interStageProps) {
        return (TextInterStagePropsContainer)super.getInterStagePropsContainer(c, interStageProps);
    }

    public boolean isEquivalentProps(Component other, boolean shouldCompareCommonProps) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        Text textRef = (Text)other;
        if (this.accessibleClickableSpans != textRef.accessibleClickableSpans) {
            return false;
        }
        if (this.alignment != null ? !this.alignment.equals((Object)textRef.alignment) : textRef.alignment != null) {
            return false;
        }
        if (this.breakStrategy != textRef.breakStrategy) {
            return false;
        }
        if (Float.compare(this.clickableSpanExpandedOffset, textRef.clickableSpanExpandedOffset) != 0) {
            return false;
        }
        if (this.clipToBounds != textRef.clipToBounds) {
            return false;
        }
        if (this.customEllipsisText != null ? !this.customEllipsisText.equals(textRef.customEllipsisText) : textRef.customEllipsisText != null) {
            return false;
        }
        if (this.dynamicTextColor != null ? !this.dynamicTextColor.equals(textRef.dynamicTextColor) : textRef.dynamicTextColor != null) {
            return false;
        }
        if (this.ellipsize != null ? !this.ellipsize.equals((Object)textRef.ellipsize) : textRef.ellipsize != null) {
            return false;
        }
        if (Float.compare(this.extraSpacing, textRef.extraSpacing) != 0) {
            return false;
        }
        if (this.glyphWarming != textRef.glyphWarming) {
            return false;
        }
        if (this.highlightColor != textRef.highlightColor) {
            return false;
        }
        if (this.highlightEndOffset != textRef.highlightEndOffset) {
            return false;
        }
        if (this.highlightStartOffset != textRef.highlightStartOffset) {
            return false;
        }
        if (this.hyphenationFrequency != textRef.hyphenationFrequency) {
            return false;
        }
        if (this.isSingleLine != textRef.isSingleLine) {
            return false;
        }
        if (this.justificationMode != textRef.justificationMode) {
            return false;
        }
        if (Float.compare(this.letterSpacing, textRef.letterSpacing) != 0) {
            return false;
        }
        if (Float.compare(this.lineHeight, textRef.lineHeight) != 0) {
            return false;
        }
        if (this.linkColor != textRef.linkColor) {
            return false;
        }
        if (this.maxEms != textRef.maxEms) {
            return false;
        }
        if (this.maxLines != textRef.maxLines) {
            return false;
        }
        if (this.maxTextWidth != textRef.maxTextWidth) {
            return false;
        }
        if (this.minEms != textRef.minEms) {
            return false;
        }
        if (this.minLines != textRef.minLines) {
            return false;
        }
        if (this.minTextWidth != textRef.minTextWidth) {
            return false;
        }
        if (this.minimallyWide != textRef.minimallyWide) {
            return false;
        }
        if (this.minimallyWideThreshold != textRef.minimallyWideThreshold) {
            return false;
        }
        if (this.shadowColor != textRef.shadowColor) {
            return false;
        }
        if (Float.compare(this.shadowDx, textRef.shadowDx) != 0) {
            return false;
        }
        if (Float.compare(this.shadowDy, textRef.shadowDy) != 0) {
            return false;
        }
        if (Float.compare(this.shadowRadius, textRef.shadowRadius) != 0) {
            return false;
        }
        if (this.shouldIncludeFontPadding != textRef.shouldIncludeFontPadding) {
            return false;
        }
        if (Float.compare(this.spacingMultiplier, textRef.spacingMultiplier) != 0) {
            return false;
        }
        if (this.spanListener != null ? !this.spanListener.equals(textRef.spanListener) : textRef.spanListener != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(textRef.text) : textRef.text != null) {
            return false;
        }
        if (this.textAlignment != null ? !this.textAlignment.equals((Object)textRef.textAlignment) : textRef.textAlignment != null) {
            return false;
        }
        if (this.textColor != textRef.textColor) {
            return false;
        }
        if (this.textColorStateList != null ? !this.textColorStateList.equals(textRef.textColorStateList) : textRef.textColorStateList != null) {
            return false;
        }
        if (this.textDirection != null ? !this.textDirection.equals(textRef.textDirection) : textRef.textDirection != null) {
            return false;
        }
        if (this.textOffsetOnTouchHandler != null ? !this.textOffsetOnTouchHandler.isEquivalentTo(textRef.textOffsetOnTouchHandler) : textRef.textOffsetOnTouchHandler != null) {
            return false;
        }
        if (this.textSize != textRef.textSize) {
            return false;
        }
        if (this.textStyle != textRef.textStyle) {
            return false;
        }
        if (this.touchableSpanListener != null ? !this.touchableSpanListener.equals(textRef.touchableSpanListener) : textRef.touchableSpanListener != null) {
            return false;
        }
        if (this.typeface != null ? !this.typeface.equals((Object)textRef.typeface) : textRef.typeface != null) {
            return false;
        }
        return !(this.verticalGravity != null ? !this.verticalGravity.equals((Object)textRef.verticalGravity) : textRef.verticalGravity != null);
    }

    protected void copyInterStageImpl(InterStagePropsContainer copyIntoInterStagePropsContainer, InterStagePropsContainer copyFromInterStagePropsContainer) {
        TextInterStagePropsContainer copyIntoInterStagePropsContainer_ref = (TextInterStagePropsContainer)copyIntoInterStagePropsContainer;
        TextInterStagePropsContainer copyFromInterStagePropsContainer_ref = (TextInterStagePropsContainer)copyFromInterStagePropsContainer;
        copyIntoInterStagePropsContainer_ref.clickableSpans = copyFromInterStagePropsContainer_ref.clickableSpans;
        copyIntoInterStagePropsContainer_ref.imageSpans = copyFromInterStagePropsContainer_ref.imageSpans;
        copyIntoInterStagePropsContainer_ref.measureLayout = copyFromInterStagePropsContainer_ref.measureLayout;
        copyIntoInterStagePropsContainer_ref.measuredHeight = copyFromInterStagePropsContainer_ref.measuredHeight;
        copyIntoInterStagePropsContainer_ref.measuredWidth = copyFromInterStagePropsContainer_ref.measuredWidth;
        copyIntoInterStagePropsContainer_ref.processedText = copyFromInterStagePropsContainer_ref.processedText;
        copyIntoInterStagePropsContainer_ref.textLayout = copyFromInterStagePropsContainer_ref.textLayout;
        copyIntoInterStagePropsContainer_ref.textLayoutTranslationY = copyFromInterStagePropsContainer_ref.textLayoutTranslationY;
    }

    public Text makeShallowCopy() {
        Text component = (Text)super.makeShallowCopy();
        return component;
    }

    protected DynamicValue[] getDynamicProps() {
        return this.mDynamicProps;
    }

    protected void bindDynamicProp(int dynamicPropIndex, Object value, Object mountedContent) {
        switch (dynamicPropIndex) {
            case 0: {
                TextSpec.onBindTextColor((TextDrawable)((Object)mountedContent), (Integer)Text.retrieveValue(this.dynamicTextColor));
                break;
            }
        }
    }

    protected void onLoadStyle(ComponentContext c) {
        Output ellipsizeTmp = new Output();
        Output extraSpacingTmp = new Output();
        Output shouldIncludeFontPaddingTmp = new Output();
        Output spacingMultiplierTmp = new Output();
        Output minLinesTmp = new Output();
        Output maxLinesTmp = new Output();
        Output minEmsTmp = new Output();
        Output maxEmsTmp = new Output();
        Output minTextWidthTmp = new Output();
        Output maxTextWidthTmp = new Output();
        Output isSingleLineTmp = new Output();
        Output textTmp = new Output();
        Output textColorStateListTmp = new Output();
        Output linkColorTmp = new Output();
        Output highlightColorTmp = new Output();
        Output textSizeTmp = new Output();
        Output alignmentTmp = new Output();
        Output breakStrategyTmp = new Output();
        Output hyphenationFrequencyTmp = new Output();
        Output justificationModeTmp = new Output();
        Output textStyleTmp = new Output();
        Output shadowRadiusTmp = new Output();
        Output shadowDxTmp = new Output();
        Output shadowDyTmp = new Output();
        Output shadowColorTmp = new Output();
        Output verticalGravityTmp = new Output();
        Output typefaceTmp = new Output();
        TextSpec.onLoadStyle(c, (Output<TextUtils.TruncateAt>)ellipsizeTmp, (Output<Float>)extraSpacingTmp, (Output<Boolean>)shouldIncludeFontPaddingTmp, (Output<Float>)spacingMultiplierTmp, (Output<Integer>)minLinesTmp, (Output<Integer>)maxLinesTmp, (Output<Integer>)minEmsTmp, (Output<Integer>)maxEmsTmp, (Output<Integer>)minTextWidthTmp, (Output<Integer>)maxTextWidthTmp, (Output<Boolean>)isSingleLineTmp, (Output<CharSequence>)textTmp, (Output<ColorStateList>)textColorStateListTmp, (Output<Integer>)linkColorTmp, (Output<Integer>)highlightColorTmp, (Output<Integer>)textSizeTmp, (Output<TextAlignment>)alignmentTmp, (Output<Integer>)breakStrategyTmp, (Output<Integer>)hyphenationFrequencyTmp, (Output<Integer>)justificationModeTmp, (Output<Integer>)textStyleTmp, (Output<Float>)shadowRadiusTmp, (Output<Float>)shadowDxTmp, (Output<Float>)shadowDyTmp, (Output<Integer>)shadowColorTmp, (Output<VerticalGravity>)verticalGravityTmp, (Output<Typeface>)typefaceTmp);
        if (ellipsizeTmp.get() != null) {
            this.ellipsize = (TextUtils.TruncateAt)ellipsizeTmp.get();
        }
        if (extraSpacingTmp.get() != null) {
            this.extraSpacing = ((Float)extraSpacingTmp.get()).floatValue();
        }
        if (shouldIncludeFontPaddingTmp.get() != null) {
            this.shouldIncludeFontPadding = (Boolean)shouldIncludeFontPaddingTmp.get();
        }
        if (spacingMultiplierTmp.get() != null) {
            this.spacingMultiplier = ((Float)spacingMultiplierTmp.get()).floatValue();
        }
        if (minLinesTmp.get() != null) {
            this.minLines = (Integer)minLinesTmp.get();
        }
        if (maxLinesTmp.get() != null) {
            this.maxLines = (Integer)maxLinesTmp.get();
        }
        if (minEmsTmp.get() != null) {
            this.minEms = (Integer)minEmsTmp.get();
        }
        if (maxEmsTmp.get() != null) {
            this.maxEms = (Integer)maxEmsTmp.get();
        }
        if (minTextWidthTmp.get() != null) {
            this.minTextWidth = (Integer)minTextWidthTmp.get();
        }
        if (maxTextWidthTmp.get() != null) {
            this.maxTextWidth = (Integer)maxTextWidthTmp.get();
        }
        if (isSingleLineTmp.get() != null) {
            this.isSingleLine = (Boolean)isSingleLineTmp.get();
        }
        if (textTmp.get() != null) {
            this.text = (CharSequence)textTmp.get();
        }
        if (textColorStateListTmp.get() != null) {
            this.textColorStateList = (ColorStateList)textColorStateListTmp.get();
        }
        if (linkColorTmp.get() != null) {
            this.linkColor = (Integer)linkColorTmp.get();
        }
        if (highlightColorTmp.get() != null) {
            this.highlightColor = (Integer)highlightColorTmp.get();
        }
        if (textSizeTmp.get() != null) {
            this.textSize = (Integer)textSizeTmp.get();
        }
        if (alignmentTmp.get() != null) {
            this.alignment = (TextAlignment)((Object)alignmentTmp.get());
        }
        if (breakStrategyTmp.get() != null) {
            this.breakStrategy = (Integer)breakStrategyTmp.get();
        }
        if (hyphenationFrequencyTmp.get() != null) {
            this.hyphenationFrequency = (Integer)hyphenationFrequencyTmp.get();
        }
        if (justificationModeTmp.get() != null) {
            this.justificationMode = (Integer)justificationModeTmp.get();
        }
        if (textStyleTmp.get() != null) {
            this.textStyle = (Integer)textStyleTmp.get();
        }
        if (shadowRadiusTmp.get() != null) {
            this.shadowRadius = ((Float)shadowRadiusTmp.get()).floatValue();
        }
        if (shadowDxTmp.get() != null) {
            this.shadowDx = ((Float)shadowDxTmp.get()).floatValue();
        }
        if (shadowDyTmp.get() != null) {
            this.shadowDy = ((Float)shadowDyTmp.get()).floatValue();
        }
        if (shadowColorTmp.get() != null) {
            this.shadowColor = (Integer)shadowColorTmp.get();
        }
        if (verticalGravityTmp.get() != null) {
            this.verticalGravity = (VerticalGravity)((Object)verticalGravityTmp.get());
        }
        if (typefaceTmp.get() != null) {
            this.typeface = (Typeface)typefaceTmp.get();
        }
    }

    protected void onMeasure(ComponentContext context, ComponentLayout layout2, int widthSpec, int heightSpec, Size size, InterStagePropsContainer _5) {
        InterStagePropsContainer _interStageProps = _5;
        Output measureLayoutTmp = new Output();
        Output measuredWidthTmp = new Output();
        Output measuredHeightTmp = new Output();
        TextSpec.onMeasure(context, layout2, widthSpec, heightSpec, size, this.text, this.ellipsize, this.shouldIncludeFontPadding, this.minLines, this.maxLines, this.minEms, this.maxEms, this.minTextWidth, this.maxTextWidth, this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor, this.isSingleLine, this.textColor, this.textColorStateList, this.linkColor, this.textSize, this.extraSpacing, this.spacingMultiplier, this.letterSpacing, this.textStyle, this.typeface, this.textAlignment, this.alignment, this.breakStrategy, this.hyphenationFrequency, this.justificationMode, this.glyphWarming, this.textDirection, this.minimallyWide, this.minimallyWideThreshold, this.lineHeight, (Output<Layout>)measureLayoutTmp, (Output<Integer>)measuredWidthTmp, (Output<Integer>)measuredHeightTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).measureLayout = (Layout)measureLayoutTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).measuredWidth = (Integer)measuredWidthTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)context, (InterStagePropsContainer)_interStageProps).measuredHeight = (Integer)measuredHeightTmp.get();
    }

    protected boolean canMeasure() {
        return true;
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout2, InterStagePropsContainer _2) {
        InterStagePropsContainer _interStageProps = _2;
        Output processedTextTmp = new Output();
        Output textLayoutTmp = new Output();
        Output textLayoutTranslationYTmp = new Output();
        Output clickableSpansTmp = new Output();
        Output imageSpansTmp = new Output();
        TextSpec.onBoundsDefined(c, layout2, this.text, this.ellipsize, this.shouldIncludeFontPadding, this.maxLines, this.minEms, this.maxEms, this.minTextWidth, this.maxTextWidth, this.shadowRadius, this.shadowDx, this.shadowDy, this.shadowColor, this.isSingleLine, this.textColor, this.textColorStateList, this.linkColor, this.textSize, this.extraSpacing, this.spacingMultiplier, this.letterSpacing, this.verticalGravity, this.textStyle, this.typeface, this.textAlignment, this.alignment, this.breakStrategy, this.hyphenationFrequency, this.glyphWarming, this.textDirection, this.customEllipsisText, this.lineHeight, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).measureLayout, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).measuredWidth, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).measuredHeight, (Output<CharSequence>)processedTextTmp, (Output<Layout>)textLayoutTmp, (Output<Float>)textLayoutTranslationYTmp, (Output<ClickableSpan[]>)clickableSpansTmp, (Output<ImageSpan[]>)imageSpansTmp);
        this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).processedText = (CharSequence)processedTextTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).textLayout = (Layout)textLayoutTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).textLayoutTranslationY = (Float)textLayoutTranslationYTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).clickableSpans = (ClickableSpan[])clickableSpansTmp.get();
        this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).imageSpans = (ImageSpan[])imageSpansTmp.get();
    }

    protected Object onCreateMountContent(Context c) {
        TextDrawable _result = TextSpec.onCreateMountContent(c);
        return _result;
    }

    protected void onMount(ComponentContext c, Object textDrawable, InterStagePropsContainer _2) {
        InterStagePropsContainer _interStageProps = _2;
        TextSpec.onMount(c, (TextDrawable)((Object)textDrawable), this.textColor, this.highlightColor, this.textColorStateList, this.textOffsetOnTouchHandler, this.highlightStartOffset, this.highlightEndOffset, this.clickableSpanExpandedOffset, this.clipToBounds, this.spanListener, this.touchableSpanListener, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).processedText, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).textLayout, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).textLayoutTranslationY, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).clickableSpans, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).imageSpans);
    }

    protected void onUnmount(ComponentContext c, Object textDrawable, InterStagePropsContainer _2) {
        TextSpec.onUnmount(c, (TextDrawable)((Object)textDrawable), this.text);
    }

    protected void onPopulateAccessibilityNode(ComponentContext c, View host, AccessibilityNodeInfoCompat node, InterStagePropsContainer _3) {
        TextSpec.onPopulateAccessibilityNode(c, host, node, (Integer)Text.retrieveValue(this.dynamicTextColor), this.text, this.isSingleLine);
    }

    public boolean implementsAccessibility() {
        return true;
    }

    protected int getExtraAccessibilityNodesCount(ComponentContext c, InterStagePropsContainer _1) {
        InterStagePropsContainer _interStageProps = _1;
        int _result = TextSpec.getExtraAccessibilityNodesCount(c, this.accessibleClickableSpans, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).clickableSpans);
        return _result;
    }

    protected void onPopulateExtraAccessibilityNode(ComponentContext c, AccessibilityNodeInfoCompat node, int extraNodeIndex, int componentBoundsLeft, int componentBoundsTop, InterStagePropsContainer _5) {
        InterStagePropsContainer _interStageProps = _5;
        TextSpec.onPopulateExtraAccessibilityNode(c, node, extraNodeIndex, componentBoundsLeft, componentBoundsTop, this.text, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).textLayout, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).clickableSpans);
    }

    public boolean implementsExtraAccessibilityNodes() {
        return true;
    }

    protected int getExtraAccessibilityNodeAt(ComponentContext c, int x, int y, InterStagePropsContainer _3) {
        InterStagePropsContainer _interStageProps = _3;
        int _result = TextSpec.getExtraAccessibilityNodeAt(c, x, y, this.text, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).textLayout, this.getInterStagePropsContainerImpl((ComponentContext)c, (InterStagePropsContainer)_interStageProps).clickableSpans);
        return _result;
    }

    public Component.MountType getMountType() {
        return Component.MountType.DRAWABLE;
    }

    public int poolSize() {
        return 30;
    }

    public boolean canPreallocate() {
        return true;
    }

    protected boolean isMountSizeDependent() {
        return true;
    }

    public boolean isPureRender() {
        return true;
    }

    @Nullable
    public static EventHandler<TextOffsetOnTouchEvent> getTextOffsetOnTouchEventHandler(ComponentContext context) {
        if (context.getComponentScope() == null) {
            return null;
        }
        return ((Text)context.getComponentScope()).textOffsetOnTouchEventHandler;
    }

    static void dispatchTextOffsetOnTouchEvent(EventHandler _eventHandler, CharSequence text, int textOffset) {
        TextOffsetOnTouchEvent _eventState = new TextOffsetOnTouchEvent();
        _eventState.text = text;
        _eventState.textOffset = textOffset;
        EventDispatcher _dispatcher = _eventHandler.dispatchInfo.hasEventDispatcher.getEventDispatcher();
        _dispatcher.dispatchOnEvent(_eventHandler, (Object)_eventState);
    }

    public static Builder create(ComponentContext context) {
        return Text.create(context, 0, 0);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        Text instance = new Text();
        return new Builder(context, defStyleAttr, defStyleRes, instance);
    }

    static /* synthetic */ DynamicValue[] access$102(Text x0, DynamicValue[] x1) {
        x0.mDynamicProps = x1;
        return x1;
    }

    @Generated
    public static final class Builder
    extends Component.Builder<Builder> {
        Text mText;
        ComponentContext mContext;
        private final String[] REQUIRED_PROPS_NAMES = new String[]{"text"};
        private final int REQUIRED_PROPS_COUNT = 1;
        private final BitSet mRequired = new BitSet(1);

        private Builder(ComponentContext context, int defStyleAttr, int defStyleRes, Text textRef) {
            super(context, defStyleAttr, defStyleRes, (Component)textRef);
            this.mText = textRef;
            this.mContext = context;
            this.mRequired.clear();
        }

        protected void setComponent(Component component) {
            this.mText = (Text)component;
        }

        @PropSetter(value="accessibleClickableSpans", required=false)
        public Builder accessibleClickableSpans(boolean accessibleClickableSpans) {
            this.mText.accessibleClickableSpans = accessibleClickableSpans;
            return this;
        }

        @PropSetter(value="accessibleClickableSpans", required=false)
        public Builder accessibleClickableSpansRes(@BoolRes int resId) {
            this.mText.accessibleClickableSpans = this.mResourceResolver.resolveBoolRes(resId);
            return this;
        }

        @PropSetter(value="accessibleClickableSpans", required=false)
        public Builder accessibleClickableSpansAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mText.accessibleClickableSpans = this.mResourceResolver.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="accessibleClickableSpans", required=false)
        public Builder accessibleClickableSpansAttr(@AttrRes int attrResId) {
            this.mText.accessibleClickableSpans = this.mResourceResolver.resolveBoolAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="alignment", required=false)
        public Builder alignment(@Nullable TextAlignment alignment) {
            this.mText.alignment = alignment;
            return this;
        }

        @PropSetter(value="breakStrategy", required=false)
        public Builder breakStrategy(int breakStrategy) {
            this.mText.breakStrategy = breakStrategy;
            return this;
        }

        @PropSetter(value="clickableSpanExpandedOffset", required=false)
        public Builder clickableSpanExpandedOffsetPx(@Px float clickableSpanExpandedOffset) {
            this.mText.clickableSpanExpandedOffset = clickableSpanExpandedOffset;
            return this;
        }

        @PropSetter(value="clickableSpanExpandedOffset", required=false)
        public Builder clickableSpanExpandedOffsetDip(@Dimension(unit=0) float dip) {
            this.mText.clickableSpanExpandedOffset = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="clickableSpanExpandedOffset", required=false)
        public Builder clickableSpanExpandedOffsetSp(@Dimension(unit=2) float sip) {
            this.mText.clickableSpanExpandedOffset = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="clickableSpanExpandedOffset", required=false)
        public Builder clickableSpanExpandedOffsetRes(@DimenRes int resId) {
            this.mText.clickableSpanExpandedOffset = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="clickableSpanExpandedOffset", required=false)
        public Builder clickableSpanExpandedOffsetAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.clickableSpanExpandedOffset = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="clickableSpanExpandedOffset", required=false)
        public Builder clickableSpanExpandedOffsetAttr(@AttrRes int attrResId) {
            this.mText.clickableSpanExpandedOffset = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="clipToBounds", required=false)
        public Builder clipToBounds(boolean clipToBounds) {
            this.mText.clipToBounds = clipToBounds;
            return this;
        }

        @PropSetter(value="customEllipsisText", required=false)
        public Builder customEllipsisText(@Nullable CharSequence customEllipsisText) {
            this.mText.customEllipsisText = customEllipsisText;
            return this;
        }

        @PropSetter(value="customEllipsisText", required=false)
        public Builder customEllipsisTextRes(@StringRes int resId) {
            this.mText.customEllipsisText = this.mResourceResolver.resolveStringRes(resId);
            return this;
        }

        @PropSetter(value="customEllipsisText", required=false)
        public Builder customEllipsisTextRes(@StringRes int resId, Object ... formatArgs) {
            this.mText.customEllipsisText = this.mResourceResolver.resolveStringRes(resId, formatArgs);
            return this;
        }

        @PropSetter(value="customEllipsisText", required=false)
        public Builder customEllipsisTextAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mText.customEllipsisText = this.mResourceResolver.resolveStringAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="customEllipsisText", required=false)
        public Builder customEllipsisTextAttr(@AttrRes int attrResId) {
            this.mText.customEllipsisText = this.mResourceResolver.resolveStringAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="dynamicTextColor", required=false)
        public Builder dynamicTextColor(DynamicValue<Integer> dynamicTextColor) {
            this.mText.dynamicTextColor = dynamicTextColor;
            return this;
        }

        @PropSetter(value="dynamicTextColor", required=false)
        public Builder dynamicTextColor(Integer dynamicTextColor) {
            this.mText.dynamicTextColor = new DynamicValue((Object)dynamicTextColor);
            return this;
        }

        @PropSetter(value="ellipsize", required=false)
        public Builder ellipsize(@Nullable TextUtils.TruncateAt ellipsize) {
            this.mText.ellipsize = ellipsize;
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingPx(@Px float extraSpacing) {
            this.mText.extraSpacing = extraSpacing;
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingDip(@Dimension(unit=0) float dip) {
            this.mText.extraSpacing = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingSp(@Dimension(unit=2) float sip) {
            this.mText.extraSpacing = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingRes(@DimenRes int resId) {
            this.mText.extraSpacing = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.extraSpacing = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="extraSpacing", required=false)
        public Builder extraSpacingAttr(@AttrRes int attrResId) {
            this.mText.extraSpacing = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="glyphWarming", required=false)
        public Builder glyphWarming(boolean glyphWarming) {
            this.mText.glyphWarming = glyphWarming;
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColor(@ColorInt int highlightColor) {
            this.mText.highlightColor = highlightColor;
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorRes(@ColorRes int resId) {
            this.mText.highlightColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mText.highlightColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="highlightColor", required=false)
        public Builder highlightColorAttr(@AttrRes int attrResId) {
            this.mText.highlightColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="highlightEndOffset", required=false)
        public Builder highlightEndOffset(int highlightEndOffset) {
            this.mText.highlightEndOffset = highlightEndOffset;
            return this;
        }

        @PropSetter(value="highlightStartOffset", required=false)
        public Builder highlightStartOffset(int highlightStartOffset) {
            this.mText.highlightStartOffset = highlightStartOffset;
            return this;
        }

        @PropSetter(value="hyphenationFrequency", required=false)
        public Builder hyphenationFrequency(int hyphenationFrequency) {
            this.mText.hyphenationFrequency = hyphenationFrequency;
            return this;
        }

        @PropSetter(value="isSingleLine", required=false)
        public Builder isSingleLine(boolean isSingleLine) {
            this.mText.isSingleLine = isSingleLine;
            return this;
        }

        @PropSetter(value="isSingleLine", required=false)
        public Builder isSingleLineRes(@BoolRes int resId) {
            this.mText.isSingleLine = this.mResourceResolver.resolveBoolRes(resId);
            return this;
        }

        @PropSetter(value="isSingleLine", required=false)
        public Builder isSingleLineAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mText.isSingleLine = this.mResourceResolver.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="isSingleLine", required=false)
        public Builder isSingleLineAttr(@AttrRes int attrResId) {
            this.mText.isSingleLine = this.mResourceResolver.resolveBoolAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="justificationMode", required=false)
        public Builder justificationMode(int justificationMode) {
            this.mText.justificationMode = justificationMode;
            return this;
        }

        @PropSetter(value="letterSpacing", required=false)
        public Builder letterSpacing(float letterSpacing) {
            this.mText.letterSpacing = letterSpacing;
            return this;
        }

        @PropSetter(value="letterSpacing", required=false)
        public Builder letterSpacingRes(@DimenRes int resId) {
            this.mText.letterSpacing = this.mResourceResolver.resolveFloatRes(resId);
            return this;
        }

        @PropSetter(value="letterSpacing", required=false)
        public Builder letterSpacingAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.letterSpacing = this.mResourceResolver.resolveFloatAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="letterSpacing", required=false)
        public Builder letterSpacingAttr(@AttrRes int attrResId) {
            this.mText.letterSpacing = this.mResourceResolver.resolveFloatAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="lineHeight", required=false)
        public Builder lineHeightPx(@Px float lineHeight) {
            this.mText.lineHeight = lineHeight;
            return this;
        }

        @PropSetter(value="lineHeight", required=false)
        public Builder lineHeightDip(@Dimension(unit=0) float dip) {
            this.mText.lineHeight = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="lineHeight", required=false)
        public Builder lineHeightSp(@Dimension(unit=2) float sip) {
            this.mText.lineHeight = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="lineHeight", required=false)
        public Builder lineHeightRes(@DimenRes int resId) {
            this.mText.lineHeight = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="lineHeight", required=false)
        public Builder lineHeightAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.lineHeight = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="lineHeight", required=false)
        public Builder lineHeightAttr(@AttrRes int attrResId) {
            this.mText.lineHeight = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="linkColor", required=false)
        public Builder linkColor(@ColorInt int linkColor) {
            this.mText.linkColor = linkColor;
            return this;
        }

        @PropSetter(value="linkColor", required=false)
        public Builder linkColorRes(@ColorRes int resId) {
            this.mText.linkColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="linkColor", required=false)
        public Builder linkColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mText.linkColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="linkColor", required=false)
        public Builder linkColorAttr(@AttrRes int attrResId) {
            this.mText.linkColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="maxEms", required=false)
        public Builder maxEms(int maxEms) {
            this.mText.maxEms = maxEms;
            return this;
        }

        @PropSetter(value="maxEms", required=false)
        public Builder maxEmsRes(@IntegerRes int resId) {
            this.mText.maxEms = this.mResourceResolver.resolveIntRes(resId);
            return this;
        }

        @PropSetter(value="maxEms", required=false)
        public Builder maxEmsAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mText.maxEms = this.mResourceResolver.resolveIntAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="maxEms", required=false)
        public Builder maxEmsAttr(@AttrRes int attrResId) {
            this.mText.maxEms = this.mResourceResolver.resolveIntAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLines(int maxLines) {
            this.mText.maxLines = maxLines;
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLinesRes(@IntegerRes int resId) {
            this.mText.maxLines = this.mResourceResolver.resolveIntRes(resId);
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mText.maxLines = this.mResourceResolver.resolveIntAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="maxLines", required=false)
        public Builder maxLinesAttr(@AttrRes int attrResId) {
            this.mText.maxLines = this.mResourceResolver.resolveIntAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="maxTextWidth", required=false)
        public Builder maxTextWidthPx(@Px int maxTextWidth) {
            this.mText.maxTextWidth = maxTextWidth;
            return this;
        }

        @PropSetter(value="maxTextWidth", required=false)
        public Builder maxTextWidthDip(@Dimension(unit=0) float dip) {
            this.mText.maxTextWidth = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="maxTextWidth", required=false)
        public Builder maxTextWidthRes(@DimenRes int resId) {
            this.mText.maxTextWidth = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="maxTextWidth", required=false)
        public Builder maxTextWidthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.maxTextWidth = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="maxTextWidth", required=false)
        public Builder maxTextWidthAttr(@AttrRes int attrResId) {
            this.mText.maxTextWidth = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="minEms", required=false)
        public Builder minEms(int minEms) {
            this.mText.minEms = minEms;
            return this;
        }

        @PropSetter(value="minEms", required=false)
        public Builder minEmsRes(@IntegerRes int resId) {
            this.mText.minEms = this.mResourceResolver.resolveIntRes(resId);
            return this;
        }

        @PropSetter(value="minEms", required=false)
        public Builder minEmsAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mText.minEms = this.mResourceResolver.resolveIntAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="minEms", required=false)
        public Builder minEmsAttr(@AttrRes int attrResId) {
            this.mText.minEms = this.mResourceResolver.resolveIntAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLines(int minLines) {
            this.mText.minLines = minLines;
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLinesRes(@IntegerRes int resId) {
            this.mText.minLines = this.mResourceResolver.resolveIntRes(resId);
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLinesAttr(@AttrRes int attrResId, @IntegerRes int defResId) {
            this.mText.minLines = this.mResourceResolver.resolveIntAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="minLines", required=false)
        public Builder minLinesAttr(@AttrRes int attrResId) {
            this.mText.minLines = this.mResourceResolver.resolveIntAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="minTextWidth", required=false)
        public Builder minTextWidthPx(@Px int minTextWidth) {
            this.mText.minTextWidth = minTextWidth;
            return this;
        }

        @PropSetter(value="minTextWidth", required=false)
        public Builder minTextWidthDip(@Dimension(unit=0) float dip) {
            this.mText.minTextWidth = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="minTextWidth", required=false)
        public Builder minTextWidthRes(@DimenRes int resId) {
            this.mText.minTextWidth = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="minTextWidth", required=false)
        public Builder minTextWidthAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.minTextWidth = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="minTextWidth", required=false)
        public Builder minTextWidthAttr(@AttrRes int attrResId) {
            this.mText.minTextWidth = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="minimallyWide", required=false)
        public Builder minimallyWide(boolean minimallyWide) {
            this.mText.minimallyWide = minimallyWide;
            return this;
        }

        @PropSetter(value="minimallyWideThreshold", required=false)
        public Builder minimallyWideThresholdPx(@Px int minimallyWideThreshold) {
            this.mText.minimallyWideThreshold = minimallyWideThreshold;
            return this;
        }

        @PropSetter(value="minimallyWideThreshold", required=false)
        public Builder minimallyWideThresholdDip(@Dimension(unit=0) float dip) {
            this.mText.minimallyWideThreshold = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="minimallyWideThreshold", required=false)
        public Builder minimallyWideThresholdRes(@DimenRes int resId) {
            this.mText.minimallyWideThreshold = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="minimallyWideThreshold", required=false)
        public Builder minimallyWideThresholdAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.minimallyWideThreshold = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="minimallyWideThreshold", required=false)
        public Builder minimallyWideThresholdAttr(@AttrRes int attrResId) {
            this.mText.minimallyWideThreshold = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColor(@ColorInt int shadowColor) {
            this.mText.shadowColor = shadowColor;
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorRes(@ColorRes int resId) {
            this.mText.shadowColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mText.shadowColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowColor", required=false)
        public Builder shadowColorAttr(@AttrRes int attrResId) {
            this.mText.shadowColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxPx(@Px float shadowDx) {
            this.mText.shadowDx = shadowDx;
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxDip(@Dimension(unit=0) float dip) {
            this.mText.shadowDx = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxSp(@Dimension(unit=2) float sip) {
            this.mText.shadowDx = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxRes(@DimenRes int resId) {
            this.mText.shadowDx = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.shadowDx = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowDx", required=false)
        public Builder shadowDxAttr(@AttrRes int attrResId) {
            this.mText.shadowDx = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyPx(@Px float shadowDy) {
            this.mText.shadowDy = shadowDy;
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyDip(@Dimension(unit=0) float dip) {
            this.mText.shadowDy = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDySp(@Dimension(unit=2) float sip) {
            this.mText.shadowDy = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyRes(@DimenRes int resId) {
            this.mText.shadowDy = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.shadowDy = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowDy", required=false)
        public Builder shadowDyAttr(@AttrRes int attrResId) {
            this.mText.shadowDy = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusPx(@Px float shadowRadius) {
            this.mText.shadowRadius = shadowRadius;
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusDip(@Dimension(unit=0) float dip) {
            this.mText.shadowRadius = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusSp(@Dimension(unit=2) float sip) {
            this.mText.shadowRadius = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusRes(@DimenRes int resId) {
            this.mText.shadowRadius = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.shadowRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shadowRadius", required=false)
        public Builder shadowRadiusAttr(@AttrRes int attrResId) {
            this.mText.shadowRadius = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="shouldIncludeFontPadding", required=false)
        public Builder shouldIncludeFontPadding(boolean shouldIncludeFontPadding) {
            this.mText.shouldIncludeFontPadding = shouldIncludeFontPadding;
            return this;
        }

        @PropSetter(value="shouldIncludeFontPadding", required=false)
        public Builder shouldIncludeFontPaddingRes(@BoolRes int resId) {
            this.mText.shouldIncludeFontPadding = this.mResourceResolver.resolveBoolRes(resId);
            return this;
        }

        @PropSetter(value="shouldIncludeFontPadding", required=false)
        public Builder shouldIncludeFontPaddingAttr(@AttrRes int attrResId, @BoolRes int defResId) {
            this.mText.shouldIncludeFontPadding = this.mResourceResolver.resolveBoolAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="shouldIncludeFontPadding", required=false)
        public Builder shouldIncludeFontPaddingAttr(@AttrRes int attrResId) {
            this.mText.shouldIncludeFontPadding = this.mResourceResolver.resolveBoolAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="spacingMultiplier", required=false)
        public Builder spacingMultiplier(float spacingMultiplier) {
            this.mText.spacingMultiplier = spacingMultiplier;
            return this;
        }

        @PropSetter(value="spacingMultiplier", required=false)
        public Builder spacingMultiplierRes(@DimenRes int resId) {
            this.mText.spacingMultiplier = this.mResourceResolver.resolveFloatRes(resId);
            return this;
        }

        @PropSetter(value="spacingMultiplier", required=false)
        public Builder spacingMultiplierAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.spacingMultiplier = this.mResourceResolver.resolveFloatAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="spacingMultiplier", required=false)
        public Builder spacingMultiplierAttr(@AttrRes int attrResId) {
            this.mText.spacingMultiplier = this.mResourceResolver.resolveFloatAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="spanListener", required=false)
        public Builder spanListener(@Nullable ClickableSpanListener spanListener) {
            this.mText.spanListener = spanListener;
            return this;
        }

        @PropSetter(value="text", required=true)
        @RequiredProp(value="text")
        public Builder text(@Nullable CharSequence text) {
            this.mText.text = text;
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="text", required=true)
        @RequiredProp(value="text")
        public Builder textRes(@StringRes int resId) {
            this.mText.text = this.mResourceResolver.resolveStringRes(resId);
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="text", required=true)
        @RequiredProp(value="text")
        public Builder textRes(@StringRes int resId, Object ... formatArgs) {
            this.mText.text = this.mResourceResolver.resolveStringRes(resId, formatArgs);
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="text", required=true)
        @RequiredProp(value="text")
        public Builder textAttr(@AttrRes int attrResId, @StringRes int defResId) {
            this.mText.text = this.mResourceResolver.resolveStringAttr(attrResId, defResId);
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="text", required=true)
        @RequiredProp(value="text")
        public Builder textAttr(@AttrRes int attrResId) {
            this.mText.text = this.mResourceResolver.resolveStringAttr(attrResId, 0);
            this.mRequired.set(0);
            return this;
        }

        @PropSetter(value="textAlignment", required=false)
        public Builder textAlignment(@Deprecated @Nullable Layout.Alignment textAlignment) {
            this.mText.textAlignment = textAlignment;
            return this;
        }

        @PropSetter(value="textColor", required=false)
        public Builder textColor(@ColorInt int textColor) {
            this.mText.textColor = textColor;
            return this;
        }

        @PropSetter(value="textColor", required=false)
        public Builder textColorRes(@ColorRes int resId) {
            this.mText.textColor = this.mResourceResolver.resolveColorRes(resId);
            return this;
        }

        @PropSetter(value="textColor", required=false)
        public Builder textColorAttr(@AttrRes int attrResId, @ColorRes int defResId) {
            this.mText.textColor = this.mResourceResolver.resolveColorAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="textColor", required=false)
        public Builder textColorAttr(@AttrRes int attrResId) {
            this.mText.textColor = this.mResourceResolver.resolveColorAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="textColorStateList", required=false)
        public Builder textColorStateList(ColorStateList textColorStateList) {
            this.mText.textColorStateList = textColorStateList;
            return this;
        }

        @PropSetter(value="textDirection", required=false)
        public Builder textDirection(@Nullable TextDirectionHeuristicCompat textDirection) {
            this.mText.textDirection = textDirection;
            return this;
        }

        @PropSetter(value="textOffsetOnTouchHandler", required=false)
        public Builder textOffsetOnTouchHandler(@Nullable EventHandler textOffsetOnTouchHandler) {
            this.mText.textOffsetOnTouchHandler = textOffsetOnTouchHandler;
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizePx(@Px int textSize) {
            this.mText.textSize = textSize;
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeDip(@Dimension(unit=0) float dip) {
            this.mText.textSize = this.mResourceResolver.dipsToPixels(dip);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeSp(@Dimension(unit=2) float sip) {
            this.mText.textSize = this.mResourceResolver.sipsToPixels(sip);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeRes(@DimenRes int resId) {
            this.mText.textSize = this.mResourceResolver.resolveDimenSizeRes(resId);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeAttr(@AttrRes int attrResId, @DimenRes int defResId) {
            this.mText.textSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, defResId);
            return this;
        }

        @PropSetter(value="textSize", required=false)
        public Builder textSizeAttr(@AttrRes int attrResId) {
            this.mText.textSize = this.mResourceResolver.resolveDimenSizeAttr(attrResId, 0);
            return this;
        }

        @PropSetter(value="textStyle", required=false)
        public Builder textStyle(int textStyle) {
            this.mText.textStyle = textStyle;
            return this;
        }

        @PropSetter(value="touchableSpanListener", required=false)
        public Builder touchableSpanListener(@Nullable TouchableSpanListener touchableSpanListener) {
            this.mText.touchableSpanListener = touchableSpanListener;
            return this;
        }

        @PropSetter(value="typeface", required=false)
        public Builder typeface(@Nullable Typeface typeface) {
            this.mText.typeface = typeface;
            return this;
        }

        @PropSetter(value="verticalGravity", required=false)
        public Builder verticalGravity(VerticalGravity verticalGravity) {
            this.mText.verticalGravity = verticalGravity;
            return this;
        }

        public Builder textOffsetOnTouchEventHandler(@Nullable EventHandler<TextOffsetOnTouchEvent> textOffsetOnTouchEventHandler) {
            this.mText.textOffsetOnTouchEventHandler = textOffsetOnTouchEventHandler;
            return this;
        }

        public Builder getThis() {
            return this;
        }

        public Text build() {
            Builder.checkArgs((int)1, (BitSet)this.mRequired, (String[])this.REQUIRED_PROPS_NAMES);
            Text.access$102(this.mText, new DynamicValue[1]);
            ((Text)this.mText).mDynamicProps[0] = this.mText.dynamicTextColor;
            return this.mText;
        }
    }

    @Generated
    static class TextInterStagePropsContainer
    implements InterStagePropsContainer {
        ClickableSpan[] clickableSpans;
        ImageSpan[] imageSpans;
        Layout measureLayout;
        Integer measuredHeight;
        Integer measuredWidth;
        CharSequence processedText;
        Layout textLayout;
        Float textLayoutTranslationY;

        TextInterStagePropsContainer() {
        }
    }
}

