/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.text.style.ImageSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.facebook.fbui.textlayoutbuilder.util.LayoutMeasureUtil;
import com.facebook.litho.TextContent;
import com.facebook.litho.Touchable;
import com.facebook.litho.widget.ClickableSpanListener;
import com.facebook.litho.widget.LongClickableSpan;
import com.facebook.litho.widget.TextSpec;
import com.facebook.litho.widget.TouchableSpanListener;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class TextDrawable
extends Drawable
implements Touchable,
TextContent,
Drawable.Callback {
    @Nullable
    private Layout mLayout;
    private float mLayoutTranslationY;
    private boolean mClipToBounds;
    private boolean mShouldHandleTouch;
    private CharSequence mText;
    private ColorStateList mColorStateList;
    private int mUserColor;
    private int mHighlightColor;
    private ClickableSpan[] mClickableSpans;
    private ImageSpan[] mImageSpans;
    private int mSelectionStart;
    private int mSelectionEnd;
    private Path mSelectionPath;
    private Path mTouchAreaPath;
    private boolean mSelectionPathNeedsUpdate;
    private Paint mHighlightPaint;
    private TextOffsetOnTouchListener mTextOffsetOnTouchListener;
    private float mClickableSpanExpandedOffset;
    private boolean mLongClickActivated;
    @Nullable
    private Handler mLongClickHandler;
    @Nullable
    private LongClickRunnable mLongClickRunnable;
    @Nullable
    private ClickableSpanListener mSpanListener;
    @Nullable
    private TouchableSpanListener mTouchableSpanListener;
    @Nullable
    private String mContextLogTag;
    @Nullable
    private TextContent.Item mTextContentItem;

    public void draw(Canvas canvas) {
        if (this.mLayout == null) {
            return;
        }
        int saveCount = canvas.save();
        Rect bounds = this.getBounds();
        if (this.mClipToBounds) {
            canvas.clipRect(bounds);
        }
        canvas.translate((float)bounds.left, (float)bounds.top + this.mLayoutTranslationY);
        try {
            this.mLayout.draw(canvas, this.getSelectionPath(), this.mHighlightPaint, 0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage() + this.getDebugInfo());
        }
        canvas.restoreToCount(saveCount);
    }

    private String getDebugInfo() {
        StringBuilder debugInfo = new StringBuilder();
        debugInfo.append(" [");
        debugInfo.append(this.mContextLogTag);
        debugInfo.append("] ");
        if (this.mText instanceof SpannableStringBuilder) {
            Object[] spans = ((SpannableStringBuilder)this.mText).getSpans(0, this.mText.length(), Object.class);
            debugInfo.append("spans: ");
            for (Object span : spans) {
                debugInfo.append(span.getClass().getSimpleName());
                debugInfo.append(", ");
            }
        }
        debugInfo.append("ellipsizedWidth: ");
        debugInfo.append(this.mLayout.getEllipsizedWidth());
        debugInfo.append(", lineCount: ");
        debugInfo.append(this.mLayout.getLineCount());
        return debugInfo.toString();
    }

    public boolean isStateful() {
        return this.mColorStateList != null;
    }

    protected boolean onStateChange(int[] states) {
        if (this.mColorStateList != null && this.mLayout != null) {
            int previousColor = this.mLayout.getPaint().getColor();
            int currentColor = this.mColorStateList.getColorForState(states, this.mUserColor);
            if (currentColor != previousColor) {
                this.mLayout.getPaint().setColor(currentColor);
                this.invalidateSelf();
            }
        }
        return super.onStateChange(states);
    }

    public boolean onTouchEvent(MotionEvent event, View view) {
        if ((this.shouldHandleTouchForClickableSpan(event) || this.shouldHandleTouchForLongClickableSpan(event)) && this.handleTouchForSpans(event, view)) {
            return true;
        }
        if (this.shouldHandleTextOffsetOnTouch(event)) {
            this.handleTextOffsetChange(event);
        }
        return false;
    }

    private boolean handleTouchForSpans(MotionEvent event, View view) {
        int y;
        Rect bounds;
        boolean clickActivationAllowed;
        int action = event.getActionMasked();
        if (action == 3) {
            this.clearSelection();
            this.resetLongClick();
            if (this.mTouchableSpanListener != null) {
                this.mTouchableSpanListener.onTouch(null, event, view);
            }
            return false;
        }
        if (action == 2 && !this.mLongClickActivated && this.mLongClickRunnable != null) {
            this.trackLongClickBoundaryOnMove(event);
        }
        boolean bl = clickActivationAllowed = !this.mLongClickActivated;
        if (action == 1) {
            this.resetLongClick();
        }
        if (!TextDrawable.isWithinBounds(bounds = this.getBounds(), event)) {
            return false;
        }
        int x = (int)event.getX() - bounds.left;
        ClickableSpan clickedSpan = this.getClickableSpanInCoords(x, y = (int)event.getY() - bounds.top);
        if (clickedSpan == null && this.mClickableSpanExpandedOffset > 0.0f) {
            clickedSpan = this.getClickableSpanInProximityToClick(x, y, this.mClickableSpanExpandedOffset);
        }
        if (clickedSpan == null) {
            this.clearSelection();
            return false;
        }
        if (action == 1) {
            this.clearSelection();
            if (clickActivationAllowed && (this.mSpanListener == null || !this.mSpanListener.onClick(clickedSpan, view))) {
                clickedSpan.onClick(view);
            }
        } else if (action == 0) {
            if (clickedSpan instanceof LongClickableSpan) {
                this.registerForLongClick((LongClickableSpan)clickedSpan, view);
            }
            this.setSelection(clickedSpan);
        }
        if (this.mTouchableSpanListener != null) {
            this.mTouchableSpanListener.onTouch(clickedSpan, event, view);
        }
        return true;
    }

    private void resetLongClick() {
        if (this.mLongClickHandler != null) {
            this.mLongClickHandler.removeCallbacks((Runnable)this.mLongClickRunnable);
            this.mLongClickRunnable = null;
        }
        this.mLongClickActivated = false;
    }

    private void registerForLongClick(LongClickableSpan longClickableSpan, View view) {
        this.mLongClickRunnable = new LongClickRunnable(longClickableSpan, view);
        this.mLongClickHandler.postDelayed((Runnable)this.mLongClickRunnable, (long)ViewConfiguration.getLongPressTimeout());
    }

    private void handleTextOffsetChange(MotionEvent event) {
        int y;
        Rect bounds = this.getBounds();
        int x = (int)event.getX() - bounds.left;
        int offset = this.getTextOffsetAt(x, y = (int)event.getY() - bounds.top);
        if (offset >= 0 && offset <= this.mText.length()) {
            this.mTextOffsetOnTouchListener.textOffsetOnTouch(offset);
        }
    }

    public boolean shouldHandleTouchEvent(MotionEvent event) {
        return this.shouldHandleTouchForClickableSpan(event) || this.shouldHandleTouchForLongClickableSpan(event) || this.shouldHandleTextOffsetOnTouch(event);
    }

    private boolean shouldHandleTouchForClickableSpan(MotionEvent event) {
        int action = event.getActionMasked();
        boolean isUpOrDown = action == 1 || action == 0;
        return this.mShouldHandleTouch && TextDrawable.isWithinBounds(this.getBounds(), event) && isUpOrDown || action == 3;
    }

    private boolean shouldHandleTouchForLongClickableSpan(MotionEvent event) {
        return this.mShouldHandleTouch && this.mLongClickHandler != null && event.getAction() != 0;
    }

    private static boolean isWithinBounds(Rect bounds, MotionEvent event) {
        return bounds.contains((int)event.getX(), (int)event.getY());
    }

    private void trackLongClickBoundaryOnMove(MotionEvent event) {
        Rect bounds = this.getBounds();
        if (!TextDrawable.isWithinBounds(bounds, event)) {
            this.resetLongClick();
            return;
        }
        ClickableSpan clickableSpan = this.getClickableSpanInCoords((int)event.getX() - bounds.left, (int)event.getY() - bounds.top);
        if (this.mLongClickRunnable.longClickableSpan != clickableSpan) {
            this.resetLongClick();
        }
    }

    private boolean shouldHandleTextOffsetOnTouch(MotionEvent event) {
        return this.mTextOffsetOnTouchListener != null && event.getActionMasked() == 0 && this.getBounds().contains((int)event.getX(), (int)event.getY());
    }

    public void mount(CharSequence text, Layout layout2, int userColor, ClickableSpan[] clickableSpans) {
        this.mount(text, layout2, 0.0f, false, null, userColor, 0, clickableSpans, null, null, null, null, -1, -1, 0.0f, null);
    }

    public void mount(CharSequence text, Layout layout2, int userColor, int highlightColor) {
        this.mount(text, layout2, 0.0f, false, null, userColor, highlightColor, null, null, null, null, null, -1, -1, 0.0f, null);
    }

    public void mount(CharSequence text, Layout layout2, float layoutTranslationY, ColorStateList colorStateList, int userColor, int highlightColor, ClickableSpan[] clickableSpans) {
        this.mount(text, layout2, 0.0f, false, null, userColor, highlightColor, clickableSpans, null, null, null, null, -1, -1, 0.0f, null);
    }

    public void mount(CharSequence text, Layout layout2, float layoutTranslationY, boolean clipToBounds, ColorStateList colorStateList, int userColor, int highlightColor, @Nullable ClickableSpan[] clickableSpans, @Nullable ImageSpan[] imageSpans, @Nullable ClickableSpanListener spanListener, @Nullable TouchableSpanListener touchableSpanListener, @Nullable TextOffsetOnTouchListener textOffsetOnTouchListener, int highlightStartOffset, int highlightEndOffset, float clickableSpanExpandedOffset, String contextLogTag) {
        this.mLayout = layout2;
        this.mLayoutTranslationY = layoutTranslationY;
        this.mClipToBounds = clipToBounds;
        this.mText = text;
        this.mClickableSpans = clickableSpans;
        this.mTouchableSpanListener = touchableSpanListener;
        if (this.mLongClickHandler == null && TextDrawable.containsLongClickableSpan(clickableSpans)) {
            this.mLongClickHandler = new Handler();
        }
        this.mSpanListener = spanListener;
        this.mTextOffsetOnTouchListener = textOffsetOnTouchListener;
        this.mShouldHandleTouch = clickableSpans != null && clickableSpans.length > 0;
        this.mHighlightColor = highlightColor;
        this.mClickableSpanExpandedOffset = clickableSpanExpandedOffset;
        if (userColor != 0) {
            this.mColorStateList = null;
            this.mUserColor = userColor;
        } else {
            this.mColorStateList = colorStateList != null ? colorStateList : TextSpec.textColorStateList;
            this.mUserColor = this.mColorStateList.getDefaultColor();
            if (this.mLayout != null) {
                this.mLayout.getPaint().setColor(this.mColorStateList.getColorForState(this.getState(), this.mUserColor));
            }
        }
        if (this.highlightOffsetsValid(text, highlightStartOffset, highlightEndOffset)) {
            this.setSelection(highlightStartOffset, highlightEndOffset);
        } else {
            this.clearSelection();
        }
        if (imageSpans != null) {
            int size = imageSpans.length;
            for (int i = 0; i < size; ++i) {
                Drawable drawable = imageSpans[i].getDrawable();
                drawable.setCallback((Drawable.Callback)this);
                drawable.setVisible(true, false);
            }
        }
        this.mImageSpans = imageSpans;
        this.mContextLogTag = contextLogTag;
        this.invalidateSelf();
    }

    public void setTextColor(@ColorInt int textColor) {
        this.mUserColor = textColor;
        if (this.mLayout != null) {
            this.mLayout.getPaint().setColor(textColor);
        }
        this.invalidateSelf();
    }

    private static boolean containsLongClickableSpan(@Nullable ClickableSpan[] clickableSpans) {
        if (clickableSpans == null) {
            return false;
        }
        for (ClickableSpan span : clickableSpans) {
            if (!(span instanceof LongClickableSpan)) continue;
            return true;
        }
        return false;
    }

    private boolean highlightOffsetsValid(CharSequence text, int highlightStart, int highlightEnd) {
        return highlightStart >= 0 && highlightEnd <= text.length() && highlightStart < highlightEnd;
    }

    public void unmount() {
        this.mTextContentItem = null;
        this.mLayout = null;
        this.mLayoutTranslationY = 0.0f;
        this.mText = null;
        this.mClickableSpans = null;
        this.mShouldHandleTouch = false;
        this.mHighlightColor = 0;
        this.mSpanListener = null;
        this.mTextOffsetOnTouchListener = null;
        this.mColorStateList = null;
        this.mUserColor = 0;
        if (this.mImageSpans != null) {
            int size = this.mImageSpans.length;
            for (int i = 0; i < size; ++i) {
                Drawable drawable = this.mImageSpans[i].getDrawable();
                drawable.setCallback(null);
                drawable.setVisible(false, false);
            }
            this.mImageSpans = null;
        }
    }

    public ClickableSpan[] getClickableSpans() {
        return this.mClickableSpans;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return 0;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public int getColor() {
        return this.mLayout.getPaint().getColor();
    }

    public float getTextSize() {
        return this.mLayout.getPaint().getTextSize();
    }

    public Layout getLayout() {
        return this.mLayout;
    }

    @Nullable
    private ClickableSpan getClickableSpanInCoords(int x, int y) {
        int offset = this.getTextOffsetAt(x, y);
        if (offset < 0) {
            return null;
        }
        ClickableSpan[] clickableSpans = (ClickableSpan[])((Spanned)this.mText).getSpans(offset, offset, ClickableSpan.class);
        if (clickableSpans != null && clickableSpans.length > 0) {
            return clickableSpans[0];
        }
        return null;
    }

    private int getTextOffsetAt(int x, int y) {
        float right;
        float left;
        int line = this.mLayout.getLineForVertical(y);
        if (this.mLayout.getAlignment() == Layout.Alignment.ALIGN_CENTER) {
            left = this.mLayout.getLineLeft(line);
            right = this.mLayout.getLineRight(line);
        } else {
            boolean rtl = this.mLayout.getParagraphDirection(line) == -1;
            left = rtl ? (float)this.mLayout.getWidth() - this.mLayout.getLineMax(line) : (float)this.mLayout.getParagraphLeft(line);
            float f = right = rtl ? (float)this.mLayout.getParagraphRight(line) : this.mLayout.getLineMax(line);
        }
        if ((float)x < left || (float)x > right) {
            return -1;
        }
        try {
            return this.mLayout.getOffsetForHorizontal(line, (float)x);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    @Nullable
    @VisibleForTesting
    Layout.Alignment getLayoutAlignment() {
        return this.mLayout == null ? null : this.mLayout.getAlignment();
    }

    @Nullable
    private ClickableSpan getClickableSpanInProximityToClick(float x, float y, float tapRadius) {
        Region touchAreaRegion = new Region();
        Region clipBoundsRegion = new Region();
        if (this.mTouchAreaPath == null) {
            this.mTouchAreaPath = new Path();
        }
        clipBoundsRegion.set(0, 0, LayoutMeasureUtil.getWidth((Layout)this.mLayout), LayoutMeasureUtil.getHeight((Layout)this.mLayout));
        this.mTouchAreaPath.reset();
        this.mTouchAreaPath.addCircle(x, y, tapRadius, Path.Direction.CW);
        touchAreaRegion.setPath(this.mTouchAreaPath, clipBoundsRegion);
        ClickableSpan result = null;
        for (ClickableSpan span : this.mClickableSpans) {
            if (!this.isClickCloseToSpan(span, (Spanned)this.mText, this.mLayout, touchAreaRegion, clipBoundsRegion)) continue;
            if (result != null) {
                return null;
            }
            result = span;
        }
        return result;
    }

    @Nullable
    private Path getSelectionPath() {
        if (this.mSelectionStart == this.mSelectionEnd) {
            return null;
        }
        if (Color.alpha((int)this.mHighlightColor) == 0) {
            return null;
        }
        if (this.mSelectionPathNeedsUpdate) {
            if (this.mSelectionPath == null) {
                this.mSelectionPath = new Path();
            }
            this.mLayout.getSelectionPath(this.mSelectionStart, this.mSelectionEnd, this.mSelectionPath);
            this.mSelectionPathNeedsUpdate = false;
        }
        return this.mSelectionPath;
    }

    private void setSelection(ClickableSpan span) {
        Spanned text = (Spanned)this.mText;
        this.setSelection(text.getSpanStart((Object)span), text.getSpanEnd((Object)span));
    }

    private void setSelection(int selectionStart, int selectionEnd) {
        if (Color.alpha((int)this.mHighlightColor) == 0 || this.mSelectionStart == selectionStart && this.mSelectionEnd == selectionEnd) {
            return;
        }
        this.mSelectionStart = selectionStart;
        this.mSelectionEnd = selectionEnd;
        if (this.mHighlightPaint == null) {
            this.mHighlightPaint = new Paint();
            this.mHighlightPaint.setColor(this.mHighlightColor);
        } else {
            this.mHighlightPaint.setColor(this.mHighlightColor);
        }
        this.mSelectionPathNeedsUpdate = true;
        this.invalidateSelf();
    }

    private void clearSelection() {
        this.setSelection(0, 0);
    }

    private boolean isClickCloseToSpan(ClickableSpan span, Spanned buffer, Layout layout2, Region touchAreaRegion, Region clipBoundsRegion) {
        Region clickableSpanAreaRegion = new Region();
        Path clickableSpanAreaPath = new Path();
        layout2.getSelectionPath(buffer.getSpanStart((Object)span), buffer.getSpanEnd((Object)span), clickableSpanAreaPath);
        clickableSpanAreaRegion.setPath(clickableSpanAreaPath, clipBoundsRegion);
        return clickableSpanAreaRegion.op(touchAreaRegion, Region.Op.INTERSECT);
    }

    public void invalidateDrawable(Drawable drawable) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable drawable, Runnable runnable, long l) {
        this.scheduleSelf(runnable, l);
    }

    public void unscheduleDrawable(Drawable drawable, Runnable runnable) {
        this.unscheduleSelf(runnable);
    }

    @NonNull
    public List<TextContent.Item> getItems() {
        TextContent.Item item = this.getOrCreateTextItem();
        if (item == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(item);
    }

    @NonNull
    public List<CharSequence> getTextList() {
        TextContent.Item item = this.getOrCreateTextItem();
        if (item == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(item.getText());
    }

    @Nullable
    private TextContent.Item getOrCreateTextItem() {
        Layout layout2 = this.mLayout;
        if (layout2 == null) {
            return null;
        }
        if (this.mTextContentItem == null) {
            final CharSequence text = this.getText();
            final float textSize = this.getTextSize();
            final Typeface typeface = layout2.getPaint().getTypeface();
            final int color = this.getColor();
            final float fontLineHeight = (float)layout2.getPaint().getFontMetricsInt(null) * layout2.getSpacingMultiplier() + layout2.getSpacingAdd();
            final int linesCount = layout2.getLineCount();
            this.mTextContentItem = new TextContent.Item(){

                @NonNull
                public CharSequence getText() {
                    return text;
                }

                public float getTextSize() {
                    return textSize;
                }

                @NonNull
                public Typeface getTypeface() {
                    return typeface;
                }

                public int getColor() {
                    return color;
                }

                public float getFontLineHeight() {
                    return fontLineHeight;
                }

                public int getLinesCount() {
                    return linesCount;
                }
            };
        }
        return this.mTextContentItem;
    }

    private class LongClickRunnable
    implements Runnable {
        private LongClickableSpan longClickableSpan;
        private View longClickableSpanView;

        LongClickRunnable(LongClickableSpan span, View view) {
            this.longClickableSpan = span;
            this.longClickableSpanView = view;
        }

        @Override
        public void run() {
            TextDrawable.this.mLongClickActivated = TextDrawable.this.mSpanListener != null && TextDrawable.this.mSpanListener.onLongClick(this.longClickableSpan, this.longClickableSpanView) || this.longClickableSpan.onLongClick(this.longClickableSpanView);
        }
    }

    static interface TextOffsetOnTouchListener {
        public void textOffsetOnTouch(int var1);
    }
}

