/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.KeyListener;
import android.text.method.MovementMethod;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.util.ObjectsCompat;
import androidx.core.view.ViewCompat;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.Diff;
import com.facebook.litho.EventHandler;
import com.facebook.litho.Output;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateValue;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.annotations.FromTrigger;
import com.facebook.litho.annotations.MountSpec;
import com.facebook.litho.annotations.OnBind;
import com.facebook.litho.annotations.OnCreateInitialState;
import com.facebook.litho.annotations.OnCreateMountContent;
import com.facebook.litho.annotations.OnMeasure;
import com.facebook.litho.annotations.OnMount;
import com.facebook.litho.annotations.OnTrigger;
import com.facebook.litho.annotations.OnUnbind;
import com.facebook.litho.annotations.OnUnmount;
import com.facebook.litho.annotations.OnUpdateState;
import com.facebook.litho.annotations.Prop;
import com.facebook.litho.annotations.PropDefault;
import com.facebook.litho.annotations.ResType;
import com.facebook.litho.annotations.ShouldUpdate;
import com.facebook.litho.annotations.State;
import com.facebook.litho.utils.MeasureUtils;
import com.facebook.litho.widget.ClearFocusEvent;
import com.facebook.litho.widget.DispatchKeyEvent;
import com.facebook.litho.widget.EditorActionEvent;
import com.facebook.litho.widget.GetLineCountEvent;
import com.facebook.litho.widget.GetTextEvent;
import com.facebook.litho.widget.InputConnectionEvent;
import com.facebook.litho.widget.InputFocusChangedEvent;
import com.facebook.litho.widget.KeyPreImeEvent;
import com.facebook.litho.widget.KeyUpEvent;
import com.facebook.litho.widget.ReplaceTextEvent;
import com.facebook.litho.widget.RequestFocusEvent;
import com.facebook.litho.widget.SelectionChangedEvent;
import com.facebook.litho.widget.SetSelectionEvent;
import com.facebook.litho.widget.SetTextEvent;
import com.facebook.litho.widget.TextChangedEvent;
import com.facebook.litho.widget.TextInput;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

@MountSpec(isPureRender=true, events={TextChangedEvent.class, SelectionChangedEvent.class, InputFocusChangedEvent.class, KeyUpEvent.class, KeyPreImeEvent.class, EditorActionEvent.class, SetTextEvent.class, InputConnectionEvent.class})
class TextInputSpec {
    static final Drawable UNSET_DRAWABLE = new ColorDrawable(0);
    @PropDefault
    protected static final ColorStateList textColorStateList = ColorStateList.valueOf((int)-16777216);
    @PropDefault
    protected static final ColorStateList hintColorStateList = ColorStateList.valueOf((int)-3355444);
    @PropDefault
    static final CharSequence hint = "";
    @PropDefault
    static final CharSequence initialText = "";
    @PropDefault
    protected static final int shadowColor = -7829368;
    @PropDefault
    protected static final int textSize = -1;
    @PropDefault
    protected static final Drawable inputBackground = UNSET_DRAWABLE;
    @PropDefault
    protected static final Typeface typeface = Typeface.DEFAULT;
    @PropDefault
    protected static final int textAlignment = 1;
    @PropDefault
    protected static final int gravity = 8388627;
    @PropDefault
    protected static final boolean editable = true;
    @PropDefault
    protected static final int inputType = 1;
    @PropDefault
    protected static final int rawInputType = 0;
    @PropDefault
    protected static final int imeOptions = 0;
    @PropDefault
    protected static final int cursorDrawableRes = -1;
    @PropDefault
    static final boolean multiline = false;
    @PropDefault
    protected static final int minLines = 1;
    @PropDefault
    protected static final int maxLines = Integer.MAX_VALUE;
    @PropDefault
    protected static final int importantForAutofill = 0;
    @PropDefault
    protected static final MovementMethod movementMethod = ArrowKeyMovementMethod.getInstance();
    private static final Rect sBackgroundPaddingRect = new Rect();
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];

    TextInputSpec() {
    }

    @OnCreateInitialState
    static void onCreateInitialState(StateValue<AtomicReference<EditTextWithEventHandlers>> mountedView, StateValue<AtomicReference<CharSequence>> savedText, StateValue<Integer> measureSeqNumber, @Prop(optional=true, resType=ResType.STRING) CharSequence initialText) {
        mountedView.set(new AtomicReference());
        measureSeqNumber.set((Object)0);
        savedText.set(new AtomicReference<CharSequence>(initialText));
    }

    static void onLoadStyle(ComponentContext c, Output<Integer> highlightColor) {
        TypedArray a = c.obtainStyledAttributes(new int[]{0x1010099}, 0);
        try {
            highlightColor.set((Object)a.getColor(0, 0));
        }
        finally {
            a.recycle();
        }
    }

    @OnMeasure
    static void onMeasure(ComponentContext c, ComponentLayout layout2, int widthSpec, int heightSpec, Size size, @Prop(optional=true, resType=ResType.STRING) CharSequence hint, @Prop(optional=true, resType=ResType.DRAWABLE) Drawable inputBackground, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true) ColorStateList hintColorStateList, @Prop(optional=true, resType=ResType.COLOR) Integer highlightColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true) Typeface typeface, @Prop(optional=true) int textAlignment, @Prop(optional=true) int gravity, @Prop(optional=true) boolean editable, @Prop(optional=true) int inputType, @Prop(optional=true) int rawInputType, @Prop(optional=true) int imeOptions, @Prop(optional=true, varArg="inputFilter") List<InputFilter> inputFilters, @Prop(optional=true) boolean multiline, @Prop(optional=true) TextUtils.TruncateAt ellipsize, @Prop(optional=true) int minLines, @Prop(optional=true) int maxLines, @Prop(optional=true) int cursorDrawableRes, @Prop(optional=true, resType=ResType.STRING) CharSequence error, @Prop(optional=true, resType=ResType.DRAWABLE) Drawable errorDrawable, @Prop(optional=true) @Nullable KeyListener keyListener, @Prop(optional=true) int importantForAutofill, @Prop(optional=true) @Nullable String[] autofillHints, @State AtomicReference<CharSequence> savedText) {
        EditText forMeasure = TextInputSpec.createAndMeasureEditText(c, layout2, widthSpec, heightSpec, size, hint, inputBackground, shadowRadius, shadowDx, shadowDy, shadowColor, textColorStateList, hintColorStateList, highlightColor, textSize, typeface, textAlignment, gravity, editable, inputType, rawInputType, keyListener, imeOptions, inputFilters, multiline, ellipsize, minLines, maxLines, cursorDrawableRes, error, errorDrawable, importantForAutofill, autofillHints, savedText.get());
        TextInputSpec.setSizeForView(size, widthSpec, heightSpec, (View)forMeasure);
    }

    static void setSizeForView(Size size, int widthSpec, int heightSpec, View forMeasure) {
        size.height = forMeasure.getMeasuredHeight();
        size.width = SizeSpec.getMode((int)widthSpec) == 0 ? 0 : Math.min(SizeSpec.getSize((int)widthSpec), forMeasure.getMeasuredWidth());
    }

    static EditText createAndMeasureEditText(ComponentContext c, ComponentLayout layout2, int widthSpec, int heightSpec, Size size, CharSequence hint, Drawable inputBackground, float shadowRadius, float shadowDx, float shadowDy, int shadowColor, ColorStateList textColorStateList, ColorStateList hintColorStateList, Integer highlightColor, int textSize, Typeface typeface, int textAlignment, int gravity, boolean editable, int inputType, int rawInputType, @Nullable KeyListener keyListener, int imeOptions, List<InputFilter> inputFilters, boolean multiline, TextUtils.TruncateAt ellipsize, int minLines, int maxLines, int cursorDrawableRes, CharSequence error, Drawable errorDrawable, int importantForAutofill, @Nullable String[] autofillHints, CharSequence text) {
        ForMeasureEditText forMeasure = new ForMeasureEditText(c.getAndroidContext());
        if (text instanceof Spannable) {
            text = text.toString();
        }
        TextInputSpec.setParams(forMeasure, hint, TextInputSpec.getBackgroundOrDefault(c, inputBackground == UNSET_DRAWABLE ? forMeasure.getBackground() : inputBackground), shadowRadius, shadowDx, shadowDy, shadowColor, textColorStateList, hintColorStateList, highlightColor, textSize, typeface, textAlignment, gravity, editable, inputType, rawInputType, keyListener, imeOptions, inputFilters, multiline, ellipsize, minLines, maxLines, cursorDrawableRes, forMeasure.getMovementMethod(), text, error, errorDrawable, true, importantForAutofill, autofillHints);
        forMeasure.measure(MeasureUtils.getViewMeasureSpec((int)widthSpec), MeasureUtils.getViewMeasureSpec((int)heightSpec));
        return forMeasure;
    }

    static void setParams(EditText editText, @Nullable CharSequence hint, @Nullable Drawable background, float shadowRadius, float shadowDx, float shadowDy, int shadowColor, ColorStateList textColorStateList, ColorStateList hintColorStateList, Integer highlightColor, int textSize, Typeface typeface, int textAlignment, int gravity, boolean editable, int inputType, int rawInputType, @Nullable KeyListener keyListener, int imeOptions, @Nullable List<InputFilter> inputFilters, boolean multiline, @Nullable TextUtils.TruncateAt ellipsize, int minLines, int maxLines, int cursorDrawableRes, MovementMethod movementMethod, @Nullable CharSequence text, @Nullable CharSequence error, @Nullable Drawable errorDrawable, boolean isForMeasure, int importantForAutofill, @Nullable String[] autofillHints) {
        if (textSize == -1) {
            editText.setTextSize(2, 14.0f);
        } else {
            editText.setTextSize(0, (float)textSize);
        }
        if (multiline) {
            inputType |= 0x20001;
            editText.setMinLines(minLines);
            editText.setMaxLines(maxLines);
        } else {
            inputType &= 0xFFFDFFFF;
            editText.setLines(1);
        }
        if (!editable) {
            inputType = 0;
        }
        if (rawInputType != 0) {
            editText.setRawInputType(rawInputType);
        } else {
            TextInputSpec.setInputTypeAndKeyListenerIfChanged(editText, inputType, keyListener);
        }
        if (inputFilters != null) {
            editText.setFilters(inputFilters.toArray(new InputFilter[inputFilters.size()]));
        } else {
            editText.setFilters(NO_FILTERS);
        }
        editText.setHint(hint);
        if (Build.VERSION.SDK_INT < 16) {
            editText.setBackgroundDrawable(background);
        } else {
            editText.setBackground(background);
        }
        if (background == null || !background.getPadding(sBackgroundPaddingRect)) {
            editText.setPadding(0, 0, 0, 0);
        }
        editText.setShadowLayer(shadowRadius, shadowDx, shadowDy, shadowColor);
        editText.setTypeface(typeface, 0);
        editText.setGravity(gravity);
        editText.setImeOptions(imeOptions);
        editText.setFocusable(editable);
        editText.setFocusableInTouchMode(editable);
        editText.setLongClickable(editable);
        editText.setCursorVisible(editable);
        editText.setTextColor(textColorStateList);
        editText.setHintTextColor(hintColorStateList);
        if (highlightColor != null) {
            editText.setHighlightColor(highlightColor.intValue());
        }
        editText.setMovementMethod(movementMethod);
        editText.setError(error, errorDrawable);
        if (cursorDrawableRes != -1) {
            if (Build.VERSION.SDK_INT >= 29) {
                editText.setTextCursorDrawable(cursorDrawableRes);
            } else {
                try {
                    Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
                    f.setAccessible(true);
                    f.set(editText, cursorDrawableRes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        editText.setEllipsize(ellipsize);
        if (Build.VERSION.SDK_INT >= 17) {
            editText.setTextAlignment(textAlignment);
        }
        if (text != null && !ObjectsCompat.equals((Object)editText.getText().toString(), (Object)text.toString())) {
            editText.setText(text);
            if (!isForMeasure) {
                editText.setSelection(editText.getText().toString().length());
            }
        }
        Api26Utils.setAutoFillProps(editText, importantForAutofill, autofillHints);
    }

    private static void setInputTypeAndKeyListenerIfChanged(EditText editText, int inputType, @Nullable KeyListener keyListener) {
        if (inputType != editText.getInputType()) {
            editText.setInputType(inputType);
        }
        if (keyListener != null && keyListener != editText.getKeyListener()) {
            editText.setKeyListener(keyListener);
        }
    }

    @ShouldUpdate
    static boolean shouldUpdate(@Prop(optional=true, resType=ResType.STRING) Diff<CharSequence> initialText, @Prop(optional=true, resType=ResType.STRING) Diff<CharSequence> hint, @Prop(optional=true, resType=ResType.DRAWABLE) Diff<Drawable> inputBackground, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) Diff<Float> shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) Diff<Float> shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) Diff<Float> shadowDy, @Prop(optional=true, resType=ResType.COLOR) Diff<Integer> shadowColor, @Prop(optional=true) Diff<ColorStateList> textColorStateList, @Prop(optional=true) Diff<ColorStateList> hintColorStateList, @Prop(optional=true, resType=ResType.COLOR) Diff<Integer> highlightColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) Diff<Integer> textSize, @Prop(optional=true) Diff<Typeface> typeface, @Prop(optional=true) Diff<Integer> textAlignment, @Prop(optional=true) Diff<Integer> gravity, @Prop(optional=true) Diff<Boolean> editable, @Prop(optional=true) Diff<Integer> inputType, @Prop(optional=true) Diff<Integer> rawInputType, @Prop(optional=true) Diff<Integer> imeOptions, @Prop(optional=true, varArg="inputFilter") Diff<List<InputFilter>> inputFilters, @Prop(optional=true) Diff<TextUtils.TruncateAt> ellipsize, @Prop(optional=true) Diff<Boolean> multiline, @Prop(optional=true) Diff<Integer> minLines, @Prop(optional=true) Diff<Integer> maxLines, @Prop(optional=true) Diff<Integer> cursorDrawableRes, @Prop(optional=true) Diff<MovementMethod> movementMethod, @Prop(optional=true, resType=ResType.STRING) Diff<CharSequence> error, @Prop(optional=true) Diff<KeyListener> keyListener, @State Diff<Integer> measureSeqNumber, @State Diff<AtomicReference<EditTextWithEventHandlers>> mountedView, @State Diff<AtomicReference<CharSequence>> savedText) {
        if (!ObjectsCompat.equals((Object)measureSeqNumber.getPrevious(), (Object)measureSeqNumber.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)initialText.getPrevious(), (Object)initialText.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)hint.getPrevious(), (Object)hint.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)shadowRadius.getPrevious(), (Object)shadowRadius.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)shadowDx.getPrevious(), (Object)shadowDx.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)shadowDy.getPrevious(), (Object)shadowDy.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)shadowColor.getPrevious(), (Object)shadowColor.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)textColorStateList.getPrevious(), (Object)textColorStateList.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)hintColorStateList.getPrevious(), (Object)hintColorStateList.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)highlightColor.getPrevious(), (Object)highlightColor.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)textSize.getPrevious(), (Object)textSize.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)typeface.getPrevious(), (Object)typeface.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)textAlignment.getPrevious(), (Object)textAlignment.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)gravity.getPrevious(), (Object)gravity.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)editable.getPrevious(), (Object)editable.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)inputType.getPrevious(), (Object)inputType.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)rawInputType.getPrevious(), (Object)rawInputType.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)keyListener.getPrevious(), (Object)keyListener.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)imeOptions.getPrevious(), (Object)imeOptions.getNext())) {
            return true;
        }
        if (!TextInputSpec.equalInputFilters((List)inputFilters.getPrevious(), (List)inputFilters.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)ellipsize.getPrevious(), (Object)ellipsize.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)multiline.getPrevious(), (Object)multiline.getNext())) {
            return true;
        }
        if (((Boolean)multiline.getNext()).booleanValue()) {
            if (!ObjectsCompat.equals((Object)minLines.getPrevious(), (Object)minLines.getNext())) {
                return true;
            }
            if (!ObjectsCompat.equals((Object)maxLines.getPrevious(), (Object)maxLines.getNext())) {
                return true;
            }
        }
        if (!ObjectsCompat.equals((Object)cursorDrawableRes.getPrevious(), (Object)cursorDrawableRes.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)movementMethod.getPrevious(), (Object)movementMethod.getNext())) {
            return true;
        }
        if (!ObjectsCompat.equals((Object)error.getPrevious(), (Object)error.getNext())) {
            return true;
        }
        if (mountedView.getPrevious() != mountedView.getNext()) {
            return true;
        }
        if (savedText.getPrevious() != savedText.getNext()) {
            return true;
        }
        Drawable previousBackground = (Drawable)inputBackground.getPrevious();
        Drawable nextBackground = (Drawable)inputBackground.getNext();
        if (previousBackground == null && nextBackground != null) {
            return true;
        }
        if (previousBackground != null && nextBackground == null) {
            return true;
        }
        if (previousBackground != null && nextBackground != null) {
            if (previousBackground instanceof ColorDrawable && nextBackground instanceof ColorDrawable) {
                ColorDrawable prevColor = (ColorDrawable)previousBackground;
                ColorDrawable nextColor = (ColorDrawable)nextBackground;
                if (prevColor.getColor() != nextColor.getColor()) {
                    return true;
                }
            } else if (!ObjectsCompat.equals((Object)previousBackground.getConstantState(), (Object)nextBackground.getConstantState())) {
                return true;
            }
        }
        return false;
    }

    static boolean equalInputFilters(List<InputFilter> a, List<InputFilter> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            InputFilter fa = a.get(i);
            InputFilter fb = b.get(i);
            if (fa instanceof InputFilter.AllCaps && fb instanceof InputFilter.AllCaps || !(Build.VERSION.SDK_INT >= 21 && fa instanceof InputFilter.LengthFilter && fb instanceof InputFilter.LengthFilter ? ((InputFilter.LengthFilter)fa).getMax() != ((InputFilter.LengthFilter)fb).getMax() : !ObjectsCompat.equals((Object)fa, (Object)fb))) continue;
            return false;
        }
        return true;
    }

    @OnCreateMountContent
    protected static EditTextWithEventHandlers onCreateMountContent(Context c) {
        return new EditTextWithEventHandlers(c);
    }

    @OnMount
    static void onMount(ComponentContext c, EditTextWithEventHandlers editText, @Prop(optional=true, resType=ResType.STRING) CharSequence hint, @Prop(optional=true, resType=ResType.DRAWABLE) Drawable inputBackground, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowRadius, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDx, @Prop(optional=true, resType=ResType.DIMEN_OFFSET) float shadowDy, @Prop(optional=true, resType=ResType.COLOR) int shadowColor, @Prop(optional=true) ColorStateList textColorStateList, @Prop(optional=true) ColorStateList hintColorStateList, @Prop(optional=true, resType=ResType.COLOR) Integer highlightColor, @Prop(optional=true, resType=ResType.DIMEN_TEXT) int textSize, @Prop(optional=true) Typeface typeface, @Prop(optional=true) int textAlignment, @Prop(optional=true) int gravity, @Prop(optional=true) boolean editable, @Prop(optional=true) int inputType, @Prop(optional=true) int rawInputType, @Prop(optional=true) int imeOptions, @Prop(optional=true, varArg="inputFilter") List<InputFilter> inputFilters, @Prop(optional=true) boolean multiline, @Prop(optional=true) int minLines, @Prop(optional=true) int maxLines, @Prop(optional=true) TextUtils.TruncateAt ellipsize, @Prop(optional=true) int cursorDrawableRes, @Prop(optional=true) MovementMethod movementMethod, @Prop(optional=true, resType=ResType.STRING) CharSequence error, @Prop(optional=true, resType=ResType.DRAWABLE) Drawable errorDrawable, @Prop(optional=true) @Nullable KeyListener keyListener, @Prop(optional=true) int importantForAutofill, @Prop(optional=true) @Nullable String[] autofillHints, @State AtomicReference<CharSequence> savedText, @State AtomicReference<EditTextWithEventHandlers> mountedView) {
        mountedView.set(editText);
        TextInputSpec.setParams(editText, hint, TextInputSpec.getBackgroundOrDefault(c, inputBackground), shadowRadius, shadowDx, shadowDy, shadowColor, textColorStateList, hintColorStateList, highlightColor, textSize, typeface, textAlignment, gravity, editable, inputType, rawInputType, keyListener, imeOptions, inputFilters, multiline, ellipsize, minLines, maxLines, cursorDrawableRes, movementMethod, savedText.get(), error, errorDrawable, false, importantForAutofill, autofillHints);
        editText.setTextState(savedText);
    }

    @OnBind
    static void onBind(ComponentContext c, EditTextWithEventHandlers editText, @Prop(optional=true, varArg="textWatcher") List<TextWatcher> textWatchers) {
        TextInputSpec.onBindEditText(c, editText, textWatchers, TextInput.getTextChangedEventHandler(c), TextInput.getSelectionChangedEventHandler(c), TextInput.getInputFocusChangedEventHandler(c), TextInput.getKeyUpEventHandler(c), TextInput.getKeyPreImeEventHandler(c), TextInput.getEditorActionEventHandler(c), TextInput.getInputConnectionEventHandler(c));
    }

    static void onBindEditText(ComponentContext c, EditTextWithEventHandlers editText, @Nullable List<TextWatcher> textWatchers, EventHandler textChangedEventHandler, EventHandler selectionChangedEventHandler, EventHandler inputFocusChangedEventHandler, EventHandler keyUpEventHandler, EventHandler keyPreImeEventHandler, EventHandler EditorActionEventHandler, EventHandler inputConnectionEventHandler) {
        editText.attachWatchers(textWatchers);
        editText.setComponentContext(c);
        editText.setTextChangedEventHandler((EventHandler<TextChangedEvent>)textChangedEventHandler);
        editText.setSelectionChangedEventHandler((EventHandler<SelectionChangedEvent>)selectionChangedEventHandler);
        editText.setInputFocusChangedEventHandler((EventHandler<InputFocusChangedEvent>)inputFocusChangedEventHandler);
        editText.setKeyUpEventHandler((EventHandler<KeyUpEvent>)keyUpEventHandler);
        editText.setKeyPreImeEventEventHandler((EventHandler<KeyPreImeEvent>)keyPreImeEventHandler);
        editText.setEditorActionEventHandler((EventHandler<EditorActionEvent>)EditorActionEventHandler);
        editText.setInputConnectionEventHandler((EventHandler<InputConnectionEvent>)inputConnectionEventHandler);
    }

    @OnUnmount
    static void onUnmount(ComponentContext c, EditTextWithEventHandlers editText, @Prop(optional=true) @Nullable KeyListener keyListener, @State AtomicReference<EditTextWithEventHandlers> mountedView) {
        if (keyListener != null) {
            editText.setKeyListener(null);
            editText.setInputType(1);
        }
        editText.setTextState(null);
        mountedView.set(null);
    }

    @OnUnbind
    static void onUnbind(ComponentContext c, EditTextWithEventHandlers editText) {
        editText.detachWatchers();
        editText.setComponentContext(null);
        editText.setTextChangedEventHandler(null);
        editText.setSelectionChangedEventHandler(null);
        editText.setInputFocusChangedEventHandler(null);
        editText.setKeyUpEventHandler(null);
        editText.setKeyPreImeEventEventHandler(null);
        editText.setEditorActionEventHandler(null);
        editText.setInputConnectionEventHandler(null);
    }

    @Nullable
    static Drawable getBackgroundOrDefault(ComponentContext c, Drawable specifiedBackground) {
        if (specifiedBackground == UNSET_DRAWABLE) {
            int[] attrs = new int[]{16842964};
            TypedArray a = c.getAndroidContext().obtainStyledAttributes(null, attrs, 16842862, 0);
            Drawable defaultBackground = a.getDrawable(0);
            a.recycle();
            return defaultBackground;
        }
        return specifiedBackground;
    }

    @OnTrigger(value=RequestFocusEvent.class)
    static void requestFocus(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView) {
        EditTextWithEventHandlers view = mountedView.get();
        if (view != null && view.requestFocus()) {
            view.setSoftInputVisibility(true);
            view.performAccessibilityFocus();
        }
    }

    @OnTrigger(value=ClearFocusEvent.class)
    static void clearFocus(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView) {
        EditTextWithEventHandlers view = mountedView.get();
        if (view != null) {
            view.clearFocus();
            view.setSoftInputVisibility(false);
        }
    }

    @Nullable
    @OnTrigger(value=GetTextEvent.class)
    static CharSequence getText(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView, @State AtomicReference<CharSequence> savedText) {
        EditTextWithEventHandlers view = mountedView.get();
        return view == null ? savedText.get() : view.getText();
    }

    @Nullable
    @OnTrigger(value=GetLineCountEvent.class)
    static Integer getLineCount(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView) {
        EditTextWithEventHandlers view = mountedView.get();
        return view != null ? Integer.valueOf(view.getLineCount()) : null;
    }

    @OnTrigger(value=SetTextEvent.class)
    static void setText(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView, @State AtomicReference<CharSequence> savedText, @FromTrigger CharSequence text) {
        boolean shouldRemeasure = TextInputSpec.setTextEditText(mountedView, savedText, text);
        if (shouldRemeasure) {
            TextInput.remeasureForUpdatedTextSync(c);
        }
    }

    static boolean setTextEditText(AtomicReference<EditTextWithEventHandlers> mountedView, AtomicReference<CharSequence> savedText, @Nullable CharSequence text) {
        ThreadUtils.assertMainThread();
        EditTextWithEventHandlers editText = mountedView.get();
        if (editText == null) {
            savedText.set(text);
            return true;
        }
        editText.setText(text);
        editText.setSelection(text != null ? text.length() : 0);
        return false;
    }

    @OnTrigger(value=ReplaceTextEvent.class)
    static void replaceText(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView, @State AtomicReference<CharSequence> savedText, @FromTrigger CharSequence text, @FromTrigger int startIndex, @FromTrigger int endIndex) {
        EditTextWithEventHandlers editText = mountedView.get();
        if (editText != null) {
            editText.getText().replace(startIndex, endIndex, text);
            editText.setSelection(text != null ? startIndex + text.length() : startIndex);
            return;
        }
        CharSequence currentSavedText = savedText.get();
        savedText.set(currentSavedText == null ? text : new SpannableStringBuilder().append(currentSavedText.subSequence(0, startIndex)).append(text).append(currentSavedText.subSequence(endIndex, currentSavedText.length())));
        TextInput.remeasureForUpdatedTextSync(c);
    }

    @OnTrigger(value=DispatchKeyEvent.class)
    static void dispatchKey(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView, @FromTrigger KeyEvent keyEvent) {
        EditTextWithEventHandlers view = mountedView.get();
        if (view != null) {
            view.dispatchKeyEvent(keyEvent);
        }
    }

    @OnTrigger(value=SetSelectionEvent.class)
    static void setSelection(ComponentContext c, @State AtomicReference<EditTextWithEventHandlers> mountedView, @FromTrigger int start, @FromTrigger int end) {
        EditTextWithEventHandlers view = mountedView.get();
        if (view != null) {
            view.setSelection(start, end < start ? start : end);
        }
    }

    @OnUpdateState
    static void remeasureForUpdatedText(StateValue<Integer> measureSeqNumber) {
        measureSeqNumber.set((Object)((Integer)measureSeqNumber.get() + 1));
    }

    private static class Api26Utils {
        private Api26Utils() {
        }

        private static void setAutoFillProps(EditText editText, int importantForAutofill, @Nullable String[] autofillHints) {
            if (Build.VERSION.SDK_INT >= 26) {
                editText.setImportantForAutofill(importantForAutofill);
                editText.setAutofillHints(autofillHints);
            }
        }
    }

    static class ForMeasureEditText
    extends EditText {
        public ForMeasureEditText(Context context) {
            super(context);
        }

        public void invalidate() {
        }

        public void setBackground(Drawable background) {
            if (background != null) {
                background.mutate();
            }
            super.setBackground(background);
        }
    }

    static class EditTextWithEventHandlers
    extends EditText
    implements TextView.OnEditorActionListener {
        private static final int UNMEASURED_LINE_COUNT = -1;
        @Nullable
        private EventHandler<TextChangedEvent> mTextChangedEventHandler;
        @Nullable
        private EventHandler<SelectionChangedEvent> mSelectionChangedEventHandler;
        @Nullable
        private EventHandler<InputFocusChangedEvent> mInputFocusChangedEventHandler;
        @Nullable
        private EventHandler<KeyUpEvent> mKeyUpEventHandler;
        @Nullable
        private EventHandler<KeyPreImeEvent> mKeyPreImeEventEventHandler;
        @Nullable
        private EventHandler<EditorActionEvent> mEditorActionEventHandler;
        @Nullable
        private EventHandler<InputConnectionEvent> mInputConnectionEventHandler;
        @Nullable
        private ComponentContext mComponentContext;
        @Nullable
        private AtomicReference<CharSequence> mTextState;
        private int mLineCount = -1;
        @Nullable
        private TextWatcher mTextWatcher;
        private boolean mIsSoftInputRequested = false;

        public EditTextWithEventHandlers(Context context) {
            super(context);
            this.setOnEditorActionListener(this);
        }

        public void requestLayout() {
            if (Build.VERSION.SDK_INT == 23 && !ThreadUtils.isMainThread()) {
                return;
            }
            super.requestLayout();
        }

        protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
            super.onTextChanged(text, start, lengthBefore, lengthAfter);
            if (this.mTextState != null) {
                this.mTextState.set(text);
            }
            if (this.mTextChangedEventHandler != null) {
                TextInput.dispatchTextChangedEvent(this.mTextChangedEventHandler, this, text.toString());
            }
            int lineCount = this.getLineCount();
            if (this.mLineCount != -1 && this.mLineCount != lineCount && this.mComponentContext != null) {
                TextInput.remeasureForUpdatedTextSync(this.mComponentContext);
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.mLineCount = this.getLineCount();
        }

        protected void onSelectionChanged(int selStart, int selEnd) {
            super.onSelectionChanged(selStart, selEnd);
            if (this.mSelectionChangedEventHandler != null) {
                TextInput.dispatchSelectionChangedEvent(this.mSelectionChangedEventHandler, selStart, selEnd);
            }
        }

        protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
            if (this.mInputFocusChangedEventHandler != null) {
                TextInput.dispatchInputFocusChangedEvent(this.mInputFocusChangedEventHandler, focused);
            }
        }

        public boolean onKeyUp(int keyCode, KeyEvent event) {
            if (this.mKeyUpEventHandler != null) {
                return TextInput.dispatchKeyUpEvent(this.mKeyUpEventHandler, keyCode, event);
            }
            return super.onKeyUp(keyCode, event);
        }

        public boolean onKeyPreIme(int keyCode, KeyEvent event) {
            if (this.mKeyPreImeEventEventHandler != null) {
                return TextInput.dispatchKeyPreImeEvent(this.mKeyPreImeEventEventHandler, keyCode, event);
            }
            return super.onKeyPreIme(keyCode, event);
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            if (this.mEditorActionEventHandler != null) {
                return TextInput.dispatchEditorActionEvent(this.mEditorActionEventHandler, v, actionId, event);
            }
            return false;
        }

        public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
            InputConnection inputConnection = super.onCreateInputConnection(editorInfo);
            if (this.mInputConnectionEventHandler != null) {
                return TextInput.dispatchInputConnectionEvent(this.mInputConnectionEventHandler, inputConnection, editorInfo);
            }
            return inputConnection;
        }

        void setTextChangedEventHandler(@Nullable EventHandler<TextChangedEvent> textChangedEventHandler) {
            this.mTextChangedEventHandler = textChangedEventHandler;
        }

        void setSelectionChangedEventHandler(@Nullable EventHandler<SelectionChangedEvent> selectionChangedEventHandler) {
            this.mSelectionChangedEventHandler = selectionChangedEventHandler;
        }

        void setInputFocusChangedEventHandler(@Nullable EventHandler<InputFocusChangedEvent> inputFocusChangedEventHandler) {
            this.mInputFocusChangedEventHandler = inputFocusChangedEventHandler;
        }

        void setKeyUpEventHandler(@Nullable EventHandler<KeyUpEvent> keyUpEventHandler) {
            this.mKeyUpEventHandler = keyUpEventHandler;
        }

        void setKeyPreImeEventEventHandler(@Nullable EventHandler<KeyPreImeEvent> keyPreImeEventEventHandler) {
            this.mKeyPreImeEventEventHandler = keyPreImeEventEventHandler;
        }

        void setEditorActionEventHandler(@Nullable EventHandler<EditorActionEvent> editorActionEventHandler) {
            this.mEditorActionEventHandler = editorActionEventHandler;
        }

        void setInputConnectionEventHandler(@Nullable EventHandler<InputConnectionEvent> inputConnectionEventHandler) {
            this.mInputConnectionEventHandler = inputConnectionEventHandler;
        }

        void setComponentContext(@Nullable ComponentContext componentContext) {
            this.mComponentContext = componentContext;
        }

        void setTextState(@Nullable AtomicReference<CharSequence> savedText) {
            this.mTextState = savedText;
        }

        void attachWatchers(@Nullable List<TextWatcher> textWatchers) {
            if (textWatchers != null && textWatchers.size() > 0) {
                this.mTextWatcher = textWatchers.size() == 1 ? textWatchers.get(0) : new CompositeTextWatcher(textWatchers);
                this.addTextChangedListener(this.mTextWatcher);
            }
        }

        void detachWatchers() {
            if (this.mTextWatcher != null) {
                this.removeTextChangedListener(this.mTextWatcher);
                this.mTextWatcher = null;
            }
        }

        void setSoftInputVisibility(boolean visible) {
            final InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
            if (imm == null) {
                return;
            }
            if (visible) {
                if (imm.isActive((View)this)) {
                    imm.showSoftInput((View)this, 0);
                    this.mIsSoftInputRequested = false;
                } else {
                    this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (mIsSoftInputRequested) {
                                imm.showSoftInput((View)this, 0);
                            }
                            mIsSoftInputRequested = false;
                        }
                    });
                    this.mIsSoftInputRequested = true;
                }
            } else {
                imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.mIsSoftInputRequested = false;
            }
        }

        void performAccessibilityFocus() {
            try {
                ViewCompat.performAccessibilityAction((View)this, (int)64, null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        static final class CompositeTextWatcher
        implements TextWatcher {
            private final List<TextWatcher> mTextWatchers;

            CompositeTextWatcher(List<TextWatcher> textWatchers) {
                this.mTextWatchers = new ArrayList<TextWatcher>(textWatchers);
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                for (TextWatcher w : this.mTextWatchers) {
                    w.beforeTextChanged(s, start, count, after);
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                for (TextWatcher w : this.mTextWatchers) {
                    w.onTextChanged(s, start, before, count);
                }
            }

            public void afterTextChanged(Editable editable) {
                for (TextWatcher w : this.mTextWatchers) {
                    w.afterTextChanged(editable);
                }
            }
        }
    }
}

